//===========================>>> vTextEditor::formatC <<<=====================
 int vTextEditor::formatC(long count)
  {
    /* format C code according to Bruce's style */

    int oldef, i, ij, ik, spaces, tabs, prev_key;
    long prev_lnum;

    char prev_line[40];
    char prev_prev_line[40];

    oldef = state.echof;
    if ( curlin >= _nextLine-1)	/* can't do last line */
	return 0;

    if (count > 1)
	state.echof = 0;

    for (i = 1 ; i <= count ; ++i, lineDownBeg((long)1))
      {
	if ((prev_lnum = get_prev(prev_line,curlin)) <= 0)	/* get the previous line */
	    continue;			/* handle 1st line of file! */

	(void) get_prev(prev_prev_line,prev_lnum);	/* and the line before it */

	if (*prev_line != ' ' && *prev_line != '\t')	/* funny line */
	  {
	    lineDownBeg((long)1);
	    break;			/* give up */
	  }

	/* count previous tabs/spaces */
	tabs = spaces = 0;
	for (ij = 0 ; ij < 38 ; ++ij)
	  {
	    if (prev_line[ij] == '\t')
	      {
		spaces = 0;		/* skip embedded spaces */
		++tabs;
	      }
	    else if (prev_line[ij] == ' ')
		++spaces;
	    else
		break;			/* break on first non tab non blank */
	  }
	if (tabs == 0 && spaces <= 2)
	  {
	    lineDownBeg((long) 1);
	    break;			/* give up on function heads */
	  }

	/* now process current line */
	beglin((long)1);		/* start at beginning of line */

	if (curlin >= _nextLine-1)
	    break;		/* done */

	/* don't fix blank lines */

	if (GCh(curchr) != ' ' && GCh(curchr) != '\t' )
	  {
	    lineDownBeg((long) 1);
	    break;		/* break on line I don't know about */
	  }

	while (GCh(curchr) == ' ' || GCh(curchr) == '\t')
	    delnxt((long)1);		/* delete them */

	if (GCh(curchr) == '\n')
	    continue;		/* skip blank lines */

	/* determine spacing of current line based on prev line */

	prev_key = 0;
	if (is_key_word(&prev_line[ij],1))	/* a kew word! */
	  {
	    prev_key = 1;			/* last line was key */
	    if (GCh(curchr) == '{')
		spaces += 2;
	    else
		spaces += 4;
	  }
	else if (prev_line[ij] == '{')
	  {
	    spaces += 2;
	  }
	else if (prev_line[ij] == '}')
	  {
	    spaces -= 2;
	  }

	if (has_key(bp+curchr), "else"))
	  {
	    if (prev_line[ij] != '}')
		spaces -= 4;
	  }
	else if (has_key(bp+curchr), "case") ||
	  has_key((bp+curchr), "default:"))
	  {
	    if (prev_line[ij] != '{')
		spaces -= 4;
	  }
	else if (!prev_key && prev_line[ij] != '{' && 
	  prev_line[ij] != '}' && is_key_word(prev_prev_line,0))
		spaces -= 4;

	/* don't else next one, works with last else if */
	if (GCh(curchr) == '}')	/* } */
	    spaces -= 2;

	/* fix tab/space counts */
	if (spaces < 0)
	  {
	    if (--tabs < 0)
		tabs = 0;
	    spaces = 8 + spaces;
	  }
	while (spaces >= 8)
	  {
	    ++tabs;
	    spaces -= 8;
	  }

	for (ik = 0 ; ik < tabs ; ++ik)
	    charInsert('\t');
	for (ik = 0 ; ik < spaces ; ++ik)
	    charInsert(' ');

      }	/* end of main for loop */

    state.echof = oldef;
    if (oldef && count > 1)
	verify();

    return 1;

  }

// =============================>>> vTextEditor::has_key <<<=======================
  int vTextEditor::has_key(char *buff_ptr, char *key)
  {
    while (*key)
      {
	if (*buff_ptr++ != *key++)
	    return 0;
      }
    return 1;	/* buff_ptr matches key up to key's EOS */

  }

// ==========================>>> vTextEditor::is_key_word <<<====================== 
  int vTextEditor::is_key_word(char *bf, int case_def)
  {
    char *strstr();

    while (*bf == ' ' || *bf == '\t')	/* skip leading white */
	++bf;
    if (strstr(bf,"if(") == bf)
	return 1;
    if (strstr(bf,"if (") == bf)
	return 1;
    if (strstr(bf,"for(") == bf)
	return 1;
    if (strstr(bf,"for (") == bf)
	return 1;
    if (strstr(bf,"while(") == bf)
	return 1;
    if (strstr(bf,"while (") == bf)
	return 1;
    if (strstr(bf,"else") == bf)
	return 1;
    if (strstr(bf,"typedef ") == bf)
	return 1;
    if (strstr(bf,"struct ") == bf)
	return 1;
    if (strstr(bf,"switch(") == bf)
	return 1;
    if (strstr(bf,"switch (") == bf)
	return 1;
    if (case_def && strstr(bf,"case ") == bf)
	return 1;
    if (case_def && strstr(bf,"default:") == bf)
	return 1;
    return 0;
  }

//=============================>>> vTextEditor::get_prev <<<======================
  long vTextEditor::get_prev(TEXT *prev_buff, long start)
  {	// Get previous non-blank line in text buffer (BEW: 10/1/98)
    long pline;
    int ix, blank_line;
    BUFFPTR bi;

    *prev_buff = 0;			/* empty line for sure */
    pline = start;
GP_TOP:
    --pline;				/* previous line */

    if (pline <= 1)
	return 0;			/* there is no previous line */

    bi = GLine(pline);		/* first char of buffer */

    blank_line = 1;
    for (ix = 0 ; ix < 38 ; ++ix)
      {
	if (GCh(bi+ix) == '\n')
	    break;
	prev_buff[ix] = GCh(bi+ix);	/* copy the char */
	if (prev_buff[ix] != ' ' || prev_buff[ix] != '\t')
	   blank_line = 0;		/* not a blank line */
      }
    prev_buff[ix] = 0;			/* terminate the string */
    if (blank_line || prev_buff[0] == '#')
	goto GP_TOP;			/* find previous non-blank line */

    return pline;
  }
