# EXAMPLE makefile for V Tutorial Demo application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using v.mak or vopengl.mak 
#
# to create debug versions enter: nmake /f DEBUG=1 vtutor.mak
# to create release versions enter: nmake /f vtutor.mak
#

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\tutor
INCDIR=$(VDIR)\tutor
BINFILE=$(BINDIR)\vtutapp.exe
RESFILE=$(OBJDIR)\vapp.res
DEFFILE=$(VSRCDIR)\vos2.def

OBJFILES= $(OBJDIR)\vstartup.obj \
 $(OBJDIR)\tutapp.obj \
 $(OBJDIR)\tdialog.obj \
 $(OBJDIR)\tmodal.obj \
 $(OBJDIR)\tcanvas.obj \
 $(OBJDIR)\tcmdwin.obj 

# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(RESFILE) $(VLIB)
	-$(CC) /Q /B"$(LFLAGS)" @<<
 /Fe$@
 $(OBJFILES)
 $(LIBS)
 $(DEFFILE)
<<NOKEEP
    $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vapp.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\tcanvas.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\tdialog.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\tmodal.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\\$$(@B).h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\tcmdwin.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\\$$(@B).h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\tutapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\tdialog.h $(INCDIR)\tmodal.h \
 $(INCDIR)\tcmdwin.h 

