# EXAMPLE makefile for V Test Demo application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using v.mak or vopengl.mak 
#
# to create debug versions enter: nmake /f DEBUG=1 vtest.mak
# to create release versions enter: nmake /f vtest.mak
#

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\test
INCDIR=$(VDIR)\test
BINFILE=$(BINDIR)\vtest.exe
RESFILE=$(OBJDIR)\vapp.res
DEFFILE=$(VSRCDIR)\vos2.def

OBJFILES= $(OBJDIR)\vstartup.obj \
 $(OBJDIR)\testapp.obj \
 $(OBJDIR)\vtcanvas.obj \
 $(OBJDIR)\vtcmdwin.obj \
 $(OBJDIR)\vtcw2.obj \
 $(OBJDIR)\vtdialog.obj \
 $(OBJDIR)\vttogdlg.obj \


# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(RESFILE) $(VLIB)
	-$(LD) $(LFLAGS) @<<
 $(OBJFILES),
 $@,
 NUL,
 $(LIBS),
 $(DEFFILE)
<<NOKEEP
    $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vapp.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\testapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\vtcanvas.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\vtcmdwin.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\vtcw2.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\vtdialog.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\vttogdlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 
