//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

#ifndef V_DEFS_H
#define V_DEFS_H
//
// OS/2 PM
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//                                                                         //
// VV         VV                                       VV         VV       //
//  VV       VV     V - A Portable C++ GUI Framework    VV       VV        //
//   VV     VV           designed and written by         VV     VV         //
//    VV   VV                                             VV   VV          //
//     VV VV              Bruce E. Wampler, Ph.D.          VV VV           //
//      VVV               e-mail: wampler@cs.unm.edu        VVV            //
//       V                                                   V             //
//                 Ported to OS/2 by Jon B. Hacker, Ph.D.                  //
//                                                                         //
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//                                                                         //
// v_defs.h - Standard V definitions                                       //
//                                                                         //
// Copyright (C) 1995,1996  Bruce E. Wampler                               //
//                                                                         //
// This file is part of the V C++ GUI Framework.                           //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//                                                                         //
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

#ifndef vDEBUG                // force DEBUG for now
#define vDEBUG
#endif
//#undef vDEBUG

#define INCL_PM
#define INCL_WIN
#define INCL_GPI
#define INCL_SPLDOSPRINT
#define INCL_DOSPROCESS

#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define V_VersMajor 1
#define V_VersMinor 17
#define V_Version "V 1.17 - 2/1/98"
#define V_VersionOS2 "1.17 Build 216"

    // system error functions
    extern void vSysWarning(char* msg);
    extern void vSysError(char* msg);

    // Define basic types

    typedef unsigned int vKey;          // Value for a Key
    typedef int ItemVal;                // Value for an Item (menu,button, etc)
    typedef unsigned int CmdAttribute;  // Attributes of commands

#define vRGB (v,x,y,z)  v.r = x ; v.g = y ; v.z = b;
#define vpRGB (v,x,y,z)  v->r = x ; v->g = y ; v->z = b;

    typedef struct DebugMask
      {
        unsigned
        System : 1,                     // System debug messages
        CmdEvents : 1,                  // Show command events (buttons, etc.)
        MouseEvents : 1,                // Show mouse events
        WindowEvents : 1,               // Window events (resize, etc.)
        Build : 1,                      // Define/Build window
        BadVals: 1,                     // Error values
        Misc : 1,                       // Misc stuff
        Text : 1,                       // Text events
        Constructor : 1,                // Show constructors
        Destructor : 1,                 // Show destructors
        User: 1,                        // Debug user events
        UserApp1 : 1,                   // Level 1 User App
        UserApp2 : 1,                   // Level 2 User App
	UserApp3 : 1,                   // Level 3 User App
	OS2Dev : 1;                     // OS/2 development debugging
      } DebugMask;

    extern DebugMask DebugState;        // allow everyone to see DebugState

// Define some macros to make adding debugging stuff easy

//int printf(const char *f, ...);
#ifdef vDEBUG
#define UserDebug(u,v) if (DebugState.u && DebugState.User) printf(v);
#define UserDebug1(u,v,w) if (DebugState.u && DebugState.User) printf(v,w);
#define UserDebug2(u,v,w,x) if (DebugState.u && DebugState.User) printf(v,w,x);
#define UserDebug3(u,v,w,x,z) if (DebugState.u && DebugState.User) printf(v,w,x,z);

#define SysDebug(u,v) if (DebugState.u && DebugState.System) printf(v);
#define SysDebug1(u,v,w) if (DebugState.u && DebugState.System) printf(v,w);
#define SysDebug2(u,v,w,x) if (DebugState.u && DebugState.System) printf(v,w,x);
#define SysDebug3(u,v,w,x,z) if (DebugState.u && DebugState.System) printf(v,w,x,z);

#else

#define UserDebug(u,v) // Nothing
#define UserDebug1(u,v,w) // Nothing
#define UserDebug2(u,v,y,x) // Nothing
#define UserDebug3(u,v,y,x,z) // Nothing

#define SysDebug(u,v) // Nothing
#define SysDebug1(u,v,w) // Nothing
#define SysDebug2(u,v,w,x) // Nothing
#define SysDebug3(u,v,w,x,z) // Nothing
#endif

// Define some standard font ids, which will internally correspond
// to both the id and the index of the vApp font array.


  enum WindowType { WINDOW, CMDWINDOW, DIALOG };  // Types of windows

  // How Items can be set
  enum ItemSetType {Checked, Sensitive, Value, Hidden, ChangeList,
    ChangeListPtr, Red, Green, Blue, ChangeColor};

  enum CmdType        // types of dialog commands
  {
    C_EndOfList,                    // Used to denote end of command list
    C_ArrowButton,                  // An arrow button
    C_Blank,                        // filler to help RightOfs, Belows work
    C_BoxedLabel,                   // A status bar boxed label (Win only)
    C_Button,                       // Command Button
    C_CheckBox,                     // Checked Item
    C_ColorButton,                  // A colored button
    C_ColorLabel,                   // A colored label
    C_Custom,                       // A custom control
    C_ComboBox,                     // Popup combo list
    C_Frame,                        // General purpose frame
    C_Icon,                         // a display only Icon
    C_IconButton,                   // a command button Icon
    C_Label,                        // Regular text label
    C_List,                         // List of items (scrollable)
    C_Menu,                         // Menu item
    C_ProgressBar,                  // Bar to show progress
    C_RadioButton,                  // Radio button
    C_Slider,                       // Slider to enter value
    C_Spinner,                      // a spinner box
    C_TextIn,                       // Text input field
    C_Text,                         // wrapping text out
    C_ToggleButton,                 // A toggle button
    C_ToggleFrame,                  // A toggle frame
    C_ToggleIconButton,             // A toggle icon button
    C_ZZZ                           // make my life easy
  };

  enum PaneType       // Kinds of Panes
  {
    P_Canvas,                       // Drawing Canvas
    P_TextCanvas,                   // TextCanvas
    P_Menu,                         // Menu
    P_Commands,                     // Commands
    P_Icons,                        // Icon Bar
    P_Buttons,                      // Button Bar
    P_Status,                       // Status Bar
    P_Dialog                        // Dialog
  };

  const CmdAttribute CA_None = 0;             // No special attributes
  const CmdAttribute CA_MainMsg = 0x01;       // Gets replacement message
  const CmdAttribute CA_DefaultButton = 0x02; // Special Default Button

  const CmdAttribute CA_Large = 0x04;         // Command larger than normal
  const CmdAttribute CA_Small = 0x08;         // Command smaller than normal
  const CmdAttribute CA_Hidden = 0x10;        // Starts out hidden
  const CmdAttribute CA_Horizontal = 0x20;    // Horizontal orientation
  const CmdAttribute CA_Vertical = 0x40;      // Vertical orientation
  const CmdAttribute CA_NoNotify = 0x100;     // Don't notify on all events
  const CmdAttribute CA_NoLabel = 0x100;      // No label (ProgressCmd only)
  const CmdAttribute CA_Simple = 0x100;       // backward compatible
  const CmdAttribute CA_Text = 0x200;         // A Text command
  const CmdAttribute CA_NoBorder = 0x400;     // No border (frames, status bar)
  const CmdAttribute CA_NoSpace = 0x800;      // No space between widgets

  const CmdAttribute CA_PerControl = 0x1000;  // Specific to different controls
  const CmdAttribute CA_Percent = 0x1000;     // Show % for ProgressCmd
  const CmdAttribute CA_Size = 0x1000;        // size specified in size element

  // For backward compatibility - these haven't proven useful.
  const CmdAttribute CA_LeftJust = 0;         // Left Justified
  const CmdAttribute CA_RightJust = 0;        // Right Justified
  const CmdAttribute CA_Center = 0;           // Centered

  // These definitions go here because the user app should not need
  // to know about menus and buttons - only the static data structures
  // needed to define those things - and so shouldn't have to include
  // the header file for each menu or command object

  // definitions for dialog box command objects

  const ItemVal NoList = 0;       //  no attributes, items is null list;
  const ItemVal NoFrame = 0;      // no frame used

  typedef struct CommandObject
  {
    CmdType cmdType;        // what kind of item is this
    ItemVal cmdId;          // unique id for the item
    ItemVal retVal;         // value returned when picked (might be < 0)
    char* title;            // string
    void* itemList;         // a list of stuff to use for the cmd
    CmdAttribute attrs;     // bit map of attributes
    unsigned
    Sensitive : 1;          // if item is sensitive or not
    ItemVal cFrame;         // Frame used for an item
    ItemVal cRightOf;       // Item placed left of this id
    ItemVal cBelow;         // Item placed below this one
    int size;               // Used for sizes
  } CommandObject;

#define DialogCmd CommandObject // for backward compatibility

  typedef struct vMenu
  {
    char* label;            // The label on the menu
    ItemVal menuId;         // A User assigned unique value
    unsigned
    sensitive : 1,         // If item is sensitive or not
    checked : 1;           // If item is checked or not
    char* keyLabel;         // Label for an accelerator key
    vKey accel;             // Value of accelerator key
    vMenu* SubMenu;         // Ptr to a submenu
    unsigned int kShift;    // Shift state for accel
  } vMenu;

#define vStatusPane vCommandPane        // stat bars are really command bars

  typedef struct vStatus      // for status bars
  {
    char* label;            // label of button
    ItemVal statId;         // value
    CmdAttribute attrs;     // bit map of attributes
    unsigned
    sensitive : 1;         // if button is sensitive or not
    int width;              // if need to specify width (0 => default)
  } vStatus;

  // symbols for defining menus

  const int noKey = 0;
  const int noKeyLbl = 0;
  const int isSens = 1;
  const int notSens = 0;
  const int isChk = 1;
  const int notChk = 0;
  const int noSub = 0;
  const int notUsed = 0;
  const int noIcon = 0;

  // standard menu definitions
  const ItemVal M_File = 32000;
  const ItemVal M_Edit = 32001;
  const ItemVal M_Search = 32002;
  const ItemVal M_Help = 32003;
  const ItemVal M_Window = 32004;
  const ItemVal M_Options = 32005;
  const ItemVal M_Tools = 32006;
  const ItemVal M_Font = 32007;
  const ItemVal M_View = 32008;
  const ItemVal M_Format = 32009;
  const ItemVal M_Insert = 32010;
  const ItemVal M_Test = 32011;

  const ItemVal M_Line = 32090;

  const ItemVal M_New = 32100;
  const ItemVal M_Open = 32101;
  const ItemVal M_Close = 32102;
  const ItemVal M_Save = 32103;
  const ItemVal M_SaveAs = 32104;
  const ItemVal M_Print = 32105;
  const ItemVal M_PrintPreview = 32106;
  const ItemVal M_About = 32107;
  const ItemVal M_Exit = 32108;
  const ItemVal M_CloseFile = 32109;	// V:1.13

  const ItemVal M_Cut = 32110;
  const ItemVal M_Copy = 32111;
  const ItemVal M_Paste = 32112;
  const ItemVal M_Delete = 32113;
  const ItemVal M_Clear = 32114;

  const ItemVal M_UnDo = 32120;
  const ItemVal M_SetDebug = 32121;

  const ItemVal M_Find = 32130;
  const ItemVal M_FindAgain = 32131;
  const ItemVal M_Replace = 32132;

  const ItemVal M_Preferences = 32140;
  const ItemVal M_FontSelect = 32141;

  const ItemVal M_Cancel = 32150;
  const ItemVal M_Done = 32151;
  const ItemVal M_OK = 32152;
  const ItemVal M_Yes = 32153;
  const ItemVal M_No = 32154;
  const ItemVal M_All = 32155;
  const ItemVal M_None = 32156;

  const ItemVal M_Cascade = 32160;
  const ItemVal M_Tile = 32161;
  const ItemVal M_Arrange = 32162;
  const ItemVal M_CloseAll = 32163;
  const ItemVal M_OpenPath = 32164;
  const ItemVal M_WindowsReserved1 = 32170; // app exit
  const ItemVal M_WindowsReserved2 = 32171;
  const ItemVal M_WindowsReserved3 = 32172;
  const ItemVal M_WindowsReserved4 = 32173;
  const ItemVal M_WindowsReserved5 = 32174;
  #define M_FIRSTCHILD 32200              // higher than everything else

//--------------------------------------------------------------------------

// Definitions for drawing

  typedef POINTL vPoint;       // an OS/2 point

  typedef struct vRect
  {
    int x,y,w,h;
  } vRect;

  typedef struct vLine
  {
    int x,y,xend,yend;
  } vLine;

// for brushes and pens

  const int vSolid = 1;
  const int vTransparent = 2;

// for brushes

  const int vHorizontalHatch = 3;
  const int vVerticleHatch = 4;
  const int vVerticalHatch = 4;
  const int vLeftDiagonalHatch = 5;
  const int vRightDiagonalHatch = 6;
  const int vCrossHatch = 7;
  const int vDiagonalCrossHatch = 8;

// for pens
  const int vDash = 9;
  const int vDot = 10;
  const int vDashDot = 11;

// for filling
  const int vAlternate = 12;
  const int vWinding = 13;

// OS/2 core resource IDs
  const int vID_FRAME = 1;
// OS/2 Print Select Dialog
  const int vID_PRINT_DLG = 2;
  const int vID_PRINTER = 3;
  const int vID_JOBPROPS = 4;
  const int vID_COPIES = 5;
  const int vID_COLLATE = 6;
  const int vID_PRINTALL = 7;
  const int vID_PRINTPAGES = 8;
  const int vID_PRINTSEL = 9;
  const int vID_PRINTFROM = 10;
  const int vID_PRINTTO = 11;
  const int vID_COLLATEBMP = 12;
  const int vID_STATUS = 13;
  const int vID_TYPE = 14;
  const int vID_WHERE = 15;

//--------------------------------------------------------------------------
#endif
