#define INCL_WF
#include <wkf.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "sctool.h"
#include "iwftoolsr.h"


extern BOOL EXPENTRY IWFQUERYCOMPILEHELPFILE3(  HWND   hwndErrorBox,
                                                PSZ    pszProject,
                                                PSZ    pszHelpFile )
{
   DosBeep(400,800);
   *pszHelpFile = '\0';
   return FALSE;
}

extern ULONG EXPENTRY IWFQUERYCOMPILERESOURCEID3(  HWND   hwndErrorBox,
                                                   PSZ    pszProject,
                                                   PSZ    pszErrorLine )
{
   DosBeep(1200,800);
   return 0;
}

extern ULONG EXPENTRY IWFCOMPILEPARSEERROR(  HWND     hwndErrorBox,
                                             PSZ      pszProject,
                                             PUSHORT  pusStartLine,
                                             PUSHORT  pusEndLine,
                                             HWND     hwndFilenames,
                                             PUSHORT  pusCurrentFile,
                                             PVOID    pvOptions,
                                             PULONG   pulSetting )
{
   DosBeep(1000,200);
   WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,"Hallo","WKF",0,MB_OK|MB_MOVEABLE);
   return WKFRC_PARSEERROR_INVALID;
//   return WKFRC_PARSEERROR_SUCCESS;
}

extern APIRET EXPENTRY IWFCOMPILETERMINATE(  PVOID      *ppvToolBuffer,
                                             BOOL        fDisplayMessages,
                                             HWND        hwndWorkFrame,
                                             HMODULE     hModHandle,
                                             PSZ         pszTitle,
                                             PIWF_ACTION pIwfAction)
{
   if (ppvToolBuffer && *ppvToolBuffer) {
      free(*ppvToolBuffer);
   }
   return NO_ERROR;
}








extern ULONG EXPENTRY IWFQUERYCOMPILEOPTIONS(   HWND           hwndWorkFrame,
                                                HMODULE        hModHandle,
                                                PSZ            pszProject,
                                                PSZ            pszTitle,
                                                PIWF_ACTION    pIwfAction,
                                                ULONG          ulSetting,
                                                PULONG         pulOptionsLength,
                                                PVOID         *pvOptions,
                                                PIWF_REALLOC   pIwf_Realloc,
                                                BOOL           bFileScope )
{
   SOM_OPTIONS DefOptions;
   SOM_DLGINFO somDlgInfo;
   ULONG rc = WKF_NOERROR;

   // be 100% sure that we dont crash because of possibly wrong
   // values
   if (!pvOptions) {
      return IWF_INVALID_PARAMETER;
   }
   if (!hwndWorkFrame) {
      return IWF_INVALID_PARAMETER;
   }
   if (!hModHandle) {
      return IWF_INVALID_PARAMETER;
   }

   // only open the options dialog for file scoped actions
   // does not make sense to open it for project scope
   if (!bFileScope) {
      return IWF_ERROR_OPTIONS_DLL;
   }

   if ((*pulOptionsLength < sizeof(SOM_OPTIONS))) {
      // if the options buffer is not big enough, increase it
      *pvOptions = (*pIwf_Realloc)(*pvOptions,sizeof(SOM_OPTIONS));
   }
   if (!*pvOptions) {
      // no valid memory pointer to Iwf Options block, get out
      return IWF_MEMORY_ERROR;
   }

   // tell WKF that it only needs to save our number of bytes
   // in the project
   *pulOptionsLength = sizeof(SOM_OPTIONS);

   // preset the options if none where ever chosen (locally at first)
   SetDefaultOptions(&DefOptions);

   somDlgInfo.pDeflOptions = &DefOptions;
   somDlgInfo.pOptions = (SOM_OPTIONS*)*pvOptions;
   somDlgInfo.hModHandle = hModHandle;

   // if the passed options block has not been initialized ever
   // then copy the preset options into the passed block
   if (strncmp(   (char const *)somDlgInfo.pDeflOptions->szSignature,
                  (char const *)somDlgInfo.pOptions->szSignature,
                  sizeof(somDlgInfo.pOptions->szSignature)) ||
                  (ulSetting == WKF_QO_SETTING_USE_DEFAULT))
   {
      memcpy(somDlgInfo.pOptions,somDlgInfo.pDeflOptions,sizeof(SOM_OPTIONS));
   }

   // show the options dialog
   // it is displayed on the desktop but owned by WorkFrame
   rc = WinDlgBox(   HWND_DESKTOP,\
                     hwndWorkFrame,\
                     SomDlgProc,\
                     hModHandle,\
                     ID_SOMDLG,\
                     &somDlgInfo);

   if (rc == DID_ERROR) {
      WinMessageBox(    HWND_DESKTOP,\
                        hwndWorkFrame,\
                        "Error invoking the Options dialog",
                        "Error",
                        0UL,
                        MB_OK|MB_ERROR|MB_MOVEABLE);
      return WKF_ERROR;
   }
   return (rc);
}

extern APIRET EXPENTRY IWFQUERYCOMPILETARGET(
                                          PVOID            *ppvToolBuffer,
                                          HWND              hwndWorkFrame,
                                          HMODULE           hModHandle,
                                          PSZ               pszProject,
                                          PSZ               pszTitle,
                                          PIWF_ACTION       pIwfAction,
                                          ULONG             ulOptionsLength,
                                          PVOID             pvOptions,
                                          ULONG             ulCmdLineLength,
                                          PSZ              *pszCmdLine,
                                          ULONG             ulSearchPath,
                                          PSZ              *pszSearchPath,
                                          LIST_OF_SOURCE   *pstSourceObjects,
                                          LIST_OF_TARGET  **pstTargetObjects,
                                          LIST_OF_DEPEND  **pstDependObjects,
                                          IWF_REALLOC      *pIwf_Realloc,
                                          WKF_PRT_STATUS   *pWkf_PrtStatus,
                                          BOOL              bFileScope )
{
   SOM_OPTIONS *pOptions=NULL,*psOptions=NULL;

   ULONG ulTargetFiles;
   ULONG ulEmittedFiles;
   UCHAR szEmittedFiles[128];
   UCHAR szTargetFiles[128];
   UCHAR szCommBufSize[16];
   UCHAR szStringBufSize[16];

   ULONG ulLengthCmdLine = 0;
   ULONG ulTargetBufferNeeded = 0;

   if (!hwndWorkFrame) {
      return IWF_INVALID_PARAMETER;
   }
   if (!hModHandle) {
      return IWF_INVALID_PARAMETER;
   }
   if (!pstSourceObjects) {
      return IWF_INVALID_PARAMETER;
   }

   if (!pszCmdLine) {
      return IWF_INVALID_PARAMETER;
   }

   if (!pszSearchPath) {
      return IWF_INVALID_PARAMETER;
   }

   if (!pstTargetObjects) {
      return IWF_INVALID_PARAMETER;
   }

   if (!pstDependObjects) {
      return IWF_INVALID_PARAMETER;
   }

   // only makes sense for file scoped
   // action
   if (!bFileScope) {
      return IWF_ERROR_OPTIONS_DLL;
   }

   // there should be at least one input file selected
   if (pstSourceObjects->ulNumOfEntries < 1) {
      return IWF_INVALID_PARAMETER;
   }

/* this was just for testing IWFCOMPILETERMINATE
   *ppvToolBuffer = malloc(4096);
*/

   // if there is no option buffer
   // or if the options have not been
   // set correctly by the dialog
   if ((!pvOptions) || (ulOptionsLength < sizeof(SOM_OPTIONS))) {
      psOptions = (SOM_OPTIONS*)malloc(sizeof(SOM_OPTIONS));
      if (!psOptions)
      {
         return IWF_INVALID_PARAMETER;
      }
      pOptions = psOptions;
   }
   else
   {
      pOptions = (SOM_OPTIONS*)pvOptions;
   }

   if ((pOptions->cb != sizeof(SOM_OPTIONS)) ||
       strncmp((char const*)pOptions->szSignature,SOM_OPTIONS_SIGNATURE,sizeof(pOptions->szSignature)))
   {
      SetDefaultOptions(pOptions);
/*    Maybe set the options in the project for this tool if they arent set yet ?
      if (  pszProject &&
            pIwfAction &&
            pIwfAction->pszActionName &&
            pIwfAction->pszActionClass)
      {
         IwfSetOption(  pszProject,
                        pIwfAction->pszActionName,
                        pIwfAction->pszActionClass,
                        !bFileScope,
                        sizeof(SOM_OPTIONS),
                        pOptions);
      }
*/
   }

   // no matter how many there are selected, we only use
   // the first one in the list
   pstSourceObjects->ulNumUsed = 1;
   pstSourceObjects->stObject[0].fUsed = WKF_QT_FILE_USED;

   for (ULONG i=1;i<pstSourceObjects->ulNumOfEntries;i++) {
      pstSourceObjects->stObject[i].fUsed = WKF_QT_FILE_NOTUSED;
   }

   ulLengthCmdLine = strlen(SZ_INFILE_SUBST_VAR);

   ulLengthCmdLine += strlen(SZ_WORKDIR_PAR) + strlen(SZ_WORKDIR_SUBST_VAR);
   _ltoa(pOptions->ulCommBufSize,(char *)szCommBufSize,10);
   ulLengthCmdLine += strlen(SZ_COMMENTBUFFER) + strlen((char *)szCommBufSize);
   _ltoa(pOptions->ulStringBufSize,(char *)szStringBufSize,10);
   ulLengthCmdLine += strlen(SZ_STRINGBUFFER) + strlen((char *)szStringBufSize);

   if (pOptions->szDefSymbol[0]) {
      ulLengthCmdLine += strlen(SZ_DEFINE) + strlen((char *)pOptions->szDefSymbol);
   }
   if (pOptions->szUnDefSymbol[0]) {
      ulLengthCmdLine += strlen(SZ_UNDEFINE) + strlen((char *)pOptions->szUnDefSymbol);
   }

   if( pOptions->bShowVersion) {
      ulLengthCmdLine += strlen(SZ_SHOWVERSION);
   }
   if (pOptions->bIgnoreComments) {
      ulLengthCmdLine += strlen(SZ_IGNORECOMMENTS);
   }
   if (pOptions->bPrivates) {
      ulLengthCmdLine += strlen(SZ_PRIVATES);
   }
   if (pOptions->bReleaseOrder) {
      ulLengthCmdLine += strlen(SZ_RELEASEORDER);
   }
   if (pOptions->bUpdateRepository) {
      ulLengthCmdLine += strlen(SZ_UPDATEREPOSITORY);
   }
   if (pOptions->bNoWarnings) {
      ulLengthCmdLine += strlen(SZ_NOWARNINGS);
   }

   szEmittedFiles[0] = '\0';
   szTargetFiles[0] = '\0';
   ulTargetFiles = 0;
   ulEmittedFiles = 0;
   if (pOptions->bEmitCFiles) {
      strcat((char*)szEmittedFiles,SZ_EMITC); ulEmittedFiles+=3;
//    only include C file as target
//    because Compiler treats the h;ih Files as dependencies
//    for C Files
      strcat((char*)szTargetFiles,SZ_TARGETC); ulTargetFiles++;
   }
   if (pOptions->bEmitCPPFiles) {
      strcat((char*)szEmittedFiles,SZ_EMITCPP); ulEmittedFiles+=3;
//    only include CPP/xc file as target
//    because Compiler treats the xh;xih Files as dependencies
//    for C Files
      strcat((char*)szTargetFiles,SZ_TARGETCPP); ulTargetFiles++;
   }
   if (pOptions->bEmitDefFile) {
      strcat((char*)szEmittedFiles,SZ_EMITDEF); ulEmittedFiles++;
      strcat((char*)szTargetFiles,SZ_EMITDEF); ulTargetFiles++;
   }
   if (pOptions->bEmitIrFile) {
      strcat((char*)szEmittedFiles,SZ_EMITIR); ulEmittedFiles++;
      strcat((char*)szTargetFiles,SZ_EMITIR); ulTargetFiles++;
   }
   if (pOptions->bEmitPdlFile) {
      strcat((char*)szEmittedFiles,SZ_EMITPDL); ulEmittedFiles++;
      strcat((char*)szTargetFiles,SZ_EMITPDL); ulTargetFiles++;
   }
   if (pOptions->bEmitDTSFile) {
      strcat((char*)szEmittedFiles,SZ_EMITHH); ulEmittedFiles++;
//      I guess WF always treats this as dependeny for
//      C++ Compiler, there it should not be included as target
//      strcat((char*)szTargetFiles,SZ_EMITHH); ulTargetFiles++;
   }
   if (ulEmittedFiles) {
      // add the len
      ulLengthCmdLine += strlen(SZ_EMITPREFIX) + strlen((char*)szEmittedFiles) + strlen(SZ_EMITSUFFIX);
   }
   ulLengthCmdLine += 1; // for the terminating zero

   // realloc buffer for the cmd line if necessary
   if (ulLengthCmdLine > ulCmdLineLength) {
      *pszCmdLine = (PSZ)(*pIwf_Realloc)(*pszCmdLine,ulLengthCmdLine);
      if (!*pszCmdLine) {
         if (psOptions) free(psOptions);
         return IWF_MEMORY_ERROR;
      }
   }

   if (*pstTargetObjects)
   {
      // we need space for the %n. string, for the file extensios
      // (same size as strlen(szEmittedFiles)) and for the terminating 0
      ulTargetBufferNeeded = strlen("%n.") * ulTargetFiles + strlen((char*)szTargetFiles) +1;
      if (ulTargetBufferNeeded > (*pstTargetObjects)->ulBufferSize)
      *pstTargetObjects = (LIST_OF_TARGET*)(*pIwf_Realloc)(*pstTargetObjects,ulTargetBufferNeeded);
      if (!*pstTargetObjects) {
         if (psOptions) free(psOptions);
         return IWF_MEMORY_ERROR;
      }
      else
      {
         (*pstTargetObjects)->ulBufferSize = ulTargetBufferNeeded;
      }
   }

   // we dont check for depends
   if (*pstDependObjects)
   {
      (*pstDependObjects)->ulNumOfEntries = 0;
      (*pstDependObjects)->ulBufferSize = 1;
      (*pstDependObjects)->cBuffer[0] = '\0';
   }

   // we dont use the search path
   // WKF already passes the full qualified
   // filename to us
   (*pszSearchPath)[0] = '\0';

   // Now we start to construct the command line
   (*pszCmdLine)[0] = '\0';
   strcat(*pszCmdLine,SZ_WORKDIR_PAR);
   strcat(*pszCmdLine,SZ_WORKDIR_SUBST_VAR);
   strcat(*pszCmdLine,SZ_COMMENTBUFFER);
   strcat(*pszCmdLine,(char *)szCommBufSize);
   strcat(*pszCmdLine,SZ_STRINGBUFFER);
   strcat(*pszCmdLine,(char *)szStringBufSize);

   if (pOptions->szDefSymbol[0]) {
      strcat(*pszCmdLine,SZ_DEFINE);
      strcat(*pszCmdLine,(char *)pOptions->szDefSymbol);
   }
   if (pOptions->szUnDefSymbol[0]) {
      strcat(*pszCmdLine,SZ_UNDEFINE);
      strcat(*pszCmdLine,(char *)pOptions->szUnDefSymbol);
   }

   if( pOptions->bShowVersion) {
      strcat(*pszCmdLine,SZ_SHOWVERSION);
   }
   if (pOptions->bIgnoreComments) {
      strcat(*pszCmdLine,SZ_IGNORECOMMENTS);
   }
   if (pOptions->bPrivates) {
      strcat(*pszCmdLine,SZ_PRIVATES);
   }
   if (pOptions->bReleaseOrder) {
      strcat(*pszCmdLine,SZ_RELEASEORDER);
   }
   if (pOptions->bUpdateRepository) {
      strcat(*pszCmdLine,SZ_UPDATEREPOSITORY);
   }
   if (pOptions->bNoWarnings) {
      strcat(*pszCmdLine,SZ_NOWARNINGS);
   }
   if (ulEmittedFiles) {
      strcat(*pszCmdLine,SZ_EMITPREFIX);
      strcat(*pszCmdLine,(char const*)&szEmittedFiles[1]); // skip first ;
      strcat(*pszCmdLine,SZ_EMITSUFFIX);
   }
   strcat(*pszCmdLine,SZ_INFILE_SUBST_VAR);

   // Now we construct the target list
   if (*pstTargetObjects)
   {
      (*pstTargetObjects)->cBuffer[0] = '\0';
      (*pstTargetObjects)->ulNumOfEntries = 0;

      if (ulTargetFiles)
      {
         PSZ pszTarget;
         PSZ pszNextExt;

         pszNextExt = strtok((char*)szTargetFiles,";");
         pszTarget = (*pstTargetObjects)->cBuffer;

         while(pszNextExt)
         {
            if (strcmp(pszNextExt,"xc") == 0)
            {
               pszNextExt = "cpp";
            }
            strcpy(pszTarget,"%n.");
            strcat(pszTarget, pszNextExt);
            (*pstTargetObjects)->ulNumOfEntries++;

            pszTarget += strlen(pszTarget) + 1;
            pszNextExt = strtok( NULL, ";");
         }
         pszTarget[0] = '\0'; // add the final terminating 0
      }
   }
   if (psOptions) free(psOptions);
   return NO_ERROR;
}
