#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

typedef struct _VBLOCK
{
    unsigned int hashValue;

    int number;
    long double floating;
    char *string;

    unsigned char number_ok:1;
    unsigned char floating_ok:1;
    unsigned char string_ok:1;
    unsigned char hash_ok:1;
} VBLOCK;

typedef struct _SYMBOL_ENTRY
{
    char *name;
    VBLOCK v;
    int scope;

    struct _SYMBOL_ENTRY *next;
} SYMBOL_ENTRY;

#define BITSET(s, v) (*((unsigned char *) (&(s).string+1)) = v);

#define SYM_NOTHING     0
#define SYM_NUMBER      1
#define SYM_FLOATING    2
#define SYM_STRING      4
#define SYM_HASH        8

typedef struct AVL_BUCKET {
    struct AVL_BUCKET *left;
    struct AVL_BUCKET *right;
    short bal;
} AVL_BUCKET;

typedef struct {
    int	count;
    int	(*cmp) (void *, void *);
    AVL_BUCKET *root;	
} AVL_TREE;

/*Ŀ*/
/*  The RexxDictionaryType structure is used to store values of all        */
/*  compound names.  Each stem will have a (possibly NULL) dictionary tree.*/
/*  Dictionary trees are organized as hybrid binary search trees.  As a    */
/*  compound name is formed by a stem name and a sequence of component     */
/*  names separated by periods, the dictionary trees are organized as      */
/*  binary search trees for each level of component with another sub-tree  */
/*  for the subsequent component in the compound.                          */
/*                                                                         */
/*  E.g. for the set of compounds  S.A.1, S.A.2 and S.B,                   */
/*                                                                         */
/*       the stem S will have a dictionary tree with A and B organized     */
/*       as a standard binary search tree, but with the node for A having  */
/*       an additional binary search sub-tree containing 1 and 2.          */
/*                                                                         */
/*       This additional sub-tree is referred to as the compound sub-tree. */
/*       If another item S.A.1.D was added to the set, another compound    */
/*       sub-tree would be constructed, joined to the node for 1.          */
/*                                                                         */
/*  This is reflected in the following data structure.                     */
/**/

typedef struct _rexxDictionary
{
    SYMBOL_ENTRY name;
    unsigned nameHash;       /* number computed from name to speed up comparisons */
    SYMBOL_ENTRY value;     /* this is NULL when value is STEM's */

    AVL_TREE *compoundDictionary;  
} RexxDictionaryType;

typedef struct _rexxStem
{
    SYMBOL_ENTRY name;  /* static */
    SYMBOL_ENTRY value; /* allocated */
    RexxDictionaryType *dictionary;  /* allocated */
} RexxStemType;

/*****************************************************************************/

typedef struct _rexxParseArgType
{
    int  argumentTypeFlag;              /* from above */
    int  variableTypeFlag;              /* from above */
    RexxStemType *stem;                 /* stem of item if applicable, NULL o.w. */
    SYMBOL_ENTRY *constantValue;        /* constant value */
    SYMBOL_ENTRY *simple;               /* simple variable value */
    SYMBOL_ENTRY **compound;            /* compound names */
} RexxParseArgType;

/*****************************************************************************/

#define REXXC_PARSE_NULL            0  /* end of arguments */
#define REXXC_PARSE_ASSIGN          1  /* for variables which get set during parse */
#define REXXC_PARSE_IGNORE          2  /* for periods */
#define REXXC_PARSE_POSITION        3  /* absolute end or beginning position */
#define REXXC_PARSE_RELATIVE_PLUS   4  /* + number */
#define REXXC_PARSE_RELATIVE_MINUS  5  /* - number */
#define REXXC_PARSE_PATTERN         6  /* search pattern */

#define REXXC_PARSE_VARIABLE_NONE       0  /* not a variable */
#define REXXC_PARSE_VARIABLE_SIMPLE     1
#define REXXC_PARSE_VARIABLE_STEM       2
#define REXXC_PARSE_VARIABLE_COMPOUND   3
#define REXXC_PARSE_VARIABLE_SIMPLE_    4
#define REXXC_PARSE_VARIABLE_STEM_      5

#define REXXC_PARSE_INDIRECT_END       -1  /* end of compound names */

#define SETUP_PARSE_SIMPLE(index, argType, var) \
              parseTemplate[index].argumentTypeFlag = argType; \
              parseTemplate[index].variableTypeFlag = REXXC_PARSE_VARIABLE_SIMPLE; \
              parseTemplate[index].simple = &var;

#define SETUP_PARSE_STEM(index, argType, var) \
              parseTemplate[index].argumentTypeFlag = argType; \
              parseTemplate[index].variableTypeFlag = REXXC_PARSE_VARIABLE_STEM; \
              parseTemplate[index].stem=&var;

#define SETUP_PARSE_COMPOUND(index, argType, stem, var) \
              parseTemplate[index].argumentTypeFlag = argType; \
              parseTemplate[index].variableTypeFlag = REXXC_PARSE_VARIABLE_COMPOUND; \
              parseTemplate[index].stem = &stem; \
              parseTemplate[index].compound = var;

#define SETUP_PARSE_LITERAL(index, argType, literal) \
          parseTemplate[index].argumentTypeFlag = argType; \
          parseTemplate[index].variableTypeFlag = REXXC_PARSE_VARIABLE_NONE; \
          parseTemplate[index].constantValue = literal; 

#define SETUP_PARSE_END(index) parseTemplate[index].argumentTypeFlag = REXXC_PARSE_NULL;

/*****************************************************************************/

short int strcmpg(char *s1, char *s2);

SYMBOL_ENTRY *REXXC_Add(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_AddNV(int n, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Subtract(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_SubtractVN(SYMBOL_ENTRY *p1, int n, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Multiply(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Divide(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_IntegerDivide(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_DivideRemainder(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Power(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_UnaryMinus(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *r);

void REXXC_IncrementN(SYMBOL_ENTRY *p, int number);
void REXXC_Increment(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2);

SYMBOL_ENTRY *REXXC_And(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Or(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Xor(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Not(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *r);

SYMBOL_ENTRY *REXXC_Equal(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_EqualNV(int n, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
short int REXXC_Equal_(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2);
SYMBOL_ENTRY *REXXC_NotEqual(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictEqual(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictEqualSV(char *s, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictNotEqual(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictNotEqualSV(char *s, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Greater(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_GreaterVS(SYMBOL_ENTRY *p1, char *s, SYMBOL_ENTRY *r);
short int REXXC_Greater_(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2);
SYMBOL_ENTRY *REXXC_GreaterVN(SYMBOL_ENTRY *p1, int n, SYMBOL_ENTRY *r);
short int REXXC_GreaterVN_(SYMBOL_ENTRY *p1, int n);
SYMBOL_ENTRY *REXXC_NotGreater(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictGreater(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictNotGreater(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_Less(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_LessVS(SYMBOL_ENTRY *p1, char *s, SYMBOL_ENTRY *r);
short int REXXC_Less_(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2);
SYMBOL_ENTRY *REXXC_LessVN(SYMBOL_ENTRY *p1, int n, SYMBOL_ENTRY *r);
short int REXXC_LessVN_(SYMBOL_ENTRY *p1, int n);
SYMBOL_ENTRY *REXXC_NotLess(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictLess(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);
SYMBOL_ENTRY *REXXC_StrictNotLess(SYMBOL_ENTRY *p1, SYMBOL_ENTRY *p2, SYMBOL_ENTRY *r);

void REXXC_Parse(char *input, RexxParseArgType *parseArg, int upper);

void REXXC_Say(SYMBOL_ENTRY *first,...);
char *REXXC_Pull(void);
char **REXXC_Derive(char ***names, int number, ...);

void REXXC_FatalErrorArg(int code, int errorNumber,char  *format,char  *marker);
void REXXC_FatalError(int code, int errorNumber,char  *format,...);

void REXXC_Assign(SYMBOL_ENTRY *d, SYMBOL_ENTRY *s);
char *getString(SYMBOL_ENTRY *s);
short int getNumber(SYMBOL_ENTRY *s, int *nr, long double *fr);
int getBoolean(SYMBOL_ENTRY *s);

char **REXXC_Derive(char ***names, int number, ...);
struct _rexxIndirectNamesType *REXXC_ParseDerive(int number, ...);
void REXXC_DeriveFree(char  **list);
char **REXXC_DeriveIndirect(char  ***names, struct _rexxIndirectNamesType *indirect);

void REXXC_SetCompound (RexxStemType *stem, SYMBOL_ENTRY *value, ...);
SYMBOL_ENTRY *REXXC_EvalCompound(RexxStemType *stem, ...);
void REXXC_SetStem(struct _rexxStem *stem, SYMBOL_ENTRY *value);
SYMBOL_ENTRY *REXXC_EvalStem(struct _rexxStem *stem);

char *REXXC_Copy(char *string, char *format,...);
char *REXXC_CopyStringLength(char *string, int  length);
char *REXXC_CopyStringToDot(char *string);

int REXXC_LabelIndex(char *, char **);
char *REXXC_Run(SYMBOL_ENTRY *, ...);
char *REXXC_CreateArgLine(char *, SYMBOL_ENTRY *, ...);

void REXXC_Initialize(void);

unsigned int HashName(char *);

char *REXXC_StandardIn(void);
char *REXXC_LineIn(char *filename);
char *REXXC_Lines(char *filename);
int REXXC_Lines_(char *filename);
char *REXXC_LinesStdIn(void);
int REXXC_LinesStdIn_(void);

#ifdef RUNTIME

SYMBOL_ENTRY constBuf[64];
char **deriveBuf[64];
char xbuf[1024];
char *exprBuf[8] = {xbuf, xbuf, xbuf, xbuf, xbuf, xbuf, xbuf, xbuf};

#else

extern SYMBOL_ENTRY constBuf[];
extern char **deriveBuf[];
extern char xbuf[];
extern char *exprBuf[];

#endif

SYMBOL_ENTRY *tse;  /* Temporary Symbol Entry */

#define M(e) (e, exprBuf[k+1] = exprBuf[k]+strlen(exprBuf[k])+1, exprBuf[k++])
#define CN(n) (tse = &constBuf[j++], tse->scope = -1, tse->v.number = n, tse->v.number_ok = TRUE, tse->v.string_ok = FALSE, tse->v.floating_ok = FALSE, tse)
#define CS(s) (tse = &constBuf[j++], tse->scope = -1, tse->v.string = s, tse->v.number_ok = FALSE, tse->v.string_ok = TRUE, tse->v.floating_ok = FALSE, tse)

extern char *sourceFileName;
extern unsigned int sourceLineNumber;
extern int i;
extern int j;
extern int k;
extern int scope;

char *REXXC_Function(int, ...);

