// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved



#include"mainwin.h"


//-------------------------------------------------------------------
//   TMainWindow
TMainWindow::TMainWindow(CHAR *title, ULONG flags, ULONG resource):
      TWindow(title, flags, resource)
{
   fExtension = "*.*";
}


//-------------------------------------------------------------------
//   ~TMainWindow
TMainWindow::~TMainWindow()
{

}


//-------------------------------------------------------------------
//   doCommand
MRESULT TMainWindow::doCommand(HWND hWnd, ULONG Message, MPARAM mParam1, MPARAM mParam2)
{
   short command = SHORT1FROMMP(mParam1);
   if (command == cm_FileOpen)
   {
      doFileOpen();
      return (MRESULT)TRUE;
   }
   else if (command == cm_FileSaveAs)
   {
      doFileSave();
      return (MRESULT)TRUE;
   }
   else
      return TWindow::doCommand( hWnd, Message, mParam1, mParam2);
}


//-------------------------------------------------------------------
//   getClassName
const char *TMainWindow::getClassName(void)
{
   return "TMainWindow";
}


//-------------------------------------------------------------------
//   doFileOpen
void TMainWindow::doFileOpen()
{
   FILEDLG FileDlg;
   HWND hwndDlg;

   memset(&FileDlg, 0, sizeof(FILEDLG) );
   FileDlg.cbSize = sizeof(FILEDLG);
   FileDlg.fl = FDS_CENTER | FDS_HELPBUTTON | FDS_OPEN_DIALOG;
   FileDlg.pszTitle = (PSZ)"Open File";
   strcpy(FileDlg.szFullFile, fExtension);

   hwndDlg = WinFileDlg(HWND_DESKTOP, hwndFrame, (PFILEDLG)&FileDlg);

   if (hwndDlg && (FileDlg.lReturn == DID_OK))
   {
      readFile();
   }
}


//-------------------------------------------------------------------
//   readFile
void TMainWindow::readFile()
{

}


//-------------------------------------------------------------------
//   doFileSave
void TMainWindow::doFileSave()
{
   FILEDLG FileDlg;
   HWND hwndDlg;

   memset(&FileDlg, 0, sizeof(FILEDLG) );
   FileDlg.cbSize = sizeof(FILEDLG);
   FileDlg.fl = FDS_CENTER | FDS_HELPBUTTON | FDS_SAVEAS_DIALOG;
   FileDlg.pszTitle = (PSZ)"SaveFile";
   strcpy(FileDlg.szFullFile, fExtension);

   hwndDlg = WinFileDlg(HWND_DESKTOP, hwndFrame, (PFILEDLG)&FileDlg);

   if (hwndDlg && (FileDlg.lReturn == DID_OK))
   {
      writeFile();
   }

}


//-------------------------------------------------------------------
//   writeFile
void TMainWindow::writeFile()
{

}


//-------------------------------------------------------------------
//   getFileExtension
CHAR *TMainWindow::getFileExtension()
{
   return fExtension;
}


//-------------------------------------------------------------------
//   setFileExtension
void TMainWindow::setFileExtension(CHAR *ext)
{
   fExtension = ext;
}

