/*  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Asuactl.dll -
 * Pasek narzdzi plik gwny
 * (c) 1999 Wojciech Gazda
 *
 * toolbar.c
 *
 * $Author: Wojciech_Gazda $
 * $Date: 1999/06/27 12:35:32 $
 * $Name:  $
 * $RCSfile: toolbar.c $
 * $Revision: 1.1 $
 *
 */


#define INCL_GPICONTROL
#define INCL_GPIPRIMITIVES
#define INCL_WINRECTANGLES
#define INCL_WINMESSAGEMGR
#define INCL_WINERRORS


// Deklaracje OS/2
#define  INCL_DOSPROCESS
#define  INCL_DOSMISC
#define  INCL_GPILOGCOLORTABLE
#define  INCL_WINWINDOWMGR
#define  INCL_WINFRAMEMGR
#define  INCL_WININPUT
#define  INCL_WINATOM
#define  INCL_WINSYS
#include <os2.h>


// Funkcje biblioteczne
#include <malloc.h>
#include <string.h>

// *** TEST ****
#include <stdio.h>


// Deklaracje lokalne
#define  __INTERNAL_USE__
#include "status.h"
#include "asuintl.h"
#include "toolbar.h"
#include "tooldefs.h"
#include "tcontrol.h"
#include "carrier.h"
#include "objmgr.h"




// Zmienne globalne
// Tablica wzorcw kolorw uywanych posczas rysowania paska narzdzi
PPTEMPLATE PPmColor[TOOL_MAXCOLOR] =
{{  PP_BACKGROUNDCOLOR,     QPF_NOINHERIT, // TOOL_BACKGROUND
    SYSCLR_BUTTONMIDDLE,    0xCCCCCC },    //   Kolor ta nieaktywnego paska tytuu
 {  PP_ACTIVECOLOR,         QPF_NOINHERIT, // TOOL_HILITEBACKGROUND
    0L,                     0xC7D5FF },    //   Kolor ta aktywnego paska tytuu
 {  PP_BORDERLIGHTCOLOR,    QPF_NOINHERIT, // TOOL_FRAMEHILITE
    0L,                     0xFFFFFF },    //   Kolor owietlenia
 {  PP_BORDERDARKCOLOR,     QPF_NOINHERIT, // TOOL_FRAMEDARK
    0L,                     0x808080 },    //   Kolor cienia
 {  PP_TOOLTIPBACKGROUND,   QPF_NOINHERIT, // TOOL_TIPBACKGROUND
    0L,                     0xFFFFC8 },    //   Kolor ta pod tekstem podpowiedzi
 {  PP_TOOLTIPTEXT,         QPF_NOINHERIT, // TOOL_TIPTEXTCOLOR
    SYSCLR_MENUTEXT,        0x000000 },    //   Kolor tekstu w oknie podpowiedzi
 {  PP_TOOLTIPFRAME,        QPF_NOINHERIT, // TOOL_TIPFRAMECOLOR
    0L,                     0x000000 },    //   Kolor ramki otaczajcej podpowied
 {  PP_BORDER2LIGHTCOLOR,   QPF_NOINHERIT, // TOOL_FRAMEDRAGHILITE
    0L,                     0x808080 },    //   Kolor ramki otaczajcej pasek podczas przesuwania
 {  PP_BORDER2DARKCOLOR,    QPF_NOINHERIT, // TOOL_FRAMEDRAGDARK
    0L,                     0x000000 },    //   Kolor ramki otaczajcej pasek podczas przesuwania
};


// Wersja paska narzdzi
static CTLINFO ctlToolVersion =
{ sizeof(CTLINFO),
  NULL,
  1,0
};




// Prototypy funkcji
LONG ASUAAPI CtlToolbarInitialize(HAB hab);
VOID     ToolDisplayTip(HWND hwnd, HWND hwndRef, PSZ szTipText);
VOID     ToolDrawSeparator(HWND hwnd, LONG lPos, ULONG ulSize);
TOOLCTL *ToolLoadData(HWND hwnd, PSZ module);
LONG     ToolSendNotify(HWND hwnd, ULONG notify, VOID *ctlspec);
VOID     ToolUpdateSize(TOOLCTL *tcl);

// Prototypy funkcji lokalnych
static MRESULT EXPENTRY WinToolbarProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
static MRESULT ToolAutoSize(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
static MRESULT ToolCalcRect(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
static MRESULT ToolEnableRotate(HWND hwnd, MPARAM mp1);
static MRESULT ToolQueryHeight(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
static MRESULT ToolQueryParams(HWND hwnd, MPARAM mp1);
static MRESULT ToolQueryState(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
static MRESULT ToolQueryWidth(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
static MRESULT ToolSetParams(HWND hwnd, MPARAM mp1);
static VOID  ToolDestroy(HWND hwnd);
static LONG  ToolInit(HWND hwnd, VOID *ctldata, CREATESTRUCT *ctr);

// Lokalne funkcje pomocnicze
static VOID  StoreClassData(TOOLCTL *tcl, TOOLINFO *cdata);
static VOID  StoreWindowText(TOOLCTL *tcl, PSZ text);
static VOID  UpdateTipPParams(HWND ToolBar, HWND ToolTip);





// Przygotowanie okna WC_TOOLBAR do pracy
//
// Parametry:
//   hab       - [parametr] uchwyt anchor block
//
// Powrt:
//   0    - poprawne wykonanie funkcji
//   1    - bd rejestracji klasy okna
//
LONG ASUAAPI CtlToolbarInitialize(HAB hab)
{ ULONG winstyle;   // Domylny styl okna
  LONG  rc;         // Kody bdw zwracane przez funkcje systemowe

  // Ustalenie domylnego stylu okna WC_TOOLBAR
  winstyle = CS_CLIPCHILDREN | CS_CLIPSIBLINGS;
  // Rejestracja nowej klasy okna - pasek narzdzi
  rc = WinRegisterClass(hab, WC_TOOLBAR, WinToolbarProc, winstyle, 16);
  if(!rc) return(1);

  // Rejestracja klasy paska tytuu - INTC_MINITITLE
  winstyle = CS_SYNCPAINT | CS_SIZEREDRAW;
  rc = WinRegisterClass(hab, INTC_MINITITLE, MiniTitlebarProc, winstyle, sizeof(VOID *));
  if(!rc) return(1);

  // Rejestracja klasy paska tytuu - INTC_ROTATEBTN
  winstyle = CS_SYNCPAINT | CS_SIZEREDRAW;
  rc = WinRegisterClass(hab, INTC_ROTATEBTN, RotateButtonProc, winstyle, sizeof(VOID *));
  if(!rc) return(1);

  // Rejestracja klasy okna przechowujcego obiekty - INTC_OBJECTPAD
  winstyle = CS_CLIPCHILDREN | CS_CLIPSIBLINGS | CS_HITTEST;
  rc = WinRegisterClass(hab, INTC_OBJECTPAD, ObjectPadProc, winstyle, sizeof(VOID *));

  return(0);
}





// Wywietlenie okna z podpowiedzi - okno jest pozycjonowane wzgldem
// dolnej krawdzi okna odniesienia.
//
// Parametry:
//   hwnd      - [parametr] okno rodzicielskie majce dostp do struktury TOOLCTL
//   hwndRef   - [parametr] okno odniesienia, wzgldem ktrego jest pozycjonowana podpowied
//   szTipText - [parametr] tekst podpowiedzi
//
VOID ToolDisplayTip(HWND hwnd, HWND hwndRef, PSZ szTipText)
{ TOOLCTL *tcl;          // Adres gwnej struktury kontrolnej paska narzdzi
  RECTL    screen;       // Rozmiary ekranu
  RECTL    refsize;      // Rozmiary okna odniesienia
  LONG     tlcx, tlcy;   // Rozmiary okna podpowiedzi
  LONG     tlx, tly;     // Pozycja okna podpowiedzi


  if(szTipText == NULL) return;
  tcl = ToolLoadData(hwnd, "ToolDispalyTip");
  if(tcl == NULL) return;

  // Tworzenie okna podpowiedzi jeli wczeniej nie istniao
  if(tcl->hwndToolTip == NULLHANDLE)
  { tcl->hwndToolTip = WinCreateWindow(HWND_DESKTOP, WC_STATUS, "",
                         SS_THINFRAME  | SS_BORDER | SS_CENTER |
                         SS_XAUTOSCALE | SS_YAUTOSCALE | SS_MOUSETRANSPARENT |
                         WS_SYNCPAINT,
                         0, 0, 0, 0,
                         tcl->hwndToolBar,
                         HWND_TOP, TCID_TOOLTIP,
                         NULL, NULL);

    // Kopiowanie domylnych prametrw prezentacji
    UpdateTipPParams(tcl->hwndToolBar, tcl->hwndToolTip);
  }

  if(tcl->hwndToolTip)
  { // Zaadowanie tekstu podpowiedzi
    WinSetWindowText(tcl->hwndToolTip, szTipText);
    // Odczyt rozmiarw okna podpowiedzi
    tlcx = (LONG)WinSendMsg(tcl->hwndToolTip, SM_QUERYWIDTH,  0L, 0L);
    tlcy = (LONG)WinSendMsg(tcl->hwndToolTip, SM_QUERYHEIGHT, 0L, 0L);

    // Obliczenie pozycji okna wzgldem lewego dolnego rogu ekranu
    // Odczyt rozmiarw ekranu
    WinQueryWindowRect(HWND_DESKTOP, &screen);
    // Odczyt rozmiarw okna odniesienia
    WinQueryWindowRect(hwndRef, &refsize);
    // Konwersja do wsprzdnych ekranowych
    WinMapWindowPoints(hwndRef, HWND_DESKTOP, (POINTL *)&refsize, 2L);

    // Okrelenie pooenia okna podpowiedzi
    tlx  = refsize.xLeft;
    // Korekta pooenia poziomego
    if((tlx + tlcx) > screen.xRight)
    { // Odsunicie okna od prawej krawdzi
      tlx = screen.xRight - tlcx;
    }
    else if(tlx < screen.xLeft)
    { // Dosunicie okna do lewej krawdzi
      tlx = screen.xLeft;
    }

    tly  = refsize.yBottom - tlcy - CY_BOTTOMTIPSPACE;
    // Korekta pooenia pionowego
    if(tly < screen.yBottom)
    { // Przeniesienie podpowiedzi ponad okno
      tly = refsize.yTop + CY_TOPTIPSPACE;
    }

    // Wywietlenie okna
    WinSetWindowPos(tcl->hwndToolTip, HWND_TOP,
                    tlx, tly, 0, 0,
                    SWP_MOVE | SWP_ZORDER | SWP_SHOW);
  }
}






// adowanie wskanika do struktur kontrolnych okna
// paska narzdzi i jego okien potomnych
//
// Parametry:
//   hwnd      - [parametr] uchwyt okna
//   module    - [parametr] nazwa funkcji wywoujcej funkcj (opcjonalnie)
//
// Powrt:
//   <>NULL    - wskanik do struktur kontrolnych
//     NULL    - bd odczytu
//
TOOLCTL *ToolLoadData(HWND hwnd, PSZ module)
{ TOOLCTL *tcl;     // Adres struktur kontrolnych
  //LONG     rc;      // Kod bdu

  // Odczyt adresu struktury kontrolnej
  tcl = WinQueryWindowPtr(hwnd, 0L);
  if(tcl != NULL)
  {
    // Odwieenie pl zawierajcych styl i stan paska narzdzi na podstawie
    // danych zapisanych w systemowych strukturach okna
    tcl->flWinStyle = WinQueryWindowULong(tcl->hwndToolBar, QWL_STYLE);
    if(tcl->flWinStyle & WS_MAXIMIZED) tcl->flToolState |=  TST_FIXED;
    else                               tcl->flToolState &= ~TST_FIXED;
    if(tcl->flWinStyle & WS_MINIMIZED) tcl->flToolState |=  TST_MINIMIZED;
    else                               tcl->flToolState &= ~TST_MINIMIZED;

    return(tcl);
  }

  // Odczyt kodu bdu
  //rc = WinGetLastError(WinQueryAnchorBlock(hwnd));
  // Zapisanie komunikatu do pliku
  //AsuLogPMError(WC_TOOLBAR, rc, module, "WinQueryWindowPtr is unable to get TOOLCTL structure adress.");
  // Powrt - bdny wskanik
  return(NULL);
}





// Wysanie komunikatu WM_CONTROL do waciciela okna
//
// Parametry:
//   hwnd      - [parametr] uchwyt okna wysyajcego komunikat
//   notify    - [parametr] kod potwierdzenia
//   ctlspec   - [paramet/rezultat] dane control-specific
//
// Powrt:
//   Kod zwrcony przez WinSendMsg()
//
LONG ToolSendNotify(HWND hwnd, ULONG notify, VOID *ctlspec)
{ ULONG winid;      // Identyfikator okna
  HWND  owner;      // Uchwyt waciciela
  LONG  rc;         // Kod odpowiedzi

  // Odczyt uchwytu wascicela
  owner = WinQueryWindow(hwnd, QW_OWNER);
  if(owner == NULLHANDLE) return(0);
  // Odczyt identyfikatora okna
  winid = WinQueryWindowUShort(hwnd, QWS_ID);

  // Wysanie komunikatu
  rc = (LONG)WinSendMsg(owner, WM_CONTROL, MPFROM2SHORT(winid, notify), MPFROMP(ctlspec));
  return(rc);
}





// Funkcja koryguje rozmiary paska narzdzi i uoenie okien potomnych po dodaniu
// lub odjciu obiektu
//
// Parametry:
//   tcl       - [parametr] wskanik do struktur kontrolnych paska narzdzi
//
VOID ToolUpdateSize(TOOLCTL *tcl)
{
  // Koniec przetwarzania wtedy gdy komunikat zosta wywoany podczas
  // minimalizacji/maksymalizacji lub przejcia w stan "floating"
  if(tcl->flToolState & TST_MINMAXCTL) return;

  // Korekta rozmiarw okna
  if((LONG)WinSendMsg(tcl->hwndToolBar, TM_AUTOSIZE, 0, 0) == FALSE)
  {
    // Rozmieszczenie okien kontrolnych
    CrrPlaceControls(tcl->hwndToolBar);
  }
}




/*******************/
/* Funkcje lokalne */
/*******************/

// Procedura rysujca i kontrolujca okno statusowe WC_TOOLBAR
//
static MRESULT EXPENTRY WinToolbarProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch(msg)
  {
    case WM_ADJUSTWINDOWPOS:       // Sterowanie pozycjonowaniem okna
      { SWP *swp;        // Proponowane wymiary i pooenie okna

        swp = PVOIDFROMMP(mp1);
        // Sprawdzenie czy jest to minimalizacja/maksymalizacja/odtworzenie stanu
        if(swp->fl & (SWP_MAXIMIZE | SWP_MINIMIZE | SWP_RESTORE))
        { // Wysanie komunikatu WM_MINMAXFRAME do samego siebie
          return(WinSendMsg(hwnd, WM_MINMAXFRAME, mp1, mp2));
        }
        // Obsuga pozostaych zdarze
      }
      break;


    // Tu bdzie wywoywana procedura "inteligentnego" odwieania okna.
    case WM_CALCVALIDRECTS:
      { RECTL *old, *new;

        old = PVOIDFROMMP(mp1);
        new = old + 1;

        // **** TEST ****
        memset(old, 0, sizeof(RECTL));
        //WinInvalidateRect(hwnd, NULL, TRUE);
        return(0L);
      }
      break;

    case WM_CREATE:           // Inicjacja okna
      return(MRFROMLONG(ToolInit(hwnd, PVOIDFROMMP(mp1), (CREATESTRUCT *)PVOIDFROMMP(mp2))));

    case WM_DESTROY:          // Zamknicie okna
      ToolDestroy(hwnd);
      break;

    case WM_NULL:             // Odczyt wersji kontrolki
      AsuQueryCtlInfo(hwnd, msg, mp1, &ctlToolVersion);
      break;

    case WM_OWNERPOSCHANGE:   // Nastpia zmiana pooenia waciciela
      CrrMoveWithOwner(hwnd, PVOIDFROMMP(mp1), PVOIDFROMMP(mp2));
      return(0);

    case WM_PAINT:            // Przerysowywanie okna
      CrrRedrawBorder(hwnd);
      break;

    case WM_PRESPARAMCHANGED: // Parametry prezentacji ulegy zmianie, przerysowanie okna
      WinInvalidateRect(hwnd, NULL, TRUE);
      break;

    case WM_QUERYWINDOWPARAMS:  // Odczyt parametrw okna
      return(ToolQueryParams(hwnd, mp1));

    case WM_SETWINDOWPARAMS:  // Zapamitanie parametrw okna
      return(ToolSetParams(hwnd, mp1));

    case WM_SIZE:             // Pozycjonowanie okien potomnych
      CrrPlaceControls(hwnd);
      break;

    case WM_TRACKFRAME:  // Rozpoczcie przesuwania okna
      return(MRFROMLONG(CrrTrackRect(hwnd)));

    case WM_MINMAXFRAME: // Minimalizacja/maksymalizacja/restore
      return(MRFROMLONG(CrrMinMaxFrame(hwnd, PVOIDFROMMP(mp1))));
  }

  // Obsuga niestandardowych komunikatw sterujcych TM_*
  if((msg >= TOOL_FIRST_MSG) && (msg <= TOOL_LAST_MSG))
  { switch(msg)
    { case TM_AUTOSIZE:       // Automatyczne pozycjonowanie paska
        return(ToolAutoSize(hwnd, msg, mp1, mp2));

      case TM_CALCNEWRECT:    // Obliczenie nowej proponowanej pozycji i wymiarw
        return(ToolCalcRect(hwnd, msg, mp1, mp2));

      case TM_DELETEOBJECT:   // Usunicie obiektu z paska narzdzi
        return(MRFROMLONG(ObjDeleteObject(hwnd, (ULONG)mp1)));

      case TM_ENABLEROTATE:   // Odblokowanie/zablokowanie przycisku obracania okna
        return(ToolEnableRotate(hwnd, mp1));

      case TM_IDFROMPOSITION: // Odczyt identyfikatora obiektu na podstawie pozycji
        return(MRFROMLONG(ObjIdFromPosition(hwnd, LONGFROMMP(mp1))));

      case TM_INSERTOBJECT:   // Dodanie obiektu do paska narzdzi
        return(MRFROMLONG(ObjInsertObject(hwnd, (TOOLOBJ *)mp1, (TOOLWIN *)mp2)));

      case TM_INSERTTOOLTIP:  // Dodanie podpowiedzi do paska narzdzi
        return(MRFROMLONG(ObjInsertTooltip(hwnd, LONGFROMMP(mp1), PVOIDFROMMP(mp2))));

      case TM_MOVEOBJECT:     // Przesunicie obiektu zawartego na pasku narzdzi
        return(MRFROMLONG(ObjMoveObject(hwnd, SHORT1FROMMP(mp1), SHORT2FROMMP(mp1), LONGFROMMP(mp2))));

      case TM_POSITIONFROMID: // Odczyt pozycji obiektu na podstawie identyfikatora
        return(MRFROMLONG(ObjQueryPosition(hwnd, LONGFROMMP(mp1))));

      case TM_QUERYHANDLE:    // Odczyt uchwytu okna obiektu
        return((MRESULT)ObjQueryHandle(hwnd, LONGFROMMP(mp1)));

      case TM_QUERYHEIGHT:    // Odczyt wysokoi paska
        return(ToolQueryHeight(hwnd, msg, mp1, mp2));

      case TM_QUERYOBJECT:    // Odczyt struktury informacyjnej obiektu
        return(MRFROMLONG(ObjQueryObject(hwnd, LONGFROMMP(mp1), PVOIDFROMMP(mp2))));

      case TM_QUERYOBJECTCOUNT: // Odczyt liczby obiektw umieszczonych na pasku narzdzi
        return(MRFROMLONG(ObjQueryObjectCount(hwnd)));

      case TM_QUERYSTATE:     // Odczyt aktualnego stanu paska narzdzi
        return(ToolQueryState(hwnd, msg, mp1, mp2));

      case TM_QUERYTIP:       // Odczyt tekstu podpowiedzi
        return(MRFROMLONG(ObjQueryTip(hwnd, SHORT1FROMMP(mp1), SHORT2FROMMP(mp1), PVOIDFROMMP(mp2))));

      case TM_QUERYWIDTH:     // Odczyt szerokoci paska
        return(ToolQueryWidth(hwnd, msg, mp1, mp2));

      case TM_ROTATE:         // Obracanie paska narzdzi
        return(MRFROMLONG(CrrRotate(hwnd, LONGFROMMP(mp1))));

      case TM_SETOBJECT:      // Zmiana parametrw obiektu
        return(MRFROMLONG(ObjSetObject(hwnd, SHORT1FROMMP(mp1), SHORT2FROMMP(mp1), PVOIDFROMMP(mp2))));

      case TM_SHOWOBJECT:     // Ukrycie/wywietlenie obiektu na pasku narzdzi
        return(MRFROMLONG(ObjShowObject(hwnd, LONGFROMMP(mp1), LONGFROMMP(mp2))));
    }
  }

  // Przekazanie reszty komunikatw standardowej procedurze okna
  return(WinDefWindowProc(hwnd, msg, mp1, mp2));
}





// Automatyczne skalowanie paska narzdzi
//
static MRESULT ToolAutoSize(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{ TOOLCTL *tcl;     // Wsknik do gwnej struktury kontrolnej paska
  TOOLADJ  tadj;    // Struktura sterujca pozycjonowaniem paska narzdzi
  RECTL    oldpos;  // Stare rozmiary paska narzdzi
  ULONG    maxl;    // Maksymalna dugo paska narzdzi


  // Odczyt adresu struktur kontrolnych
  tcl = ToolLoadData(hwnd, "ToolAutoSize");
  if(tcl == NULL) return(0);
  // Odczyt max. dugoci paska
  maxl = LONGFROMMP(mp1);
  // Zapamitanie aktualnych rozmiarw paska narzdzi
  WinQueryWindowRect(tcl->hwndToolBar, &oldpos);

  // Inicjacja struktury TOOLADJ
  tadj.hwndToolBar = hwnd;
  tadj.hwndParent  = WinQueryWindow(hwnd, QW_PARENT);
  tadj.flAttrs     = tcl->flToolAttrs;
  tadj.flState     = tcl->flToolState;

  // Obliczenie proponowanych wymiarw i pozycji paska narzdzi
  CrrCalcNewRect(&tadj);
  // Wysanie potwierdzenia do waciciela
  ToolSendNotify(hwnd, TN_AUTOSIZE, &tadj);

  // Ustawienie nowej pozycji paska
  WinSetWindowPos(hwnd, HWND_TOP,
                  tadj.rclSizePos.xLeft,
                  tadj.rclSizePos.yBottom,
                  tadj.rclSizePos.xRight - tadj.rclSizePos.xLeft,
                  tadj.rclSizePos.yTop   - tadj.rclSizePos.yBottom,
                  SWP_ZORDER | SWP_MOVE | SWP_SIZE);

  if((tadj.rclSizePos.xRight - tadj.rclSizePos.xLeft) != (oldpos.xRight - oldpos.xLeft))
    return(MRFROMLONG(TRUE));
  if((tadj.rclSizePos.yTop - tadj.rclSizePos.yBottom) != (oldpos.yTop - oldpos.yBottom))
    return(MRFROMLONG(TRUE));
  // Wymiary nie zmieniy si
  return(FALSE);
}





// Funkcja umoliwia obliczenie nowych wymiarw i pozycji paska narzdzi na
// podstawie parametrw przekazanych za porednictwem mp1
// (struktura TOOLADJ)
//
static MRESULT ToolCalcRect(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{ TOOLADJ  *tadj;   // Wskanik do struktury zawierajcej proponowane atrybuty
  TOOLCTL  *tcl;    // Wskanik do gwnej struktury kontrolnej paska

  // adowanie danych kontrolnych
  tcl = ToolLoadData(hwnd, "ToolCalcRect");
  if(tcl == NULL) return(0);

  // Odczyt wskanika do struktury
  tadj = PVOIDFROMMP(mp1);
  // Korekta zawartoci pl struktury
  tadj->hwndToolBar = hwnd;
  tadj->hwndParent  = WinQueryWindow(hwnd, QW_PARENT);
  // Korekta stanu okna - uwzgldnienie flag niedostpnych dla uytkownika
  tadj->flState &= 0xFFFF;
  tadj->flState |= (tcl->flToolState & 0xFFFF0000);

  CrrCalcNewRect(tadj);
  return(0);
}






// Odblokowanie/zablokowanie przycisku obracania okna. Stan przycisku
// mona odczyta za pomoc WinIsWindowEnabled, dla okna o identyfikatorze TCID_ROTATE
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   mp1       - [parametr] nowy stan przycisku
//
static MRESULT ToolEnableRotate(HWND hwnd, MPARAM mp1)
{ TOOLCTL *tcl;          // Wskanik do struktur kontrolnych okna

  tcl = ToolLoadData(hwnd, "ToolEnableRestore");
  if(tcl == NULL) return(0);

  // Sterowanie przyciskiem
  if(tcl->flWinStyle & TBS_ROTATEBUTTON)
  { if((BOOL)mp1 == TRUE)
    { // Odblokowanie przycisku obracania okna
      WinEnableWindow(tcl->hwndRotate, TRUE);
    }
    else
    { // Zablokowanie przycisku obracania okna
      WinEnableWindow(tcl->hwndRotate, FALSE);
    }

    // Korekta wymiarw okna
    ToolUpdateSize(tcl);
  }
  return(0);
}





// Odczyt proponowanej wysokoci paska narzdzi
//
static MRESULT ToolQueryHeight(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{ TOOLCTL *tcl;          // Wskanik do gwnej struktury kontrolnej
  TOOLADJ  tadj;         // Struktura wypeniana przez funkcje okrelajce rozmiary
  ULONG    options;      // Opcje sterujce odczytem wysokoci

  tcl = ToolLoadData(hwnd, "ToolQueryHeight");
  if(tcl == NULL) return(0);
  // Inicjacja struktury TOOLADJ
  tadj.hwndToolBar = hwnd;
  tadj.hwndParent  = WinQueryWindow(hwnd, QW_PARENT);
  tadj.flAttrs = tcl->flToolAttrs;
  tadj.flState = tcl->flToolState;

  // Odczyt i interpretacja opcji
  options = LONGFROMMP(mp1);
  if(options != TDQ_CURRENT)
  { tadj.flState &= ~(TST_MINIMIZED | TST_FIXED);
    if(options == TDQ_MINIMIZED) tadj.flState |= TST_MINIMIZED;
    if(options == TDQ_FIXED)     tadj.flState |= TST_FIXED;
  }

  // Odczyt wysokoci paska
  return(MRFROMLONG(CrrQueryHeight(&tadj)));
}





// Obsuga komunikatu WM_QUERYWINDOWPARAMS
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   mp1       - [parametr] wskanik do struktury WNDPARAMS
//
// Powrt:
//   FALSE - bd odczytu
//   TRUE  - odczyt wykonany poprawnie
//
static MRESULT ToolQueryParams(HWND hwnd, MPARAM mp1)
{ WNDPARAMS *wpm;   // Adres struktury w ktrej funkcja zwraca odczytane wartoci
  TOOLCTL   *tcl;   // Adres gwnej struktury kontrolnej okna

  // Inicjacja zmiennych
  tcl = ToolLoadData(hwnd, "ToolQueryParams");
  if(tcl == NULL) return(FALSE);
  wpm = (WNDPARAMS *)mp1;

  // Odczyt rozmiaru danych Class-Specific
  if(wpm->fsStatus & WPM_CBCTLDATA)
  { wpm->cbCtlData = sizeof(TOOLINFO);
    wpm->fsStatus &= ~WPM_CBCTLDATA;
  }

  // Odczyt dugoci tekstu przechowywanego w oknie
  if(wpm->fsStatus & WPM_CCHTEXT)
  { if(tcl->szWinText == NULL)
      wpm->cchText = 0;
    else wpm->cchText = strlen(tcl->szWinText);
    wpm->fsStatus &= ~WPM_CCHTEXT;
  }

  // Odczyt danych Class-Specific
  if(wpm->fsStatus & WPM_CTLDATA)
  { TOOLINFO *tnfo;      // Wskanik pomocniczy

    tnfo = wpm->pCtlData;
    tnfo->cb          = sizeof(TOOLINFO);
    tnfo->flToolAttrs = tcl->flToolAttrs;
    tnfo->usMaxLength = tcl->ulMaxLength;
    wpm->fsStatus &= ~WPM_CTLDATA;
  }

  // Odczyt tytuu okna
  if(wpm->fsStatus & WPM_TEXT)
  { if(tcl->szWinText != NULL)
      strcpy(wpm->pszText, tcl->szWinText);
     wpm->fsStatus &= ~WPM_TEXT;
  }

  return(MRFROMLONG(TRUE));
}





// Odczyt stanu paska narzdzi
//
static MRESULT ToolQueryState(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{ TOOLCTL *tcl;          // Wskanik do gwnej struktury kontrolnej

  tcl = ToolLoadData(hwnd, "ToolQueryState");
  if(tcl == NULL) return(0);

  return(MRFROMLONG(tcl->flToolState & 0xFFFF));
}





// Odczyt proponowanej szerokoci paska narzdzi
//
static MRESULT ToolQueryWidth(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{ TOOLCTL *tcl;          // Wskanik do gwnej struktury kontrolnej
  TOOLADJ  tadj;         // Struktura wypeniana przez funkcje okrelajce rozmiary
  ULONG    options;      // Opcje sterujce odczytem szerokoci

  tcl = ToolLoadData(hwnd, "ToolQueryWidth");
  if(tcl == NULL) return(0);
  // Inicjacja struktury TOOLADJ
  tadj.hwndToolBar = hwnd;
  tadj.hwndParent  = WinQueryWindow(hwnd, QW_PARENT);
  tadj.flAttrs = tcl->flToolAttrs;
  tadj.flState = tcl->flToolState;

  // Odczyt opcji
  options = LONGFROMMP(mp1);
  if(options != TDQ_CURRENT)
  { tadj.flState &= ~(TST_MINIMIZED | TST_FIXED);
    if(options == TDQ_MINIMIZED) tadj.flState |= TST_MINIMIZED;
    if(options == TDQ_FIXED)     tadj.flState |= TST_FIXED;
  }

  // Odczyt szerokoi paska
  return(MRFROMLONG(CrrQueryWidth(&tadj)));
}





// Ustawienie parametrw okna (obsuga komunikatu WM_SETWINDOWPARAMS)
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   mp1       - [parametr] wskanik do struktury WNDPARAMS
//
// Powrt:
//   TRUE  - poprawne wykonanie funkcji
//   FALSE - bd zmiany parametrw
//
static MRESULT ToolSetParams(HWND hwnd, MPARAM mp1)
{ WNDPARAMS *wpm;   // Wskanik do struktury zawierajcej zmieniane parametry
  TOOLCTL   *tcl;   // Wskanik do gwnej struktury kontrolnej okna

  // Inicjacja zmiennych
  tcl = ToolLoadData(hwnd, "ToolSetParams");
  if(tcl == NULL) return(MRFROMLONG(FALSE));
  wpm = (WNDPARAMS *)mp1;

  // adowanie danych Class-Specific
  if(wpm->fsStatus & WPM_CTLDATA)
  {
    // Zapamitanie danych
    StoreClassData(tcl, (TOOLINFO *)wpm->pCtlData);
    // Korekta wymiarw okna
    WinSendMsg(tcl->hwndToolBar, TM_AUTOSIZE, 0, 0);
  }

  // adowanie tytuu okna
  if(wpm->fsStatus & WPM_TEXT)
  {
    // Zapamitanie tekstu
    StoreWindowText(tcl, wpm->pszText);
  }

  return(MRFROMLONG(TRUE));
}





// Usunicie struktur kontrolnych paska narzdzi
//
// Parametry:
//   hwnd      - [parametr] uchwyt okna
//
static VOID ToolDestroy(HWND hwnd)
{ TOOLCTL *tcl;          // Gwna struktura kontrolna paska narzdzi

  // Odczyt adresu struktury kontrolnej
  tcl = ToolLoadData(hwnd, "ToolDestroy");
  if(tcl == NULL) return;

  // Usunicie zasobw zwizanych z obiektami umieszczonymi na pasku
  ObjReleaseResources(tcl);

  // Usunicie paska tytuu
  if(tcl->hwndTitleBar != NULLHANDLE)
    WinDestroyWindow(tcl->hwndTitleBar);
  // Usunicie okna podpowiedzi
  if(tcl->hwndToolTip != NULLHANDLE)
    WinDestroyWindow(tcl->hwndToolTip);
  // Usunicie przycisku obracania okna
  if(tcl->hwndRotate != NULLHANDLE)
    WinDestroyWindow(tcl->hwndRotate);

  // Zwolnienie pamici zajmowanej przez tekst okna
  if(tcl->szWinText != NULL) free(tcl->szWinText);
  // Zwolnienie pamici zajmowanej przez struktury kontrolne
  free(tcl);
}





// Inicjacja paska narzdzi
//
// Parametry:
//   hwnd      - [parametr] uchwyt okna
//   ctldata   - [parametr] dane class-specific
//   ctr       - [parametr] struktura informacyjna przekazywana przy tworzeniu okna
//
// Powrt:
//   FALSE - poprawne wykonanie funkcji
//   TRUE  - bd inicjacji
//
static LONG ToolInit(HWND hwnd, VOID *ctldata, CREATESTRUCT *ctr)
{ TOOLCTL *tcl;          // Gwna struktura kontrolna paska narzdzi


  // Alokacja pamici dla struktur kontrolnych
  tcl = malloc(sizeof(TOOLCTL));
  if(tcl == NULL) return(TRUE);
  memset(tcl, 0, sizeof(TOOLCTL));

  // Zapamitanie wskanika w zmiennych okna
  WinSetWindowPtr(hwnd, 0L, tcl);

  // Uchwyt okna
  tcl->hwndToolBar = hwnd;
  // Style okna
  tcl->flWinStyle = ctr->flStyle;

  // Zapamitanie tekstu wywietlanego w oknie
  StoreWindowText(tcl, ctr->pszText);
  // Zapamitanie presentation parameters
  if(ctr->pPresParams != NULL)
    PpmStorePresParams(hwnd, ctr->pPresParams, NULL, 0);
  // Zapamitanie danych class-specific w strukturach kontrolnych
  StoreClassData(tcl, ctr->pCtlData);

  // Inicjacja nonika
  if(CrrInitialize(hwnd, tcl)) return(TRUE);
  // Inicjacja moduu Object Manager
  if(ObjInitialize(tcl) == TRUE) return(TRUE);

  // Poprawne wykonanie funkcji
  return(FALSE);
}





/******************************/
/* Dodatkowe funkcje usugowe */
/******************************/

// Zapamitanie danych class-specific w wewntrznych strukturach okna
//
// Parametry:
//   tcl       - [rezultat] adres gwnej struktury kontrolnej paska narzdzi
//   cdata     - [parametr] wskanik do danych class-specific paska
//
static VOID  StoreClassData(TOOLCTL *tcl, TOOLINFO *cdata)
{ LONG  dsize;      // Rozmiar danych class-specific

  // Obliczenie rozmiaru struktury danych
  if(cdata == NULL) dsize = 0;
  else              dsize = cdata->cb;

  // Opuszczenie pola okrelajcego rozmiar struktury
  dsize -= sizeof(cdata->cb);
  // Odczyt i zapamitanie atrybutw paska narzdzi (jeli s)
  if(dsize >= (LONG)sizeof(cdata->flToolAttrs))
  { tcl->flToolAttrs = cdata->flToolAttrs;
    dsize -= sizeof(cdata->flToolAttrs);
  }
  else return;
  // Korekta bitw stanu okna w zalenoci od przekazanych atrybutw
  if(tcl->flToolAttrs & TBA_VERTICAL)
    tcl->flToolState |= TST_ROTATED;

  // Odczyt i zapamitanie maksymalnej dugoci paska (jeli jest)
  if(dsize >= (LONG)sizeof(cdata->usMaxLength))
  { tcl->ulMaxLength = cdata->usMaxLength;
    dsize -= sizeof(cdata->usMaxLength);
  }
  else return;

  // ***** TEST *****
  // tcl->flToolState |= TST_FULLTRCFRAME;
}





// Zapamitanie tekstu w zmiennych kontrolnych okna
//
// Parametry:
//   tcl       - [rezultat] adres gwnej struktury kontrolnej okna
//   text      - [parametr] wskanik do zapamitywanego cigu znakw
//
static VOID StoreWindowText(TOOLCTL *tcl, PSZ text)
{ LONG tlng;        // Dugo acucha tekstowego

  // Odczyt dugoci acucha tekstowego
  if(text == NULL) tlng = 0;
  else             tlng = strlen(text) + 1;

  if(tlng == 0)
  { // Zwolnienie pamici zajmowanej przez tekst
    if(tcl->szWinText != NULL)
      free(tcl->szWinText);
    tcl->szWinText = NULL;
    return;
  }
  else
  { // Alokacja pamici "od zera"
    if(tcl->szWinText == NULL)
    { tcl->szWinText = malloc(tlng);
      // Bd alokacji
      if(tcl->szWinText == NULL) return;
    }
    else
    { PSZ tmp;      // Wskanik pomocniczy

      // Zmiana rozmiaru zaalokowanego obszaru pamici
      tmp = realloc(tcl->szWinText, tlng);
      if(tmp == NULL)
      { free(tcl->szWinText);
        tcl->szWinText = NULL;
        return;
      }
      // Zapamitanie adresu nowego obszaru
      tcl->szWinText = tmp;
    }
  }
  // Zapamitanie tekstu
  strcpy(tcl->szWinText, text);
}





// Aktualizacja paramerw prezentacji okna podpowiedzi
//
// Parametry:
//   ToolBar   - [parametr] uchwyt paska narzdzi - okno zawiera parametry rdowe
//   ToolTip   - [parametr] uchwyt okna podpowiedzi
//
static VOID UpdateTipPParams(HWND ToolBar, HWND ToolTip)
{ LONG  color;     // Odczytana warto koloru
  UCHAR font[32];  // Nazwa i rozmiar czcionki
  LONG  rc;        // Kody zwracane przez funkcje systemowe


  // adowanie kolorw do pamici okna podpowiedzi
  // Zablokowanie odwieania okna
  WinEnableWindowUpdate(ToolTip, FALSE);

  // Zaadowanie nowych kolorw
  PpmQueryPresColors(ToolBar, 1, PPmColor + TOOL_TIPBACKGROUND, &color);
  WinSetPresParam(ToolTip, PP_BACKGROUNDCOLOR,  4, &color);
  PpmQueryPresColors(ToolBar, 1, PPmColor + TOOL_TIPTEXTCOLOR, &color);
  WinSetPresParam(ToolTip, PP_FOREGROUNDCOLOR,  4, &color);
  PpmQueryPresColors(ToolBar, 1, PPmColor + TOOL_TIPFRAMECOLOR, &color);
  WinSetPresParam(ToolTip, PP_BORDER2DARKCOLOR, 4, &color);

  // Prba odczytu nazwy czcionki
  rc = WinQueryPresParam(ToolBar, PP_TOOLTIPFONT, 0L, NULL, 32L, font, 0L);
  // Programowanie czcionki odczytanej lub domylenj
  if(!rc) WinSetPresParam(ToolTip, PP_FONTNAMESIZE, 7, "8.Helv");
  else    WinSetPresParam(ToolTip, PP_FONTNAMESIZE, rc, font);

  // Odblokowanie odwieania okna
  WinEnableWindowUpdate(ToolTip, TRUE);
}

/*
 * $Log: toolbar.c $
 * Revision 1.1  1999/06/27 12:35:32  Wojciech_Gazda
 * Initial revision
 *
 */
