/* Biblioteka okien kontrolnych - Asua Controls
 * Pomocnicze funkcje graficzne.
 * (c) 1999 Wojciech Gazda & Przemyslaw Dobrowolski
 *
 * graphics.c
 *
 * $Author: $
 * $Date:  $
 * $Name:  $
 * $RCSfile:  $
 * $Revision: $
 *
 */

/*  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


// Deklaracje OS/2
#define  INCL_GPIBITMAPS
#define INCL_GPIPRIMITIVES
#include <os2.h>

// Funkcje biblioteczne

// Deklarace lokalne
#include "graphics.h"



// Prototypy funkcji
LONG ASUAAPI GrfDrawBitmap(HPS hps, HBITMAP hbmColor, HBITMAP hbmMono, POINTL *pos, BOOL flPattern);






// Rysowanie mapy bitowej z przezroczystym tem.
// Rozmiary bitmapy odczytywane s automatycznie.
//
// Parametry:
//   hps       - [parametr] presentation space
//   hbmColor  - [parametr] uchwyt kolorowej mapy bitowej
//   hbmMono   - [parametr] uchwyt maski bitowej, wycinajcej to
//   pos       - [parametr] pooenie i rozmiary modyfikowanego obszaru
//   flPattern - [parametr] znacznik naoenia rastru: TRUE - nakadany jest raster
//
// Powrt:
//    0 - Poprawne wykonanie funkcji
//  <>0 - Bd
//
LONG ASUAAPI GrfDrawBitmap(HPS hps, HBITMAP hbmColor, HBITMAP hbmMono, POINTL *pos, BOOL flPattern)
{ BITMAPINFOHEADER2 *bfh;     // Wskanik do pocztku struktury informacyjnej
  POINTL bmpos[4];            // Pozycja mapy bitowej (wsprzdzne dla GpiWCBitBlt)
  UCHAR  tmp[16];             // Bufor na pocztkow cz struktury BITMAPINFOHEADER2
  ULONG  ulMode;              // Tryb rysowania kolorowej mapy bitowej

  if(hbmColor == NULLHANDLE) return(1);
  // Inicjacja zmiennych
  bfh = (BITMAPINFOHEADER2 *)tmp;


  if(hbmMono != NULLHANDLE)
  { // Odczyt wymiarw mapy bitowej
    bfh->cbFix = 16;
    if(GpiQueryBitmapInfoHeader(hbmMono, bfh) == FALSE) return(1);

    // Obliczenie wsprzdnych kopiowanych map bitowych
    // Wsprzdne lewego dolnego rogu obszaru docelowego
    bmpos[0].x = pos->x;
    bmpos[0].y = pos->y;
    // Wsprzdne prawego grnego rogu obszaru docelowego
    bmpos[1].x = bmpos[0].x + bfh->cx - 1;
    bmpos[1].y = bmpos[0].y + bfh->cy - 1;
    // Wsprzdne lewego dolnego rogu obszaru rdowego
    bmpos[2].x = 0;
    bmpos[2].y = 0;
    // Wsprzdne prawego grnego rogu obszaru rdowego
    bmpos[3].x = bfh->cx;
    bmpos[3].y = bfh->cy;

    // Ustawienie atrybutw - koloru ta i punktu
    GpiSetColor(hps, CLR_WHITE);
    GpiSetBackColor(hps, CLR_BLACK);

    // Ustalenie trybu kopiowania maski (czy ma by nakadany raster)
    if(flPattern == TRUE)
      ulMode = 0x8A;
    else ulMode = ROP_SRCAND;

    // Kopiowanie podkadowej mapy bitowej
    GpiWCBitBlt(hps, hbmMono, 4L, bmpos, ulMode, 0L);
  }

  // Odczyt wymiarw kolorowej mapy bitowej
  bfh->cbFix = 16;
  if(GpiQueryBitmapInfoHeader(hbmColor, bfh) == FALSE) return(1);

  // Ponowne obliczenie wsprzdnych kopiowanych map bitowych
  // (GpiWCBitBlt modyfikuje wsprzdne)
  // Wsprzdne lewego dolnego rogu obszaru docelowego
  bmpos[0].x = pos->x;
  bmpos[0].y = pos->y;
  // Wsprzdne prawego grnego rogu obszaru docelowego
  bmpos[1].x = bmpos[0].x + bfh->cx - 1;
  bmpos[1].y = bmpos[0].y + bfh->cy - 1;
  // Wsprzdne lewego dolnego rogu obszaru rdowego
  bmpos[2].x = 0;
  bmpos[2].y = 0;
  // Wsprzdne prawego grnego rogu obszaru rdowego
  bmpos[3].x = bfh->cx;
  bmpos[3].y = bfh->cy;

  // Okrelenie trybu nakadania mapy bitowej
  if(hbmMono == NULLHANDLE)
  { // Rysowanie tylko mapy kolorowej
    if(flPattern == TRUE)
    { // Uwzgldnienie rastra
      ulMode = 0xCA;
    }
    else ulMode = ROP_SRCCOPY;
  }
  else
  { // Rysowanie bitmapy z naoon przezroczystoci
    if(flPattern == TRUE)
    { // Uwzgldnienie rastra
      ulMode = 0xEA;
    }
    else ulMode = ROP_SRCPAINT;
  }

  // Rysowanie kolorowej mapy bitowej
  GpiWCBitBlt(hps, hbmColor, 4L, bmpos, ulMode, 0L);
  return(0);
}

/*
 * $Log: $
 *
 */
