package Config;
use Exporter ();
@ISA = (Exporter);
@EXPORT = qw(%Config);
@EXPORT_OK = qw(myconfig config_sh config_vars);

$] == 5.002 or die sprintf
    "Perl lib version (5.002) doesn't match executable version (%.3f)\n", $];

# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

##
## This file was produced by running the Configure script. It holds all the
## definitions figured out by Configure. Should you modify one of these values,
## do not forget to propagate your changes by running "Configure -der". You may
## instead choose to run each of the .SH files by yourself, or "Configure -S".
##
#
## Configuration time: Tue Feb 20 13:47:28 CUT 1996
## Configured by: ak
## Target system: OS/2 2.11 - EMX 0.9

my $config_sh = <<'!END!';
archlibexp='c:/usr/lib/perl5/os2'
archname='os2'
cc='gcc'
ccflags='-Zomf'
cppflags='-DDOSISH -DOS2=2 -DEMBED -I. -Ios2'
dlsrc='dl_os2.xs'
dynamic_ext='Fcntl GDBM_File SDBM_File POSIX Socket OS2::UPM OS2::REXX OS2::FTP'
extensions='Fcntl GDBM_File SDBM_File POSIX Socket OS2::UPM OS2::REXX OS2::FTP'
installarchlib='c:/usr/perl5/os2'
installprivlib='c:/usr/perl5'
libpth=''
libs=''
osname='OS/2'
osvers='3.0'
prefix='c:/usr'
privlibexp='c:/usr/perl'
sharpbang='extproc '
shsharp='true'
sig_name='ZERO HUP INT QUIT ILL TRAP ABRT EMT FPE KILL BUS SEGV SYS PIPE ALRM TERM USR1 USR2 CHLD 19 20 BREAK'
so='dll'
startsh='extproc ksh'
static_ext=' '
Author=''
CONFIG='true'
Date='$Date'
Header=''
Id='$Id'
Locker=''
Log='$Log'
Mcc='Mcc'
PATCHLEVEL='2'
RCSfile='$RCSfile'
Revision='$Revision'
Source=''
State=''
afs='false'
alignbytes='8'
aphostname=''
ar='ar'
archlib='c:/usr/lib/perl5/os2'
archobjs=''
awk='awk'
baserev='5.0'
bash=''
bin='c:/usr/binp'
binexp='c:/usr/binp'
bison='bison'
byacc=''
byteorder='1234'
c='\c'
castflags='0'
cat='cat'
cccdlflags='-Zdll'
ccdlflags=''
cf_by='ak'
cf_email='ak@ananke.s.bawue.de'
cf_time='Tue Feb 20 13:47:28 CET 1996'
chgrp=''
chmod=''
chown=''
clocktype='clock_t'
comm='comm'
compress='compress'
contains='grep'
cp='cp'
cpio='cpio'
cpp='cpp'
cpp_stuff='42'
cpplast=''
cppminus=''
cpprun='cpp'
cppstdin='cpp'
cryptlib=''
csh=''
d_Gconvert='gcvt((x),(n),(b))'
d_access='define'
d_alarm='define'
d_archlib='define'
d_attribut='define'
d_bcmp='define'
d_bcopy='define'
d_bsd='undef'
d_bsdpgrp='undef'
d_bzero='define'
d_casti32='define'
d_castneg='define'
d_charvspr='define'
d_chown='undef'
d_chroot='undef'
d_chsize='define'
d_closedir='define'
d_const='define'
d_crypt='define'
d_csh='undef'
d_cuserid='define'
d_dbl_dig='define'
d_difftime='define'
d_dirnamlen='define'
d_dlerror='undef'
d_dlopen='undef'
d_dlsymun='undef'
d_dosuid='undef'
d_dup2='define'
d_eofnblk='define'
d_fchmod='undef'
d_fchown='undef'
d_fcntl='define'
d_fd_macros='define'
d_fd_set='define'
d_fds_bits='define'
d_fgetpos='define'
d_flexfnam='define'
d_flock='define'
d_fork='undef'
d_fpathconf='define'
d_fsetpos='define'
d_getgrps='undef'
d_gethent='define'
d_gethname='undef'
d_getlogin='undef'
d_getpgrp2='undef'
d_getpgrp='undef'
d_getppid='define'
d_getprior='define'
d_htonl='define'
d_index='undef'
d_isascii='define'
d_killpg='undef'
d_link='undef'
d_locconv='define'
d_lockf='undef'
d_lstat='undef'
d_mblen='define'
d_mbstowcs='define'
d_mbtowc='define'
d_memcmp='define'
d_memcpy='define'
d_memmove='define'
d_memset='define'
d_mkdir='define'
d_mkfifo='undef'
d_mktime='define'
d_msg='undef'
d_msgctl='undef'
d_msgget='undef'
d_msgrcv='undef'
d_msgsnd='undef'
d_mymalloc='define'
d_nice='undef'
d_oldarchlib='undef'
d_oldsock='undef'
d_open3='undef'
d_pathconf='define'
d_pause='define'
d_phostname='undef'
d_pipe='define'
d_poll='undef'
d_portable='define'
d_pwage='undef'
d_pwchange='undef'
d_pwclass='undef'
d_pwcomment='undef'
d_pwexpire='undef'
d_pwquota='undef'
d_readdir='define'
d_readlink='undef'
d_rename='define'
d_rewinddir='define'
d_rmdir='define'
d_safebcpy='undef'
d_safemcpy='undef'
d_seekdir='define'
d_select='define'
d_sem='undef'
d_semctl='undef'
d_semget='undef'
d_semop='undef'
d_setegid='undef'
d_seteuid='undef'
d_setlinebuf='undef'
d_setlocale='define'
d_setpgid='undef'
d_setpgrp2='undef'
d_setpgrp='undef'
d_setprior='define'
d_setregid='undef'
d_setresgid='undef'
d_setresuid='undef'
d_setreuid='undef'
d_setrgid='undef'
d_setruid='undef'
d_setsid='undef'
d_shm='undef'
d_shmat='undef'
d_shmatprototype='undef'
d_shmctl='undef'
d_shmdt='undef'
d_shmget='undef'
d_shrplib='undef'
d_sigaction='define'
d_sigintrp=''
d_sigvec='define'
d_sigvectr='undef'
d_socket='define'
d_sockpair='undef'
d_statblks='undef'
d_stdio_cnt_lval='define'
d_stdio_ptr_lval='define'
d_stdiobase='define'
d_stdstdio='define'
d_strchr='define'
d_strcoll='define'
d_strctcpy='define'
d_strerrm='strerror(e)'
d_strerror='define'
d_strxfrm='define'
d_suidsafe='undef'
d_symlink='undef'
d_syscall='undef'
d_sysconf='define'
d_sysernlst=''
d_syserrlst='define'
d_system='define'
d_tcgetpgrp='define'
d_tcsetpgrp='define'
d_telldir='define'
d_time='define'
d_times='define'
d_truncate='define'
d_tzname='define'
d_umask='define'
d_uname='define'
d_unlnkallvers='define'
d_vfork='undef'
d_vms='undef'
d_void_closedir='define'
d_voidsig='define'
d_voidtty=''
d_volatile='define'
d_vprintf='define'
d_wait4='undef'
d_waitpid='define'
d_wcstombs='define'
d_wctomb='define'
d_xenix='undef'
date='date'
db_hashtype='int'
db_prefixtype='int'
defvoidused='15'
direntrytype='struct dirent'
dlext='dll'
eagain='EAGAIN'
echo='echo'
egrep='egrep'
emacs=''
eunicefix=':'
exe_ext=''
expr='expr'
find='find'
firstmakefile='makefile'
flex=''
fpostype='fpos_t'
freetype='void'
full_csh=''
full_sed='sed'
gcc=''
gccversion=''
gidtype='gid_t'
glibpth='c:/usr/lib/emx h:/emx/lib'
grep='grep'
groupcat=''
groupstype='gid_t'
h_fcntl='true'
h_sysfile='true'
hint='recommended'
hostcat=''
huge=''
i_bsdioctl=''
i_db='undef'
i_dbm='define'
i_dirent='define'
i_dld='undef'
i_dlfcn='undef'
i_fcntl='define'
i_float='define'
i_gdbm='define'
i_grp='undef'
i_limits='define'
i_locale='define'
i_malloc='define'
i_math='define'
i_memory='undef'
i_ndbm='undef'
i_neterrno='undef'
i_niin='define'
i_pwd='undef'
i_rpcsvcdbm='undef'
i_sgtty='undef'
i_stdarg='define'
i_stddef='define'
i_stdlib='define'
i_string='define'
i_sysdir='define'
i_sysfile='define'
i_sysfilio='undef'
i_sysin='undef'
i_sysioctl='define'
i_sysndir='undef'
i_sysparam='define'
i_sysselct='define'
i_syssockio=''
i_sysstat='define'
i_systime='define'
i_systimek='undef'
i_systimes='define'
i_systypes='define'
i_sysun='undef'
i_termio='undef'
i_termios='define'
i_time='define'
i_unistd='define'
i_utime='define'
i_varargs='undef'
i_varhdr='stdarg.h'
i_vfork='undef'
incpath=''
inews=''
installbin='c:/usr/binp'
installman1dir=''
installman3dir=''
installscript='c:/usr/binp'
installsitearch='c:/usr/perl5'
installsitelib='c:/usr/perl'
intsize='4'
known_extensions='DB_File Fcntl FileHandle GDBM_File NDBM_File ODBM_File POSIX SDBM_File Safe Socket UPM REXXCALL'
ksh='ksh'
large=''
ld='gcc'
lddlflags='-Zdll'
ldflags='-Zomf'
less='pg'
lib_ext='.lib'
libc=''
libswanted=''
line='line'
lint=''
lkflags=''
ln=''
lns=''
locincpth=''
loclibpth=''
lp=''
lpr=''
ls='ls'
lseektype='off_t'
mail=''
mailx=''
make=''
mallocobj='malloc.obj'
mallocsrc='malloc.c'
malloctype='void *'
man1dir=''
man1direxp=''
man1ext=''
man3dir=''
man3direxp=''
man3ext=''
medium=''
mips=''
mips_type=''
mkdir='mkdir'
models='none'
modetype='mode_t'
more='pg'
mv=''
myarchname='OS/2 3.0'
mydomain='.s.bawue.de'
myhostname='ananke'
myuname='OS/2 3.0 - EMX 0.9b'
n=''
nm_opt='-p'
nroff='nroff'
o_nonblock='O_NONBLOCK'
obj_ext='.obj'
oldarchlib=''
oldarchlibexp=''
optimize='-O2'
orderlib='false'
package='perl5'
pager='pg'
passcat=''
patchlevel='2'
path_sep=';'
perl='perl'
perladmin='ak@ananke.s.bawue.de'
perlpath='c:/usr/bin/perl'
pg='pg'
phostname='hostname'
plibpth=''
pmake=''
pr=''
prefixexp='c:/usr'
privlib='c:/usr/perl'
prototype='define'
randbits='15'
ranlib=':'
rd_nodata='-1'
rm='rm'
rmail=''
runnm='true'
scriptdir='c:/usr/binp'
scriptdirexp='c:/usr/bin'
sed='sed'
selecttype='int *'
sendmail=''
sh=''
shar=''
shmattype='char *'
shrpdir='none'
sig_num='0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 '
signal_t='void'
sitearch='c:/usr/perl/os'
sitearchexp='c:/usr/perl5/os2'
sitelib='c:/usr/perl'
sitelibexp='c:/usr/perl'
sizetype='size_t'
sleep='sleep'
smail=''
small=''
sockethdr=''
socketlib=''
sort='sort'
spackage='Perl5'
spitshell='cat'
split=''
ssizetype='ssize_t'
startperl='extproc perl -S'
stdchar='unsigned char'
stdio_base='(fp)->_buffer'
stdio_bufsiz='((fp)->_rcount + (fp)->_ptr - (fp)->_buffer)'
stdio_cnt='((fp)->_rcount)'
stdio_ptr='((fp)->_ptr)'
strings='/usr/include/string.h'
submit=''
sysman=''
tail='tail'
tar=''
tbl=''
test=''
timeincl=''
timetype='time_t'
touch='touch'
tr=''
troff=''
uidtype='uid_t'
uname='uname'
uniq=''
usedl='define'
usemymalloc='y'
usenm='true'
useposix='true'
usesafe='true'
usevfork='false'
usrinc='c:/usr/inc'
uuname=''
vi=''
voidflags='15'
xlibpth=''
zcat=''
!END!

my $summary = <<'!END!';
Summary of my $package ($baserev patchlevel $PATCHLEVEL) configuration:
  Platform:
    osname=$osname, osver=$osvers, archname=$archname
    uname='$myuname'
    hint=$hint, useposix=$useposix 
  Compiler:
    cc='$cc', optimize='$optimize', gccversion=$gccversion
    cppflags='$cppflags'
    ccflags ='$ccflags'
    stdchar='$stdchar', d_stdstdio=$d_stdstdio, usevfork=$usevfork
    voidflags=$voidflags, castflags=$castflags, d_casti32=$d_casti32, d_castneg=$d_castneg
    intsize=$intsize, alignbytes=$alignbytes, usemymalloc=$usemymalloc, randbits=$randbits
  Linker and Libraries:
    ld='$ld', ldflags ='$ldflags'
    libpth=$libpth
    libs=$libs
    libc=$libc, so=$so
  Dynamic Linking:
    dlsrc=$dlsrc, dlext=$dlext, d_dlsymun=$d_dlsymun, ccdlflags='$ccdlflags'
    cccdlflags='$cccdlflags', lddlflags='$lddlflags'

!END!
my $summary_expanded = 0;

sub myconfig {
	return $summary if $summary_expanded;
	$summary =~ s/\$(\w+)/$Config{$1}/ge;
	$summary_expanded = 1;
	$summary;
}

tie %Config, Config;
sub TIEHASH { bless {} }
sub FETCH { 
    # check for cached value (which maybe undef so we use exists not defined)
    return $_[0]->{$_[1]} if (exists $_[0]->{$_[1]});
 
    my($value); # search for the item in the big $config_sh string
    return undef unless (($value) = $config_sh =~ m/^$_[1]='(.*)'\s*$/m);
 
    $value = undef if $value eq 'undef'; # So we can say "if $Config{'foo'}".
    $_[0]->{$_[1]} = $value; # cache it
    return $value;
}
 
my $prevpos = 0;

sub FIRSTKEY {
    $prevpos = 0;
    my($key) = $config_sh =~ m/^(.*?)=/;
    $key;
}

sub NEXTKEY {
    my $pos = index($config_sh, "\n", $prevpos) + 1;
    my $len = index($config_sh, "=", $pos) - $pos;
    $prevpos = $pos;
    $len > 0 ? substr($config_sh, $pos, $len) : undef;
}

sub EXISTS { 
     exists($_[0]->{$_[1]})  or  $config_sh =~ m/^$_[1]=/m; 
}

sub STORE  { die "\%Config::Config is read-only\n" }
sub DELETE { &STORE }
sub CLEAR  { &STORE }


sub config_sh {
    $config_sh
}
sub config_vars {
    foreach(@_){
	my $v=(exists $Config{$_}) ? $Config{$_} : 'UNKNOWN';
	$v='undef' unless defined $v;
	print "$_='$v';\n";
    }
}

1;
__END__

=head1 NAME

Config - access Perl configuration information

=head1 SYNOPSIS

    use Config;
    if ($Config{'cc'} =~ /gcc/) {
	print "built by gcc\n";
    } 

    use Config qw(myconfig config_sh config_vars);

    print myconfig();

    print config_sh();

    config_vars(qw(osname archname));


=head1 DESCRIPTION

The Config module contains all the information that was available to
the C<Configure> program at Perl build time (over 900 values).

Shell variables from the F<config.sh> file (written by Configure) are
stored in the readonly-variable C<%Config>, indexed by their names.

Values stored in config.sh as 'undef' are returned as undefined
values.  The perl C<exists> function can be used to check is a
named variable exists.

=over 4

=item myconfig()

Returns a textual summary of the major perl configuration values.
See also C<-V> in L<perlrun/Switches>.

=item config_sh()

Returns the entire perl configuration information in the form of the
original config.sh shell variable assignment script.

=item config_vars(@names)

Prints to STDOUT the values of the named configuration variable. Each is
printed on a separate line in the form:

  name='value';

Names which are unknown are output as C<name='UNKNOWN';>.
See also C<-V:name> in L<perlrun/Switches>.

=back

=head1 EXAMPLE

Here's a more sophisticated example of using %Config:

    use Config;

    defined $Config{sig_name} || die "No sigs?";
    foreach $name (split(' ', $Config{sig_name})) {
	$signo{$name} = $i;
	$signame[$i] = $name;
	$i++;
    }   

    print "signal #17 = $signame[17]\n";
    if ($signo{ALRM}) { 
	print "SIGALRM is $signo{ALRM}\n";
    }   

=head1 WARNING

Because this information is not stored within the perl executable
itself it is possible (but unlikely) that the information does not
relate to the actual perl binary which is being used to access it.

The Config module is installed into the architecture and version
specific library directory ($Config{installarchlib}) and it checks the
perl version number when loaded.

=head1 NOTE

This module contains a good example of how to use tie to implement a
cache and an example of how to make a tied variable readonly to those
outside of it.

=cut

