(*  JAM Application Programming Interface for Virtual Pascal/2, Version 1.0  *)
(*    Copyright (C) 1996-1997 Dusk To Dawn Computing. All Rights Reserved.   *)
(*                             Sample Application                            *)
(* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- *)
(* History:                                                                  *)
(*                                                                           *)
(* 06/07/96 1.00  Initial coding                                             *)
(* 03/12/97 1.01  Conversion to use 0.91 object                              *)

program JamUtilP;

uses
   Crt,
   JAM,
   JAMMB,
   JAMINFO,
   SysUtils,
   UnixTime,
   Use32;

var
   Done:       Boolean;
   ExitSave:   Pointer;
   FName:      tFileName;
   MsgBase:    tJamAPI;
   MsgNum:     LongInt;
   TempChr:    Char;
   TempStr:    String;

procedure MyExit;

begin
   ExitProc := ExitSave;
   MsgBase.Free;
end;

procedure Usage(Level: LongInt);

begin
   case Level of
      1:
      begin
         WriteLn('    JAMutil: A program to test JAM API functions, Version 1.10');
         WriteLn('Copyright (C) 1996-1997 Dusk To Dawn Computing. All Rights Reserved.');
      end;
      2:
      begin
         Usage(1);
         WriteLn('Usage: ' + ParamStr(0) + ' <MsgBase> [MsgNum]');
         WriteLn('Where:  <MsgBase> is the path and base filename of the JAM Message Base');
         WriteLn('        <MsgNum>  is the first message number to display.');
      end;
   end;
end;

begin
   try
      ClrScr;
         Usage(1);
      if ((ParamCount < 1) or (ParamCount > 2)) then
      begin
         Usage(2);
         Halt(1);
      end;
      if ParamCount >= 2 then
         MsgNum := StrToIntDef(ParamStr(2), 1)
      else
         MsgNum := 0;
      MsgBase := tJamAPI.Create(65536);
      MsgBase.BaseName := ParamStr(1);
      ExitSave := ExitProc;
      ExitProc := @MyExit;
      try
         MsgBase.OpenBase;
      except
         WriteLn(Format('Unable to open message base "%s".', [MsgBase.BaseName]));
         Halt(1);
      end;
      if MsgNum = 0 then
         MsgNum := MsgBase.HdrInfo.BaseMsgNum;
      DisplayMsgHdr(MsgBase, MsgNum);
      while not Done do
      begin
         Write(#13#10, 'H=HdrInfo, N=Next, P=Prev, Q=Quit, R=ReIndex, S=SubFields, T=Text: ');
         TempChr := UpCase(ReadKey);
         case TempChr of
         'Q', #27:
            begin
               Write('Quit');
               Done := True;
               Break;
            end;
         'H':
            begin
               Write('HdrInfo');
               ClrScr;
               Usage(1);
               DisplayHdrInfo(MsgBase);
            end;
         'N':
            begin
               Write('Next');
               Inc(MsgNum);
               ClrScr;
               Usage(1);
               DisplayMsgHdr(MsgBase, MsgNum);
            end;
         'P':
            begin
               Write('Prev');
               Dec(MsgNum);
               ClrScr;
               Usage(1);
               DisplayMsgHdr(MsgBase, MsgNum);
            end;
         'R':
            begin
               Write('ReIndex');
               MsgBase.LockBase(True);
               try
                  ClrScr;
                  Usage(1);
                  WriteLn;
                  Write('ReIndexing...');
                  MsgBase.ReIndex;
                  WriteLn('Done.');
               except
                  WriteLn('Failed. Message base has likely been destroyed.');
               end;
               MsgBase.LockBase(False);
            end;
         'S':
            begin
               Write('SubFields');
               ClrScr;
               Usage(1);
               DisplayMsgSubFld(MsgBase);
            end;
         'T':
            begin
               Write('Text');
               ClrScr;
               Usage(1);
               DisplayMsgTxt(MsgBase);
            end;
         '0'..'9':
            begin
               TempStr := '';
               Write('Goto msg #', TempChr);
               Readln(TempStr);
               Insert(TempChr, TempStr, 1);
               MsgNum := StrToIntDef(TempStr, 1);
               ClrScr;
               Usage(1);
               DisplayMsgHdr(MsgBase, MsgNum);
            end;
         else
            Continue;
         end;
      end;
      Halt(0);
   except
      on Exception do
         Halt(1);
   end;
end.
