(********************************************************************************************
** PROGRAM     : rename
** VERSION     : 1.0.0
** DESCRIPTION : Renames a file.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to provide
** an example of how to use the built-in procedure 'rename'. To make best use of this
** sample you should have a basic understanding of Pascal.
**********************************************************************************************)
program rename;
var
   f : text;

   procedure syntax;
   begin
      writeln('Renames a file');
      writeln('Syntax: ivm rename old new');
      writeln('  renames a file named ''old'' to ''new''');
      exitcode := 1;
      halt
   end;

begin
   if paramcount <> 2 then
      syntax;
   //Associate the name of the file to be renamed so that 'rename' knows which
   //file to rename. NOTE: 'rename' takes a file variable and a string as parameters,
   //and expects the name of the file to be renamed to be associated with the
   //file variable, and the string to contain the name the file should be renamed to.
   assign(f, paramstr(1));
   rename(f, paramstr(2))
end.
