//FILE: WINGDI.INC
//VERSION: 1.0
(*$W44- *)
(*$W53- *)

(*$I windef.inc *)

const
    R2_BLACK = 1;
    R2_NOTMERGEPEN = 2;
    R2_MASKNOTPEN = 3;
    R2_NOTCOPYPEN = 4;
    R2_MASKPENNOT = 5;
    R2_NOT = 6;
    R2_XORPEN = 7;
    R2_NOTMASKPEN = 8;
    R2_MASKPEN = 9;
    R2_NOTXORPEN = 10;
    R2_NOP = 11;
    R2_MERGENOTPEN = 12;
    R2_COPYPEN = 13;
    R2_MERGEPENNOT = 14;
    R2_MERGEPEN = 15;
    R2_WHITE = 16;
    R2_LAST = 16;

    SRCCOPY = $00CC0020;
    SRCPAINT = $00EE0086;
    SRCAND = $008800C6;
    SRCINVERT = $00660046;
    SRCERASE = $00440328;
    NOTSRCCOPY = $00330008;
    NOTSRCERASE = $001100A6;
    MERGECOPY = $00C000CA;
    MERGEPAINT = $00BB0226;
    PATCOPY = $00F00021;
    PATPAINT = $00FB0A09;
    PATINVERT = $005A0049;
    DSTINVERT = $00550009;
    BLACKNESS = $00000042;
    WHITENESS = $00FF0062;

    GDI_ERROR = $FFFFFFFF;
    HGDI_ERROR = $FFFFFFFF;

    //ERROR = 0;
    NULLREGION = 1;
    SIMPLEREGION = 2;
    COMPLEXREGION = 3;
    RGN_ERROR = 0;
    RGN_AND = 1;
    RGN_OR = 2;
    RGN_XOR = 3;
    RGN_DIFF = 4;
    RGN_COPY = 5;
    RGN_MIN = RGN_AND;
    RGN_MAX = RGN_COPY;
    BLACKONWHITE = 1;
    WHITEONBLACK = 2;
    COLORONCOLOR = 3;
    HALFTONE = 4;
    MAXSTRETCHBLTMODE = 4;

    STRETCH_ANDSCANS = BLACKONWHITE;
    STRETCH_ORSCANS = WHITEONBLACK;
    STRETCH_DELETESCANS = COLORONCOLOR;
    STRETCH_HALFTONE = HALFTONE;
    ALTERNATE = 1;
    WINDING = 2;
    POLYFILL_LAST = 2;
    TA_NOUPDATECP = 0;
    TA_UPDATECP = 1;
    TA_LEFT = 0;
    TA_RIGHT = 2;
    TA_CENTER = 6;
    TA_TOP = 0;
    TA_BOTTOM = 8;
    TA_BASELINE = 24;

    TA_RTLREADING = 256;
    TA_MASK = 287;
    VTA_BASELINE = TA_BASELINE;
    VTA_LEFT = TA_BOTTOM;
    VTA_RIGHT = TA_TOP;
    VTA_CENTER = TA_CENTER;
    VTA_BOTTOM = TA_RIGHT;
    VTA_TOP = TA_LEFT;
    ETO_OPAQUE = $0002;
    ETO_CLIPPED = $0004;
    ETO_GLYPH_INDEX = $0010;
    ETO_RTLREADING = $0080;
    ETO_IGNORELANGUAGE = $1000;
    ASPECT_FILTERING = $0001;

    DCB_RESET = $0001;
    DCB_ACCUMULATE = $0002;
    DCB_DIRTY = DCB_ACCUMULATE;
    DCB_SET = $0003;
    DCB_ENABLE = $0004;
    DCB_DISABLE = $0008;

    META_SETBKCOLOR = $0201;
    META_SETBKMODE = $0102;
    META_SETMAPMODE = $0103;
    META_SETROP2 = $0104;
    META_SETRELABS = $0105;
    META_SETPOLYFILLMODE = $0106;
    META_SETSTRETCHBLTMODE = $0107;
    META_SETTEXTCHAREXTRA = $0108;
    META_SETTEXTCOLOR = $0209;
    META_SETTEXTJUSTIFICATION = $020A;
    META_SETWINDOWORG = $020B;
    META_SETWINDOWEXT = $020C;
    META_SETVIEWPORTORG = $020D;
    META_SETVIEWPORTEXT = $020E;
    META_OFFSETWINDOWORG = $020F;
    META_SCALEWINDOWEXT = $0410;
    META_OFFSETVIEWPORTORG = $0211;
    META_SCALEVIEWPORTEXT = $0412;
    META_LINETO = $0213;
    META_MOVETO = $0214;
    META_EXCLUDECLIPRECT = $0415;
    META_INTERSECTCLIPRECT = $0416;
    META_ARC = $0817;
    META_ELLIPSE = $0418;
    META_FLOODFILL = $0419;
    META_PIE = $081A;
    META_RECTANGLE = $041B;
    META_ROUNDRECT = $061C;
    META_PATBLT = $061D;
    META_SAVEDC = $001E;
    META_SETPIXEL = $041F;
    META_OFFSETCLIPRGN = $0220;
    META_TEXTOUT = $0521;
    META_BITBLT = $0922;
    META_STRETCHBLT = $0B23;
    META_POLYGON = $0324;
    META_POLYLINE = $0325;
    META_ESCAPE = $0626;
    META_RESTOREDC = $0127;
    META_FILLREGION = $0228;
    META_FRAMEREGION = $0429;
    META_INVERTREGION = $012A;
    META_PAINTREGION = $012B;
    META_SELECTCLIPREGION = $012C;
    META_SELECTOBJECT = $012D;
    META_SETTEXTALIGN = $012E;
    META_CHORD = $0830;
    META_SETMAPPERFLAGS = $0231;
    META_EXTTEXTOUT = $0a32;
    META_SETDIBTODEV = $0d33;
    META_SELECTPALETTE = $0234;
    META_REALIZEPALETTE = $0035;
    META_ANIMATEPALETTE = $0436;
    META_SETPALENTRIES = $0037;
    META_POLYPOLYGON = $0538;
    META_RESIZEPALETTE = $0139;
    META_DIBBITBLT = $0940;
    META_DIBSTRETCHBLT = $0b41;
    META_DIBCREATEPATTERNBRUSH = $0142;
    META_STRETCHDIB = $0f43;
    META_EXTFLOODFILL = $0548;
    META_DELETEOBJECT = $01f0;
    META_CREATEPALETTE = $00f7;
    META_CREATEPATTERNBRUSH = $01F9;
    META_CREATEPENINDIRECT = $02FA;
    META_CREATEFONTINDIRECT = $02FB;
    META_CREATEBRUSHINDIRECT = $02FC;
    META_CREATEREGION = $06FF;

    ESC_NEWFRAME = 1;
    ESC_ABORTDOC = 2;
    ESC_NEXTBAND = 3;
    ESC_SETCOLORTABLE = 4;
    ESC_GETCOLORTABLE = 5;
    ESC_FLUSHOUTPUT = 6;
    ESC_DRAFTMODE = 7;
    ESC_QUERYESCSUPPORT = 8;
    ESC_SETABORTPROC = 9;
    ESC_STARTDOC = 10;
    ESC_ENDDOC = 11;
    ESC_GETPHYSPAGESIZE = 12;
    ESC_GETPRINTINGOFFSET = 13;
    ESC_GETSCALINGFACTOR = 14;
    ESC_MFCOMMENT = 15;
    ESC_GETPENWIDTH = 16;
    ESC_SETCOPYCOUNT = 17;
    ESC_SELECTPAPERSOURCE = 18;
    ESC_DEVICEDATA = 19;
    ESC_PASSTHROUGH = 19;
    ESC_GETTECHNOLGY = 20;
    ESC_GETTECHNOLOGY = 20;
    ESC_SETLINECAP = 21;
    ESC_SETLINEJOIN = 22;
    ESC_SETMITERLIMIT = 23;
    ESC_BANDINFO = 24;
    ESC_DRAWPATTERNRECT = 25;
    ESC_GETVECTORPENSIZE = 26;
    ESC_GETVECTORBRUSHSIZE = 27;
    ESC_ENABLEDUPLEX = 28;
    ESC_GETSETPAPERBINS = 29;
    ESC_GETSETPRINTORIENT = 30;
    ESC_ENUMPAPERBINS = 31;
    ESC_SETDIBSCALING = 32;
    ESC_EPSPRINTING = 33;
    ESC_ENUMPAPERMETRICS = 34;
    ESC_GETSETPAPERMETRICS = 35;
    ESC_POSTSCRIPT_DATA = 37;
    ESC_POSTSCRIPT_IGNORE = 38;
    ESC_MOUSETRAILS = 39;
    ESC_GETDEVICEUNITS = 42;

    ESC_GETEXTENDEDTEXTMETRICS = 256;
    ESC_GETEXTENTTABLE = 257;
    ESC_GETPAIRKERNTABLE = 258;
    ESC_GETTRACKKERNTABLE = 259;
    ESC_EXTTEXTOUT = 512;
    ESC_GETFACENAME = 513;
    ESC_DOWNLOADFACE = 514;
    ESC_ENABLERELATIVEWIDTHS = 768;
    ESC_ENABLEPAIRKERNING = 769;
    ESC_SETKERNTRACK = 770;
    ESC_SETALLJUSTVALUES = 771;
    ESC_SETCHARSET = 772;

    ESC_STRETCHBLT = 2048;
    ESC_GETSETSCREENPARAMS = 3072;
    ESC_QUERYDIBSUPPORT = 3073;
    ESC_BEGIN_PATH = 4096;
    ESC_CLIP_TO_PATH = 4097;
    ESC_END_PATH = 4098;
    ESC_EXT_DEVICE_CAPS = 4099;
    ESC_RESTORE_CTM = 4100;
    ESC_SAVE_CTM = 4101;
    ESC_SET_ARC_DIRECTION = 4102;
    ESC_SET_BACKGROUND_COLOR = 4103;
    ESC_SET_POLY_MODE = 4104;
    ESC_SET_SCREEN_ANGLE = 4105;
    ESC_SET_SPREAD = 4106;
    ESC_TRANSFORM_CTM = 4107;
    ESC_SET_CLIP_BOX = 4108;
    ESC_SET_BOUNDS = 4109;
    ESC_SET_MIRROR_MODE = 4110;
    ESC_OPENCHANNEL = 4110;
    ESC_DOWNLOADHEADER = 4111;
    ESC_CLOSECHANNEL = 4112;
    ESC_POSTSCRIPT_PASSTHROUGH = 4115;
    ESC_ENCAPSULATED_POSTSCRIPT = 4116;

    QDI_SETDIBITS = 1;
    QDI_GETDIBITS = 2;
    QDI_DIBTOSCREEN = 4;
    QDI_STRETCHDIB = 8;

    SP_NOTREPORTED = $4000;
    SP_ERROR = -1;
    SP_APPABORT = -2;
    SP_USERABORT = -3;
    SP_OUTOFDISK = -4;
    SP_OUTOFMEMORY = -5;
    PR_JOBSTATUS = $0000;

    OBJ_PEN = 1;
    OBJ_BRUSH = 2;
    OBJ_DC = 3;
    OBJ_METADC = 4;
    OBJ_PAL = 5;
    OBJ_FONT = 6;
    OBJ_BITMAP = 7;
    OBJ_REGION = 8;
    OBJ_METAFILE = 9;
    OBJ_MEMDC = 10;
    OBJ_EXTPEN = 11;
    OBJ_ENHMETADC = 12;
    OBJ_ENHMETAFILE = 13;

    MWT_IDENTITY = 1;
    MWT_LEFTMULTIPLY = 2;
    MWT_RIGHTMULTIPLY = 3;
    MWT_MIN = MWT_IDENTITY;
    MWT_MAX = MWT_RIGHTMULTIPLY;

type
	XFORM = packed record
    	eM11 : FLOAT;
    	eM12 : FLOAT;
    	eM21 : FLOAT;
    	eM22 : FLOAT;
    	eDx : FLOAT;
    	eDy : FLOAT;
	end;

	_XFORM = XFORM;

	BITMAP = packed record
		bmType : LONG;
		bmWidth : LONG;
		bmHeight : LONG;
		bmWidthBytes : LONG;
		bmPlanes : shortword;
		bmBitsPixel : shortword;
		bmBits : LPVOID;
	end;

	RGBTRIPLE = packed record
        rgbtBlue : BYTE;
        rgbtGreen : BYTE;
        rgbtRed : BYTE;
	end;

	RGBQUAD = packed record
        rgbBlue : BYTE;
        rgbGreen : BYTE;
        rgbRed : BYTE;
        rgbReserved : BYTE;
	end;

	LCSCSTYPE = LONG;
	_LCSCSTYPE = LCSCSTYPE;

const
    LCS_CALIBRATED_RGB = $00000000;
    LCS_DEVICE_RGB = $00000001;
    LCS_DEVICE_CMYK = $00000002;

type
	LCSGAMUTMATCH = LONG;

const
    LCS_GM_BUSINESS = $00000001;
    LCS_GM_GRAPHICS = $00000002;
    LCS_GM_IMAGES = $00000004;

    CM_OUT_OF_GAMUT = 255;
    CM_IN_GAMUT = 0;

type
	FXPT16DOT16 = integer;
	FXPT2DOT30 = integer;

	CIEXYZ = packed record
    	ciexyzX : FXPT2DOT30;
        ciexyzY : FXPT2DOT30;
        ciexyzZ : FXPT2DOT30;
	end;

	CIEXYZTRIPLE = packed record
        ciexyzRed : CIEXYZ;
        ciexyzGreen : CIEXYZ;
        ciexyzBlue : CIEXYZ;
	end;

	LOGCOLORSPACE = packed record
		lcsSignature : DWORD;
		lcsVersion : DWORD;
		lcsSizde : DWORD;
		lcsCSType : _LCSCSTYPE;
		lcsIntent : LCSGAMUTMATCH;
		lcsEndpoints : CIEXYZTRIPLE;
		lcsGammaRed : DWORD;
		lcsGammaGreen : DWORD;
		lcsGammaBlue : DWORD;
		lcsFilename : cstring[MAX_CSTRING_PATH];
	end;

	LOGCOLORSPACEW = packed record
		lcsSignature : DWORD;
		lcsVersion : DWORD;
		lcsSizde : DWORD;
		lcsCSType : _LCSCSTYPE;
		lcsIntent : LCSGAMUTMATCH;
		lcsEndpoints : CIEXYZTRIPLE;
		lcsGammaRed : DWORD;
		lcsGammaGreen : DWORD;
		lcsGammaBlue : DWORD;
		lcsFilename : array[0..MAX_CSTRING_PATH] of WCHAR;
	end;

	BITMAPCOREHEADER = packed record
		bcSizde : DWORD;
		bcWidth : shortword;
		bcHeight : shortword;
		bcPlanes : shortword;
		bcBitCount : shortword;
	end;

	BITMAPINFOHEADER = packed record
		biSize : DWORD;
		biWidth : LONG;
		biHeight : LONG;
		biPlanes : shortword;
		biBitCount : shortword;
		biCompression : DWORD;
		biSizeImage : DWORD;
		biXPelsPerMeter : LONG;
		biYPelsPerMeter : LONG;
		biClrUsed : DWORD;
		biClrImportant : DWORD;
	end;

	BITMAPV4HEADER = packed record
        bV4Size :DWORD;
        bV4Width : LONG;
        bV4Height : LONG;
        bV4Planes : shortword;
        bV4BitCount : shortword;
        bV4V4Compression : DWORD;
        bV4SizeImage : DWORD;
        bV4XPelsPerMeter : LONG;
        bV4YPelsPerMeter : LONG;
        bV4ClrUsed : DWORD;
        bV4ClrImportant : DWORD;
        bV4RedMask : DWORD;
        bV4GreenMask : DWORD;
        bV4BlueMask : DWORD;
        bV4AlphaMask : DWORD;
        bV4CSType : DWORD;
        bV4Endpoints : CIEXYZTRIPLE;
        bV4GammaRed : DWORD;
        bV4GammaGreen : DWORD;
        bV4GammaBlue : DWORD;
	end;

const
    BI_RGB = 0;
    BI_RLE8 = 1;
    BI_RLE4 = 2;
    BI_BITFIELDS = 3;

type
	BITMAPINFO = packed record
		bmiHeader : BITMAPINFOHEADER;
		bmiColors : array[0..1] of RGBQUAD;
	end;

	BITMAPCOREINFO = packed record
    	bmciHeader : BITMAPCOREHEADER;
	end;

	BITMAPFILEHEADER = packed record
		bfType : shortword;
		bfSize : DWORD;
		bfReserved1 : shortword;
		bfReserved2 : shortword;
		bfOffBits : DWORD;
	end;

	FONTSIGNATURE = packed record
    	fsUsb : array[0..3] of DWORD;
    	fsCsb : array[0..1] of DWORD;
	end;

	CHARSETINFO = packed record
    	ciCharset : UINT;
    	ciACP : UINT;
    	fs : FONTSIGNATURE;
	end;

const
    TCI_SRCCHARSET = 1;
    TCI_SRCCODEPAGE = 2;
    TCI_SRCFONTSIG = 3;

type
	LOCALESIGNATURE = packed record
    	lsUsb : array[0..3] of DWORD;
    	lsCsbDefault : array[0..1] of DWORD;
    	lsCsbSupported : array[0..1] of DWORD;
	end;

	METARECORD = packed record
    	rdSize : DWORD;
    	rdFunction : shortword;
	end;

	METAFILEPICT = packed record
		mm : LONG;
		xExt : LONG;
		yExt : LONG;
		hMF : HMETAFILE;
	end;

	METAHEADER = packed record
		mtType : shortword;
		mtHeaderSize : shortword;
		mtVersion : shortword;
		mtSize : DWORD;
		mtNoObjecs : shortword;
		mtMaxRecord : DWORD;
		mtNoParameters : shortword;
	end;

	ENHMETARECORD = packed record
		iType : DWORD;
		nSize : DWORD;
	end;

	ENHMETAHEADER = packed record
		iType : DWORD;
		nSize : DWORD;
		rclBounds : RECTL;
		rclFrame : RECTL;
		dSignature : DWORD;
		nVersion : DWORD;
		nBytes : DWORD;
		nRecords : DWORD;
		nHandles : shortword;
		sReserved : shortword;
		nDescription : DWORD;
		offDescription : DWORD;
		nPalEntries : DWORD;
    	szlDevice : SIZEL;
    	szlMillimeters : SIZEL;
    	cbPixelFormat : DWORD;
    	offPixelFormat : DWORD;
    	bOpenGL : DWORD;
	end;

const
    TMPF_FIXED_PITCH = $01;
    TMPF_VECTOR = $02;
    TMPF_DEVICE = $08;
    TMPF_TRUETYPE = $04;

type
	BCHAR = BYTE;

	TEXTMETRIC = packed record
    	tmHeight : LONG;
    	tmAscent : LONG;
    	tmDescent : LONG;
	    tmInternalLeading : LONG;
    	tmExternalLeading : LONG;
	    tmAveCharWidth : LONG;
    	tmMaxCharWidth : LONG;
	    tmWeight : LONG;
    	tmOverhang : LONG;
	    tmDigitizedAspectX : LONG;
    	tmDigitizedAspectY : LONG;
	    tmFirstChar : BYTE;
    	tmLastChar : BYTE;
	    tmDefaultChar : BYTE;
    	tmBreakChar : BYTE;
	    tmItalic : BYTE;
    	tmUnderlined : BYTE;
	    tmStruckOut : BYTE;
    	tmPitchAndFamily : BYTE;
	    tmCharSet : BYTE;
	end;

const
    NTM_REGULAR = $00000040;
    NTM_BOLD = $00000020;
    NTM_ITALIC = $00000001;

type
	NEWTEXTMETRIC = packed record
    	tmHeight : LONG;
    	tmAscent : LONG;
    	tmDescent : LONG;
	    tmInternalLeading : LONG;
    	tmExternalLeading : LONG;
	    tmAveCharWidth : LONG;
    	tmMaxCharWidth : LONG;
	    tmWeight : LONG;
    	tmOverhang : LONG;
	    tmDigitizedAspectX : LONG;
    	tmDigitizedAspectY : LONG;
	    tmFirstChar : BYTE;
    	tmLastChar : BYTE;
	    tmDefaultChar : BYTE;
    	tmBreakChar : BYTE;
	    tmItalic : BYTE;
    	tmUnderlined : BYTE;
	    tmStruckOut : BYTE;
    	tmPitchAndFamily : BYTE;
	    tmCharSet : BYTE;
	    ntmFlags : DWORD;
    	ntmSizeEM : UINT;
	    ntmCellHeight : UINT;
    	ntmAvgWidth : UINT;
	end;

	NEWTEXTMETRICEX = packed record
    	ntmTm : NEWTEXTMETRIC;
    	ntmFontSig : FONTSIGNATURE;
	end;

	PELARRAY = packed record
	    paXCount : LONG;
    	paYCount : LONG;
	    paXExt : LONG;
    	paYExt : LONG;
	    paRGBs : BYTE;
	end;

	LOGBRUSH = packed record
    	lbStyle : UINT;
    	lbColor : COLORREF;
    	lbHatch : LONG;
	end;

	PATTERN = LOGBRUSH;

	LOGPEN = packed record
    	lopnStyle : UINT;
    	lopnWidth : POINT;
    	lopnColor : COLORREF;
	end;

	EXTLOGPEN = packed record
    	elpPenStyle : DWORD;
	    elpWidth : DWORD;
    	elpBrushStyle : UINT;
	    elpColor : COLORREF;
    	elpHatch : LONG;
	    elpNumEntries : DWORD;
	end;

const
	LF_FACESIZE = 31;

type
	LOGFONT = packed record
    	lfHeight : LONG;
	    lfWidth : LONG;
    	lfEscapement : LONG;
	    lfOrientation : LONG;
	    lfWeight : LONG;
	    lfItalic : BYTE;
	    lfUnderline : BYTE;
	    lfStrikeOut : BYTE;
	    lfCharSet : BYTE;
	    lfOutPrecision : BYTE;
	    lfClipPrecision : BYTE;
	    lfQuality : BYTE;
	    lfPitchAndFamily : BYTE;
    	lfFaceName : cstring[LF_FACESIZE];
	end;
	LOGFONTW = packed record
    	lfHeight : LONG;
	    lfWidth : LONG;
    	lfEscapement : LONG;
	    lfOrientation : LONG;
	    lfWeight : LONG;
	    lfItalic : BYTE;
	    lfUnderline : BYTE;
	    lfStrikeOut : BYTE;
	    lfCharSet : BYTE;
	    lfOutPrecision : BYTE;
	    lfClipPrecision : BYTE;
	    lfQuality : BYTE;
	    lfPitchAndFamily : BYTE;
	    lfFaceName : array[0..LF_FACESIZE] of WCHAR;
	end;

const
	LF_FULLFACESIZE = 63;

type
	ENUMLOGFONT = packed record
    	elfLogFont : LOGFONT;
    	elfFullName : cstring[LF_FULLFACESIZE];
    	elfStyle : cstring[LF_FACESIZE];
	end;

	ENUMLOGFONTEX = packed record
    	elfLogFont : LOGFONT;
    	elfFullName : cstring[LF_FULLFACESIZE];
    	elfStyle : cstring[LF_FACESIZE];
    	elfScript : cstring[LF_FACESIZE];
	end;

const
    OUT_DEFAULT_PRECIS = 0;
    OUT_STRING_PRECIS = 1;
    OUT_CHARACTER_PRECIS = 2;
    OUT_STROKE_PRECIS = 3;
    OUT_TT_PRECIS = 4;
    OUT_DEVICE_PRECIS = 5;
    OUT_RASTER_PRECIS = 6;
    OUT_TT_ONLY_PRECIS = 7;
    OUT_OUTLINE_PRECIS = 8;
    OUT_SCREEN_OUTLINE_PRECIS = 9;

    CLIP_DEFAULT_PRECIS = 0;
    CLIP_CHARACTER_PRECIS = 1;
    CLIP_STROKE_PRECIS = 2;
    CLIP_MASK = $f;
    CLIP_LH_ANGLES = $10;
    CLIP_TT_ALWAYS = $20;
    CLIP_EMBEDDED = $80;

    DEFAULT_QUALITY = 0;
    DRAFT_QUALITY = 1;
    PROOF_QUALITY = 2;
    NONANTIALIASED_QUALITY = 3;
    ANTIALIASED_QUALITY = 4;
    DEFAULT_PITCH = 0;
    FIXED_PITCH = 1;
    VARIABLE_PITCH = 2;
    MONO_FONT = 8;

    ANSI_CHARSET = 0;
    DEFAULT_CHARSET = 1;
    SYMBOL_CHARSET = 2;
    SHIFTJIS_CHARSET = 128;
    HANGEUL_CHARSET = 129;
    GB2312_CHARSET = 134;
    CHINESEBIG5_CHARSET = 136;
    OEM_CHARSET = 255;
    JOHAB_CHARSET = 130;
    HEBREW_CHARSET = 177;
    ARABIC_CHARSET = 178;
    GREEK_CHARSET = 161;
    TURKISH_CHARSET = 162;
    VIETNAMESE_CHARSET = 163;
    THAI_CHARSET = 222;
    EASTEUROPE_CHARSET = 238;
    RUSSIAN_CHARSET = 204;
    MAC_CHARSET = 77;
    BALTIC_CHARSET = 186;

    FS_LATIN1 = $00000001;
    FS_LATIN2 = $00000002;
    FS_CYRILLIC = $00000004;
    FS_GREEK = $00000008;
    FS_TURKISH = $00000010;
    FS_HEBREW = $00000020;
    FS_ARABIC = $00000040;
    FS_BALTIC = $00000080;
    FS_VIETNAMESE = $00000100;
    FS_THAI = $00010000;
    FS_JISJAPAN = $00020000;
    FS_CHINESESIMP = $00040000;
    FS_WANSUNG = $00080000;
    FS_CHINESETRAD = $00100000;
    FS_JOHAB = $00200000;
    FS_SYMBOL = $80000000;

    FF_DONTCARE = $00;
    FF_ROMAN = $10;
    FF_SWISS = $20;
    FF_MODERN = $30;
    FF_SCRIPT = $40;
    FF_DECORATIVE = $50;

    FW_DONTCARE = 0;
    FW_THIN = 100;
    FW_EXTRALIGHT = 200;
    FW_LIGHT = 300;
    FW_NORMAL = 400;
    FW_MEDIUM = 500;
    FW_SEMIBOLD = 600;
    FW_BOLD = 700;
    FW_EXTRABOLD = 800;
    FW_HEAVY = 900;
    FW_ULTRALIGHT = FW_EXTRALIGHT;
    FW_REGULAR = FW_NORMAL;
    FW_DEMIBOLD = FW_SEMIBOLD;
    FW_ULTRABOLD = FW_EXTRABOLD;
    FW_BLACK = FW_HEAVY;

    PANOSE_COUNT = 10;
    PAN_FAMILYTYPE_INDEX = 0;
    PAN_SERIFSTYLE_INDEX = 1;
    PAN_WEIGHT_INDEX = 2;
    PAN_PROPORTION_INDEX = 3;
    PAN_CONTRAST_INDEX = 4;
    PAN_STROKEVARIATION_INDEX = 5;
    PAN_ARMSTYLE_INDEX = 6;
    PAN_LETTERFORM_INDEX = 7;
    PAN_MIDLINE_INDEX = 8;
    PAN_XHEIGHT_INDEX = 9;
    PAN_CULTURE_LATIN = 0;

type
	PANOSE = packed record
	    bFamilyType : BYTE;
    	bSerifStyle : BYTE;
	    bWeight : BYTE;
    	bProportion : BYTE;
	    bContrast : BYTE;
    	bStrokeVariation : BYTE;
	    bArmStyle : BYTE;
    	bLetterform : BYTE;
	    bMidline : BYTE;
    	bXHeight : BYTE;
	end;

const
    PAN_ANY = 0;
    PAN_NO_FIT = 1;
    PAN_FAMILY_TEXT_DISPLAY = 2;
    PAN_FAMILY_SCRIPT = 3;
    PAN_FAMILY_DECORATIVE = 4;
    PAN_FAMILY_PICTORIAL = 5;
    PAN_SERIF_COVE = 2;
    PAN_SERIF_OBTUSE_COVE = 3;
    PAN_SERIF_SQUARE_COVE = 4;
    PAN_SERIF_OBTUSE_SQUARE_COVE = 5;
    PAN_SERIF_SQUARE = 6;
    PAN_SERIF_THIN = 7;
    PAN_SERIF_BONE = 8;
    PAN_SERIF_EXAGGERATED = 9;
    PAN_SERIF_TRIANGLE = 10;
    PAN_SERIF_NORMAL_SANS = 11;
    PAN_SERIF_OBTUSE_SANS = 12;
    PAN_SERIF_PERP_SANS = 13;
    PAN_SERIF_FLARED = 14;
    PAN_SERIF_ROUNDED = 15;

    PAN_WEIGHT_VERY_LIGHT = 2;
    PAN_WEIGHT_LIGHT = 3;
    PAN_WEIGHT_THIN = 4;
    PAN_WEIGHT_BOOK = 5;
    PAN_WEIGHT_MEDIUM = 6;
    PAN_WEIGHT_DEMI = 7;
    PAN_WEIGHT_BOLD = 8;
    PAN_WEIGHT_HEAVY = 9;
    PAN_WEIGHT_BLACK = 10;
    PAN_WEIGHT_NORD = 11;
    PAN_PROP_OLD_STYLE = 2;
    PAN_PROP_MODERN = 3;
    PAN_PROP_EVEN_WIDTH = 4;
    PAN_PROP_EXPANDED = 5;
    PAN_PROP_CONDENSED = 6;
    PAN_PROP_VERY_EXPANDED = 7;
    PAN_PROP_VERY_CONDENSED = 8;
    PAN_PROP_MONOSPACED = 9;

    PAN_CONTRAST_NONE = 2;
    PAN_CONTRAST_VERY_LOW = 3;
    PAN_CONTRAST_LOW = 4;
    PAN_CONTRAST_MEDIUM_LOW = 5;
    PAN_CONTRAST_MEDIUM = 6;
    PAN_CONTRAST_MEDIUM_HIGH = 7;
    PAN_CONTRAST_HIGH = 8;
    PAN_CONTRAST_VERY_HIGH = 9;
    PAN_STROKE_GRADUAL_DIAG = 2;
    PAN_STROKE_GRADUAL_TRAN = 3;
    PAN_STROKE_GRADUAL_VERT = 4;
    PAN_STROKE_GRADUAL_HORZ = 5;
    PAN_STROKE_RAPID_VERT = 6;
    PAN_STROKE_RAPID_HORZ = 7;
    PAN_STROKE_INSTANT_VERT = 8;

    PAN_STRAIGHT_ARMS_HORZ = 2;
    PAN_STRAIGHT_ARMS_WEDGE = 3;
    PAN_STRAIGHT_ARMS_VERT = 4;
    PAN_STRAIGHT_ARMS_SINGLE_SERIF = 5;
    PAN_STRAIGHT_ARMS_DOUBLE_SERIF = 6;
    PAN_BENT_ARMS_HORZ = 7;
    PAN_BENT_ARMS_WEDGE = 8;
    PAN_BENT_ARMS_VERT = 9;
    PAN_BENT_ARMS_SINGLE_SERIF = 10;
    PAN_BENT_ARMS_DOUBLE_SERIF = 11;
    PAN_LETT_NORMAL_CONTACT = 2;
    PAN_LETT_NORMAL_WEIGHTED = 3;
    PAN_LETT_NORMAL_BOXED = 4;
    PAN_LETT_NORMAL_FLATTENED = 5;
    PAN_LETT_NORMAL_ROUNDED = 6;
    PAN_LETT_NORMAL_OFF_CENTER = 7;
    PAN_LETT_NORMAL_SQUARE = 8;
    PAN_LETT_OBLIQUE_CONTACT = 9;
    PAN_LETT_OBLIQUE_WEIGHTED = 10;
    PAN_LETT_OBLIQUE_BOXED = 11;
    PAN_LETT_OBLIQUE_FLATTENED = 12;
    PAN_LETT_OBLIQUE_ROUNDED = 13;
    PAN_LETT_OBLIQUE_OFF_CENTER = 14;
    PAN_LETT_OBLIQUE_SQUARE = 15;

    PAN_MIDLINE_STANDARD_TRIMMED = 2;
    PAN_MIDLINE_STANDARD_POINTED = 3;
    PAN_MIDLINE_STANDARD_SERIFED = 4;
    PAN_MIDLINE_HIGH_TRIMMED = 5;
    PAN_MIDLINE_HIGH_POINTED = 6;
    PAN_MIDLINE_HIGH_SERIFED = 7;
    PAN_MIDLINE_CONSTANT_TRIMMED = 8;
    PAN_MIDLINE_CONSTANT_POINTED = 9;
    PAN_MIDLINE_CONSTANT_SERIFED = 10;
    PAN_MIDLINE_LOW_TRIMMED = 11;
    PAN_MIDLINE_LOW_POINTED = 12;
    PAN_MIDLINE_LOW_SERIFED = 13;
    PAN_XHEIGHT_CONSTANT_SMALL = 2;
    PAN_XHEIGHT_CONSTANT_STD = 3;
    PAN_XHEIGHT_CONSTANT_LARGE = 4;
    PAN_XHEIGHT_DUCKING_SMALL = 5;
    PAN_XHEIGHT_DUCKING_STD = 6;
    PAN_XHEIGHT_DUCKING_LARGE = 7;

	ELF_VENDOR_SIZE = 4;

type
	EXTLOGFONT = packed record
	    elfLogFont : LOGFONT;
    	elfFullName : cstring[LF_FULLFACESIZE];
	    elfStyle : cstring[LF_FACESIZE];
    	elfVersion : DWORD;
	    elfStyleSize : DWORD;
    	elfMatch : DWORD;
	    elfReserved : DWORD;
    	elfVendorId : cstring[ELF_VENDOR_SIZE];
	    elfCulture : DWORD;
    	elfPanose : PANOSE;
	end;
	EXTLOGFONTW = packed record
	    elfLogFont : LOGFONTW;
    	elfFullName : array[0..LF_FULLFACESIZE] of WCHAR;
	    elfStyle : array[0..LF_FACESIZE] of WCHAR;
    	elfVersion : DWORD;
	    elfStyleSize : DWORD;
    	elfMatch : DWORD;
	    elfReserved : DWORD;
    	elfVendorId : cstring[ELF_VENDOR_SIZE];
	    elfCulture : DWORD;
    	elfPanose : PANOSE;
	end;

const
    ELF_VERSION = 0;
    ELF_CULTURE_LATIN = 0;
    RASTER_FONTTYPE = $0001;
    DEVICE_FONTTYPE = $002;
    TRUETYPE_FONTTYPE = $004;

    PC_RESERVED = $01;
    PC_EXPLICIT = $02;
    PC_NOCOLLAPSE = $04;

    TRANSPARENT = 1;
    OPAQUE = 2;
    BKMODE_LAST = 2;

    GM_COMPATIBLE = 1;
    GM_ADVANCED = 2;
    GM_LAST = 2;

    PT_CLOSEFIGURE = $01;
    PT_LINETO = $02;
    PT_BEZIERTO = $04;
    PT_MOVETO = $06;

    MM_TEXT = 1;
    MM_LOMETRIC = 2;
    MM_HIMETRIC = 3;
    MM_LOENGLISH = 4;
    MM_HIENGLISH = 5;
    MM_TWIPS = 6;
    MM_ISOTROPIC = 7;
    MM_ANISOTROPIC = 8;

    MM_MIN = MM_TEXT;
    MM_MAX = MM_ANISOTROPIC;
    MM_MAX_FIXEDSCALE = MM_TWIPS;
    ABSOLUTE = 1;
    RELATIVE = 2;

    WHITE_BRUSH = 0;
    LTGRAY_BRUSH = 1;
    GRAY_BRUSH = 2;
    DKGRAY_BRUSH = 3;
    BLACK_BRUSH = 4;
    NULL_BRUSH = 5;
    HOLLOW_BRUSH = NULL_BRUSH;
    WHITE_PEN = 6;
    BLACK_PEN = 7;
    NULL_PEN = 8;
    OEM_FIXED_FONT = 10;
    ANSI_FIXED_FONT = 11;
    ANSI_VAR_FONT = 12;
    SYSTEM_FONT = 13;
    DEVICE_DEFAULT_FONT = 14;
    DEFAULT_PALETTE = 15;
    SYSTEM_FIXED_FONT = 16;
    DEFAULT_GUI_FONT = 17;
	STOCK_LAST = 17;

	CLR_INVALID = $FFFFFFFF;

    BS_SOLID = 0;
    BS_NULL = 1;
    BS_HOLLOW = BS_NULL;
    BS_HATCHED = 2;
    BS_PATTERN = 3;
    BS_INDEXED = 4;
    BS_DIBPATTERN = 5;
    BS_DIBPATTERNPT = 6;
    BS_PATTERN8X8 = 7;
    BS_DIBPATTERN8X8 = 8;
    BS_MONOPATTERN = 9;

    HS_HORIZONTAL = 0;
    HS_VERTICAL = 1;
    HS_FDIAGONAL = 2;
    HS_BDIAGONAL = 3;
    HS_CROSS = 4;
    HS_DIAGCROSS = 5;

    PS_SOLID = 0;
    PS_DASH = 1;
    PS_DOT = 2;
    PS_DASHDOT = 3;
    PS_DASHDOTDOT = 4;
    PS_NULL = 5;
    PS_INSIDEFRAME = 6;
    PS_USERSTYLE = 7;
    PS_ALTERNATE = 8;
    PS_STYLE_MASK = $0000000F;

    PS_ENDCAP_ROUND = $00000000;
    PS_ENDCAP_SQUARE = $00000100;
    PS_ENDCAP_FLAT = $00000200;
    PS_ENDCAP_MASK = $00000F00;
    PS_JOIN_ROUND = $00000000;
    PS_JOIN_BEVEL = $00001000;
    PS_JOIN_MITER = $00002000;
    PS_JOIN_MASK = $0000F000;
    PS_COSMETIC = $00000000;
    PS_GEOMETRIC = $00010000;
    PS_TYPE_MASK = $000F0000;
    AD_COUNTERCLOCKWISE = 1;
    AD_CLOCKWISE = 2;

    DRIVERVERSION = 0;
    TECHNOLOGY = 2;
    HORZSIZE = 4;
    VERTSIZE = 6;
    HORZRES = 8;
    VERTRES = 10;
    BITSPIXEL = 12;
    PLANES = 14;
    NUMBRUSHES = 16;
    NUMPENS = 18;
    NUMMARKERS = 20;
    NUMFONTS = 22;
    NUMCOLORS = 24;
    PDEVICESIZE = 26;
    CURVECAPS = 28;
    LINECAPS = 30;
    POLYGONALCAPS = 32;
    TEXTCAPS = 34;
    CLIPCAPS = 36;
    RASTERCAPS = 38;
    ASPECTX = 40;
    ASPECTY = 42;
    ASPECTXY = 44;

    LOGPIXELSX = 88;
    LOGPIXELSY = 90;
    SIZEPALETTE = 104;
    NUMRESERVED = 106;
    COLORRES = 108;


    PHYSICALWIDTH = 110;
    PHYSICALHEIGHT = 111;
    PHYSICALOFFSETX = 112;
    PHYSICALOFFSETY = 113;
    SCALINGFACTORX = 114;
    SCALINGFACTORY = 115;

    VREFRESH = 116;
    DESKTOPVERTRES = 117;
    DESKTOPHORZRES = 118;
    BLTALIGNMENT = 119;

    DT_PLOTTER = 0;
    DT_RASDISPLAY = 1;
    DT_RASPRINTER = 2;
    DT_RASCAMERA = 3;
    DT_CHARSTREAM = 4;
    DT_METAFILE = 5;
    DT_DISPFILE = 6;

    CC_NONE = 0;
    CC_CIRCLES = 1;
    CC_PIE = 2;
    CC_CHORD = 4;
    CC_ELLIPSES = 8;
    CC_WIDE = 16;
    CC_STYLED = 32;
    CC_WIDESTYLED = 64;
    CC_INTERIORS = 128;
    CC_ROUNDRECT = 256;

    LC_NONE = 0;
    LC_POLYLINE = 2;
    LC_MARKER = 4;
    LC_POLYMARKER = 8;
    LC_WIDE = 16;
    LC_STYLED = 32;
    LC_WIDESTYLED = 64;
    LC_INTERIORS = 128;

    PC_NONE = 0;
    PC_POLYGON = 1;
    PC_RECTANGLE = 2;
    PC_WINDPOLYGON = 4;
    PC_TRAPEZOID = 4;
    PC_SCANLINE = 8;
    PC_WIDE = 16;
    PC_STYLED = 32;
    PC_WIDESTYLED = 64;
    PC_INTERIORS = 128;
    PC_POLYPOLYGON = 256;
    PC_PATHS = 512;

    CP_NONE = 0;
    CP_RECTANGLE = 1;
    CP_REGION = 2;

    TC_OP_CHARACTER = $00000001;
    TC_OP_STROKE = $00000002;
    TC_CP_STROKE = $00000004;
    TC_CR_90 = $00000008;
    TC_CR_ANY = $00000010;
    TC_SF_X_YINDEP = $00000020;
    TC_SA_DOUBLE = $00000040;
    TC_SA_INTEGER = $00000080;
    TC_SA_CONTIN = $00000100;
    TC_EA_DOUBLE = $00000200;
    TC_IA_ABLE = $00000400;
    TC_UA_ABLE = $00000800;
    TC_SO_ABLE = $00001000;
    TC_RA_ABLE = $00002000;
    TC_VA_ABLE = $00004000;
    TC_RESERVED = $00008000;
    TC_SCROLLBLT = $00010000;

    RC_BITBLT = 1;
    RC_BANDING = 2;
    RC_SCALING = 4;
    RC_BITMAP64 = 8;
    RC_GDI20_OUTPUT = $0010;
    RC_GDI20_STATE = $0020;
    RC_SAVEBITMAP = $0040;
    RC_DI_BITMAP = $0080;
    RC_PALETTE = $0100;
    RC_DIBTODEV = $0200;
    RC_BIGFONT = $0400;
    RC_STRETCHBLT = $0800;
    RC_FLOODFILL = $1000;
    RC_STRETCHDIB = $2000;
    RC_OP_DX_OUTPUT = $4000;
    RC_DEVBITS = $8000;


    DIB_RGB_COLORS = 0;
    DIB_PAL_COLORS = 1;
    SYSPAL_ERROR = 0;
    SYSPAL_STATIC = 1;
    SYSPAL_NOSTATIC = 2;
    CBM_INIT = $04;
    FLOODFILLBORDER = 0;
    FLOODFILLSURFACE = 1;

    CCHDEVICENAME = 31;
    CCHFORMNAME = 31;

type
	DEVMODE = packed record
	    dmDeviceName : cstring[CCHDEVICENAME];
    	dmSpecVersion : shortword;
	    dmDriverVersion : shortword;
    	dmSize : shortword;
	    dmDriverExtra : shortword;
    	dmFields : DWORD;
	    dmOrientation : shortint;
    	dmPaperSize : shortint;
	    dmPaperLength : shortint;
    	dmPaperWidth : shortint;
	    dmScale : shortint;
    	dmCopies : shortint;
	    dmDefaultSource : shortint;
    	dmPrintQuality : shortint;
	    dmColor : shortint;
    	dmDuplex : shortint;
	    dmYResolution : shortint;
    	dmTTOption : shortint;
	    dmCollate : shortint;
    	dmFormName : cstring[CCHFORMNAME];
	    dmLogPixels : shortword;
    	dmBitsPerPel : DWORD;
	    dmPelsWidth : DWORD;
    	dmPelsHeight : DWORD;
	    dmDisplayFlags : DWORD;
    	dmDisplayFrequency : DWORD;
	    dmICMMethod : DWORD;
    	dmICMIntent : DWORD;
	    dmMediaType : DWORD;
    	dmDitherType : DWORD;
	    dmICCManufacturer : DWORD;
    	dmICCModel : DWORD;
    	dmPanningWidth : DWORD;
	    dmPanningHeight : DWORD;
	end;

const
    DM_SPECVERSION = $0401;
    DM_ORIENTATION = $00000001;
    DM_PAPERSIZE = $00000002;
    DM_PAPERLENGTH = $00000004;
    DM_PAPERWIDTH = $00000008;
    DM_SCALE = $00000010;
    DM_COPIES = $00000100;
    DM_DEFAULTSOURCE = $00000200;
    DM_PRINTQUALITY = $00000400;
    DM_COLOR = $00000800;
    DM_DUPLEX = $00001000;
    DM_YRESOLUTION = $00002000;
    DM_TTOPTION = $00004000;
    DM_COLLATE = $00008000;
    DM_FORMNAME = $00010000;
    DM_LOGPIXELS = $00020000;
    DM_BITSPERPEL = $00040000;
    DM_PELSWIDTH = $00080000;
    DM_PELSHEIGHT = $00100000;
    DM_DISPLAYFLAGS = $00200000;
    DM_DISPLAYFREQUENCY = $00400000;
    DM_PANNINGWIDTH = $00800000;
    DM_PANNINGHEIGHT = $01000000;
    DM_ICMMETHOD = $02000000;
    DM_ICMINTENT = $04000000;
    DM_MEDIATYPE = $08000000;
    DM_DITHERTYPE = $10000000;
    DM_ICCMANUFACTURER = $20000000;
    DM_ICCMODEL = $40000000;
    DMORIENT_PORTRAIT = 1;
    DMORIENT_LANDSCAPE = 2;

    DMPAPER_LETTER = 1;
    DMPAPER_FIRST = DMPAPER_LETTER;
    DMPAPER_LETTERSMALL = 2;
    DMPAPER_TABLOID = 3;
    DMPAPER_LEDGER = 4;
    DMPAPER_LEGAL = 5;
    DMPAPER_STATEMENT = 6;
    DMPAPER_EXECUTIVE = 7;
    DMPAPER_A3 = 8;
    DMPAPER_A4 = 9;
    DMPAPER_A4SMALL = 10;
    DMPAPER_A5 = 11;
    DMPAPER_B4 = 12;
    DMPAPER_B5 = 13;
    DMPAPER_FOLIO = 14;
    DMPAPER_QUARTO = 15;
    DMPAPER_10X14 = 16;
    DMPAPER_11X17 = 17;
    DMPAPER_NOTE = 18;
    DMPAPER_ENV_9 = 19;
    DMPAPER_ENV_10 = 20;
    DMPAPER_ENV_11 = 21;
    DMPAPER_ENV_12 = 22;
    DMPAPER_ENV_14 = 23;
    DMPAPER_CSHEET = 24;
    DMPAPER_DSHEET = 25;
    DMPAPER_ESHEET = 26;
    DMPAPER_ENV_DL = 27;
    DMPAPER_ENV_C5 = 28;
    DMPAPER_ENV_C3 = 29;
    DMPAPER_ENV_C4 = 30;
    DMPAPER_ENV_C6 = 31;
    DMPAPER_ENV_C65 = 32;
    DMPAPER_ENV_B4 = 33;
    DMPAPER_ENV_B5 = 34;
    DMPAPER_ENV_B6 = 35;
    DMPAPER_ENV_ITALY = 36;
    DMPAPER_ENV_MONARCH = 37;
    DMPAPER_ENV_PERSONAL = 38;
    DMPAPER_FANFOLD_US = 39;
    DMPAPER_FANFOLD_STD_GERMAN = 40;
    DMPAPER_FANFOLD_LGL_GERMAN = 41;
    DMPAPER_ISO_B4 = 42;
    DMPAPER_JAPANESE_POSTCARD = 43;
    DMPAPER_9X11 = 44;
    DMPAPER_10X11 = 45;
    DMPAPER_15X11 = 46;
    DMPAPER_ENV_INVITE = 47;
    DMPAPER_RESERVED_48 = 48;
    DMPAPER_RESERVED_49 = 49;
    DMPAPER_LETTER_EXTRA = 50;
    DMPAPER_LEGAL_EXTRA = 51;
    DMPAPER_TABLOID_EXTRA = 52;
    DMPAPER_A4_EXTRA = 53;
    DMPAPER_LETTER_TRANSVERSE = 54;
    DMPAPER_A4_TRANSVERSE = 55;
    DMPAPER_LETTER_EXTRA_TRANSVERSE = 56;
    DMPAPER_A_PLUS = 57;
    DMPAPER_B_PLUS = 58;
    DMPAPER_LETTER_PLUS = 59;
    DMPAPER_A4_PLUS = 60;
    DMPAPER_A5_TRANSVERSE = 61;
    DMPAPER_B5_TRANSVERSE = 62;
    DMPAPER_A3_EXTRA = 63;
    DMPAPER_A5_EXTRA = 64;
    DMPAPER_B5_EXTRA = 65;
    DMPAPER_A2 = 66;
    DMPAPER_A3_TRANSVERSE = 67;
    DMPAPER_A3_EXTRA_TRANSVERSE = 68;

    DMPAPER_LAST = DMPAPER_A3_EXTRA_TRANSVERSE;
    DMPAPER_USER = 256;

    DMBIN_UPPER = 1;
    DMBIN_FIRST = DMBIN_UPPER;
    DMBIN_ONLYONE = 1;
    DMBIN_LOWER = 2;
    DMBIN_MIDDLE = 3;
    DMBIN_MANUAL = 4;
    DMBIN_ENVELOPE = 5;
    DMBIN_ENVMANUAL = 6;
    DMBIN_AUTO = 7;
    DMBIN_TRACTOR = 8;
    DMBIN_SMALLFMT = 9;
    DMBIN_LARGEFMT = 10;
    DMBIN_LARGECAPACITY = 11;
    DMBIN_CASSETTE = 14;
    DMBIN_FORMSOURCE = 15;
    DMBIN_LAST = DMBIN_FORMSOURCE;

	DMBIN_USER = 256;

    DMRES_DRAFT = -1;
    DMRES_LOW = -2;
    DMRES_MEDIUM = -3;
    DMRES_HIGH = -4;

    DMCOLOR_MONOCHROME = 1;
    DMCOLOR_COLOR = 2;
    DMDUP_SIMPLEX = 1;
    DMDUP_VERTICAL = 2;
    DMDUP_HORIZONTAL = 3;

    DMTT_BITMAP = 1;
    DMTT_DOWNLOAD = 2;
    DMTT_SUBDEV = 3;
    DMTT_DOWNLOAD_OUTLINE = 4;

    DMCOLLATE_FALSE = 0;
    DMCOLLATE_TRUE = 1;

    DMDISPLAYFLAGS_TEXTMODE = $00000004;

    DMICMMETHOD_NONE = 1;
    DMICMMETHOD_SYSTEM = 2;
    DMICMMETHOD_DRIVER = 3;
    DMICMMETHOD_DEVICE = 4;
    DMICMMETHOD_USER = 256;
    DMICM_SATURATE = 1;
    DMICM_CONTRAST = 2;
    DMICM_COLORMETRIC = 3;
    DMICM_USER = 256;

    DMMEDIA_STANDARD = 1;
    DMMEDIA_TRANSPARENCY = 2;
    DMMEDIA_GLOSSY = 3;
    DMMEDIA_USER = 256;

    DMDITHER_NONE = 1;
    DMDITHER_COARSE = 2;
    DMDITHER_FINE = 3;
    DMDITHER_LINEART = 4;
    DMDITHER_GRAYSCALE = 5;
    DMDITHER_USER = 256;

	RDH_RECTANGLES = 1;

type
	RGNDATAHEADER = packed record
	    dwSize : DWORD;
    	iType : DWORD;
	    nCount : DWORD;
    	nRgnSize : DWORD;
    	rcBound : RECT;
	end;

	RGNDATA = packed record
    	rdh : RGNDATAHEADER;
	end;

	ABC = packed record
	    abcA : integer;
    	abcB : UINT;
	    abcC : integer;
	end;

	ABCFLOAT = packed record
	    abcfA : FLOAT;
    	abcfB : FLOAT;
    	abcfC : FLOAT;
	end;

	OUTLINETEXTMETRIC = packed record
	    otmSize : UINT;
    	otmTextMetrics : TEXTMETRIC;
	    otmFiller : BYTE;
    	otmPanoseNumber : PANOSE;
	    otmfsSelection : UINT;
    	otmfsType : UINT;
	    otmsCharSlopeRise : integer;
    	otmsCharSlopeRun : integer;
     	otmItalicAngle : integer;
    	otmEMSquare : UINT;
     	otmAscent : integer;
     	otmDescent : integer;
    	otmLineGap : UINT;
	    otmsCapEmHeight : UINT;
    	otmsXHeight : UINT;
	    otmrcFontBox : RECT;
    	otmMacAscent : integer;
     	otmMacDescent : integer;
	    otmMacLineGap : UINT;
	    otmusMinimumPPEM : UINT;
	    otmptSubscriptSize : POINT;
    	otmptSubscriptOffset : POINT;
	    otmptSuperscriptSize : POINT;
    	otmptSuperscriptOffset : POINT;
	    otmsStrikeoutSize : UINT;
    	otmsStrikeoutPosition : integer;
	    otmsUnderscoreSize : integer;
    	otmsUnderscorePosition : integer;
    	otmpFamilyName : PSTR;
	    otmpFaceName : PSTR;
	    otmpStyleName : PSTR;
    	otmpFullName : PSTR;
	end;

	POLYTEXT = packed record
	    x : integer;
    	y : integer;
	    n : UINT;
    	lpstr : LPCSTR;
	    uiFlags : UINT;
    	rcl : RECT;
	    pdx : address;
	end;

	FIXED = packed record
		fract : shortword;
		value : shortint;
	end;

	MAT2 = packed record
		eM11 : FIXED;
	    eM12 : FIXED;
    	eM21 : FIXED;
	    eM22 : FIXED;
	end;

	GLYPHMETRICS = packed record
	    gmBlackBoxX : UINT;
    	gmBlackBoxY : UINT;
	    gmptGlyphOrigin : POINT;
    	gmCellIncX : shortint;
	    gmCellIncY : shortint;
	end;

const
    GGO_METRICS = 0;
    GGO_BITMAP = 1;
    GGO_NATIVE = 2;
    GGO_GRAY2_BITMAP = 4;
    GGO_GRAY4_BITMAP = 5;
    GGO_GRAY8_BITMAP = 6;
    GGO_GLYPH_INDEX = $0080;
    TT_POLYGON_TYPE = 24;
    TT_PRIM_LINE = 1;
    TT_PRIM_QSPLINE = 2;

type
	POINTFX = packed record
		x : FIXED;
		y : FIXED;
	end;

	TTPOLYCURVE = packed record
		wType : shortword;
		cpfx : shortword;
	end;

	TTPOLYGONHEADER = packed record
		cb : DWORD;
		dwType : DWORD;
		pfxStart : POINTFX;
	end;

const
    GCP_DBCS = $0001;
    GCP_REORDER = $0002;
    GCP_USEKERNING = $0008;
    GCP_GLYPHSHAPE = $0010;
    GCP_LIGATE = $0020;
    GCP_DIACRITIC = $0100;
    GCP_KASHIDA = $0400;
    GCP_ERROR = $8000;
    FLI_MASK = $103B;

    GCP_JUSTIFY = $00010000;
    FLI_GLYPHS = $00040000;
    GCP_CLASSIN = $00080000;
    GCP_MAXEXTENT = $00100000;
    GCP_JUSTIFYIN = $00200000;
    GCP_DISPLAYZWG = $00400000;
    GCP_SYMSWAPOFF = $00800000;
    GCP_NUMERICOVERRIDE = $01000000;
    GCP_NEUTRALOVERRIDE = $02000000;
    GCP_NUMERICSLATIN = $04000000;
    GCP_NUMERICSLOCAL = $08000000;

    GCPCLASS_LATIN = 1;
    GCPCLASS_HEBREW = 2;
    GCPCLASS_ARABIC = 2;
    GCPCLASS_NEUTRAL = 3;
    GCPCLASS_LOCALNUMBER = 4;
    GCPCLASS_LATINNUMBER = 5;
    GCPCLASS_LATINNUMERICTERMINATOR = 6;
    GCPCLASS_LATINNUMERICSEPARATOR = 7;
    GCPCLASS_NUMERICSEPARATOR = 8;
    GCPCLASS_PREBOUNDLTR = $80;
    GCPCLASS_PREBOUNDRTL = $40;
    GCPCLASS_POSTBOUNDLTR = $20;
    GCPCLASS_POSTBOUNDRTL = $10;
    GCPGLYPH_LINKBEFORE = $8000;
    GCPGLYPH_LINKAFTER = $4000;

type
	GCP_RESULTS = packed record
	    lStructSize : DWORD;
    	lpOutString : LPSTR;
	    lpOrder : address;
    	lpDx : address;
	    lpCaretPos : address;
    	lpClass : LPSTR;
	    lpGlyphs : LPWSTR;
    	nGlyphs : UINT;
	    nMaxFit : integer;
	end;

	RASTERIZER_STATUS = packed record
	    nSize : shortint;
    	wFlags : shortint;
	    nLanguageID : shortint;
	end;

const
    TT_AVAILABLE = $0001;
    TT_ENABLED = $0002;

type
	PIXELFORMATDESCRIPTOR = packed record
	    nSize : shortword;
    	nVersion : shortword;
	    dwFlags : DWORD;
    	iPixelType : BYTE;
	    cColorBits : BYTE;
    	cRedBits : BYTE;
	    cRedShift : BYTE;
    	cGreenBits : BYTE;
	    cGreenShift : BYTE;
    	cBlueBits : BYTE;
	    cBlueShift : BYTE;
    	cAlphaBits : BYTE;
	    cAlphaShift : BYTE;
    	cAccumBits : BYTE;
	    cAccumRedBits : BYTE;
    	cAccumGreenBits : BYTE;
	    cAccumBlueBits : BYTE;
    	cAccumAlphaBits : BYTE;
	    cDepthBits : BYTE;
    	cStencilBits : BYTE;
	    cAuxBuffers : BYTE;
    	iLayerType : BYTE;
	    bReserved : BYTE;
    	dwLayerMask : DWORD;
	    dwVisibleMask : DWORD;
    	dwDamageMask : DWORD;
	end;

const
    PFD_TYPE_RGBA = 0;
    PFD_TYPE_COLORINDEX = 1;
    PFD_MAIN_PLANE = 0;
    PFD_OVERLAY_PLANE = 1;
    PFD_UNDERLAY_PLANE = -1;

    PFD_DOUBLEBUFFER = $00000001;
    PFD_STEREO = $00000002;
    PFD_DRAW_TO_WINDOW = $00000004;
    PFD_DRAW_TO_BITMAP = $00000008;
    PFD_SUPPORT_GDI = $00000010;
    PFD_SUPPORT_OPENGL = $00000020;
    PFD_GENERIC_FORMAT = $00000040;
    PFD_NEED_PALETTE = $00000080;
    PFD_NEED_SYSTEM_PALETTE = $00000100;
    PFD_SWAP_EXCHANGE = $00000200;
    PFD_SWAP_COPY = $00000400;
    PFD_SWAP_LAYER_BUFFERS = $00000800;
    PFD_GENERIC_ACCELERATED = $00001000;

    PFD_DEPTH_DONTCARE = $20000000;
    PFD_DOUBLEBUFFER_DONTCARE = $40000000;
    PFD_STEREO_DONTCARE = $80000000;

	function AddFontResource(lpszFileName : address) : integer;
		external dll='gdi32.dll' name='AddFontResourceA' stdcall;
	function AnimatePalette(hPal : HPALETTE; iStartIndex, cEntries : UINT; ppe : address) : BOOL;
		external dll='gdi32.dll';
	function Arc(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer;
				nXStartArc, nYStartArc, nXEndArc, nYEndArc : integer) : BOOL;
		external dll='gdi32.dll';
	function BitBlt(hdcDest : HDC; nXDest, nYDest, nWidth, nHeight : integer;
				hdcSrc : HDC; nXSrc, nYSrc : integer; dwRop : DWORD) : BOOL;
		external dll='gdi32.dll';
	function CancelDC(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function Chord(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer;
					nXRadial1, nYRadial1, nXRadial2, nYRadial2 : integer) : BOOL;
		external dll='gdi32.dll';
	function ChoosePixelFormat(hDC : _HDC; ppfd : address) : integer;
		external dll='gdi32.dll';
	function CloseMetaFile(hDC : _HDC) : HMETAFILE;
		external dll='gdi32.dll';
	function CombineRgn(hrgnDest, hrgnSrc1, hrgnSrc2 : HRGN; fnCombineMode : integer) : integer;
		external dll='gdi32.dll';
	function CopyMetaFile(hmfSrc : HMETAFILE; lpszFile : address) : HMETAFILE;
		external dll='gdi32.dll' name='CopyMetaFileA' stdcall;
	function CreateBitmap(nWidth, nHeight : integer; cPlanes, cBitsPerPel : UINT; lpvBits : address) : HBITMAP;
		external dll='gdi32.dll';
	function CreateBitmapIndirect(lpbm : address) : HBITMAP;
		external dll='gdi32.dll';
	function CreateBrushIndirect(lplb : address) : HBRUSH;
		external dll='gdi32.dll';
	function CreateCompatibleBitmap(hDC : _HDC; nWidth, nHeight : integer) : HBITMAP;
		external dll='gdi32.dll';
	function CreateDiscardableBitmap(hDC : _HDC; nWidth, nHeight : integer) : HBITMAP;
		external dll='gdi32.dll';
	function CreateCompatibleDC(hdc : _HDC) : _HDC;
		external dll='gdi32.dll';
	function CreateDC(lpszDriver, lpszDevice, lpszOutput : address; lpInitData : address) : HDC;
		external dll='gdi32.dll' name='CreateDCA' stdcall;
	function CreateDIBitmap(hdc : _HDC; lpbmih : address; fdwInit : DWORD; lpbInit : address;
							lpbmi : address; fuUsage : UINT) : HBITMAP;
		external dll='gdi32.dll';
	function CreateDIBPatternBrush(hglbDIBPacked : HGLOBAL; fuColorSpec : UINT) : HBRUSH;
		external dll='gdi32.dll';
	function CreateDIBPatternBrushPt(lpPackedDIB : address; iUsage : UINT) : HBRUSH;
		external dll='gdi32.dll';
	function CreateEllipticRgn(nLeftRect, nTopRect, nRightRect, nBottomRect : integer) : HRGN;
		external dll='gdi32.dll';
	function CreateEllipticRgnIndirect(lprc : address) : HRGN;
		external dll='gdi32.dll';
	function CreateFontIndirect(var lplf : LOGFONT) : HFONT;
		external dll='gdi32.dll' name='CreateFontIndirectA' stdcall;
	function CreateFont(nHeight, nWidth, nEscapement, nOrientation, fnWeight : integer;
						fdwItalic, fdwUnderline, fdwStikeout, fdwCharset, fdwOutputPrecision,
						fdwClipPrecision, fdwQuality, fdwPitchAndFamily : DWORD;
						lpszFace : address) : HFONT;
		external dll='gdi32.dll' name='CreateFontA' stdcall;
	function CreateHatchBrush(fnStyle : integer; clrref : COLORREF) : HBRUSH;
		external dll='gdi32.dll';
	function CreateIC(lpszDriver, lpszDevice, lpszOutput : address;
						var lpdvmInit : DEVMODE) : HDC;
		external dll='gdi32.dll' name='CreateICA' stdcall;
	function CreateMetaFile(lpszFile : address) : HDC;
		external dll='gdi32.dll' name='CreateMetaFileA' stdcall;
	function CreatePalette(var lplgpl : LOGPALETTE) : HPALETTE;
		external dll='gdi32.dll';
	function CreatePen(fnPenStyle, nWidth : integer; crColor : COLORREF) : HPEN;
		external dll='gdi32.dll';
	function CreatePenIndirect(var plp : LOGPEN) : HPEN;
		external dll='gdi32.dll';
	function CreatePolyPolygonRgn(lppt, lpPolyCounts : address; nCount, fnPolyFillMode : integer) : HRGN;
		external dll='gdi32.dll';
	function CreatePatternBrush(hbmp : HBITMAP) : HBRUSH;
		external dll='gdi32.dll';
	function CreateRectRgn(nLeftRect, nTopRect, nRightRect, nBottomRect : integer) : HRGN;
		external dll='gdi32.dll';
	function CreateRectRgnIndirect(var lprc : RECT) : HRGN;
		external dll='gdi32.dll';
	function CreateRoundRectRgn(nLeftRect, nTopRect, nRightRect, nBottomRect, nWidthEllipse, nHeightEllipse : integer) : HRGN;
		external dll='gdi32.dll';
	function CreateScalableFontResource(fdwHidden : DWORD; lpszFontRes, lpszFontFile, lpszCurrentPath : address) : BOOL;
		external dll='gdi32.dll' name='CreateScalableFontResourceA' stdcall;
	function CreateSolidBrush(crColor : COLORREF) : HBRUSH;
		external dll='gdi32.dll';
	function DeleteDC(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function DeleteMetaFile(hmf : HMETAFILE) : BOOL;
		external dll='gdi32.dll';
	function DeleteObject(hObj : HGDIOBJ) : BOOL;
		external dll='gdi32.dll';
	function DescribePixelFormat(hDC : _HDC; iPixelFormat : integer; nBytes : UINT;
								var ppfd : PIXELFORMATDESCRIPTOR) : integer;
		external dll='gdi32.dll';

const
    DCTT_BITMAP = $0000001;
    DCTT_DOWNLOAD = $0000002;
    DCTT_SUBDEV = $0000004;
    DCTT_DOWNLOAD_OUTLINE = $0000008;
    DCBA_FACEUPNONE = $0000;
    DCBA_FACEUPCENTER = $0001;
    DCBA_FACEUPLEFT = $0002;
    DCBA_FACEUPRIGHT = $0003;
    DCBA_FACEDOWNNONE = $0100;
    DCBA_FACEDOWNCENTER = $0101;
    DCBA_FACEDOWNLEFT = $0102;
    DCBA_FACEDOWNRIGHT = $0103;

	function DeviceCapabilities(pDevice, pPort : address; dwCapability : shortword;
								pOutput : address; var pDevMode : DEVMODE) : integer;
		external dll='gdi32.dll' name='DeviceCapabilitiesA' stdcall;
	function DrawEscape(hDC : _HDC; nEscape, cbInput : integer;
						lpszInData : address) : integer;
		external dll='gdi32.dll';
	function Ellipse(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer) : BOOL;
		external dll='gdi32.dll';
	function EnumFontFamiliesEx(hDC : _HDC; var lpLogFont : LOGFONT; lpEnumProc : PROC;
								lParam : _LPARAM; dwFlags : DWORD) : integer;
		external dll='gdi32.dll' name='EnumFontFamiliesExA' stdcall;
	function EnumFontFamilies(hDC : _HDC; lpszFamily : address; lpEnumProc : PROC;
								lParam : _LPARAM) : integer;
		external dll='gdi32.dll' name='EnumFontFamiliesA' stdcall;
	function EnumFonts(hDC : _HDC; lpFaceName : address; lpEnumProc : PROC; lParam : _LPARAM) : integer;
		external dll='gdi32.dll' name='EnumFontsA' stdcall;
	function EnumObjects(hDC : _HDC; nObjectType : integer; lpObjectFunc : PROC; lParam : _LPARAM) : integer;
		external dll='gdi32.dll';
	function EqualRgn(hgrn1, hrgn2 : HRGN) : BOOL;
		external dll='gdi32.dll';
	function Escape(hDC : _HDC; nEscape, cbInput : integer; lpvInData, lpvOutData : address) : integer;
		external dll='gdi32.dll';
	function ExtEscape(hDC : _HDC; nEscape, cbInput : integer; lpvInData : address; cbOutput : integer; lpvOutData : address) : integer;
		external dll='gdi32.dll';
	function ExcludeClipRect(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer) : integer;
		external dll='gdi32.dll';
	function ExtCreateRegion(var lpXForm : XFORM; nCount : DWORD; lpRgnData : address) : HRGN;
		external dll='gdi32.dll';
	function ExtFloodFill(hDC : _HDC; nXStart, nYStart : integer; crColor : COLORREF;
							fuFillType : UINT) : BOOL;
		external dll='gdi32.dll';
	function FillRgn(hDC : _HDC; hrgn : _HRGN; hbr : HBRUSH) : BOOL;
		external dll='gdi32.dll';
	function FloodFill(hDC : _HDC; nXStart, nYStart : integer; crColor : COLORREF) : BOOL;
		external dll='gdi32.dll';
	function FrameRgn(hDC : _HDC; hrgn : _HRGN; hbr : HBRUSH; nWidth, nHeight : integer) : BOOL;
		external dll='gdi32.dll';
	function GetROP2(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetAspectRatioFilterEx(hDC : _HDC; var lpAspectRation : SIZE) : BOOL;
		external dll='gdi32.dll';
	function GetBkColor(hDC : _HDC) : COLORREF;
		external dll='gdi32.dll';
	function GetBkMode(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetBitmapBits(hbmp : HBITMAP; cbBuffer : LONG; lpvBits : LPVOID) : LONG;
		external dll='gdi32.dll';
	function GetBitmapDimensionEx(hbmp : HBITMAP; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function GetBoundsRect(hDC : _HDC; var lprcBounds : RECT; flags : UINT) : UINT;
		external dll='gdi32.dll';
	function GetBrushOrgEx(hDC : _HDC; var lppt : POINT) : BOOL;
		external dll='gdi32.dll';
	function GetCharWidth(hDC : _HDC; iFirstChar, iLastChar : UINT; lpBuffer : address) : BOOL;
		external dll='gdi32.dll' name='GetCharWidthA' stdcall;
	function GetCharWidth32(hDC : _HDC; iFirstChar, iLastChar : UINT; lpBuffer : address) : BOOL;
		external dll='gdi32.dll' name='GetCharWidth32A' stdcall;
	function GetCharWidthFloat(hDC : _HDC; iFirstChar, iLastChar : UINT; lpBuffer : address) : BOOL;
		external dll='gdi32.dll' name='GetCharWidthFloatA' stdcall;
	function GetCharABCWidths(hDC : _HDC; iFirstChar, iLastChar : UINT; lpabc : address) : BOOL;
		external dll='gdi32.dll' name='GetCharABCWidthsA' stdcall;
	function GetCharABCWidthsFloat(hDC : _HDC; iFirstChar, iLastChar : UINT; lpabc : address) : BOOL;
		external dll='gdi32.dll' name='GetCharABCWidthsFloatA' stdcall;
	function GetClipBox(hDC : _HDC; var lpRect : RECT) : integer;
		external dll='gdi32.dll';
	function GetClipRgn(hDC : _HDC; hrgn : _HRGN) : integer;
		external dll='gdi32.dll';
	function GetMetaRgn(hDC : _HDC; hrgn : _HRGN) : integer;
		external dll='gdi32.dll';
	function GetCurrentObject(hDC : _HDC; uObjectType : UINT) : HGDIOBJ;
		external dll='gdi32.dll';
	function GetCurrentPositionEx(hDC : _HDC; var lppt : POINT) : BOOL;
		external dll='gdi32.dll';
	function GetDeviceCaps(hDC : _HDC; nIndex : integer) : integer;
		external dll='gdi32.dll';
	function GetDIBits(hDC : _HDC; hbm : HBITMAP; uStartScan, cScanLines : UINT;
						lpvBits : address; var lpbi : BITMAPINFO; uUsage : UINT) : integer;
		external dll='gdi32.dll';
	function GetFontData(hDC : _HDC; dwTable, dwOffset : DWORD; lpvBuffer : address; cbData : DWORD) : DWORD;
		external dll='gdi32.dll';
	function GetGlyphOutline(hDC : _HDC; uChar, uFormat : UINT; var lpgm : GLYPHMETRICS;
							cbBuffer : DWORD; lpvBuffer : LPVOID;
							var lpMat2 : MAT2) : DWORD;
		external dll='gdi32.dll' name='GetGlyphOutlineA' stdcall;
	function GetGraphicsMode(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetMapMode(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetMetaFileBitsEx(hmf : HMETAFILE; nSize : UINT; lpvData : LPVOID) : UINT;
		external dll='gdi32.dll';
	//function GetMetaFile(lpszFile : address) : HMETAFILE;
	//	external dll='gdi32.dll' name='GetMetaFileA' stdcall;
	function GetNearestColor(hDC : _HDC; crColor : COLORREF) : COLORREF;
		external dll='gdi32.dll';
	function GetNearestPaletteIndex(hpal : HPALETTE; crColor : COLORREF) : UINT;
		external dll='gdi32.dll';
	function GetObjectType(h : HGDIOBJ) : DWORD;
		external dll='gdi32.dll';
	function GetOutlineTextMetrics(hDC : _HDC; cbData : UINT; lpOTM : address) : UINT;
		external dll='gdi32.dll' name='GetOutlineTextMetricsA' stdcall;
	function GetPaletteEntries(hPal : HPALETTE; iStartIndex, iEntries : UINT; lppe : address) : UINT;
		external dll='gdi32.dll';
	function GetPixel(hDC : _HDC; XPos, YPos : integer) : COLORREF;
		external dll='gdi32.dll';
	function GetPixelFormat(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetPolyFillMode(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetRasterizerCaps(var lprs : RASTERIZER_STATUS; cb : UINT) : BOOL;
		external dll='gdi32.dll';
	function GetRegionData(hRGN : _HRGN; dwCount : DWORD; lpRgnData : address) : DWORD;
		external dll='gdi32.dll';
	function GetRgnBox(hRGN : _HRGN; var lprc : RECT) : integer;
		external dll='gdi32.dll';
	function GetStockObject(fnObject : integer) : HGDIOBJ;
		external dll='gdi32.dll';
	function GetStretchBltMode(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetSystemPaletteEntries(hPal : HPALETTE; iStartIndex, iEntries : UINT; lppe : address) : UINT;
		external dll='gdi32.dll';
	function GetSystemPaletteUse(hDC : _HDC) : UINT;
		external dll='gdi32.dll';
	function GetTextCharacterExtra(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetTextAlign( hDC : _HDC) : UINT;
		external dll='gdi32.dll';
	function GetTextColor(hDC : _HDC) : COLORREF;
		external dll='gdi32.dll';
	function GetTextExtentPoint(hDC : _HDC; lpszStr : address; cbString : integer; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll' name='GetTextExtentPointA' stdcall;
	function GetTextExtentPoint32(hDC : _HDC; lpszStr : address; cbString : integer; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll' name='GetTextExtentPoint32A' stdcall;
	function GetTextExtentExPoint(hDC : _HDC; lpszStr : address; cchString, nMaxExten : integer;
									var lpnFit : integer; alpDx : address; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll' name='GetTextExtentExPointA' stdcall;
	function GetTextCharset(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetTextCharsetInfo(hDC : _HDC; lpSig : FONTSIGNATURE; dwFlags : DWORD) : integer;
		external dll='gdi32.dll';
	function TranslateCharsetInfo(lpsrc : word; var lpCs : CHARSETINFO; dwFlags : DWORD) : BOOL;
		external dll='gdi32.dll';
	function GetFontLanguageInfo(hDC : _HDC) : DWORD;
		external dll='gdi32.dll';
	function GetCharacterPlacement(hDC : _HDC; lpString : address; nCount, nMaxExtent : integer;
									var lpResults : GCP_RESULTS; dwFlags : DWORD) : DWORD;
		external dll='gdi32.dll' name='GetCharacterPlacementA' stdcall;
	function GetViewportExtEx(hDC : _HDC; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function GetViewportOrgEx(hDC : _HDC; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function GetWindowExtEx(hDC : _HDC; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function GetWindowOrgEx(hDC : _HDC; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function IntersectClipRect(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer) : integer;
		external dll='gdi32.dll';
	function InvertRgn(hDC : _HDC; hRgn : _HRGN) : BOOL;
		external dll='gdi32.dll';
	function LineDDA(nXStary, nYStart, nXEnd, nYEnd : integer; lpLineFunc : PROC; lParam : _LPARAM) : BOOL;
		external dll='gdi32.dll';
	function LineTo(hDC : _HDC; nXEnd, nYEnd : integer) : BOOL;
		external dll='gdi32.dll';
	function MaskBlt(hdcDest : HDC; nXDest, nYDest, nWidth, nHeight : integer;
					hdcSrc : HDC; nXSrc, nYSrc : integer; hbmpMash : HBITMAP;
					xMask, yMask : integer; dwRop : DWORD) : BOOL;
		external dll='gdi32.dll';
	function PlgBlt(hdcDest : HDC; lpPoint : address; hdcSrc : HDC;
					nXSrc, nYSrc, nWidth, nHeight : integer; hbmMask : HBITMAP;
					xMask, yMask : integer) : BOOL;
		external dll='gdi32.dll';
	function OffsetClipRgn(hDC : _HDC; nXOffset, nYOffset : integer) : integer;
		external dll='gdi32.dll';
	function OffsetRgn(hRgn : _HRGN; nXOffset, nYOffset : integer) : integer;
		external dll='gdi32.dll';
	function PatBlt(hDC : _HDC; nXLeft, nYLeft, nWidth, nHeight : integer; dwRop : DWORD) : BOOL;
		external dll='gdi32.dll';
	function Pie(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer;
				nXRadial1, nYRadial1, nXRadial2, nYRadial2 : integer) : BOOL;
		external dll='gdi32.dll';
	function PlayMetaFile(hDC : _HDC; hmf : HMETAFILE) : BOOL;
		external dll='gdi32.dll';
	function PaintRgn(hDC : _HDC; hRgn : _HRGN) : BOOL;
		external dll='gdi32.dll';
	function PolyPolygon(hDC : _HDC; lpPoints : address; lpPolyCounts : address; nCount : integer) : BOOL;
		external dll='gdi32.dll';
	function PtInRegion(hRgn : _HRGN; xPos, yPos : integer) : BOOL;
		external dll='gdi32.dll';
	function PtVisible(hDC : _HDC; xPos, yPos : integer) : BOOL;
		external dll='gdi32.dll';
	function RectInRegion(hRgn : _HRGN; var lprc : RECT) : BOOL;
		external dll='gdi32.dll';
	function RectVisible(hDC : _HDC; var lprc : RECT) : BOOL;
		external dll='gdi32.dll';
	function Rectangle(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer) : BOOL;
		external dll='gdi32.dll';
	function RestoreDC(hDC : _HDC; nSavedDC : integer) : BOOL;
		external dll='gdi32.dll';
	function ResetDC(hDC : _HDC; var lpInitData : DEVMODE) : _HDC;
		external dll='gdi32.dll' name='ResetDCA' stdcall;
	function RealizePalette(hDC : _HDC) : UINT;
		external dll='gdi32.dll';
	function RemoveFontResource(lpFileName : address) : BOOL;
		external dll='gdi32.dll' name='RemoveFontResourceA' stdcall;
	function RoundRect(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer;
						nWidth, nHeight : integer) : BOOL;
		external dll='gdi32.dll';
	function ResizePalette(hpal : HPALETTE; nEntries : UINT) : BOOL;
		external dll='gdi32.dll';
	function SaveDC(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function SelectClipRgn(hDC : _HDC; hRgn : _HRGN) : integer;
		external dll='gdi32.dll';
	function ExtSelectClipRgn(hDC : _HDC; hRgn : _HRGN; fnMode : integer) : integer;
		external dll='gdi32.dll';
	function SetMetaRgn(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function SelectObject(hDC : _HDC; h : HGDIOBJ) : HGDIOBJ;
		external dll='gdi32.dll';
	function SelectPalette(hDC : _HDC; hpal : HPALETTE; bForceBackground : BOOL) : HPALETTE;
		external dll='gdi32.dll';
	function SetBkColor(hDC : _HDC; crColor : COLORREF) : COLORREF;
		external dll='gdi32.dll';
	function SetBkMode(hDC : _HDC; iBkMode : integer) : integer;
		external dll='gdi32.dll';
	function SetBitmapBits(hbmp : HBITMAP; cBytes : DWORD; lpBits : address) : LONG;
		external dll='gdi32.dll';
	function SetBoundsRect(hDC : _HDC; var lprcBounds : RECT; flags : UINT) : UINT;
		external dll='gdi32.dll';
	function SetDIBits(hDC : _HDC; hbmp : HBITMAP; uStartScan, cScanLines : UINT;
						lpvBits : address; var lpbmi : BITMAPINFO; fuColorUse : UINT) : integer;
		external dll='gdi32.dll';
	function SetDIBitsToDevice(hDC : _HDC; XDEst, YDest : integer; dwWidth, dwHeight : DWORD;
								XSrc, YSrc : integer; uScanLines, cScanLines : UINT;
								lpvBits : address; var lpbmi : BITMAPINFO; fuColorUse : UINT) : integer;
		external dll='gdi32.dll';
	function SetMapperFlags(hDC : _HDC; dwFlag : DWORD) : DWORD;
		external dll='gdi32.dll';
	function SetGraphicsMode(hdc : _HDC; iMode : integer) : integer;
		external dll='gdi32.dll';
	function SetMapMode(hDC : _HDC; fnMapMode : integer) : integer;
		external dll='gdi32.dll';
	function SetMetaFileBitsEx(nSize : UINT; lpData : address) : HMETAFILE;
		external dll='gdi32.dll';
	function SetPaletteEntries(hpal : HPALETTE; iStart, cEntries : UINT; lppe : address) : UINT;
		external dll='gdi32.dll';
	function SetPixel(hDC : _HDC; x, y : integer; crColor : COLORREF) : COLORREF;
		external dll='gdi32.dll';
	function SetPixelV(hDC : _HDC; x, y : integer; crColor : COLORREF) : BOOL;
		external dll='gdi32.dll';
	function SetPixelFormat(hDC : _HDC; iPixelFormat : integer; var ppfd : PIXELFORMATDESCRIPTOR) : BOOL;
		external dll='gdi32.dll';
	function SetPolyFillMode(hDC : _HDC; iPolyFillMode : integer) : integer;
		external dll='gdi32.dll';
	function StretchBlt(hdcDest : HDC; nXOriginDest, nYOriginDest, nWidthDest, nHeightDest : integer;
						hdcSrc : HDC; nXOriginSrc, nYOriginSrc, nWidthSrc, nHeightSrc : integer;
						dwRop : DWORD) : BOOL;
		external dll='gdi32.dll';
	function SetRectRgn(hRgn : _HRGN; nLeftRect, nTopRect, nRightRect, nBottomRect : integer) : BOOL;
		external dll='gdi32.dll';
	function StretchDIBits(hDC : _HDC; XDest, YDest, nDestWidth, nDestHeight : integer;
							XSrc, YSrc, nSrcWidth, nSrcHeight : integer;
							lpBits : address; var lpBitsInfo : BITMAPINFO; iUsage : UINT;
							dwRop : DWORD) : integer;
		external dll='gdi32.dll';
	function SetROP2(hDC : _HDC; fnDrawMode : integer) : integer;
		external dll='gdi32.dll';
	function SetStretchBltMode(hDC : _HDC; iStretchMode : integer) : integer;
		external dll='gdi32.dll';
	function SetSystemPaletteUse(hDC : _HDC; uUsage : UINT) : UINT;
		external dll='gdi32.dll';
	function SetTextCharacterExtra(hDC : _HDC; nCharExtra : integer) : integer;
		external dll='gdi32.dll';
	function SetTextColor(hDC : _HDC; crColor : COLORREF) : COLORREF;
		external dll='gdi32.dll';
	function SetTextAlign(hDC : _HDC; fMode : UINT) : UINT;
		external dll='gdi32.dll';
	function SetTextJustification(hDC : _HDC; nBreakExtra, nBreakCount : integer) : BOOL;
		external dll='gdi32.dll';
	function UpdateColors(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function PlayMetaFileRecord(hDC : _HDC; lpHandleTable : address;
								var lpMetaRecord : METARECORD; nHandles : UINT) : BOOL;
		external dll='gdi32.dll';
	function EnumMetaFile(hDC : _HDC; hmf : HMETAFILE; lpMetaFunc : PROC; lParam : _LPARAM) : BOOL;
		external dll='gdi32.dll';
	function CloseEnhMetaFile(hDC : _HDC) : HENHMETAFILE;
		external dll='gdi32.dll';
	function CopyEnhMetaFile(hemfSrc : HENHMETAFILE; lpszFile : address) : HENHMETAFILE;
		external dll='gdi32.dll' name='CopyEnhMetaFileA' stdcall;
	function CreateEnhMetaFile(hdcRef : HDC; lpFilename : address; var lpRect : RECT;
								lpDescription : address) : HDC;
		external dll='gdi32.dll' name='CreateEnhMetaFileA' stdcall;
	function DeleteEnhMetaFile(hemf : HENHMETAFILE) : BOOL;
		external dll='gdi32.dll';
	function EnumEnhMetaFile(hDC : _HDC; hemf : HENHMETAFILE; lpenhMetaFunc : PROC;
							lpData : LPVOID; var lpRect : RECT) : BOOL;
		external dll='gdi32.dll';
	function GetEnhMetaFile(lpszMetaFile : address) : HENHMETAFILE;
		external dll='gdi32.dll' name='GetEnhMetaFileA' stdcall;
	function GetEnhMetaFileBits(hemf : HENHMETAFILE; cbBuffer : UINT; lpbBuffer : address) : UINT;
		external dll='gdi32.dll';
	function GetEnhMetaFileDescription(hemf : HENHMETAFILE; cchBuffer : UINT;
										lpszDescription : address) : UINT;
		external dll='gdi32.dll' name='GetEnhMetaFileDescriptionA' stdcall;
	function GetEnhMetaFileHeader(hemf : HENHMETAFILE; cbBuffer : UINT;
									var lpemh : ENHMETAHEADER) : UINT;
		external dll='gdi32.dll';
	function GetEnhMetaFilePaletteEntries(hemf : HENHMETAFILE; cEntries : UINT;
											lppe : address) : UINT;
		external dll='gdi32.dll';
	function GetEnhMetaFilePixelFormat(hemf : HENHMETAFILE; cbBuffer : UINT;
										var ppfd : PIXELFORMATDESCRIPTOR) : UINT;
		external dll='gdi32.dll';
	function GetWinMetaFileBits(hemf : HENHMETAFILE; cbBuffer : UINT; lpbBuffer : address;
								fnMapMode : integer; hdcRef : HDC) : UINT;
		external dll='gdi32.dll';
	function PlayEnhMetaFile(hDC : _HDC; hemf : HENHMETAFILE; var lpRect : RECT) : BOOL;
		external dll='gdi32.dll';
	function PlayEnhMetaFileRecord(hDC : _HDC; lpHandleTable : address;
									lpenhMetaRecord : address; nHandles : UINT) : BOOL;
		external dll='gdi32.dll';
	function SetEnhMetaFileBits(cbBuffer : UINT; lpData : address) : HENHMETAFILE;
		external dll='gdi32.dll';
	function SetWinMetaFileBits(cbBuffer : UINT; lpbBuffer : address; hdcRef : HDC;
								var lpmfp : METAFILEPICT) : HENHMETAFILE;
		external dll='gdi32.dll';
	function GdiComment(hDC : _HDC; cbSize : UINT; lpData : address) : BOOL;
		external dll='gdi32.dll';
	function GetTextMetrics(hDC : _HDC; var lptm : TEXTMETRIC) : BOOL;
		external dll='gdi32.dll' name='GetTextMetricsA' stdcall;

type
	DIBSECTION = packed record
		dsBm : BITMAP;
		dsBmih : BITMAPINFOHEADER;
		dsBitFields : array[0..2] of DWORD;
		dshSection : HANDLE;
		dsOffset : DWORD;
	end;

	function AngleArc(hDC : _HDC; x, y : integer; dwRadius : DWORD;
						eStartAngle, eSweepAngle : FLOAT) : BOOL;
		external dll='gdi32.dll';
	function PolyPolyline(hDC : _HDC; lppt : address; lpdwPolyPoints : address;
							cCount : DWORD) : BOOL;
		external dll='gdi32.dll';
	function GetWorldTransform(hDC : _HDC; var lpXForm : XFORM) : BOOL;
		external dll='gdi32.dll';
	function SetWorldTransform(hDC : _HDC; var lpXForm : XFORM) : BOOL;
		external dll='gdi32.dll';
	function ModifyWorldTransform(hDC : _HDC; var lpXForm : XFORM; iMode : DWORD) : BOOL;
		external dll='gdi32.dll';
	function CombineTransform(var lpxformResult, lpxform1, lpxform2 : XFORM) : BOOL;
		external dll='gdi32.dll';
	function CreateDIBSection(hDC : _HDC; var pbmi : BITMAPINFO; iUsage : UINT;
								var ppvBits : address; hSection : HANDLE; dwOffset : DWORD) : HBITMAP;
		external dll='gdi32.dll';
	function GetDIBColorTable(hDC : _HDC; uStartIndex, cEntries : UINT; pColors : address) : UINT;
		external dll='gdi32.dll';
	function SetDIBColorTable(hDC : _HDC; uStartIndex, cEntries : UINT; pColors : address) : UINT;
		external dll='gdi32.dll';

const
    CA_NEGATIVE = $0001;
    CA_LOG_FILTER = $0002;

    ILLUMINANT_DEVICE_DEFAULT = 0;
    ILLUMINANT_A = 1;
    ILLUMINANT_B = 2;
    ILLUMINANT_C = 3;
    ILLUMINANT_D50 = 4;
    ILLUMINANT_D55 = 5;
    ILLUMINANT_D65 = 6;
    ILLUMINANT_D75 = 7;
    ILLUMINANT_F2 = 8;
    ILLUMINANT_MAX_INDEX = ILLUMINANT_F2;
    ILLUMINANT_TUNGSTEN = ILLUMINANT_A;
    ILLUMINANT_DAYLIGHT = ILLUMINANT_C;
    ILLUMINANT_FLUORESCENT = ILLUMINANT_F2;
    ILLUMINANT_NTSC = ILLUMINANT_C;

    RGB_GAMMA_MIN = 02500;
    RGB_GAMMA_MAX = 65000;
    REFERENCE_WHITE_MIN = 6000;
    REFERENCE_WHITE_MAX = 10000;
    REFERENCE_BLACK_MIN = 0;
    REFERENCE_BLACK_MAX = 4000;

    COLOR_ADJ_MIN = -100;
    COLOR_ADJ_MAX = 100;

type
	COLORADJUSTMENT = packed record
	    caSize : shortword;
    	caFlags : shortword;
	    caIlluminantIndex : shortword;
    	caRedGamma : shortword;
	    caGreenGamma : shortword;
    	caBlueGamma : shortword;
	    caReferenceBlack : shortword;
    	caReferenceWhite : shortword;
	    caContrast : shortint;
    	caBrightness : shortint;
	    caColorfulness : shortint;
    	caRedGreenTint : shortint;
	end;

	function SetColorAdjustment(hDC : _HDC; var lpca : COLORADJUSTMENT) : BOOL;
		external dll='gdi32.dll';
	function GetColorAdjustment(hDC : _HDC; var lpca : COLORADJUSTMENT) : BOOL;
		external dll='gdi32.dll';
	function CreateHalftonePalette(hDC : _HDC) : HPALETTE;
		external dll='gdi32.dll';

type
	DOCINFO = packed record
		cbSize : integer;
		lpszDocName : LPCSTR;
		lpszOutput : LPCSTR;
		lpszDatatype : LPCSTR;
		fwType : DWORD;
	end;

const
	DI_APPBANDING = $0001;

	function StartDoc(hDC : _HDC; var lpdi : DOCINFO) : integer;
		external dll='gdi32.dll' name='StartDocA' stdcall;
	function EndDoc(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function StartPage(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function EndPage(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function AbortDoc(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function SetAbortProc(hDC : _HDC; lpAbortProc : PROC) : integer;
		external dll='gdi32.dll';
	function AbortPath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function ArcTo(hDC : _HDC; nLeftRect, nTopRect, nRightRect, nBottomRect : integer;
					nXRadial1, nYRadial1, nXRadial2, nYRadial2 : integer) : BOOL;
		external dll='gdi32.dll';
	function BeginPath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function CloseFigure(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function EndPath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function FillPath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function FlattenPath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function GetPath(lpPoints : address; lpBytes : address; nSize : integer) : integer;
		external dll='gdi32.dll';
	function PathToRegion(hDC : _HDC) : HRGN;
		external dll='gdi32.dll';
	function PolyDraw(hDC : _HDC; lppt : address; lpbTypes : address; cCount : integer) : BOOL;
		external dll='gdi32.dll';
	function SelectClipPath(hDC : _HDC; iMode : integer) : BOOL;
		external dll='gdi32.dll';
	function SetArcDirection(hDC : _HDC; ArcDirection : integer) : integer;
		external dll='gdi32.dll';
	function SetMiterLimit(hDC : _HDC; eNewLimit : FLOAT; var peOldLimit : FLOAT) : BOOL;
		external dll='gdi32.dll';
	function StrokeAndFillPath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function StrokePath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function WidenPath(hDC : _HDC) : BOOL;
		external dll='gdi32.dll';
	function ExtCreatePen(dwPenStyle, dwWidth : DWORD; var lplb : LOGBRUSH;
							dwStyleCount : DWORD; lpStyle : address) : HPEN;
		external dll='gdi32.dll';
	function GetMiterLimit(hDC : _HDC; var peLimit : FLOAT) : BOOL;
		external dll='gdi32.dll';
	function GetArcDirection(hDC : _HDC) : integer;
		external dll='gdi32.dll';
	function GetObject(h : HGDIOBJ; cbBuffer : integer; lpvObject : address) : integer;
		external dll='gdi32.dll' name='GetObjectA' stdcall;
	function MoveToEx(hDC : _HDC; x, y : integer; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function TextOut(hDC : _HDC; nXStart, nYStart : integer; lpString : address; cbString : integer) : BOOL;
		external dll='gdi32.dll' name='TextOutA' stdcall;
	function ExtTextOut(hdc : _HDC; x, y : integer; fuOptions : UINT; var lprc : RECT;
						lpString : address; cbCount : UINT; lpDx : address) : BOOL;
		external dll='gdi32.dll' name='ExtTextOutA' stdcall;
	function PolyTextOut(hdc : _HDC; pptxt : address; cStrings : integer) : BOOL;
		external dll='gdi32.dll' name='PolyTextOutA' stdcall;
	function CreatePolygonRgn(lppt : address; cPoints, fnPolyFillMode : integer) : HRGN;
		external dll='gdi32.dll';
	function DPtoLP(hDC : _HDC; lpPoints : address; nCount : integer) : BOOL;
		external dll='gdi32.dll';
	function LPtoDP(hDC : _HDC; lpPoints : address; nCount : integer) : BOOL;
		external dll='gdi32.dll';
	function Polygon(hDC : _HDC; lpPoints : address; nCount : integer) : BOOL;
		external dll='gdi32.dll';
	function Polyline(hDC : _HDC; lpPoints : address; cPoints : integer) : BOOL;
		external dll='gdi32.dll';
	function PolyBezier(hDC : _HDC; lpPoints : address; cPoints : DWORD) : BOOL;
		external dll='gdi32.dll';
	function PolyBezierTo(hDC : _HDC; lpPoints : address; cCount : DWORD) : BOOL;
		external dll='gdi32.dll';
	function PolylineTo(hDC : _HDC; lpPoints : address; cCount : DWORD) : BOOL;
		external dll='gdi32.dll';
	function SetViewportExtEx(hDC : _HDC; nXExtent, nYExtent : integer; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function SetViewportOrgEx(hDC : _HDC; x, y : integer; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function SetWindowExtEx(hDC : _HDC; nXExtent, nYExtent : integer; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function SetWindowOrgEx(hDC : _HDC; x, y : integer; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function OffsetViewportOrgEx(hDC : _HDC; x, y : integer; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function OffsetWindowOrgEx(hDC : _HDC; x, y : integer; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function ScaleViewportExtEx(hDC : _HDC; Xnum, Xdenum, Ynum, Ydenum : integer; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function ScaleWindowExtEx(hDC : _HDC; Xnum, Xdenum, Ynum, Ydenum : integer; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function SetBitmapDimensionEx(hbmp : HBITMAP; nWidth, nHeight : integer; var lpSize : SIZE) : BOOL;
		external dll='gdi32.dll';
	function SetBrushOrgEx(hDC : _HDC; nXOrg, nYOrg : integer; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	function GetTextFace(hDC : _HDC; nCount : integer; lpFaceName : address) : integer;
		external dll='gdi32.dll' name='GetTextFaceA' stdcall;

const
	FONTMAPPER_MAX = 10;

type
	KERNINGPAIR = packed record
   		wFirst : shortword;
   		wSecond : shortword;
   		iKernAmount : integer;
	end;

	function GetKerningPairs(hDC : _HDC; nNumPairs : DWORD; lpkrnpair : address) : DWORD;
		external dll='gdi32.dll' name='GetKerningPairsA' stdcall;
	function GetDCOrgEx(hDC : _HDC; var lpPoint : POINT) : BOOL;
		external dll='gdi32.dll';
	(*
	** This function does nothing on win32 (just returns FALSE)
	** WINGDIAPI BOOL  WINAPI FixBrushOrgEx(HDC,int,int,LPPOINT);
	*)
	function UnrealizeObject(h : HGDIOBJ) : BOOL;
		external dll='gdi32.dll';
	function GdiFlush : BOOL;
		external dll='gdi32.dll';
	function GdiSetBatchLimit(dwLimit : DWORD) : DWORD;
		external dll='gdi32.dll';
	function GdiGetBatchLimit : DWORD;
		external dll='gdi32.dll';

const
    ICM_OFF = 1;
    ICM_ON = 2;
    ICM_QUERY = 3;

	function SetICMMode(hDC : _HDC; fICM : integer) : integer;
		external dll='gdi32.dll';
	function CheckColorsInGamut(hDC : _HDC; lpaRGBQuad, lpResult : LPVOID; nCount : DWORD) : BOOL;
		external dll='gdi32.dll';
	function GetColorSpace(hDC : _HDC) : HANDLE;
		external dll='gdi32.dll';
	function GetLogColorSpace(hcs : HCOLORSPACE; var lpBuffer : LOGCOLORSPACE; nSize : DWORD) : BOOL;
		external dll='gdi32.dll' name='GetLogColorSpaceA' stdcall;
	function CreateColorSpace(var lpLogColorSpace : LOGCOLORSPACE) : HCOLORSPACE;
		external dll='gdi32.dll' name='CreateColorSpaceA' stdcall;
	function SetColorSpace(hDC : _HDC; hcs : HCOLORSPACE) : BOOL;
		external dll='gdi32.dll';
	function DeleteColorSpace(hcs : HCOLORSPACE) : BOOL;
		external dll='gdi32.dll';
	function GetICMProfile(hDC : _HDC; var lpcbName : DWORD; lpszFilename : address) : BOOL;
		external dll='gdi32.dll' name='GetICMProfileA' stdcall;
	function SetICMProfile(hDC : _HDC; lpszFilename : address) : BOOL;
		external dll='gdi32.dll' name='SetICMProfileA' stdcall;
type
	GammaColors = (redGammaColor, greenGammaColor, blueGammaColor);
	GammaRamp = packed array[redGammaColor..blueGammaColor, 0..255] of byte;

	function GetDeviceGammaRamp(hDC : _HDC; var lpRamp : GammaRamp) : BOOL;
		external dll='gdi32.dll';
	function SetDeviceGammaRamp(hDC : _HDC; var lpRamp : GammaRamp) : BOOL;
		external dll='gdi32.dll';
	function ColorMatchToTarget(hDC : _HDC; hdcTarget : _HDC; uiAction : DWORD) : BOOL;
		external dll='gdi32.dll';

const
	ENHMETA_SIGNATURE = $464D4520;

	ENHMETA_STOCK_OBJECT = $80000000;

    EMR_HEADER = 1;
    EMR_POLYBEZIER = 2;
    EMR_POLYGON = 3;
    EMR_POLYLINE = 4;
    EMR_POLYBEZIERTO = 5;
    EMR_POLYLINETO = 6;
    EMR_POLYPOLYLINE = 7;
    EMR_POLYPOLYGON = 8;
    EMR_SETWINDOWEXTEX = 9;
    EMR_SETWINDOWORGEX = 10;
    EMR_SETVIEWPORTEXTEX = 11;
    EMR_SETVIEWPORTORGEX = 12;
    EMR_SETBRUSHORGEX = 13;
    EMR_EOF = 14;
    EMR_SETPIXELV = 15;
    EMR_SETMAPPERFLAGS = 16;
    EMR_SETMAPMODE = 17;
    EMR_SETBKMODE = 18;
    EMR_SETPOLYFILLMODE = 19;
    EMR_SETROP2 = 20;
    EMR_SETSTRETCHBLTMODE = 21;
    EMR_SETTEXTALIGN = 22;
    EMR_SETCOLORADJUSTMENT = 23;
    EMR_SETTEXTCOLOR = 24;
    EMR_SETBKCOLOR = 25;
    EMR_OFFSETCLIPRGN = 26;
    EMR_MOVETOEX = 27;
    EMR_SETMETARGN = 28;
    EMR_EXCLUDECLIPRECT = 29;
    EMR_INTERSECTCLIPRECT = 30;
    EMR_SCALEVIEWPORTEXTEX = 31;
    EMR_SCALEWINDOWEXTEX = 32;
    EMR_SAVEDC = 33;
    EMR_RESTOREDC = 34;
    EMR_SETWORLDTRANSFORM = 35;
    EMR_MODIFYWORLDTRANSFORM = 36;
    EMR_SELECTOBJECT = 37;
    EMR_CREATEPEN = 38;
    EMR_CREATEBRUSHINDIRECT = 39;
    EMR_DELETEOBJECT = 40;
    EMR_ANGLEARC = 41;
    EMR_ELLIPSE = 42;
    EMR_RECTANGLE = 43;
    EMR_ROUNDRECT = 44;
    EMR_ARC = 45;
    EMR_CHORD = 46;
    EMR_PIE = 47;
    EMR_SELECTPALETTE = 48;
    EMR_CREATEPALETTE = 49;
    EMR_SETPALETTEENTRIES = 50;
    EMR_RESIZEPALETTE = 51;
    EMR_REALIZEPALETTE = 52;
    EMR_EXTFLOODFILL = 53;
    EMR_LINETO = 54;
    EMR_ARCTO = 55;
    EMR_POLYDRAW = 56;
    EMR_SETARCDIRECTION = 57;
    EMR_SETMITERLIMIT = 58;
    EMR_BEGINPATH = 59;
    EMR_ENDPATH = 60;
    EMR_CLOSEFIGURE = 61;
    EMR_FILLPATH = 62;
    EMR_STROKEANDFILLPATH = 63;
    EMR_STROKEPATH = 64;
    EMR_FLATTENPATH = 65;
    EMR_WIDENPATH = 66;
    EMR_SELECTCLIPPATH = 67;
    EMR_ABORTPATH = 68;

    EMR_GDICOMMENT = 70;
    EMR_FILLRGN = 71;
    EMR_FRAMERGN = 72;
    EMR_INVERTRGN = 73;
    EMR_PAINTRGN = 74;
    EMR_EXTSELECTCLIPRGN = 75;
    EMR_BITBLT = 76;
    EMR_STRETCHBLT = 77;
    EMR_MASKBLT = 78;
    EMR_PLGBLT = 79;
    EMR_SETDIBITSTODEVICE = 80;
    EMR_STRETCHDIBITS = 81;
    EMR_EXTCREATEFONTINDIRECTW = 82;
    EMR_EXTTEXTOUTA = 83;
    EMR_EXTTEXTOUTW = 84;
    EMR_POLYBEZIER16 = 85;
    EMR_POLYGON16 = 86;
    EMR_POLYLINE16 = 87;
    EMR_POLYBEZIERTO16 = 88;
    EMR_POLYLINETO16 = 89;
    EMR_POLYPOLYLINE16 = 90;
    EMR_POLYPOLYGON16 = 91;
    EMR_POLYDRAW16 = 92;
    EMR_CREATEMONOBRUSH = 93;
    EMR_CREATEDIBPATTERNBRUSHPT = 94;
    EMR_EXTCREATEPEN = 95;
    EMR_POLYTEXTOUTA = 96;
    EMR_POLYTEXTOUTW = 97;
    EMR_SETICMMODE = 98;
    EMR_CREATECOLORSPACE = 99;
    EMR_SETCOLORSPACE = 100;
    EMR_DELETECOLORSPACE = 101;
    EMR_GLSRECORD = 102;
    EMR_GLSBOUNDEDRECORD = 103;
    EMR_PIXELFORMAT = 104;

    EMR_MIN = 1;
    EMR_MAX = 104;

type
	EMR = packed record
		iType : DWORD;
		nSize : DWORD;
	end;

	_EMR = EMR;

	EMRTEXT = packed record
    	ptlReference : POINTL;
	    nChars : DWORD;
    	offString : DWORD;
	    fOptions : DWORD;
    	rcl : RECTL;
	    offDx : DWORD;
	end;

	_EMRTEXT = EMRTEXT;

	EMRABORTPATH = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRBEGINPATH = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRENDPATH  = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRCLOSEFIGURE = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRFLATTENPATH = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRWIDENPATH = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRSETMETARGN = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRSAVEDC = packed record
		iType : DWORD;
		nSize : DWORD;
	end;
	EMRREALIZEPALETTE = packed record
		iType : DWORD;
		nSize : DWORD;
	end;

	EMRSELECTCLIPPATH = packed record
		emr : _EMR;
		iMode : DWORD;
	end;

	EMRSETBKMODE = packed record
		emr : _EMR;
		iMode : DWORD;
	end;
	EMRSETMAPMODE = packed record
		emr : _EMR;
		iMode : DWORD;
	end;
	EMRSETPOLYFILLMODE = packed record
		emr : _EMR;
		iMode : DWORD;
	end;
	EMRSETROP2 = packed record
		emr : _EMR;
		iMode : DWORD;
	end;
	EMRSETSTRETCHBLTMODE = packed record
		emr : _EMR;
		iMode : DWORD;
	end;
	EMRSETICMMODE = packed record
		emr : _EMR;
		iMode : DWORD;
	end;
	EMRSETTEXTALIGN = packed record
		emr : _EMR;
		iMode : DWORD;
	end;

	EMRSETMITERLIMIT = packed record
		emr : _EMR;
		eMiterLimit : FLOAT;
	end;

	EMRRESTOREDC = packed record
		emr : _EMR;
		iRelative : LONG;
	end;

	EMRSETARCDIRECTION = packed record
		emr : _EMR;
		iArcDirection : DWORD;
	end;

	EMRSETMAPPERFLAGS = packed record
		emr : _EMR;
		dwFlags : DWORD;
	end;

	EMRSETBKCOLOR = packed record
		emr : _EMR;
		crColor : COLORREF;
	end;

	EMRSETTEXTCOLOR = packed record
		emr : _EMR;
		crColor : COLORREF;
	end;

	EMRSELECTOBJECT = packed record
		emr : _EMR;
		ihObject : DWORD;
	end;

	EMRDELETEOBJECT = packed record
		emr : _EMR;
		ihObject : DWORD;
	end;

	EMRSELECTCOLORSPACE = packed record
		emr : _EMR;
		ihCS : DWORD;
	end;

	EMRDELETECOLORSPACE = packed record
		emr : _EMR;
		ihCS : DWORD;
	end;

	EMRSELECTPALETTE = packed record
		emr : _EMR;
		ihPal : DWORD;
	end;

	EMRRESIZEPALETTE = packed record
		emr : _EMR;
		ihPal : DWORD;
		cEntries : DWORD;
	end;

	EMRSETPALETTEENTRIES = packed record
		emr : _EMR;
		ihPal : DWORD;
		iStart : DWORD;
		cEntries : DWORD;
	end;

	EMRSETCOLORADJUSTMENT = packed record
		emr : _EMR;
		ca : COLORADJUSTMENT;
	end;

	EMRGDICOMMENT = packed record
		emr : _EMR;
		cbData : DWORD;
	end;

	EMREOF = packed record
		emr : _EMR;
	    nPalEntries : DWORD;
    	offPalEntries : DWORD;
	    nSizeLast : DWORD;
	end;

	EMRLINETO = packed record
		emr : _EMR;
		ptl : POINTL;
	end;
	EMRMOVETOEX = packed record
		emr : _EMR;
		ptl : POINTL;
	end;

	EMROFFSETCLIPRGN = packed record
		emr : _EMR;
		ptlOffset : POINTL;
	end;

	EMRFILLPATH = packed record
		emr : _EMR;
		rclBounds : RECTL;
	end;
	EMRSTROKEANDFILLPATH = packed record
		emr : _EMR;
		rclBounds : RECTL;
	end;

	EMRSTROKEPATH = packed record
		emr : _EMR;
		rclBounds : RECTL;
	end;

	EMREXCLUDECLIPRECT = packed record
		emr : _EMR;
		rclClip : RECTL;
	end;
	EMRINTERSECTCLIPRECT = packed record
		emr : _EMR;
		rclClip : RECTL;
	end;

	EMRSETVIEWPORTORGEX = packed record
		emr : _EMR;
		ptlOrigin : POINTL;
	end;
	EMRSETWINDOWORGEX = packed record
		emr : _EMR;
		ptlOrigin : POINTL;
	end;

	EMRSETBRUSHORGEX = packed record
		emr : _EMR;
		ptlOrigin : POINTL;
	end;

	EMRSETVIEWPORTEXTEX = packed record
		emr : _EMR;
		szlExtent : SIZEL;
	end;
	EMRSETWINDOWEXTEX = packed record
		emr : _EMR;
		szlExtent : SIZEL;
	end;

	EMRSCALEVIEWPORTEXTEX = packed record
		emr : _EMR;
		xNum : LONG;
    	xDenom : LONG;
    	yNum : LONG;
    	yDenom : LONG;
	end;
	EMRSCALEWINDOWEXTEX = packed record
		emr : _EMR;
		xNum : LONG;
    	xDenom : LONG;
    	yNum : LONG;
    	yDenom : LONG;
	end;

	EMRSETWORLDTRANSFORM = packed record
		emr : _EMR;
		xform : _XFORM;
	end;

	EMRMODIFYWORLDTRANSFORM = packed record
		emr : _EMR;
		xform : _XFORM;
		iMode : DWORD;
	end;

	EMRSETPIXELV = packed record
		emr : _EMR;
    	ptlPixel : POINTL;
    	crColor : COLORREF;
	end;

	EMREXTFLOODFILL = packed record
		emr : _EMR;
    	ptlStart : POINTL;
    	crColor : COLORREF;
    	iMode : DWORD;
	end;

	EMRELLIPSE = packed record
		emr : _EMR;
		rclBox : RECTL;
	end;
	EMRRECTANGLE = packed record
		emr : _EMR;
		rclBox : RECTL;
	end;

	EMRROUNDRECT = packed record
		emr : _EMR;
		rclBox : RECTL;
		szlCorner : SIZEL;
	end;

	EMRARC = packed record
		emr : _EMR;
		rclBox : RECTL;
    	ptlStart : POINTL;
    	ptlEnd : POINTL;
	end;
	EMRARCTO = packed record
		emr : _EMR;
		rclBox : RECTL;
    	ptlStart : POINTL;
    	ptlEnd : POINTL;
	end;

	EMRCHORD = packed record
		emr : _EMR;
		rclBox : RECTL;
    	ptlStart : POINTL;
    	ptlEnd : POINTL;
	end;

	EMRPIE = packed record
		emr : _EMR;
		rclBox : RECTL;
    	ptlStart : POINTL;
    	ptlEnd : POINTL;
	end;

	EMRANGLEARC = packed record
		emr : _EMR;
    	ptlCenter : POINTL;
    	nRadius : DWORD;
    	eStartAngle : FLOAT;
    	eSweepAngle : FLOAT;
	end;

	EMRPOLYLINE = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cptl : DWORD;
	end;
	EMRPOLYBEZIER = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cptl : DWORD;
	end;

	EMRPOLYGON = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cptl : DWORD;
	end;

	EMRPOLYBEZIERTO = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cptl : DWORD;
	end;

	EMRPOLYLINETO = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cptl : DWORD;
	end;

	EMRPOLYLINE16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cpts : DWORD;
	end;
	EMRPOLYBEZIER16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cpts : DWORD;
	end;

	EMRPOLYGON16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cpts : DWORD;
	end;

	EMRPOLYBEZIERTO16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cpts : DWORD;
	end;

	EMRPOLYLINETO16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cpts : DWORD;
	end;

	EMRPOLYDRAW = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cptl : DWORD;
	end;

	EMRPOLYDRAW16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cpts : DWORD;
	end;

	EMRPOLYPOLYLINE = packed record
		emr : _EMR;
		rclBounds : RECTL;
		nPolys : DWORD;
		cptl : DWORD;
	end;

	EMRPOLYPOLYGON = packed record
		emr : _EMR;
		rclBounds : RECTL;
		nPolys : DWORD;
		cptl : DWORD;
	end;

	EMRPOLYPOLYLINE16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		nPolys : DWORD;
		cpts : DWORD;
	end;

	EMRPOLYPOLYGON16 = packed record
		emr : _EMR;
		rclBounds : RECTL;
		nPolys : DWORD;
		cpts : DWORD;
	end;

	EMRINVERTRGN = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cbRgnData : DWORD;
	end;
	EMRPAINTRGN = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cbRgnData : DWORD;
	end;

	EMRFILLRGN = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cbRgnData : DWORD;
		ihBrush : DWORD;
	end;

	EMRFRAMERGN = packed record
		emr : _EMR;
		rclBounds : RECTL;
		cbRgnData : DWORD;
		ihBrush : DWORD;
    	szlStroke : SIZEL;
	end;

	EMREXTSELECTCLIPRGN = packed record
		emr : _EMR;
		cbRgnData : DWORD;
		iMode : DWORD;
	end;

	EMREXTTEXTOUT = packed record
		emr : _EMR;
		rclBounds : RECTL;
		iGraphicsMode : DWORD;
		exScale : FLOAT;
		eyScale : FLOAT;
		emrtext : _EMRTEXT;
	end;

	EMRPOLYTEXTOUT = packed record
		emr : _EMR;
		rclBounds : RECTL;
		iGraphicsMode : DWORD;
		exScale : FLOAT;
		eyScale : FLOAT;
		cStrings : LONG;
	end;

	EMRBITBLT = packed record
		emr : _EMR;
		rclBounds : RECTL;
	    xDest : LONG;
    	yDest : LONG;
	    cxDest : LONG;
    	cyDest : LONG;
	    dwRop : DWORD;
    	xSrc : LONG;
	    ySrc : LONG;
    	xformSrc : XFORM;
	    crBkColorSrc : COLORREF;
    	iUsageSrc : DWORD;
	    offBmiSrc : DWORD;
    	cbBmiSrc : DWORD;
	    offBitsSrc : DWORD;
    	cbBitsSrc : DWORD;
	end;

	EMRSTRETCHBLT = packed record
		emr : _EMR;
		rclBounds : RECTL;
	    xDest : LONG;
    	yDest : LONG;
	    cxDest : LONG;
    	cyDest : LONG;
	    dwRop : DWORD;
    	xSrc : LONG;
	    ySrc : LONG;
    	xformSrc : XFORM;
	    crBkColorSrc : COLORREF;
    	iUsageSrc : DWORD;
	    offBmiSrc : DWORD;
    	cbBmiSrc : DWORD;
	    offBitsSrc : DWORD;
    	cbBitsSrc : DWORD;
	    cxSrc : LONG;
    	cySrc : LONG;
	end;

	EMRMASKBLT = packed record
		emr : _EMR;
		rclBounds : RECTL;
	    xDest : LONG;
    	yDest : LONG;
	    cxDest : LONG;
    	cyDest : LONG;
	    dwRop : DWORD;
    	xSrc : LONG;
	    ySrc : LONG;
    	xformSrc : XFORM;
	    crBkColorSrc : COLORREF;
    	iUsageSrc : DWORD;
	    offBmiSrc : DWORD;
    	cbBmiSrc : DWORD;
	    offBitsSrc : DWORD;
    	cbBitsSrc : DWORD;
	    xMask : LONG;
    	yMask : LONG;
	    iUsageMask : DWORD;
    	offBmiMask : DWORD;
	    cbBmiMask : DWORD;
    	offBitsMask : DWORD;
	    cbBitsMask : DWORD;
	end;

	EMRPLGBLT = packed record
		emr : _EMR;
		rclBounds : RECTL;
		aptlDest : array[0..2] of POINTL;
    	xSrc : LONG;
	    ySrc : LONG;
    	cxSrc : LONG;
	    cySrc : LONG;
    	xformSrc : XFORM;
	    crBkColorSrc : COLORREF;
    	iUsageSrc : DWORD;
	    offBmiSrc : DWORD;
    	cbBmiSrc : DWORD;
	    offBitsSrc : DWORD;
    	cbBitsSrc : DWORD;
	    xMask : LONG;
    	yMask : LONG;
	    iUsageMask : DWORD;
    	offBmiMask : DWORD;
	    cbBmiMask : DWORD;
    	offBitsMask : DWORD;
	    cbBitsMask : DWORD;
	end;

	EMRSETDIBITSTODEVICE = packed record
		emr : _EMR;
		rclBounds : RECTL;
		xDest : LONG;
		yDest : LONG;
    	xSrc : LONG;
	    ySrc : LONG;
    	cxSrc : LONG;
	    cySrc : LONG;
	    offBmiSrc : DWORD;
    	cbBmiSrc : DWORD;
	    offBitsSrc : DWORD;
    	cbBitsSrc : DWORD;
    	iUsageSrc : DWORD;
    	iStartScan : DWORD;
    	cScans : DWORD;
	end;

	EMRSTRETCHDIBITS = packed record
		emr : _EMR;
		rclBounds : RECTL;
		xDest : LONG;
		yDest : LONG;
    	xSrc : LONG;
	    ySrc : LONG;
    	cxSrc : LONG;
	    cySrc : LONG;
	    offBmiSrc : DWORD;
    	cbBmiSrc : DWORD;
	    offBitsSrc : DWORD;
    	cbBitsSrc : DWORD;
    	iUsageSrc : DWORD;
    	dwRop : DWORD;
	    cxDest : LONG;
    	cyDest : LONG;
	end;

	EMREXTCREATEFONTINDIRECTW = packed record
	    emr : _EMR;
    	ihFont : DWORD;
	    elfw : EXTLOGFONTW;
	end;

	EMRCREATEPALETTE = packed record
	    emr : _EMR;
	    ihpal : DWORD;
	    lgpl : LOGPALETTE;
	end;

	EMRCREATECOLORSPACE = packed record
	    emr : _EMR;
	    ihcs : DWORD;
	    lcs : LOGCOLORSPACEW;
	end;

	EMRCREATEPEN = packed record
	    emr : _EMR;
	    ihPen : DWORD;
	    lopn : LOGPEN;
	end;

	EMREXTCREATEPEN = packed record
	    emr : _EMR;
	    ihPen : DWORD;
	    offBmi : DWORD;
    	cbBmi : DWORD;
	    offBits : DWORD;
    	cbBits : DWORD;
	    elp : EXTLOGPEN;
	end;

	EMRCREATEBRUSHINDIRECT = packed record
	    emr : _EMR;
	    ihBrush : DWORD;
	    lb : LOGBRUSH;
	end;

	EMRCREATEMONOBRUSH = packed record
	    emr : _EMR;
	    ihBrush : DWORD;
	    iUsage : DWORD;
    	offBmi : DWORD;
    	cbBmi : DWORD;
	    offBits : DWORD;
	    cbBits : DWORD;
	end;

	EMRCREATEDIBPATTERNBRUSHPT = packed record
	    emr : _EMR;
	    ihBrush : DWORD;
	    iUsage : DWORD;
    	offBmi : DWORD;
    	cbBmi : DWORD;
	    offBits : DWORD;
	    cbBits : DWORD;
	end;

	EMRFORMAT = packed record
	    dSignature : DWORD;
    	nVersion : DWORD;
	    cbData : DWORD;
    	offData : DWORD;
	end;

	EMRGLSRECORD = packed record
	    emr : _EMR;
	    cbData : DWORD;
	end;

	EMRGLSBOUNDEDRECORD = packed record
	    emr : _EMR;
		rclBounds : RECTL;
	    cbData : DWORD;
	end;

	EMRPIXELFORMAT = packed record
	    emr : _EMR;
	    pfd : PIXELFORMATDESCRIPTOR;
	end;

const
    GDICOMMENT_IDENTIFIER = $43494447;
    GDICOMMENT_WINDOWS_METAFILE = $80000001;
    GDICOMMENT_BEGINGROUP = $00000002;
    GDICOMMENT_ENDGROUP = $00000003;
    GDICOMMENT_MULTIFORMATS = $40000004;
    EPS_SIGNATURE = $46535045;

	function wglCopyContext(hglrcSrc, hglrcDst : HGLRC; mask : UINT) : BOOL;
		external dll='opengl32.dll';
	function wglCreateContext(hDC : _HDC) : HGLRC;
		external dll='opengl32.dll';
	function wglCreateLayerContext(hDC : _HDC; iLayerPlane : integer) : HGLRC;
		external dll='opengl32.dll';
	function wglDeleteContext(hglrc : _HGLRC) : BOOL;
		external dll='opengl32.dll';
	function wglGetCurrentContext : HGLRC;
		external dll='opengl32.dll';
	function wglGetCurrentDC : HDC;
		external dll='opengl32.dll';
	function wglGetProcAddress(lpszProc : address) : PROC;
		external dll='opengl32.dll';
	function wglMakeCurrent(hDC : _HDC; hglrc : _HGLRC) : BOOL;
		external dll='opengl32.dll';
	function wglShareLists(hglrc1, hglrc2 : HGLRC) : BOOL;
		external dll='opengl32.dll';
	function wglUseFontBitmaps(hDC : _HDC; first, count, listBase : DWORD) : BOOL;
		external dll='opengl32.dll' name='wglUseFontBitmapsA' stdcall;
	function SwapBuffers(hDC : _HDC) : BOOL;
		external dll='opengl32.dll';

type
	POINTFLOAT = packed record
		x : FLOAT;
		y : FLOAT;
	end;

	GLYPHMETRICSFLOAT = packed record
	    gmfBlackBoxX : FLOAT;
    	gmfBlackBoxY : FLOAT;
	    gmfptGlyphOrigin : POINTFLOAT;
    	gmfCellIncX : FLOAT;
	    gmfCellIncY : FLOAT;
	end;

const
    WGL_FONT_LINES = 0;
    WGL_FONT_POLYGONS = 1;

	function wglUseFontOutlines(hDC : _HDC; first, count, listBase : DWORD;
								deviation, extrusion : FLOAT; format : integer;
								lpgmf : address) : BOOL;
		external dll='opengl32.dll' name='wglUseFontOutlinesA' stdcall;

type
	LAYERPLANEDESCRIPTOR = packed record
	    nSize : shortword;
    	nVersion : shortword;
	    dwFlags : DWORD;
    	iPixelType : byte;
	    cColorBits : byte;
    	cRedBits : byte;
	    cRedShift : byte;
    	cGreenBits : byte;
	    cGreenShift : byte;
    	cBlueBits : byte;
	    cBlueShift : byte;
    	cAlphaBits : byte;
	    cAlphaShift : byte;
    	cAccumBits : byte;
	    cAccumRedBits : byte;
    	cAccumGreenBits : byte;
	    cAccumBlueBits : byte;
    	cAccumAlphaBits : byte;
	    cDepthBits : byte;
    	cStencilBits : byte;
	    cAuxBuffers : byte;
    	iLayerPlane : byte;
	    bReserved : byte;
    	crTransparent : COLORREF;
	end;

const
    LPD_DOUBLEBUFFER = $00000001;
    LPD_STEREO = $00000002;
    LPD_SUPPORT_GDI = $00000010;
    LPD_SUPPORT_OPENGL = $00000020;
    LPD_SHARE_DEPTH = $00000040;
    LPD_SHARE_STENCIL = $00000080;
    LPD_SHARE_ACCUM = $00000100;
    LPD_SWAP_EXCHANGE = $00000200;
    LPD_SWAP_COPY = $00000400;
    LPD_TRANSPARENT = $00001000;
    LPD_TYPE_RGBA = 0;
    LPD_TYPE_COLORINDEX = 1;

    WGL_SWAP_MAIN_PLANE = $00000001;
    WGL_SWAP_OVERLAY1 = $00000002;
    WGL_SWAP_OVERLAY2 = $00000004;
    WGL_SWAP_OVERLAY3 = $00000008;
    WGL_SWAP_OVERLAY4 = $00000010;
    WGL_SWAP_OVERLAY5 = $00000020;
    WGL_SWAP_OVERLAY6 = $00000040;
    WGL_SWAP_OVERLAY7 = $00000080;
    WGL_SWAP_OVERLAY8 = $00000100;
    WGL_SWAP_OVERLAY9 = $00000200;
    WGL_SWAP_OVERLAY10 = $00000400;
    WGL_SWAP_OVERLAY11 = $00000800;
    WGL_SWAP_OVERLAY12 = $00001000;
    WGL_SWAP_OVERLAY13 = $00002000;
    WGL_SWAP_OVERLAY14 = $00004000;
    WGL_SWAP_OVERLAY15 = $00008000;
    WGL_SWAP_UNDERLAY1 = $00010000;
    WGL_SWAP_UNDERLAY2 = $00020000;
    WGL_SWAP_UNDERLAY3 = $00040000;
    WGL_SWAP_UNDERLAY4 = $00080000;
    WGL_SWAP_UNDERLAY5 = $00100000;
    WGL_SWAP_UNDERLAY6 = $00200000;
    WGL_SWAP_UNDERLAY7 = $00400000;
    WGL_SWAP_UNDERLAY8 = $00800000;
    WGL_SWAP_UNDERLAY9 = $01000000;
    WGL_SWAP_UNDERLAY10 = $02000000;
    WGL_SWAP_UNDERLAY11 = $04000000;
    WGL_SWAP_UNDERLAY12 = $08000000;
    WGL_SWAP_UNDERLAY13 = $10000000;
    WGL_SWAP_UNDERLAY14 = $20000000;
    WGL_SWAP_UNDERLAY15 = $40000000;

	function wglDescribeLayerPlane(hDC : _HDC; iPixelFormat, iLayerPlane : integer;
									nBytes : UINT; var plpd : LAYERPLANEDESCRIPTOR) : BOOL;
		external dll='opengl32.dll';
	function wglSetLayerPaletteEntries(hDC : _HDC; iLayerPlance, iStart, cEntries : integer;
										pcd : address) : integer;
		external dll='opengl32.dll';
	function wglGetLayerPaletteEntries(hDC : _HDC; iLayerPlance, iStart, cEntries : integer;
										pcd : address) : integer;
		external dll='opengl32.dll';
	function wglRealizeLayerPalette(hDC : _HDC; iLayerPlance : integer; bRealize : BOOL) : BOOL;
		external dll='opengl32.dll';
	function wglSwapLayerBuffers(hDC : _HDC; fuPlanes : UINT) : BOOL;
		external dll='opengl32.dll';

(*$W53. *)
(*$W44. *)
