Unit ACLProfile;
// Crude profiling functions. Accurate to single milliseconds
// (not just 1/18s). Writes profile to text file called 'profile' in
// current directory.
// Call ProfileEvent to log an event with time.
Interface

procedure StartProfile;

procedure ProfileEvent( Event: string );

procedure StopProfile;

Implementation

uses
{$ifdef os2}
  OS2Def, PMWin,
{$else}
  Windows,
{$endif}
  SysUtils;

var
  ProfileStartTime: ULONG;
  ProfileFile: TextFile;

const
  Profiling: boolean = false;

function GetSystemMSCount: ULONG;
begin
{$ifdef os2}
  Result:= WinGetCurrentTime( AppHandle );
{$else}
  Result:= GetTickCount;
{$endif}
end;

procedure StartProfile;
begin
  ProfileStartTime:= GetSystemMSCount;
  Assign( ProfileFile, 'profile' );
  Rewrite( ProfileFile );
  WriteLn( ProfileFile,
           'Profile start' );
  Close( ProfileFile );
  Profiling:= true;
end;

procedure ProfileEvent( Event: string );
begin
  if not Profiling then
    exit;
  Append( ProfileFile );
  WriteLn( ProfileFile,
           Event + ': '
           + IntToStr( GetSystemMSCount - ProfileStartTime ) );
  Close( ProfileFile );
end;

procedure StopProfile;
begin
  if not Profiling then
    exit;
  Append( ProfileFile );
  WriteLn( ProfileFile,
           'Profile stop: '
           + IntToStr( GetSystemMSCount - ProfileStartTime ) );
  Close( ProfileFile );
  Profiling:= false;
end;

Initialization
End.
