IMPLEMENTATION MODULE Address;

INLINE
  %#include <assert.h>
  %
  %obj_ptr y_get_address_ptr YPARAMS2(obj_ptr, p)
  %{
  %  assertp(p);
  %  return ((YC_AddressAddress *)p)->Y_ThePtr;
  %}
  %
  %y_set_address_ptr YPARAMS4(obj_ptr, p,
  %                          obj_ptr, q)
  %{
  %  assertp(p);
  %  ((YC_AddressAddress *)p)->Y_ThePtr = q;
  %  assert(y_get_address_ptr(p) == q);
  %}
  %
  END;
----------------------------------------------------------------
  CLASS Address;
    VAR
      ThePtr: INTEGER;

    PRAGMA
      VarType(ThePtr, "obj_ptr");

    METHOD IsEqual(Other: Address): BOOLEAN;
      BEGIN
      ASSERT Other <> VOID;
      INLINE
        %{
        %  Y_RESULT = (y_get_address_ptr(Y_THIS) == y_get_address_ptr(Y_Other));
        %  Y_RESULT = (Y_RESULT ? TRUE : FALSE);
        %}
        END;
      END IsEqual;

    METHOD Assign(Other: Address);
      BEGIN
      ASSERT Other <> VOID;
      INLINE
        % y_set_address_ptr(Y_THIS, y_get_address_ptr(Y_Other));
        END;
      ASSERT IsEqual(Other);
      END Assign;

    METHOD IsNull: BOOLEAN;
      BEGIN
      INLINE
        %{
        %  Y_RESULT = (y_get_address_ptr(Y_THIS) == NULL);
        %  Y_RESULT = (Y_RESULT ? TRUE : FALSE);
        %}
        END;
      END IsNull;

    END Address;

END Address;












