IMPLEMENTATION MODULE AbsList;

IMPORT Comparable;

  CLASS AbstractList(Element);
    INHERITS RandomCollection (Element);
      

    METHOD ShouldSwap (One, Two: Element): BOOLEAN;
      VAR
        OneComp, TwoComp: Comparable;
      BEGIN
      WHAT One OF
        IN Comparable:
          OneComp := TAG;
          END;
        END;
      WHAT Two OF
        IN Comparable:
          TwoComp := TAG;
          END;
        END;
      RESULT := OneComp.IsGreater (TwoComp);
      END ShouldSwap;

    METHOD SetElement (Pos: INTEGER;
  		       El: Element);
      BEGIN
      IF Pos = Size THEN
        Append (El);
       ELSE
        Delete (Pos);
	Insert (Pos, El);
	END;
      END SetElement;

    METHOD Reverse;
      VAR
        TheSize: INTEGER;
	Temp: Element;
      BEGIN
      TheSize := Size;
      FOR i := 0 TO (TheSize / 2) - 1 DO
	Temp := Get(i);
	SetElement(i, Get(TheSize-i-1));
	SetElement(TheSize-i-1, Temp);
        END;
      END Reverse;

  END AbstractList;

END AbsList;
