#ifndef DBX_LIST_H
#define DBX_LIST_H 1

typedef struct dbx_elem
        {
          struct dbx_elem *next,*prev;
          VOID *info;
        } dbx_elem;

typedef struct dbx_list
        {
          dbx_elem *first,*last,*current;
          unsigned int nbr;
        } dbx_list;


void insert YARGS((dbx_list *pl,
                   dbx_elem *pe1,
                   dbx_elem *pe2,
                   VOID *info));
VOID *suppress YARGS((dbx_list *pl,
                      dbx_elem *pe));
dbx_list *new_list YARGS((void));
void dispose_list YARGS((dbx_list *pl));
dbx_elem *nth_elem YARGS((dbx_list *pl,unsigned n));
unsigned list_size YARGS((dbx_list *pl));
dbx_elem *first_elem YARGS((dbx_list *pl));
dbx_elem *last_elem YARGS((dbx_list *pl));
dbx_elem *current_elem YARGS((dbx_list *pl));
dbx_elem *next_elem YARGS((dbx_elem *pe));
dbx_elem *prev_elem YARGS((dbx_elem *pe));
VOID *elem_info YARGS((dbx_elem *pe));
void go_first YARGS((dbx_list *pl));
void go_last YARGS((dbx_list *pl));
void go_next YARGS((dbx_list *pl));
void go_prev YARGS((dbx_list *pl));
void go_nth YARGS((dbx_list *pl,unsigned n));

#endif


