#ifndef DBX_CALL_H
#define DBX_CALL_H 1

/* this module defines both the call structure and the call stack structure */
/* (which is unique in the system) */

typedef struct _dbx_call
        {
          unsigned line;
          int used_v_stack;
          int used_d_stack;
          dbx_method *method;
          VOID *context; /* the context structure contains the values of */
                         /* the formals and locals of the method including */
                         /* the eventual RESULT but excluding THIS */
          obj_ptr *this; /* by reference because though we don't modify it
	                    it is more uniform with the others locals */
        } dbx_call;

unsigned call_depth YARGS((void));
dbx_call *first_call YARGS((void));
dbx_call *last_call YARGS((void));
dbx_call *next_call YARGS((dbx_call * pc));
dbx_call *prev_call YARGS((dbx_call * pc));
dbx_method *call_method YARGS((dbx_call * pc));
char *call_name YARGS((dbx_call *pc));
dbx_class *call_class YARGS((dbx_call *pc));
dbx_module *call_module YARGS((dbx_call *pc));

unsigned call_line YARGS((dbx_call * pc));

void dump_calls YARGS((void));


dbx_call *find_next_call YARGS((dbx_call *pc,char *pattern));
dbx_call *find_prev_call YARGS((dbx_call *pc,char *pattern));
dbx_call *search_call YARGS((dbx_call *pc,dbx_method *pm));

void init_dbx_call YARGS((void));
void term_dbx_call YARGS((void));

#endif
