#include <assert.h>
#include <string.h>
#include <yafl_rnt.h>
#include <stdlib.h>

int yafl_line_nr = 0;
#define MAX_ENTRY 512

static entry_type *entry = 0;
static int        sp = -1;

/*********************************************************/
void enter_method YPARAMS6(char *, mod, char *, cl, char *, mth)
{                        
  if (sp == -1)
    {      
    entry = (entry_type *) malloc(sizeof(entry_type) * MAX_ENTRY);
    sp = 0;
    }
  if (sp >= MAX_ENTRY)
    {
      emit_stdout ("Trace stack overflow\n");
      dump_trace();
      exit (1);
    }
  if (sp > 0)
    entry[sp-1].line_nr = yafl_line_nr;
  entry[sp].mod = mod;
  entry[sp].cl = cl;
  entry[sp].mth = mth;
  entry[sp].line_nr = 0;
  entry[sp].free_dual_stack = (int*)v_stack - (int*)d_stack;
  sp ++;
}
/*********************************************************/
void exit_method YPARAMS0
{
  if (sp)
    sp --;
  if (sp)
    yafl_line_nr = entry[sp-1].line_nr;
}
/*********************************************************/
void dump_trace YPARAMS0
{
  int i;
  char a[200];
  
  if (sp>0)
    {
      emit_stdout("\n");
      for (i=sp-1; i >= 0; i--)
        {
          sprintf (a, "[%4d] %s.%s.%s: %d\n", entry[i].free_dual_stack,
                  entry[i].mod, entry[i].cl, entry[i].mth,
                  entry[i].line_nr);
          emit_stdout(a);                  
        }
    }
}
/*******************************************************************/
int trace_entries YPARAMS0
{
  return sp;
}
/*******************************************************************/
void set_trace_entries YPARAMS2(int, new_sp)
{
  sp = new_sp + 1;
  exit_method();
}
/*******************************************************************/
entry_type * get_trace_entry YPARAMS2(int, sp)
{
  return &entry[sp];
}

