#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_type.h"
#include "dbx_obar.h"

/* here we define various functions to manipulate objects and arrays */
/* these are too structures created by the compiler and we should not */
/* have to deal with implementations issues such as structure of the */
/* header etc directly */
/* we use these aliases functions instead */

dbx_type *array_type YPARAMS2(obj_ptr ,  pa)
{
  assertp(pa);
  return (HEADER(pa)->dual);
}

unsigned array_size YPARAMS2(obj_ptr ,  pa)
{
  assertp(pa);
  return (HEADER_ARRAY_SIZE(HEADER(pa)));
}

unsigned array_level YPARAMS2(obj_ptr ,  pa)
{
  assertp(pa);
  return (HEADER_ARRAY_LEVEL(HEADER(pa)));
}

int is_object YPARAMS2(obj_ptr ,  p)
{
  assertp(p);
  return (HEADER_ARRAY_LEVEL(HEADER(p)) == 0);
}

int is_array YPARAMS2(obj_ptr ,  p)
{
  return ! is_object(p);
}

dbx_type *dynamic_type YPARAMS2(obj_ptr ,  po)
{
  assertp(po);
  return (HEADER(po)->dual);
}
