#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_usr.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_modu.h"
#include "dbx_type.h"
#include "dbx_clas.h"
#include "dbx_meth.h"
#include "dbx_type.h"
#include "dbx_vari.h"
#include "dbx_fiel.h"
#include "dbx_call.h"
#include "dbx_loca.h"
#include "dbx_list.h"
#include "dbx_fram.h"
#include "dbx_ctxt.h"
#include "dbx_curr.h"

static dbx_module *cur_module = NULL;
static dbx_class *cur_class = NULL;
static dbx_method *cur_method = NULL;
static dbx_field *cur_field = NULL;
static dbx_local *cur_local = NULL;
static dbx_call *cur_call = NULL;
static dbx_context *cur_context = NULL;
static int cur_line = 0;
/*
static dbx_elem *cur_elemb = NULL;
static dbx_elem *cur_elemw = NULL;
*/

dbx_module *current_module YPARAMS0
{
  return cur_module;
}

dbx_class *current_class YPARAMS0
{
  return cur_class;
}

dbx_method *current_method YPARAMS0
{
  return cur_method;
}

dbx_field *current_field YPARAMS0
{
  return cur_field;
}

dbx_local *current_local YPARAMS0
{
  return cur_local;
}

dbx_call *current_call YPARAMS0
{
  if (cur_call == NULL)
    cur_call = last_call();
  return cur_call;
}

/*
dbx_elem *current_breakpoint YPARAMS0
{
  return cur_elemb;
}

dbx_elem *current_watch YPARAMS0
{
  return cur_elemw;
}
*/

unsigned current_line YPARAMS0
{
  return cur_line;
}

dbx_context *current_context YPARAMS0
{
  return cur_context;
}

void set_current_module YPARAMS2(dbx_module *,  pm)
{
  cur_module = pm;
  set_current_line(1);
  if (pm)
  {
    set_current_class(first_class(pm));
  }
  else
  {
    set_current_class(NULL);
  }
}

void set_current_class YPARAMS2(dbx_class *,  pc)
{
  cur_class = pc;
  if (pc)
  {
    set_current_method(first_method(pc));
    set_current_field(first_field(pc)); 
  }
  else
  {
    set_current_method(NULL);
    set_current_field(NULL);
  }
}

void set_current_method YPARAMS2(dbx_method *,  pm)
{
  cur_method = pm;
  if (pm)
  {
    set_current_local (first_local(pm));
  }
  else
  {
    set_current_local(NULL);
  }
}

void set_current_field YPARAMS2(dbx_field *, pf)
{
  cur_field = pf;
}

void set_current_local YPARAMS2(dbx_local *, pl)
{
  cur_local = pl;
}

void set_current_call YPARAMS2(dbx_call *,  pc)
{
  assertp(pc);
  cur_call = pc;
  set_current_module(call_module(pc));
  set_current_line(call_line(pc));
}

void set_current_line YPARAMS2(unsigned,  l)
{
  assert(l>0);
  cur_line = l;
}
 

/*
void set_current_breakpoint YPARAMS2(dbx_elem *,  pe)
{
  cur_elemb = pe;
}

void set_current_watch YPARAMS2(dbx_elem *,  pe)
{
  cur_elemw = pe;
}
*/

void init_dbx_curr YPARAMS0
{
  cur_context = new_context();
}

void term_dbx_curr YPARAMS0
{
}

