#include <stdio.h>
#include <stdlib.h>
#include <yafl_usr.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_comm.h"
#include <string.h>
#include "dbx_modu.h"
#include "dbx_type.h"
#include "dbx_vari.h"
#include "dbx_clas.h"
#include "dbx_meth.h"
#include "dbx_call.h"
#include "dbx_type.h"
#include "dbx_fiel.h"
#include "dbx_loca.h"
#include "dbx_list.h"
#include "dbx_fram.h"
#include "dbx_ctxt.h"
#include "dbx_curr.h"
#include "dbx_cmd.h" 
#include "dbx_file.h" 
#include "dbx_out.h"
#include "dbx_ctrl.h"

extern int dbx_status;

#define MAX_COUNT 80

void prompt YPARAMS0
{
  writestring("%");
}

void main_loop YPARAMS0
{
  char newline[200];
  static char oldline[200];
  int doreturn;                   
  dbx_call *pca;
  dbx_module *pmo;
  static int count;
  if (call_depth() > 0)
  {
    pca = last_call();
    pmo = call_module(pca);
    set_current_call(pca);
    change_call(current_context(),pca);
  }
  writestring("status ");
  writestring(ctrl_message(dbx_status));
  writeln();
  if (call_depth() > 0)
  {
    writeint(call_line(pca));
    if (file_name(pmo))
      writestring(get_source_line(file_name(pmo),call_line(pca)));
    else
      writestring("{not available}");
      writeln();
  }
  else
  {  
    writestring("empty debugger stack");
    writeln();
  }
  redraw();
  count = 0;
  if (!envi_get_no_input())
  {
    do
    {
      prompt();
      doreturn = !readstring(newline);
      if (!doreturn)
      {
        if (strlen(newline) > 0)
        {
          strcpy(oldline,newline);
          count = 0;
        }
        else
        {
          strcpy(newline,oldline);
          count++;
        }
        if (count == MAX_COUNT)
          doreturn = 1;
        else
          doreturn = exec_cmd(newline);
      }
    }
    while (!doreturn);
  }
}

