#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <yafl_usr.h>
#include <yafl_rnt.h>
#include "dbx_cfg.h"

/**********************************************/
#define STRING_SPACE 10000
static char string_sp[STRING_SPACE];
static unsigned string_pos = 0;
/**********************************************/
static void store_string YPARAMS2 (char*, a)
{ 
  char *p;
  
  assert(string_pos + strlen(a) + 10 < STRING_SPACE);
  p = string_sp + string_pos;
  strcpy (p, a);
  string_pos += strlen(a) + 1;
}
/**********************************************/
#define IS_BL(x) (((x) == '\n') || ((x) == ' ') || ((x) == '\t'))
/**********************************************/
static char * clean YPARAMS2(char *, a)
{
  char *p;
  
  while (IS_BL(*a))
    a++;
  if (*a)
    {
    p = a + strlen(a) - 1;
    while (IS_BL(*p))
      {
      *p = 0;
      p--;
      }
    }    
  return a;
}
/**********************************************/
static void store_line YPARAMS2 (char *, a)
{ 
  char *p;
              
  assert(a != NULL);
  assert(*a);
  p = strchr(a, '=');
  if (p)
    {
    *p = 0;
    p ++;
    store_string(clean(a));
    store_string(clean(p));
    }
}
/**********************************************/
int  dbx_read_cfg YPARAMS2(char *, fname)
{
  FILE * input;
  char line[512], *p, *q;
  
  input = fopen(fname, "r");
  if (!input)
    return FALSE;
  while (fgets(line, 510, input))
    {
      p = clean(line);
      if (*p)
        if (*p != ';')
          store_line(p);
    }
  fclose(input);
  return TRUE;
}
/**********************************************/
char * get_cfg_param YPARAMS2(char *, param_name)
{
  char *p, *last;
  last = string_sp + string_pos;
  p = string_sp;
  while (p < last)
    {
    if (strcmp(p, param_name) == 0)
      {
      p += strlen(p) + 1;
      return p;
      }
    p += strlen(p) + 1;
    p += strlen(p) + 1;
    }
  return NULL;
}


void init_dbx_cfg YPARAMS0
{
  static int initialized;
  if (!initialized)
  {
    dbx_read_cfg("yc.cfg"); 
    initialized = 1;
  }
}

void term_dbx_cfg YPARAMS0
{
}
