#include <yafl_usr.h>
#include <yafl_rnt.h>


typedef union {
               yint     the_int;
               ychar    the_char;
               obj_ptr  the_obj;
               double   the_double;
               } stack_elem;

typedef struct {
                stack_elem  *elems;
                int         *levels;
                int          max_size;
                int          size; 
                int          max_level;
                int          nb_level;
                } assert_stack;    
                
extern assert_stack  old_stack;
extern assert_stack  param_stack;

void assert_stack_push_int    YPARAMS4(assert_stack*, the_stack, yint,    Val);
void assert_stack_push_obj    YPARAMS4(assert_stack*, the_stack, obj_ptr, Val);
void assert_stack_push_char   YPARAMS4(assert_stack*, the_stack, ychar,  Val);
void assert_stack_push_double YPARAMS4(assert_stack*, the_stack, double,  Val);

obj_ptr assert_stack_pop_obj    YPARAMS2(assert_stack*, the_stack);
yint    assert_stack_pop_int    YPARAMS2(assert_stack*, the_stack);
ychar   assert_stack_pop_char   YPARAMS2(assert_stack*, the_stack);
double  assert_stack_pop_double YPARAMS2(assert_stack*, the_stack);

obj_ptr assert_stack_top_obj    YPARAMS2(assert_stack*, the_stack);
yint    assert_stack_top_int    YPARAMS2(assert_stack*, the_stack);
ychar   assert_stack_top_char   YPARAMS2(assert_stack*, the_stack);
double  assert_stack_top_double YPARAMS2(assert_stack*, the_stack);

obj_ptr assert_stack_get_obj    YPARAMS4(assert_stack*, the_stack, int, offset);
yint    assert_stack_get_int    YPARAMS4(assert_stack*, the_stack, int, offset);
ychar   assert_stack_get_char   YPARAMS4(assert_stack*, the_stack, int, offset);
double  assert_stack_get_double YPARAMS4(assert_stack*, the_stack, int, offset);

void check_pre_cond  YPARAMS6(obj_ptr,      Y_THIS, 
                              minimal_dual*, end_dual, 
                              char *,       meth_name);
void check_post_conditions YPARAMS6(obj_ptr,       Y_THIS, 
                                    minimal_dual*, end_dual, 
                                    char*,         meth_name);
void compute_old_expressions YPARAMS6(obj_ptr,       Y_THIS, 
                                      minimal_dual*, end_dual, 
                                      char*,         meth_name);

void assert_stack_push_level YPARAMS2(assert_stack*, the_stack);
void assert_stack_pop_level  YPARAMS2(assert_stack*, the_stack);




