IMPLEMENTATION MODULE YaflWorlds;

FROM YaflCfg IMPORT YaflCfg;
IMPORT String;

  CLASS World;
    INHERITS StringElement;
    VAR
      TheNumber: INTEGER;          
      ThePrefix: ARRAY OF CHAR;
    
    REDEFINE METHOD CREATE (Name,
                            Prefix: ARRAY OF CHAR);
      BEGIN
      BASE(Name);
      THIS.ThePrefix := Prefix;
      END CREATE;
      
    METHOD SetNumber (Nr: INTEGER);
      BEGIN
      TheNumber := Nr;
      END SetNumber;
      
    METHOD BuildSourceFName (Radix, Extension: ARRAY OF CHAR): ARRAY OF CHAR;
      BEGIN
      RESULT := YaflCfg.NameMapper.BuildSourceFileName (ThePrefix, 
                                                        Radix, 
                                                        Extension);
      END BuildSourceFName;
      
    METHOD BuildTargetFName (Radix, Extension: ARRAY OF CHAR): ARRAY OF CHAR;
      BEGIN
      RESULT := YaflCfg.NameMapper.BuildTargetFileName (ThePrefix, 
                                                        Radix, 
                                                        Extension,
                                                        YaflCfg.DirPrefix);
      END BuildTargetFName;
      
    METHOD BuildTempFName (Radix, Extension: ARRAY OF CHAR): ARRAY OF CHAR;
      BEGIN
      RESULT := YaflCfg.NameMapper.BuildTempFileName (ThePrefix, 
                                                        Radix, 
                                                        Extension,
                                                        YaflCfg.DirPrefix);
      END BuildTempFName;
      
    METHOD BuildProjectFName (Radix,
                              Extension: ARRAY OF CHAR): ARRAY OF CHAR;
      BEGIN
      RESULT := YaflCfg.NameMapper.BuildProjectFileName (ThePrefix, 
                                                         Radix, 
                                                         Extension);
      END BuildProjectFName;
                              
    METHOD BuildIndexFName (Radix,
                              Extension: ARRAY OF CHAR): ARRAY OF CHAR;
      BEGIN
      RESULT := YaflCfg.NameMapper.BuildIndexFileName (ThePrefix, 
                                                         Radix, 
                                                         Extension);
      END BuildIndexFName;
                              
    METHOD Number: INTEGER;
      BEGIN
      RESULT := TheNumber;
      END Number;  
      
    METHOD Dump (Output: OutputStream);
      BEGIN    
      Output.WriteInt (TheNumber, 0);
      Output.WriteLine (": " + ThePrefix);
      END Dump;                  
      
    METHOD Prefix: ARRAY OF CHAR;
      BEGIN
      RESULT := ThePrefix;
      END Prefix;
      
  END World;
--------------
  ONCE CLASS DefaultWorld;
    INHERITS World;
    
    REDEFINE METHOD CREATE;
      BEGIN
      BASE (Name := "<Default>", 
            Prefix := "");
      END CREATE;
      
    REDEFINE METHOD BuildSourceFName (Radix, 
                                      Extension: ARRAY OF CHAR): ARRAY OF CHAR;
      BEGIN
      RESULT := YaflCfg.NameMapper.BuildSourceFileName (VOID, 
                                                        Radix, 
                                                        Extension);
      END BuildSourceFName;
      
  END DefaultWorld;  
--------------
  ONCE CLASS WorldList;
  
    VAR
      TheList: StringList (World);
      
    METHOD Check;
      BEGIN     
      IF TheList = VOID THEN
        TheList.CREATE;
        END;
      END Check;
  
    REDEFINE METHOD CREATE;
      BEGIN
      Check;
      END CREATE;
      
    METHOD Append (El: World);
      BEGIN
      Check;
      El.SetNumber (TheList.Size);
      TheList.Append (El);
      END Append;
      
    METHOD Get(ElNr: INTEGER): World;
      BEGIN
      RESULT := TheList.Get(ElNr);
      END Get;
      
    METHOD Size: INTEGER;
      BEGIN
      RESULT := TheList.Size;
      END Size;
      
    METHOD Dump (Output: OutputStream);
      BEGIN 
      IF TheList <> VOID THEN   
        FOR i := 0 TO TheList.Size - 1 DO
          TheList.Get(i).Dump (Output);
          END;
        END;
      END Dump;
      
    METHOD Row: ARRAY OF World;
      BEGIN
      IF TheList <> VOID THEN
        RESULT := TheList.Row;
        END;
      END Row; 
      
    METHOD Find (Prefix: ARRAY OF CHAR): World;
      BEGIN    
      Check;       
      FOR i := 0 TO Size-1 WHILE RESULT = VOID DO
        IF String.Equals (TheList.Get(i).Prefix, Prefix) THEN
          RESULT := Get(i);
          END;
        END;
      END Find;
      
  END WorldList;

END YaflWorlds;
