IMPLEMENTATION MODULE CGDeclarations;

  CLASS CDummyDeclCodeGenerator;
    INHERITS DummyDeclCodeGenerator(CGcContext);
    
  END CDummyDeclCodeGenerator;
  
------------------------------------------------------------

  CLASS CImportClauseCodeGenerator;
    INHERITS ImportClauseCodeGenerator(CGcContext);
    
  END CImportClauseCodeGenerator;
    
------------------------------------------------------------
  
  CLASS CConstDeclCodeGenerator;
    INHERITS ConstDeclCodeGenerator(CGcContext);
    
    REDEFINE METHOD GenerateCode;
      BEGIN
      IF Obj.InlineString <> VOID THEN
        Ctx.Output.WriteString (Obj.InlineString);
       ELSE 
        Obj.Expr.Gc.GenerateCode;
        END;
      END GenerateCode;
      
  END CConstDeclCodeGenerator;
  
------------------------------------------------------------
  
  CLASS CSingleDataItemCodeGenerator;
    INHERITS SingleDataItemCodeGenerator(CGcContext);
        
    REDEFINE METHOD GenerateCode;
      BEGIN
      IF Obj.Once THEN
        Ctx.Output.UniqueItem (Obj.OnceNumber);
       ELSE
        Ctx.Output.Yu (Obj.Id.Data);
        END;
      END GenerateCode;

    METHOD GenerateType;
      BEGIN
      IF Obj.GetCName <> VOID THEN
        Ctx.Output.WriteString (Obj.GetCName);
        Ctx.Output.WriteChar (" ");
       ELSE
        Obj.GetType.Gc.GenerateCode;
        END;
      END GenerateType;
      
    METHOD GenerateDeclaration (Zap: BOOLEAN);
      BEGIN 
      IF Obj.Once THEN
        ASSERT Zap;
        Ctx.Output.Comment (Obj.Id.Data);
        Ctx.Output.Static;
        END;
      GenerateType;
      GenerateCode;
      IF Zap THEN
        Ctx.Output.Becomes;
        Ctx.Output.LeftParent;
        GenerateType;
        Ctx.Output.RightParent;
        Ctx.Output.WriteChar ('0');
        END;
      Ctx.Output.SemiColon;
      Ctx.Output.WriteLn;
      END GenerateDeclaration;

--------------------------------------------------------------------
-- we must give the module and the class as parameters, because for
-- some reason the object itself does not know them;
--------------------------------------------------------------------
    METHOD GenerateFieldInitDummy( Module: ImplementationModule;
                                  Class: ClassImplementation);
      BEGIN
      END GenerateFieldInitDummy;

  END CSingleDataItemCodeGenerator;
  
END CGDeclarations;


