(* Copyright (C) 1996, Klaus Preschern [klausp@ping.at]                      *)
(* All rights reserved.                                                      *)
(*                                                                           *)

(*
 * (c) Copyright 1993, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 * Permission to use, copy, modify, and distribute this software for
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation, and that
 * the name of Silicon Graphics, Inc. not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission.
 *
 * THE MATERIAL EMBODIED ON THIS SOFTWARE IS PROVIDED TO YOU "AS-IS"
 * AND WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL SILICON
 * GRAPHICS, INC.  BE LIABLE TO YOU OR ANYONE ELSE FOR ANY DIRECT,
 * SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
 * KIND, OR ANY DAMAGES WHATSOEVER, INCLUDING WITHOUT LIMITATION,
 * LOSS OF PROFIT, LOSS OF USE, SAVINGS OR REVENUE, OR THE CLAIMS OF
 * THIRD PARTIES, WHETHER OR NOT SILICON GRAPHICS, INC.  HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS, HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE
 * POSSESSION, USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * US Government Users Restricted Rights
 * Use, duplication, or disclosure by the Government is subject to
 * restrictions set forth in FAR 52.227.19(c)(2) or subparagraph
 * (c)(1)(ii) of the Rights in Technical Data and Computer Software
 * clause at DFARS 252.227-7013 and/or in similar or successor
 * clauses in the FAR or the DOD or NASA FAR Supplement.
 * Unpublished-- rights reserved under the copyright laws of the
 * United States.  Contractor/manufacturer is Silicon Graphics,
 * Inc., 2011 N.  Shoreline Blvd., Mountain View, CA 94039-7311.
 *
 * OpenGL(TM) is a trademark of Silicon Graphics, Inc.
 *)

INTERFACE GLaux;

IMPORT GL, Ctypes;

(*
** ToolKit Window Types
** In the future, AUX_RGBA may be a combination of both RGB and ALPHA
*)
CONST
  AUX_RGB           = 0;
  AUX_RGBA          = AUX_RGB;
  AUX_INDEX         = 1;
  AUX_SINGLE        = 0;
  AUX_DOUBLE        = 2;
  AUX_DIRECT        = 0;
  AUX_INDIRECT      = 4;

  AUX_ACCUM         = 8;
  AUX_ALPHA         = 16;
  AUX_DEPTH         = 32;     (* 32-bit depth buffer *)
  AUX_STENCIL       = 64;
  AUX_AUX           = 128;
  AUX_DEPTH16       = 256;    (* 16-bit depth buffer *)
  AUX_FIXED_332_PAL = 512;

(*
(*
** Window Masks
*)
#define AUX_WIND_IS_RGB(x)      (((x) & AUX_INDEX) == 0)
#define AUX_WIND_IS_INDEX(x)    (((x) & AUX_INDEX) != 0)
#define AUX_WIND_IS_SINGLE(x)   (((x) & AUX_DOUBLE) == 0)
#define AUX_WIND_IS_DOUBLE(x)   (((x) & AUX_DOUBLE) != 0)
#define AUX_WIND_IS_INDIRECT(x) (((x) & AUX_INDIRECT) != 0)
#define AUX_WIND_IS_DIRECT(x)   (((x) & AUX_INDIRECT) == 0)
#define AUX_WIND_HAS_ACCUM(x)   (((x) & AUX_ACCUM) != 0)
#define AUX_WIND_HAS_ALPHA(x)   (((x) & AUX_ALPHA) != 0)
#define AUX_WIND_HAS_DEPTH(x)   (((x) & (AUX_DEPTH | AUX_DEPTH16)) != 0)
#define AUX_WIND_HAS_STENCIL(x) (((x) & AUX_STENCIL) != 0)
#define AUX_WIND_USES_FIXED_332_PAL(x)  (((x) & AUX_FIXED_332_PAL) != 0)
*)
(*
** ToolKit Event Structure
*)

TYPE
  AUX_EVENTREC = RECORD
      event: GL.GLint;
      data:  ARRAY [0..3] OF GL.GLint;
    END (* record *);

(*
** ToolKit Event Types
*)
CONST
  AUX_EXPOSE    = 1;
  AUX_CONFIG    = 2;
  AUX_DRAW      = 4;
  AUX_KEYEVENT  = 8;
  AUX_MOUSEDOWN = 16;
  AUX_MOUSEUP   = 32;
  AUX_MOUSELOC  = 64;

(*
** Toolkit Event Data Indices
*)
CONST
  AUX_WINDOWX           = 0;
  AUX_WINDOWY           = 1;
  AUX_MOUSEX            = 0;
  AUX_MOUSEY            = 1;
  AUX_MOUSESTATUS       = 3;
  AUX_KEY               = 0;
  AUX_KEYSTATUS         = 1;

(*
** ToolKit Event Status Messages
*)
CONST
  AUX_LEFTBUTTON        = 1;
  AUX_RIGHTBUTTON       = 2;
  AUX_MIDDLEBUTTON      = 4;
  AUX_SHIFT             = 1;
  AUX_CONTROL           = 2;

(*
** ToolKit Key Codes
*)
CONST
  AUX_RETURN            = 16_0D;
  AUX_ESCAPE            = 16_1B;
  AUX_SPACE             = 16_20;
  AUX_LEFT              = 16_25;
  AUX_UP                = 16_26;
  AUX_RIGHT             = 16_27;
  AUX_DOWN              = 16_28;
  AUX_A                 = 'A';
  AUX_B                 = 'B';
  AUX_C                 = 'C';
  AUX_D                 = 'D';
  AUX_E                 = 'E';
  AUX_F                 = 'F';
  AUX_G                 = 'G';
  AUX_H                 = 'H';
  AUX_I                 = 'I';
  AUX_J                 = 'J';
  AUX_K                 = 'K';
  AUX_L                 = 'L';
  AUX_M                 = 'M';
  AUX_N                 = 'N';
  AUX_O                 = 'O';
  AUX_P                 = 'P';
  AUX_Q                 = 'Q';
  AUX_R                 = 'R';
  AUX_S                 = 'S';
  AUX_T                 = 'T';
  AUX_U                 = 'U';
  AUX_V                 = 'V';
  AUX_W                 = 'W';
  AUX_X                 = 'X';
  AUX_Y                 = 'Y';
  AUX_Z                 = 'Z';
  AUX_a                 = 'a';
  AUX_b                 = 'b';
  AUX_c                 = 'c';
  AUX_d                 = 'd';
  AUX_e                 = 'e';
  AUX_f                 = 'f';
  AUX_g                 = 'g';
  AUX_h                 = 'h';
  AUX_i                 = 'i';
  AUX_j                 = 'j';
  AUX_k                 = 'k';
  AUX_l                 = 'l';
  AUX_m                 = 'm';
  AUX_n                 = 'n';
  AUX_o                 = 'o';
  AUX_p                 = 'p';
  AUX_q                 = 'q';
  AUX_r                 = 'r';
  AUX_s                 = 's';
  AUX_t                 = 't';
  AUX_u                 = 'u';
  AUX_v                 = 'v';
  AUX_w                 = 'w';
  AUX_x                 = 'x';
  AUX_y                 = 'y';
  AUX_z                 = 'z';
  AUX_0                 = '0';
  AUX_1                 = '1';
  AUX_2                 = '2';
  AUX_3                 = '3';
  AUX_4                 = '4';
  AUX_5                 = '5';
  AUX_6                 = '6';
  AUX_7                 = '7';
  AUX_8                 = '8';
  AUX_9                 = '9';
(*
** ToolKit Gets and Sets
*)
CONST
  AUX_FD                = 1; (* return fd (long) *)
  AUX_COLORMAP          = 3; (* pass buf of r, g and b (unsigned char) *)
  AUX_GREYSCALEMAP      = 4;
  AUX_FOGMAP            = 5; (* pass fog and color bits (long) *)
  AUX_ONECOLOR          = 6; (* pass index, r, g, and b (long) *)

(*
** Color Macros
*)
CONST
  AUX_BLACK             = 0;
  AUX_RED               = 13;
  AUX_GREEN             = 14;
  AUX_YELLOW            = 15;
  AUX_BLUE              = 16;
  AUX_MAGENTA           = 17;
  AUX_CYAN              = 18;
  AUX_WHITE             = 19;

(*
extern float auxRGBMap[20][3];

#define AUX_SETCOLOR(x, y) (AUX_WIND_IS_RGB((x)) ? \
                           glColor3fv(auxRGBMap[(y)]) : glIndexf((y)))
*)
(*
** RGB Image Structure
*)
TYPE AUX_RGBImageRec = RECORD
       sizeX, sizeY: GL.GLint;
       data: Ctypes.unsigned_char_star;
     END (* record *);

(*
** Prototypes
*)
(*****************************************************************************)
(* Procedures                                                                *)
(*****************************************************************************)

<*EXTERNAL*>
PROCEDURE auxInitDisplayMode(mode: GL.GLenum);

<*EXTERNAL*>
PROCEDURE auxInitPosition (a: Ctypes.int; b: Ctypes.int;
                           c: Ctypes.int; d: Ctypes.int);

TYPE LPCTSTR = Ctypes.char_star;
<*EXTERNAL*>
PROCEDURE auxInitWindow(a: LPCTSTR): GL.GLenum;

<*EXTERNAL*>
PROCEDURE auxCloseWindow();
<*EXTERNAL*>
PROCEDURE auxQuit();
<*EXTERNAL*>
PROCEDURE auxSwapBuffers();

TYPE  AUXMAINPROC = PROCEDURE ();
<*EXTERNAL*>
PROCEDURE auxMainLoop(p: AUXMAINPROC);

TYPE  AUXEXPOSEPROC = PROCEDURE  (a: Ctypes.int; b: Ctypes.int);
<*EXTERNAL*>
PROCEDURE auxExposeFunc(p: AUXEXPOSEPROC);

TYPE AUXRESHAPEPROC = PROCEDURE (a: GL.GLsizei; b: GL.GLsizei);
<*EXTERNAL*>
PROCEDURE auxReshapeFunc(p: AUXRESHAPEPROC);

TYPE AUXIDLEPROC = PROCEDURE ();
<*EXTERNAL*>
PROCEDURE auxIdleFunc(p: AUXIDLEPROC);

TYPE AUXKEYPROC = PROCEDURE ();
<*EXTERNAL*>
PROCEDURE auxKeyFunc(k: Ctypes.int; p: AUXKEYPROC);

TYPE AUXMOUSEPROC = PROCEDURE (ep: UNTRACED REF AUX_EVENTREC);
<*EXTERNAL*>
PROCEDURE auxMouseFunc(a: Ctypes.int; b: Ctypes.int; p: AUXMOUSEPROC);

<*EXTERNAL*>
PROCEDURE auxGetColorMapSize(): Ctypes.int;
<*EXTERNAL*>
PROCEDURE auxGetMouseLoc(a: Ctypes.int_star; b: Ctypes.int_star);
<*EXTERNAL*>
PROCEDURE auxSetOneColor(a: Ctypes.int; b: Ctypes.float;
                         c: Ctypes.float; d: Ctypes.float);
<*EXTERNAL*>
PROCEDURE auxSetFogRamp(a: Ctypes.int; b: Ctypes.int);
<*EXTERNAL*>
PROCEDURE auxSetGreyRamp();
<*EXTERNAL*>
PROCEDURE auxSetRGBMap(a: Ctypes.int; b: Ctypes.float_star);

<*EXTERNAL*>
PROCEDURE auxRGBImageLoad(a: LPCTSTR): UNTRACED REF AUX_RGBImageRec;

<*EXTERNAL*>
PROCEDURE auxDIBImageLoad(a: LPCTSTR): UNTRACED REF AUX_RGBImageRec;

<*EXTERNAL*>
PROCEDURE auxCreateFont();
<*EXTERNAL*>
PROCEDURE auxDrawStr(a: LPCTSTR);

<*EXTERNAL*>
PROCEDURE auxWireSphere(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidSphere(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireCube(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidCube(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireBox(a: GL.GLdouble; b: GL.GLdouble; c: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidBox(a: GL.GLdouble; b: GL.GLdouble; c: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireTorus(a: GL.GLdouble; b: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidTorus(a: GL.GLdouble; b: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireCylinder(a: GL.GLdouble; b: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidCylinder(a: GL.GLdouble; b: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireIcosahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidIcosahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireOctahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidOctahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireTetrahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidTetrahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireDodecahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidDodecahedron(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireCone(a: GL.GLdouble; b: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidCone(a: GL.GLdouble; b: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxWireTeapot(a: GL.GLdouble);
<*EXTERNAL*>
PROCEDURE auxSolidTeapot(a: GL.GLdouble);

(*
** Window specific functions
** hwnd, hdc, and hglrc valid after auxInitWindow()
*)
(*
HWND  APIENTRY auxGetHWND(void);
HDC   APIENTRY auxGetHDC(void);
HGLRC APIENTRY auxGetHGLRC(void);
*)
(*
** Viewperf support functions and constants
*)
(* Display Mode Selection Criteria *)
CONST
    AUX_USE_ID = 1;
    AUX_EXACT_MATCH = 2;
    AUX_MINIMUM_CRITERIA = 3;

<*EXTERNAL*>
PROCEDURE auxInitDisplayModePolicy(a: GL.GLenum);
<*EXTERNAL*>
PROCEDURE auxInitDisplayModeID(a: GL.GLint): GL.GLenum;
<*EXTERNAL*>
PROCEDURE auxGetDisplayModePolicy(): GL.GLenum;
<*EXTERNAL*>
PROCEDURE auxGetDisplayModeID(): GL.GLint;
<*EXTERNAL*>
PROCEDURE auxGetDisplayMode(): GL.GLenum;

END GLaux.

