UNSAFE MODULE Light EXPORTS Main;

IMPORT GLaux, Word, M3toC, GL;

PROCEDURE Init () =
  VAR
    mat_specular:= ARRAY [0..3] OF GL.GLfloat { 1.0, 1.0, 1.0, 1.0 };
    mat_shininess:= ARRAY [0..0] OF GL.GLfloat { 50.0 };
    mat_diffuse:= ARRAY [0..3] OF GL.GLfloat { 0.9, 0.1, 0.1, 0.0 };
    light_position:= ARRAY [0..3] OF GL.GLfloat { 1.0, 1.0, 1.0, 0.0 };
  BEGIN
    GL.glMaterialfv (GL.GL_FRONT, GL.GL_DIFFUSE, ADR (mat_diffuse));
    GL.glMaterialfv(GL.GL_FRONT, GL.GL_SPECULAR, ADR (mat_specular));
    GL.glMaterialfv(GL.GL_FRONT, GL.GL_SHININESS, ADR (mat_shininess));
    GL.glLightfv(GL.GL_LIGHT0, GL.GL_POSITION, ADR (light_position));

    GL.glEnable(GL.GL_LIGHTING);
    GL.glEnable(GL.GL_LIGHT0);
    GL.glDepthFunc(GL.GL_LESS);
    GL.glEnable(GL.GL_DEPTH_TEST);
    GL.glClearColor (0.1, 0.3, 0.6, 0.0);
  END Init;

PROCEDURE Display () =
  BEGIN
    GL.glClear(Word.Or (GL.GL_COLOR_BUFFER_BIT, GL.GL_DEPTH_BUFFER_BIT));
    GLaux.auxSolidSphere(FLOAT (1.0, GL.GLdouble));
    GL.glFlush();
  END Display;

PROCEDURE Reshape (w: GL.GLsizei; h: GL.GLsizei) =
  BEGIN
    IF (h = 0) THEN h := 1 END (* if *);
    GL.glViewport(0, 0, w, h);
    GL.glMatrixMode(GL.GL_PROJECTION);
    GL.glLoadIdentity();
    IF (w <= h) THEN
      GL.glOrtho (FLOAT (-1.5, GL.GLdouble),
                  FLOAT ( 1.5, GL.GLdouble),
                  FLOAT (-1.5, GL.GLdouble) * FLOAT (h, GL.GLdouble) /
                  FLOAT (w, GL.GLdouble),
                  FLOAT ( 1.5, GL.GLdouble) * FLOAT (h, GL.GLdouble) /
                  FLOAT (w, GL.GLdouble),
                  FLOAT (-10.0, GL.GLdouble),
                  FLOAT ( 10.0, GL.GLdouble));
    ELSE
      GL.glOrtho (FLOAT (-1.5, GL.GLdouble) * FLOAT (w, GL.GLdouble) /
                  FLOAT (h, GL.GLdouble),
                  FLOAT ( 1.5, GL.GLdouble) * FLOAT (w, GL.GLdouble) /
                  FLOAT (h, GL.GLdouble),
                  FLOAT (-1.5, GL.GLdouble),
                  FLOAT ( 1.5, GL.GLdouble),
                  FLOAT (-10.0, GL.GLdouble),
                  FLOAT ( 10.0, GL.GLdouble));
    END (* if *);
    GL.glMatrixMode(GL.GL_MODELVIEW);
    GL.glLoadIdentity();
  END Reshape;

BEGIN
  GLaux.auxInitDisplayMode (
      Word.Or (Word.Or (GLaux.AUX_SINGLE, GLaux.AUX_RGB), GLaux.AUX_DEPTH16));
  GLaux.auxInitPosition (0, 0, 500, 500);
  EVAL GLaux.auxInitWindow (M3toC.TtoS ("Lighting"));
  Init();
  GLaux.auxReshapeFunc (Reshape);
  GLaux.auxMainLoop(Display);
END Light.
