/* OS2oberon V4.0-0.6e installation Rexx script for OS/2 2.x or 3.x */
/* Copyright 1995-1996 D. Steiner */

/* functions loaded from RexxUtil */
/*
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'
call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysDestroyObject', 'RexxUtil', 'SysDestroyObject'
call RxFuncAdd 'SysGetMessage', 'RexxUtil', 'SysGetMessage'
call RxFuncAdd 'SysFileSearch', 'RexxUtil', 'SysFileSearch'
*/

/* add all RexxUtil-Funktions */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* enable debugging */
/*trace all*/

/* display introducing message */
"@echo off"
say
say "OS2oberon V4.0-0.6e setup for OS/2 2.x or 3.0   (c) 1995-1996 by Daniel Steiner"
say "-------------------------------------------------------------------------------"
say

/* get default source path, usually A:\ */
parse upper source origin origin origin
origin = filespec( "drive", origin ) || filespec( "path", origin )
origin = delstr( origin, length( origin ) )

call CheckDrive (origin)

if (CheckDrive(origin) = 0) then do
  origin = 'A:\'
end
else if (substr( origin, 3, 1 ) = '') then do
  origin = origin || '\'
end
else if (substr( origin, 3, 1 ) \= '\') then do
  origin = 'A:\'
end


/* let the user confirm or modify source path */
do forever
  default = origin
  do forever
    say 'Do you want to install from source "' || origin || '" ? (Y=ok N=other)'
    pull answer
    if answer \= "Y" then do
      if answer \= "N" then do
        iterate
      end
    end
    leave
  end
  if answer \= 'Y' then do
    do forever
      origin = default
      say 'Type in a complete source path "drive-letter:\path-name"'
      pull drivepath
/* die folgenden 2 Zeilen durch eine Funktion CheckDrive ersetzen */
      if datatype( substr( drivepath,1,1 ) ) = 'CHAR' then do
        if substr( drivepath, 2, 1 ) = ':' then do
          if substr( drivepath, 3, 1 ) = '\' then do
            if length( drivepath ) > 3 then do
              if right( drivepath, 1 ) \= '\' then do
                origin = drivepath
                leave
              end
            end
          end
          if substr( drivepath, 3, 1 ) = '' then do
            origin = drivepath
            leave
          end
        end
      end
      say "Source drive and/or path is invalid or incomplete"
    end
  end
  rc = SysFileTree( origin, origin_filetree, 'D' )
  if rc = 0 then do
    if origin_filetree.0 > 0 then do
      leave
    end
    if substr( origin, 2, 2 ) = ':\' then do
      if substr( origin, 4, 1 ) = '' then do
        /* installing from a main directory */
        leave
       end
    end
  end
  say 'Cannot access source "' || origin || '"'
end

origindrive = substr( origin, 1, 2 )
say
say 'OS2oberon will be installed from "' || origin || '"'
say

/* get default target path from OS/2 drive, e.g. C:\Oberon */
dest = value( 'system_ini',,'os2environment' )
dest = substr( dest, 1, 2 )
os2drive = dest
dest = os2drive || "\Oberon"
default = dest


/* let the user confirm or change the default target */
querydest:
do forever
  dest = default
  do forever
    say 'Do you want to install to destination "' || dest || '" ? (Y=ok N=other)'
    pull answer
    if answer \= "Y" then do
      if answer \= "N" then do
        iterate
      end
    end
    leave
  end
  if answer \= 'Y' then do
    do forever
      dest = default
      say 'Type in a complete destination path "drive-letter:\path-name"'
      pull drivepath
      if drivepath = '' then do
        leave
      end
      if datatype( substr( drivepath,1,1 ) ) = 'CHAR' then do
        if substr( drivepath, 2, 1 ) = ':' then do
          if substr( drivepath, 3, 1 ) = '\' then do
            if length( drivepath ) > 3 then do
              if right( drivepath, 1 ) \= '\' then do
                dest = drivepath
                leave
              end
            end
          end
        end
      end
      say "Destination drive and/or path is invalid or incomplete"
    end
  end
  if dest = '' then do
    iterate
  end
  overwrite = 0
  rc = SysFileTree( dest, dest_filetree, 'D' )
  if rc = 0 then do
    if dest_filetree.0 > 0 then do

/* folgende Schleife laesst sich evt. mittels DO UNTIL einfacher programmieren */
      do forever
        say
        say '"' || dest || '" already exists, overwrite it? (Y/N)'
        pull answer
        if answer \= "Y" then do
          if answer \= "N" then do
            iterate
          end
        end
        leave
      end
      if answer = 'Y' then do
        overwrite = 1
        leave
      end
      iterate
    end
    leave
  end
  say 'Cannot access destination "' || dest || '"'
end


destdrive = substr( dest, 1, 2 )
say
say 'OS2oberon will be installed to "' || dest || '"'
say


/* delete old destination path if there and if not needed */
if overwrite = 1 then do
  if filespec( "name", dest ) \= '' then do
    i = 3;
    do forever
      j = pos( '\', dest, i+1 )
      if j == 0 then do
        j = length( dest )
        destpath = substr( dest, i+1, j-i )
        leave
      end
      i = j
    end
    do forever
      say 'Delete old "' || destpath || '" before installation? (Y/N)'
      pull answer
      if answer \= "Y" then do
        if answer \= "N" then do
          iterate
        end
      end
      leave
    end
    if answer = 'Y' then do
      say
      say 'Deleting old "' || destpath || '"'
      say

      /* remove read-only attribute */
      chdir dest
      "ATTRIB -R *.* /S"
  
      chdir filespec( "drive", dest ) || '\'
      rc = SysDestroyObject( dest )
      if rc \= 1 then do
        say 'Old destination "' || destpath || '" cannot be deleted'
        exit
      end
      overwrite = 0
    end
  end
end


/* check disk space before installation */
driveinfo = SysDriveInfo( destdrive )
parse upper var driveinfo    drive free total label
if free < 3000000 then do
  say 'Destination drive "' || destdrive || '" has not enough free space'
  signal querydest
end


/* create destination directories if new */
if overwrite = 0 then do
  say
  say 'Creating destination directory path "' || dest || '"'
  say
  i = 3
  if right( dest, 1 ) \= '\' then do
    dest = dest || '\'
  end
  do forever
    i = pos( "\", dest, i+1 )
    if (i == 0) then do
      leave
    end
    destpath = substr( dest, 1, i-1 )
    if (SysFileTree( destpath, dest_filetree, 'D' ) == 0) then do
      if dest_filetree.0 > 0 then do
        iterate
      end
    end
    rc = SysMkDir( destpath )
    if rc \= 0 then do
      destcreated = 0
      leave
    end
    destcreated = 1
  end
  if destcreated == 0 then do
    say 'Destination directory "' || destpath || '" cannot be created'
    say SysGetMessage( rc )
    exit
  end
  if right( dest, 1 ) == '\' then do
    if right( dest, 2 ) \= ':\' then do
      dest = substr( dest, 1, length( dest )-1 )
    end
  end
end

/* now do the installation */
say
say 'Extracting OS2oberon archive to "' || dest || '"'
say
/* das folgende Statement ist wahrscheinlich ueberfluessig */
chdir origin
chdir dest
destdrive
if overwrite = 1 then do
  if right( origin, 1 ) \= '\' then do
    origin || '\' || "oberonv4.exe -fo"   /* extract already existing files and overwrite without prompt */
    origin || '\' || "oberonv4.exe -un"  /* update and create if necessary but do not overwrite */
  end
  else do
    origin || "oberonv4.exe -fo"
    origin || "oberonv4.exe -un"
  end
end
else do
  if right( origin, 1 ) \= '\' then do
    origin || '\' || "oberonv4.exe"
  end
  else do
    origin || "oberonv4.exe"
  end
end


rc = SysFileTree( "bin\longname.exe", reg_filetree)
if rc = 0 then do
  if reg_filetree.0 > 0 then do
    /* set .LONGNAME and .TYPE EA */
    "bin\LONGNAME *"
    "bin\EATYPE *.too"
    "bin\EATYPE *.mod"
    "bin\EATYPE *.tex"
    "bin\EATYPE *.fnt"
    "bin\EATYPE *.gra"
    "bin\EATYPE *.kep"
    "bin\EATYPE *.pro"
    "bin\EATYPE *.lib"
    "cd fonts"
    "..\bin\LONGNAME *"
    "..\bin\EATYPE *"
    "cd ..\samples"
    "..\bin\LONGNAME *"
    "..\bin\EATYPE *"
    "cd ..\obj"
    "..\bin\LONGNAME *"
    "..\bin\EATYPE *"
    "cd ..\sym"
    "..\bin\LONGNAME *"
    "..\bin\EATYPE *"
    "cd .."
  end
end

/* set read-only attribute */
/*"ATTRIB +R *.* /S"*/

/* create Oberon folder */
call SysCreateObject "WPFolder", "Oberon for OS/2", "<WP_DESKTOP>", ,
     "OBJECTID=<OS2Oberon>", "replace"

/* create Oberon object in Oberon folder */
call MakeObject dest || "\oberon.exe"
call MakeObject dest || "\userguid.inf"
call MakeObject dest || "\oberon2r.inf"


/* Installation done */
say
say 'Installation is now completed.'
say
say '-------------------------------------------------------------------'

exit

/* -- MakeObject(filespec) ... create object for filespec ------------------ */
MakeObject: procedure
parse arg fspec

filename =filespec("Name", fspec)

if lastpos(".", filename) > 0 then
/* translate in dieser Form uebersetzt den String in Grossbuchstaben */
  ext=translate(substr(filename, lastpos(".", filename)+1))
else
  ext=""

/* if filename contains blank, put it into apostrophe */
if pos(" ", fspec) > 0 then
  fspecquote='"'fspec'"'
else
  fspecquote=fspec

select
  /* create programmobject view.exe for INF-file */
   when ext="INF" then
      do
         rawtitle=charin(fspec, 108, 48)   /* read title of INF-file */
         if pos(d2c(0), rawtitle) > 1 then  /* non-empty title */
           inftitle=left(rawtitle, pos(d2c(0), rawtitle)-1)
         else
           inftitle=fspec  /* use filename as title */

        call SysCreateObject "WPProgram", inftitle, "<OS2Oberon>", ,
                     "EXENAME=VIEW.EXE;PARAMETERS="||fspecquote, "fail"
        say "INF-Viewer for " fspec " created."
      end

   when ext="EXE" then
        do
           call SysCreateObject "WPProgram", fspec, "<OS2Oberon>", ,
                      "EXENAME="fspec";STARTUPDIR="filespec("Drive", fspec) || ,
                      filespec("Path", fspec), "fail"
            say "program object for " fspec " created."

        end

otherwise
        do
        end /* do */
end  /* select */
return

/* -- CheckDrive(filespec) ... check for drive letter ------------------ */
CheckDrive: procedure
parse arg fspec


if (datatype( substr( fspec, 1, 1 ) ) \= 'CHAR') then do
  return 0
end
else if (substr( fspec, 2, 1 ) \= ':') then do
  return 0
end

return 1
