.\" $Header: build.1,v 2.22 88/04/06 11:48:07 mee content6 $
.\" @(#) build.1 1.4  @(#)build.1	1.4  12/11/85  1   
.TH BUILD 1 "" "" HP-UX
.SH NAME
build - load-builder program for gpm, gardens point modula
compiler

.SH SYNOPSIS
.B build 
[
.B -options
]
.B base

.SH DESCRIPTION
.B build
is a load-builder program used in conjunction with 
.B gpm
\&(1).
It builds an executable file with no extension,
based on the characters of the base (main)
module name moved to lower case. The
.B .syx
, 
.B .o 
and 
.B .rfx 
files produced by 
.B gpm 
take their name from the module name not from the original 
.B .mod 
file name if that is different (except when the 
.B -f
option of 
.B gpm
is used).

The program seeks out the reference files of those modules which are
imported by the base module, and the reference files of the modules which
are imported by those modules, and so on.
It creates and compiles a small program containing the initialization 
call chain, and creates a script for the UNIX linker
.B ld.
Reference files are found by first searching the current directory, 
followed by the the directories of the path $M2LIB, in order.

.SH Command-line Options
.PP
build accepts a number of options from the command line. The
following conventions apply to the use of the options:

(i)   options are the first argument after the command

(ii)  the option string must start with a minus sign 
.B -

(iii) options may appear in a single group or individually

(iv)  the order of the options is not important so that

.B 	build -vS foo

and 
.B build -S -v foo 
have the same effect.


.SS Builder Option Flags
.PP
.B -L
.I dirname \t
force Library path -  the linker will search the named
directory for archive libraries before searching the
default directories
.PP
.B -q \t
query -  the builder prompts for the names of
reference files which it cannot find.  Only the file
base-name is required, and querying may be aborted by
entering a blank line
.PP
.B -S \t
aSsembler -  the initialization-call-chain code file
and the linker script are persistent as files 
.B modbase.c 
and
.B modbase 
respectively
.PP
.B -v \t
verbose messages are displayed on the screen so that
progress may be monitored, and the origin of any error
messages determined
.PP
.B -V \t
builder Version date and time are displayed, and
screen messages are verbose. Also, the library files
which are linked have their absolute path names and cryptographic key values
displayed
.PP
To build a 
.B profiling 
version of a program, 
.B build 
is invoked
under the name 
.B bldprf
\&.  This version of the load-builder
generates a linkage to the standard UNIX profiling tool 
.B prof
\&.

The source module must have been compiled with either the 
.B -g
or 
.B -p 
options. After the program is executed the results of
profiling may now be analysed using
.B prof -g base
\&.

The option and filename conventions for 
.B bldprf
are identical
to those of 
.B build
\&.

Warning : modules compiled with the 
.B -p 
option cannot be built using 
.B build
\&. Fortunately, build checks for this possibility and issues 
a specific diagnostic

.B	<base> was compiled with "-p" (profiling) flag
.br
.B	*** File creation unsuccessful ***
.br


For further information on profiling refer to the Appendix in
the Gardens Point Modula Reference Manual titled 
.B Using the Profiling Tools
\&.
.br
