implementation module timerDevice

import StdInt
import ioState, commonDef
import misc, oskernel
from deltaTimer import TicksPerSecond

		

TimerFunctions  ::    DeviceFunctions state
TimerFunctions = (ShowTimer, TimerOpen, TimerIO, TimerClose, HideTimer)



/*  Open the initial Timers */
TimerOpen:: !.(DeviceSystem s (IOState s)) !(IOState s) -> IOState s
TimerOpen (TimerSystem timers) io
		= let! 
			timerhandles
			io`
		  in io`
		  where 
		  timerhandles = InstallTimers timers
		  io`          = IOStateSetDevice io (TimerSystemState timerhandles)
		

InstallTimers:: [TimerDef s (IOState s)] -> ![TimerHandle s (IOState s)]
InstallTimers []
		= []
InstallTimers [Timer id Able interval funcs : timers]
		= let! 
			newtimer
			resttimers
			handle
		  in [newtimer : resttimers]
		  where 
		  newtimer   = (handle, id, ostime, funcs) 
		  handle     = OSTimerStart id ostime
		  ostime     = (1000 * interval) / TicksPerSecond
		  resttimers = InstallTimers timers
InstallTimers [Timer id Unable interval funcs : timers]
		= let! 
			resttimers
			newtimer
		  in [newtimer : resttimers]
		  where 
		  newtimer   = (-1, id, ostime, funcs)
		  resttimers = InstallTimers timers
		  ostime     = (1000 * interval) / TicksPerSecond
		

/*  The Timer event handling */
TimerIO :: !.Event !*s !(IOState *s) -> (!Bool, !*s, !IOState *s)
TimerIO (OSTimerDevice, timerid, time ,e3 ) state io
		= let! 
			state`
			io``
		  in (True, state`, io``)
		  where 
		  (state`, io``) = TimerIO` timerid 1 (GetTimerHandles timers) state io`
		  (timers, io`)  = IOStateGetDevice io TimerDevice
TimerIO event state io
		= (False, state, io)

TimerIO`:: !Int !TimerState ![TimerHandle *s (IOState *s)] !*s !(IOState *s) -> (!*s, !IOState *s)
TimerIO` id time timers state io
		= fun time state io
		  where 
		  fun = GetTimerFunction id timers
		

GetTimerFunction:: !Int ![TimerHandle s (IOState s)] -> TimerFunction s (IOState s)
GetTimerFunction id [(handle,id2,ostime,fun) : timers]
	| id == handle
		= fun
		= GetTimerFunction id timers
GetTimerFunction id []
		= DummyTimerFunction


DummyTimerFunction:: TimerState * s (IOState *s) -> (* s, IOState *s)
DummyTimerFunction i s io
		= (s, io)


TimerClose:: !(IOState s) -> IOState s
TimerClose io = IOStateRemoveDevice (HideTimer io) TimerDevice


HideTimer:: !(IOState s) -> IOState s
HideTimer io
		= let! 
			timers`
			io`
		  in IOStateSetDevice io` (TimerSystemState timers`)
		  where 
		  timers`      = ChangeTimers False (GetTimerHandles timers)
		  (timers,io`) = IOStateGetDevice io TimerDevice
		

ShowTimer:: !(IOState s) -> IOState s
ShowTimer io
		= let! 
			timers`
			io`
		  in IOStateSetDevice io` (TimerSystemState timers`)
		  where 
		  timers`      = ChangeTimers True (GetTimerHandles timers)
		  (timers,io`) = IOStateGetDevice io TimerDevice
		

ChangeTimers:: !Bool ![TimerHandle s (IOState s)] ->  [TimerHandle s (IOState s)]
ChangeTimers on [timer : timers]
		= let! 
			strict1
			strict2
		  in [strict1 : strict2]
		  where 
		  strict1 = ChangeTimer on timer
		  strict2 = ChangeTimers on timers
ChangeTimers on []
		= []


ChangeTimer:: !Bool !(TimerHandle s (IOState s)) ->  TimerHandle s (IOState s)
ChangeTimer True (handle,id,ostime,fun)
		= let! 
			handle` = OSTimerStart id ostime
		  in (handle`,id,ostime,fun)
ChangeTimer False (handle,id,ostime,fun)
		= let! 
			handle` = OSTimerStop handle
		  in (handle`,id,ostime,fun)		  
		

GetTimerHandles:: !(DeviceSystemState * s) ->  [TimerHandle *s (IOState *s)]
GetTimerHandles (TimerSystemState timers)
		= timers
