:userdoc.
:title.LVM API Reference
:docprof toc=1234.


.* ----------------------------------------------------------------------------
.* API Section
.* ----------------------------------------------------------------------------

:h1 x=left y=bottom width=100% height=100%.LVM Internal Types &lparen.lvm_type.h&rparen.
:p.:hp7.Module&colon. lvm_type.h:ehp7.:p.
:p.:hp7.Description:ehp7.
:p.This module defines basic types used in the declaration of disk structures.  It
also defines data structures used for LVM "plugins".
:p.Most of the contents of this module are used by LVM internally, or when creating
extensions to LVM, and are not typically useful to the application programmer.
:p.

:p.:hp7.Header files included by lvm_type.h&colon.:ehp7.
:p.
:dl tsize=15.
:dt.:hp1.lvm_gbls.h:ehp1.
:dd.INTEGER16, INTEGER32, INTEGER, CARDINAL16, CARDINAL32, CARDINAL, REAL32,
REAL64, BYTE, BOOLEAN, TRUE, FALSE, ADDRESS
:dt.:hp1.lvm_list.h:ehp1.
:dd.(Internal usage only)
:edl.:p.


:p.

.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Constants
:p.This section describes constants defined in :hp2.lvm_type.h:ehp2..

:p.The following define sets the maximum number of LVM classes for which
structures and storage will be reserved.
.br
:xmp.
#define MAXIMUM_LVM_CLASSES   3
:exmp.
:p.
:xmp.
#define MAXIMUM_LVM_INTERFACE_TYPES  3
:exmp.

:p.The following define the default help indicies which must be supported by the
Help_Panel function.  NOTE:  Index values from 0 to 100 are reserved by LVM.
The Plugin may, for its own use, use any values above 100.
.br
:xmp.
#define HELP_PLUGIN_DESCRIPTION    0
:exmp.

:p.The following define the maximum length of the names which can be used to
represent a feature in LVM.  The maximum name length for a feature is 30
characters plus the trailing NULL character.  For command line parsing, though,
a shorter name is preferable!  Thus, the "short" name for a feature will be
limited to 10 characters plus the trailing NULL character.  The "short" name
will be used for command line purposes, while the regular name will be used by
all other interfaces.
.br
:xmp.
#define MAX_FEATURE_NAME_LENGTH        31
#define MAX_FEATURE_SHORT_NAME_LENGTH  11
#define MAX_OEM_INFO_LENGTH           255
:exmp.

:p.The following defines the TAG value used to identify an item of type
Feature_ID_Data in a DLIST.
.br
:xmp.
#define FEATURE_ID_DATA_TAG 354385972

#define LVM_TOKEN_TAG    28387473
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Type definitions
:p.This section describes :hp1.typedef:ehp1. statements from :hp2.lvm_type.h:ehp2..
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Disk structure types
:p.The following types are used in the declaration of disk structures.
Disk structures have a defined size and internal structure which must be
matched exactly.

:h4 x=left y=bottom width=100% height=100%.QuadWord
:p.8 bytes.
.br
:xmp.
#ifdef LONG_LONG_SUPPORTED

typedef long long QuadWord;

#else

typedef struct _QuadWord {
    unsigned long  High32Bits;
    unsigned long  Low32Bits;
} QuadWord;

#endif
:exmp.
:p.

:h4 x=left y=bottom width=100% height=100%.DoubleWord
:p.4 bytes.
.br
:xmp.
typedef unsigned long DoubleWord;
:exmp.
:p.

:h4 x=left y=bottom width=100% height=100%.Word
:p.2 bytes.
.br
:xmp.
typedef short unsigned int Word;
:exmp.
:p.

:h4 x=left y=bottom width=100% height=100%.Byte
:p.1 byte.
.br
:xmp.
typedef unsigned char Byte;
:exmp.
:p.

:h4 x=left y=bottom width=100% height=100%.Other types
:p.The following types are used internally by LVM.

:p.Define a Partition Sector Number.  A Partition Sector Number is relative to
the start of a partition.  The first sector in a partition is PSN 0.
.br
:xmp.
typedef unsigned long PSN;
:exmp.

:p.Define a Logical Sector Number.  A Logical Sector Number is relative to
the start of a volume.  The first sector in a volume is LSN 0.
.br
:xmp.
typedef unsigned long LSN;
:exmp.

:p.Define a Logical Block Address.  A Logical Block Address is relative to
the start of a physical device - a disk drive.  The first sector on a disk
drive is LBA 0.
.br
:xmp.
typedef unsigned long LBA;
:exmp.
:p.


.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Data structures
:p.These data structures are used in defining LVM Plugins.
:p.

:h4 x=left y=bottom width=100% height=100%.LVM_Classes
:p.The following enum defines the various LVM classes to which a "feature"
may belong.  An LVM Plugin is used to implement a "feature", so "plugin" and
"feature" are really synonyms.
.br
:xmp.
typedef enum _LVM_Classes {
    :link reftype=fn refid=partition_class.Partition_Class:elink.,
    :link reftype=fn refid=aggregate_class.Aggregate_Class:elink.,
    :link reftype=fn refid=volume_class.Volume_Class:elink.
} LVM_Classes;
:exmp.
:p.

:fn id=partition_class.
:p.For "features" which must operate on a partition level - i.e. Bad Block Relocation.
:efn.
:fn id=aggregate_class.
:p.For "features" which combine partitions into a single logical entity - i.e. Drive Linking.
:efn.
:fn id=volume_class.
:p.For "features" which operate best on a volume level - i.e. encryption, mirroring etc.
:efn.


:h4 x=left y=bottom width=100% height=100%.LVM_Class_Attributes
:p.An LVM plugin may belong to one or more classes.  For each class to which it
belongs, certain attributes must be defined.  This structure tracks those
attributes for a class.
.br
:xmp.
typedef struct _LVM_Class_Attributes {
    BOOLEAN      :link reftype=fn refid=classmember.ClassMember:elink.;
    BOOLEAN      :link reftype=fn refid=globalexclusive.GlobalExclusive:elink.;
    BOOLEAN      :link reftype=fn refid=topexclusive.TopExclusive:elink.;
    BOOLEAN      :link reftype=fn refid=bottomexclusive.BottomExclusive:elink.;
    BOOLEAN      :link reftype=fn refid=classexclusive.ClassExclusive:elink.;
    CARDINAL32   :link reftype=fn refid=weightfactor.Weight_Factor:elink.;
} LVM_Class_Attributes;
:exmp.
:p.

:fn id=classmember.
:p.TRUE if a member of this class, FALSE otherwise.
:efn.
:fn id=globalexclusive.
:p.TRUE if this plugin can not work with any other plugin - i.e. it must be the
only "feature" on the volume, besides the built in feature of BBR.
:efn.
:fn id=topexclusive.
:p.TRUE if this plugin must be the topmost plugin in this class.
:efn.
:fn id=bottomexclusive.
:p.TRUE if this plugin must be the bottommost plugin in this class.
:efn.
:fn id=classexclusive.
:p.TRUE if this plugin will not work with any other plugin in this class.
:efn.
:fn id=weightfactor.
:p.A value between 1 and 100 which is used to guide the LVM interfaces when attempting
to establish a default ordering for plugins within this class.  A value of 1
indicates that this plugin wants to be as close to the bottom of the plugins
in this class as possible.  A value of 100 means that this plugin wants to
be as close to being the topmost plugin in this class as possible.  This value
is only used if none of the "exclusive" flags are set.
:p.
:efn.


:h4 x=left y=bottom width=100% height=100%.LVM_Interface_Types
:p.The following enum specifies the interface types that LVM supports, and hence
any plugin must support.
.br
:xmp.
typedef enum _LVM_Interface_Types {
    PM_Interface,
    :link reftype=fn refid=vio_interface.VIO_Interface:elink.,
    :link reftype=fn refid=java_interface.Java_Interface:elink.,
} LVM_Interface_Types;
:exmp.

:p.MAXIMUM_LVM_INTERFACE_TYPES is defined under &osq.Constants&csq..

:fn id=vio_interface.
:p.LVM.EXE is a VIO app. since it is used during install, and during recovery scenarios where PM/Java may not be available.
:efn.
:fn id=java_interface.
:p.The LVM GUI is written in Java.
:efn.


:h4 x=left y=bottom width=100% height=100%.Interface support structures
:p.The following structures define what functions must be supported for each
interface type.
.br
:xmp.
typedef struct _LVM_OS2_Native_Support {
    :link reftype=fn refid=native_support_1.void (* _System Create_and_Configure):elink. ( CARDINAL32 ID,
                                            ADDRESS InputBuffer,
                                            CARDINAL32 InputBufferSize,
                                            ADDRESS * OutputBuffer,
                                            CARDINAL32 * OutputBufferSize,
                                            CARDINAL32 * Error_Code );
    :link reftype=fn refid=native_support_2.void (* _System Display_Status):elink. ( ADDRESS Volume_Handle,
                                      CARDINAL32 * Error_Code );
    :link reftype=fn refid=native_support_3.void (* _System Control_Panel):elink. ( ADDRESS Volume_Handle,
                                     CARDINAL32 * Error_Code );
    :link reftype=fn refid=native_support_4.void (* _System Help_Panel):elink. ( CARDINAL32 Help_Index,
                                  CARDINAL32 * Error_Code );
} LVM_OS2_Native_Support;


typedef struct _LVM_Interface_Support {
    BOOLEAN Interface_Supported;
    union {
        char *                  :link reftype=fn refid=if_support_1.Java_Interface_Class:elink.;
        LVM_OS2_Native_Support  :link reftype=fn refid=if_support_2.VIO_PM_Calls:elink.;
    };
} LVM_Interface_Support;
:exmp.
:p.

:fn id=native_support_1.
:p.Native OS/2
:efn.
:fn id=native_support_2.
:p.Native OS/2
:efn.
:fn id=native_support_3.
:p.Native OS/2
:efn.
:fn id=native_support_4.
:p.Native OS/2
:efn.
:fn id=if_support_1.
:p.Java
:efn.
:fn id=if_support_2.
:p.VIO/PM
:efn.


:h4 x=left y=bottom width=100% height=100%.Feature_ID_Data
:p.The following definitions are used to control and access the various
"features" available through the LVM Engine, such as Drive Linking and BBR.
.br
:xmp.
typedef struct _Feature_ID_Data {
    char                   :link reftype=fn refid=fid_name.Name[ MAX_FEATURE_NAME_LENGTH ]:elink.;
    char                   :link reftype=fn refid=fid_shortname.Short_Name[ MAX_FEATURE_SHORT_NAME_LENGTH ]:elink.;
    char                   :link reftype=fn refid=fid_oeminfo.OEM_Info[ MAX_OEM_INFO_LENGTH ]:elink.;
    CARDINAL32             :link reftype=fn refid=fid_id.ID:elink.;
    CARDINAL32             :link reftype=fn refid=fid_majorversion.Major_Version_Number:elink.;
    CARDINAL32             :link reftype=fn refid=fid_minorversion.Minor_Version_Number:elink.;
    CARDINAL32             :link reftype=fn refid=fid_lvmmajorversion.LVM_Major_Version_Number:elink.;
    CARDINAL32             :link reftype=fn refid=fid_lvmminorversion.LVM_Minor_Version_Number:elink.;
    LVM_Classes            :link reftype=fn refid=fid_preferredclass.Preferred_Class:elink.;
    LVM_Class_Attributes   :link reftype=fn refid=fid_classdata.ClassData[ MAXIMUM_LVM_CLASSES ]:elink.;
    LVM_Interface_Support  :link reftype=fn refid=fid_ifsupport.Interface_Support[ MAXIMUM_LVM_INTERFACE_TYPES ]:elink.;
} Feature_ID_Data;
:exmp.
:p.

:fn id=fid_name.
:p.Feature Name, for use in menus and command line parsing.
:efn.
:fn id=fid_shortname.
:p.The name/code used to represent this feature during command line parsing.
:efn.
:fn id=fid_oeminfo.
:p.Name and copyright info. of the manufacturer, i.e. IBM, Vinca, etc.
:efn.
:fn id=fid_id.
:p.Numeric Feature ID.
:efn.
:fn id=fid_majorversion.
:p.The version number of this feature.
:efn.
:fn id=fid_minorversion.
:p.The version number of this feature.
:efn.
:fn id=fid_lvmmajorversion.
:p.The version of LVM that this feature was designed to work with.
:efn.
:fn id=fid_lvmminorversion.
:p.The version of LVM that this feature was designed to work with.
:efn.
:fn id=fid_preferredclass.
:p.The class from which this "feature" prefers to be chosen.  Encryption can be performed
at the partition level or the volume level, and may therefore belong to both the
Partition_Class and the Volume_Class.  However, it is preferrable for it to be used
on the volume level instead of at the partition level.  Thus, its perferred class would
be the Volume_Class, but it would still be a member of both the Volume_Class and the
Partition_Class.
:p.
:efn.
:fn id=fid_classdata.
:p.The attributes for each of the LVM classes that this "feature" is in.
:efn.
:fn id=fid_ifsupport.
:p.The functions and classes for each of the video modes that LVM can run it.
:efn.


:h4 x=left y=bottom width=100% height=100%.Token definitions
:p.The following definitions are used for command line processing.  As the
command line is processed, the command line is first broken up into tokens.
Each token has a "characterization", which indicates what the token is
thought to be.
.br
:xmp.
typedef enum {
    LVM_AcceptableCharsStr,
    LVM_All,
    LVM_BestFit,
    LVM_BootDOS,
    LVM_BootOS2,
    LVM_Bootable,
    LVM_CR,
    LVM_CRI,
    LVM_Compatibility,
    LVM_Drive,
    LVM_Existing,
    LVM_Expand,
    LVM_FS,
    LVM_FirstFit,
    LVM_Freespace,
    LVM_FromEnd,
    LVM_FromLargest,
    LVM_FromSmallest,
    LVM_FromStart,
    LVM_LVM,
    LVM_LastFit,
    LVM_Logical,
    LVM_New,
    LVM_NoBoot,
    LVM_NonBootable,
    LVM_NotBootable,
    LVM_Partition,
    LVM_Primary,
    LVM_RB,
    LVM_Size,
    LVM_Unusable,
    LVM_Unused,
    LVM_Volume,
    LVM_Volumes,
    LVM_Comma,
    LVM_Number,
    LVM_Colon,
    LVM_Space,
    LVM_Tab,
    LVM_MultiSpace,
    LVM_MultiTab,
    LVM_String,
    LVM_FileNameStr,
    LVM_SemiColon,
    LVM_Eof,
    LVM_Separator,
    :link reftype=fn refid=openparen.LVM_Open_Paren:elink.,
    :link reftype=fn refid=closeparen.LVM_Close_Paren:elink.,
    :link reftype=fn refid=openbracket.LVM_Open_Bracket:elink.,
    :link reftype=fn refid=closebracket.LVM_Close_Bracket:elink.,
    :link reftype=fn refid=openbrace.LVM_Open_Brace:elink.,
    :link reftype=fn refid=closebrace.LVM_Close_Brace:elink.,
    :link reftype=fn refid=eqsign.LVM_EQ_Sign:elink.,
    LVM_Bootmgr,
    LVM_Create,
    LVM_Delete,
    LVM_DriveLetter,
    LVM_File,
    LVM_Hide,
    LVM_Install,
    LVM_NewMBR,
    LVM_Query,
    LVM_RediscoverPRM,
    LVM_SetName,
    LVM_SetStartable,
    LVM_SI,
    LVM_SlashSize,
    LVM_StartLog
} Token_Characterizations;


typedef struct _LVM_Token{
    char *                   :link reftype=fn refid=token_text.TokenText:elink.;
    Token_Characterizations  :link reftype=fn refid=token_type.TokenType:elink.;
    CARDINAL32               :link reftype=fn refid=token_position.Position:elink.;
} LVM_Token;
:exmp.
:p.

:fn id=openparen.
:p.(
:efn.
:fn id=closeparen.
:p.)
:efn.
:fn id=openbracket.
:p.[
:efn.
:fn id=closebracket.
:p.]
:efn.
:fn id=openbrace.
:p.{
:efn.
:fn id=closebrace.
:p.}
:efn.
:fn id=eqsign.
:p.=
:efn.

:fn id=token_text.
:p.The actual text of the token.
:efn.
:fn id=token_type.
:p.What the token is thought to be.
:efn.
:fn id=token_position.
:p.The position of the first character of the token on the command line.
:efn.
:euserdoc.

