:userdoc.
:title.LVM API Reference
:docprof toc=1234.


.* ----------------------------------------------------------------------------
.* API Section
.* ----------------------------------------------------------------------------

:h1 x=left y=bottom width=100% height=100%.LVM Global Definitions &lparen.lvm_gbls.h&rparen.
:p.:hp7.Module&colon. lvm_gbls.h:ehp7.:p.
:p.:hp7.Description:ehp7.
:p.Defines various global types which are used throughout the LVM Engine.
:p.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Basic data types
:p.This section describes the basic data types defined in :hp2.lvm_gbls.h:ehp2..
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.ADDRESS
:p.An ADDRESS variable is one which holds an address.  The address can contain
anything, or even be invalid.  It is just an address which is presumed to
hold some kind of data.
.br
:xmp.
typedef void * ADDRESS;
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.BOOLEAN
:p.A BOOLEAN variable is one which is either TRUE or FALSE.
.br
:xmp.
typedef unsigned char  BOOLEAN;

#define TRUE  1
#define FALSE 0
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.BYTE
:p.A BYTE is 8 bits of memory with no interpretation attached.
.br
:xmp.
#ifdef NEED_BYTE_DEFINED

typedef unsigned char BYTE;

#else
#ifndef BYTE

#define BYTE unsigned char

#endif
#endif
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.CARDINAL types
:p.A CARDINAL number is a positive integer >= 0.
The number appended to the CARDINAL key word indicates the number of bits
used to represent a CARDINAL of that type.
.br
:xmp.
typedef unsigned short int CARDINAL16;
typedef unsigned long      CARDINAL32;
typedef unsigned int       CARDINAL;     /* Use compiler default. */
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.INTEGER types
:p.An INTEGER number is a whole number, either + or -.
The number appended to the INTEGER key word indicates the number
of bits used to represent an INTEGER of that type.
.br
:xmp.
typedef short int INTEGER16;
typedef long  int INTEGER32;
typedef int       INTEGER;    /* Use compiler default. */
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.pSTRING
:p.A basic string type.
.br
:xmp.
typedef char * pSTRING;
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.REAL types
:p.A REAL number is a floating point number.
.br
:xmp.
typedef float   REAL32;
typedef double  REAL64;
:exmp.
:p.
:euserdoc.

