:userdoc.
:title.LVM API Reference
:docprof toc=1234.


.* ----------------------------------------------------------------------------
.* API Section
.* ----------------------------------------------------------------------------

:h1 x=left y=bottom width=100% height=100%.LVM Constants &lparen.lvm_cons.h&rparen.
:p.:hp7.Module&colon. lvm_cons.h:ehp7.:p.
:p.:hp7.Description:ehp7.
:p.This module defines constants used throughout the LVM code.:p.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Constants
:p.The following sections describe constants defined in :hp2.lvm_cons.h:ehp2..

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Disk geometry constants
:p.The number of bytes in a sector on the disk.
.br
:xmp.
#define BYTES_PER_SECTOR  512
:exmp.:p.

:p.The maximum number of cylinders, heads, and sectors that a partition table
entry can accomodate.
:p.Cylinders are numbered 0 - 1023, for a maximum of 1024 cylinders.
.br
Heads are numbered 0 - 255, for a maximum of 256 heads.
.br
Sectors are numbered 1 - 63, for a maximum of 63 sectors per track.
.br
:xmp.
#define MAX_CYLINDERS 1024
#define MAX_HEADS     256
#define MAX_SECTORS   63
:exmp.:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Extended Boot Record constants
:p.The following define the values used to indicate that a partition table
entry is for an EBR, not a partition.
.br
:xmp.
#define EBR_BOOT_INDICATOR     0
#define EBR_FORMAT_INDICATOR   5
:exmp.:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Default indicator value constants
:p.The following define is used as the default Format_Indicator for new
non-primary partitions.
.br
:xmp.
#define NEW_LOGICAL_DRIVE_FORMAT_INDICATOR   0x6
:exmp.:p.

:p.The following define is used as the default Format_Indicator for a new
non-active primary partitions.
.br
:xmp.
#define NEW_PRIMARY_PARTITION_FORMAT_INDICATOR   0x16
:exmp.:p.

:p.The following define is used as the default Format_Indicator for a new
active primary partition.
.br
:xmp.
#define NEW_ACTIVE_PRIMARY_PARTITION_FORMAT_INDICATOR  0x06
:exmp.:p.

:p.The following define is used to hold the value of the Boot_Indicator for
active partitions.
.br
:xmp.
#define ACTIVE_PARTITION   0x80
:exmp.:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Name length constants
:p.(These length constants do not include null terminators.)

:p.Define the size of a Partition Name.  Partition Names are user defined names
given to a partition.
.br
:xmp.
#define PARTITION_NAME_SIZE  20
:exmp.:p.

:p.Define the size of a volume name.  Volume Names are user defined names given
to a volume.
.br
:xmp.
#define VOLUME_NAME_SIZE  20
:exmp.:p.

:p.Define the size of a disk name.  Disk Names are user defined names given to
physical disk drives in the system.
.br
:xmp.
#define DISK_NAME_SIZE    20
:exmp.:p.

:p.The name of the filesystem in use on a partition.  This name may be up to 12
( + NULL terminator) characters long.
.br
:xmp.
#define FILESYSTEM_NAME_SIZE 20
:exmp.:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Miscellaneous constants
:p.The comment field is reserved but is not currently used.  This is for future
expansion and use.
.br
:xmp.
#define COMMENT_SIZE 81
:exmp.:p.

:p.Define the minimum number of sectors to reserve on the disk for Boot Manager.
.br
:xmp.
#define BOOT_MANAGER_SIZE   2048
:exmp.:p.
:euserdoc.

