:userdoc.
:title.LVM API Reference
:docprof toc=1234.


.* ----------------------------------------------------------------------------
.* Introduction
.* ----------------------------------------------------------------------------

:h1 x=left y=bottom width=100% height=100%.About the LVM API Reference
:p.This documentation is derived from the contents of four C header files
which define the LVM programming interface.

:parml.
:pt.:hp5.lvm_intr.h:ehp5.
:pd.This file is also referred to (in some of IBM's LVM source code, not
reproduced here) as &osq.LVM_Interface.h&csq..  It defines the programming
interface to LVM.DLL, the actual LVM engine.  :hp2.LVMAPI1.INF:ehp2.
describes this file.
:pt.:hp5.lvm_cons.h:ehp5.
:pd.This file defines a number of additional constants used throughout the
LVM code.  :hp2.LVMAPI2.INF:ehp2. describes this file.
:pt.:hp5.lvm_gbls.h:ehp5.
:pd.This file defines a number of additional type and macro definitions used
throughout the LVM code.  :hp2.LVMAPI3.INF:ehp2. describes this file.
:pt.:hp5.lvm_type.h:ehp5.
:pd.This file contains some additional type definitions used in the
declarations of disk structures, and also contains definitions used for
LVM plugins and other extensions.  Most of this file is specific to LVM version
2 (see note below), and is not likely to be of interest to application
developers.  :hp2.LVMAPI4.INF:ehp2. describes this file.
:eparml.
:p.A fifth header file, :hp5.lvm_list.h:ehp5., is used internally by certain
LVM functions; however, it does not seem to be useful to API programmers and so
it is not documented here.

:p.The source for this information is the OS/2 Reference Code which IBM made
available through the Enterprise Volume Management System project
(http&colon.//evms.sourceforge.net).
:p.

:p.:hp8.Note about LVM versions:ehp8.
:p.There is a distinction made between LVM Version 1 and LVM Version 2.
All existing versions of LVM for OS/2 (including those found in the
Convenience Packages) seem to be LVM Version 1.

:p.However, this documentation -- and the published EVMS reference code
-- describe LVM Version 2.

:p.There are some features specific to Version 2 which are unusable on OS/2
and other platforms which use LVM Version 1 (at least until such a day as LVM
Version 2 is released for these platforms).

:p.Specifically, the following functions (both 16- and 32-bit versions) are
unavailable&colon.
.br
:xmp.
  Open_LVM_Engine2
  Set_Java_Call_Back
  Issue_Feature_Command
  Parse_Feature_Parameters
  Create_Volume2
  Convert_Volumes_To_V1
  Get_Child_Handles
  Get_Parent_Handle
  Get_Features
  Allocate_Engine_Memory
:exmp.

:p.These functions include the notice :hp9.LVM Version 2 only:ehp9. under their
descriptions.

:p.There is a function in Version 1 called :hp1.Export_Configuration:ehp1.
(and a corresponding :hp1.EXPORT_CONFIGURATION16:ehp1.) which does not occur
in Version 2.  No documentation is available for this function, as it is not
referenced anywhere in the EVMS source code.
:p.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Changes
:p.All descriptions have been taken (verbatim) from the source code, and
should be considered copyright IBM Corporation.  They have not been altered
(with the exception that some typos have been corrected), but some additions
have been made&colon.
:ul.
:li.Some editorial comments have been added where deemed appropriate.
:li.Some additional headings and/or section labels have been added to the
IBM comments for the sake of improving clarity.
:li.Function prototypes and descriptions have been re-ordered slightly in
the process of converting C code comments into API reference format.
:li.Document formatting has been added in the process of converting ASCII
source code into on-line documentation.
:eul.

:p.All of this material is licensed by IBM under the GNU General Public
License.  The LVM source code is available through CVS on the SourceForge
website under the name :hp2.EVMS:ehp2..
:p.

:p.:hp8.Change History&colon.:ehp8.

:p.:hp5.2006-03-07:ehp5.
.br
:ul.
:li.Added notes about the behaviour of the Current_Drive_Letter and
Drive_Letter_Preference fields in the :hp2.Volume_Information_Record:ehp2.
structure following a drive-letter change.
:eul.

:p.:hp5.2004-01-05:ehp5.
.br
:ul.
:li.Added a note about the unreliability of the :hp2.Boot_Manager_Is_Installed():ehp2.
function, and a suggested workaround.
:eul.

:p.:hp5.2002-08-17:ehp5.
.br
:ul.
:li.Added some editorial notes to various sections.
:li.Miscellaneous minor corrections.
:eul.

:p.:hp5.2002-06-02:ehp5.
.br
:ul.
:li.Removed the separate section on 16-bit functions, and consolidated all
the function headers into one entry format.
:li.Moved structure field descriptions out of code-comments and into footnotes.
This should make reading easier, and is more consistent with the standard OS/2
API reference format.
:li.Set window coordinates so resizing is friendlier.
:li.Reorganized the lvm_type.h documentation and added some notes.
:eul.

:p.:hp5.2002-02-18:ehp5.
.br
:ul.
:li.Added notes on LVM Version 1 versus LVM Version 2.
:li.Reorganized the :hp2.About:ehp2. and :hp2.Notices:ehp2. sections.
:li.Some formatting changes.
:eul.

:p.:hp5.2001-09-15:ehp5.
.br
:ul.
:li.Initial release.
:eul.
:p.


.* ----------------------------------------------------------------------------
.* Legal Schmegal
.* ----------------------------------------------------------------------------
:h1 x=left y=bottom width=100% height=100%.Notices
:p.Copyright (c) International Business Machines  Corp., 2000

:p.Formatting and editorial content is Copyright (c) 2002 Alexander Taylor.

:p.
:p.This program is free software;  you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

:p.This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;  without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.

:p.You should have received a copy of the GNU General Public License
along with this program;  if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
:p.



.* ----------------------------------------------------------------------------
.* API Section
.* ----------------------------------------------------------------------------
:h1 x=left y=bottom width=100% height=100%.LVM Interface (lvm_intr.h)
:p.:hp7.Module&colon. lvm_intr.h:ehp7.
:p.
:p.:hp7.Description:ehp7.
:p.This module defines the interface to LVM.DLL, which is the engine that
performs all of the disk partitioning &amp. volume creation work.:p.

:p.:hp7.Header files included by lvm_intr.h&colon.:ehp7.
:dl tsize=15.
:dt.:hp1.lvm_gbls.h:ehp1.
:dd.BYTE, CARDINAL32, ADDRESS, BOOLEAN, BYTE
:dt.:hp1.lvm_cons.h:ehp1.
:dd.DISK_NAME_SIZE, PARTITION_NAME_SIZE, VOLUME_NAME_SIZE, FILESYSTEM_NAME_SIZE
:dt.:hp1.lvm_type.h:ehp1.
:dd.DoubleWord
:edl.:p.


:p.:hp7.Functions&colon.:ehp7.

:dl compact tsize=32.
:dt.void
:dd.Open_LVM_Engine
:dt.void
:dd.Open_LVM_Engine2
:dt.void
:dd.Close_LVM_Engine
:dt.Drive_Control_Array
:dd.Get_Drive_Control_Data
:dt.Drive_Information_Record
:dd.Get_Drive_Status
:dt.Partition_Information_Array
:dd.Get_Partitions
:dt.Partition_Information_Record
:dd.Get_Partition_Information
:dt.void
:dd.Create_Partition
:dt.void
:dd.Delete_Partition
:dt.void
:dd.Set_Active_Flag
:dt.void
:dd.Set_OS_Flag
:dt.Volume_Control_Array
:dd.Get_Volume_Control_Data
:dt.Volume_Information_Record
:dd.Get_Volume_Information
:dt.void
:dd.Create_Volume
:dt.void
:dd.Create_Volume2
:dt.void
:dd.Hide_Volume
:dt.void
:dd.Expand_Volume
:dt.void
:dd.Assign_Drive_Letter
:dt.void
:dd.Set_Installable
:dt.void
:dd.Set_Name
:dt.CARDINAL32
:dd.Get_Valid_Options
:dt.BOOLEAN
:dd.Boot_Manager_Is_Installed
:dt.void
:dd.Add_To_Boot_Manager
:dt.void
:dd.Remove_From_Boot_Manager
:dt.Boot_Manager_Menu
:dd.Get_Boot_Manager_Menu
:dt.void
:dd.Install_Boot_Manager
:dt.void
:dd.Remove_Boot_Manager
:dt.void
:dd.Set_Boot_Manager_Options
:dt.void
:dd.Get_Boot_Manager_Options
:dt.void
:dd.New_MBR
:dt.CARDINAL32
:dd.Get_Available_Drive_Letters
:dt.BOOLEAN
:dd.Reboot_Required
:dt.void
:dd.Set_Reboot_Flag
:dt.BOOLEAN
:dd.Get_Reboot_Flag
:dt.void
:dd.Set_Min_Install_Size
:dt.void
:dd.Start_Logging
:dt.void
:dd.Stop_Logging
:edl.
:p.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Constants
:p.The following sections describe constants defined in :hp2.lvm_intr.h:ehp2..
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Partition_Type constants
:p.The following defines are for use with the Partition_Type field in the Partition_Information_Record.
.br
:xmp.
#define FREE_SPACE_PARTITION     0
#define LVM_PARTITION            1
#define COMPATIBILITY_PARTITION  2
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Partition_Status constants
:p.The following defines are for use with the Partition_Status field in the Partition_Information_Record.
.br
:xmp.
#define PARTITION_IS_IN_USE      1
#define PARTITION_IS_AVAILABLE   2
#define PARTITION_IS_FREE_SPACE  0
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Device_Type constants
:p.The following define the device types used in the Device_Type field of the Volume_Control_Record.
.br
:xmp.
#define LVM_HARD_DRIVE  0
#define LVM_PRM         1
#define NON_LVM_CDROM   2
#define NETWORK_DRIVE   3
#define NON_LVM_DEVICE  4
:exmp.
:p.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Get_Valid_Options constants
:p.The following preprocessor directives define the operations that can be performed on
a partition, volume, or a block of free space.  These definitions represent bits in a 32
bit value returned by the Get_Valid_Options function.
.br
:xmp.
#define CREATE_PRIMARY_PARTITION        1
#define CREATE_LOGICAL_DRIVE            2
#define DELETE_PARTITION                4
#define SET_ACTIVE_PRIMARY              8
#define SET_PARTITION_ACTIVE           0x10
#define SET_PARTITION_INACTIVE         0x20
#define SET_STARTABLE                  0x40
#define INSTALL_BOOT_MANAGER           0x80
#define REMOVE_BOOT_MANAGER            0x100
#define SET_BOOT_MANAGER_DEFAULTS      0x200
#define ADD_TO_BOOT_MANAGER_MENU       0x400
#define REMOVE_FROM_BOOT_MANAGER_MENU  0x800
#define DELETE_VOLUME                  0x1000
#define HIDE_VOLUME                    0x2000
#define EXPAND_VOLUME                  0x4000
#define SET_VOLUME_INSTALLABLE         0x8000
#define ASSIGN_DRIVE_LETTER            0x10000
#define :link reftype=fn refid=EC_bootprimary.CAN_BOOT_PRIMARY:elink.               0x20000
#define :link reftype=fn refid=EC_bootlogical.CAN_BOOT_LOGICAL:elink.               0x40000
#define CAN_SET_NAME                   0x80000
#define SET_BOOT_MANAGER_STARTABLE     0x100000
:exmp.
:p.

:fn id=EC_bootprimary.
:p.If a primary is created from this block of free space, then it can be made bootable.
:efn.
:fn id=EC_bootlogical.
:p.If a logical drive is created from this block of free space, then OS/2 can boot from it by adding it to the boot manager menu.
:efn.

.* ............................................................................
:h3 x=left y=bottom width=100% height=100%.Error codes returned by the LVM Engine.
:p.Error codes returned by the LVM Engine&colon.
.br
:xmp.
#define LVM_ENGINE_NO_ERROR                            0
#define LVM_ENGINE_OUT_OF_MEMORY                       1
#define LVM_ENGINE_IO_ERROR                            2
#define LVM_ENGINE_BAD_HANDLE                          3
#define LVM_ENGINE_INTERNAL_ERROR                      4
#define LVM_ENGINE_ALREADY_OPEN                        5
#define LVM_ENGINE_NOT_OPEN                            6
#define LVM_ENGINE_NAME_TOO_BIG                        7
#define LVM_ENGINE_OPERATION_NOT_ALLOWED               8
#define LVM_ENGINE_DRIVE_OPEN_FAILURE                  9
#define LVM_ENGINE_BAD_PARTITION                      10
#define LVM_ENGINE_CAN_NOT_MAKE_PRIMARY_PARTITION     11
#define LVM_ENGINE_TOO_MANY_PRIMARY_PARTITIONS        12
#define LVM_ENGINE_CAN_NOT_MAKE_LOGICAL_DRIVE         13
#define LVM_ENGINE_REQUESTED_SIZE_TOO_BIG             14
#define LVM_ENGINE_1024_CYLINDER_LIMIT                15
#define LVM_ENGINE_PARTITION_ALIGNMENT_ERROR          16
#define LVM_ENGINE_REQUESTED_SIZE_TOO_SMALL           17
#define LVM_ENGINE_NOT_ENOUGH_FREE_SPACE              18
#define LVM_ENGINE_BAD_ALLOCATION_ALGORITHM           19
#define LVM_ENGINE_DUPLICATE_NAME                     20
#define LVM_ENGINE_BAD_NAME                           21
#define LVM_ENGINE_BAD_DRIVE_LETTER_PREFERENCE        22
#define LVM_ENGINE_NO_DRIVES_FOUND                    23
#define LVM_ENGINE_WRONG_VOLUME_TYPE                  24
#define LVM_ENGINE_VOLUME_TOO_SMALL                   25
#define LVM_ENGINE_BOOT_MANAGER_ALREADY_INSTALLED     26
#define LVM_ENGINE_BOOT_MANAGER_NOT_FOUND             27
#define LVM_ENGINE_INVALID_PARAMETER                  28
#define LVM_ENGINE_BAD_FEATURE_SET                    29
#define LVM_ENGINE_TOO_MANY_PARTITIONS_SPECIFIED      30
#define LVM_ENGINE_LVM_PARTITIONS_NOT_BOOTABLE        31
#define LVM_ENGINE_PARTITION_ALREADY_IN_USE           32
#define LVM_ENGINE_SELECTED_PARTITION_NOT_BOOTABLE    33
#define LVM_ENGINE_VOLUME_NOT_FOUND                   34
#define LVM_ENGINE_DRIVE_NOT_FOUND                    35
#define LVM_ENGINE_PARTITION_NOT_FOUND                36
#define LVM_ENGINE_TOO_MANY_FEATURES_ACTIVE           37
#define LVM_ENGINE_PARTITION_TOO_SMALL                38
#define LVM_ENGINE_MAX_PARTITIONS_ALREADY_IN_USE      39
#define LVM_ENGINE_IO_REQUEST_OUT_OF_RANGE            40
#define LVM_ENGINE_SPECIFIED_PARTITION_NOT_STARTABLE  41
#define LVM_ENGINE_SELECTED_VOLUME_NOT_STARTABLE      42
#define LVM_ENGINE_EXTENDFS_FAILED                    43
#define LVM_ENGINE_REBOOT_REQUIRED                    44
#define LVM_ENGINE_CAN_NOT_OPEN_LOG_FILE              45
#define LVM_ENGINE_CAN_NOT_WRITE_TO_LOG_FILE          46
#define LVM_ENGINE_REDISCOVER_FAILED                  47
#define LVM_ENGINE_INTERNAL_VERSION_FAILURE           48
#define LVM_ENGINE_PLUGIN_OPERATION_INCOMPLETE        49
#define LVM_ENGINE_BAD_FEATURE_ID                     50
#define LVM_ENGINE_NO_INIT_DATA                       51
#define LVM_ENGINE_NO_CONTEXT_DATA                    52
#define LVM_ENGINE_WRONG_CLASS_FOR_FEATURE            53
#define LVM_ENGINE_INCOMPATIBLE_FEATURES_SELECTED     54
#define LVM_ENGINE_NO_CHILDREN                        55
#define LVM_ENGINE_FEATURE_NOT_SUPPORTED_BY_INTERFACE 56
#define LVM_ENGINE_NO_PARENT                          57
#define LVM_ENGINE_VOLUME_HAS_NOT_BEEN_COMMITTED_YET  58
#define LVM_ENGINE_UNABLE_TO_REFERENCE_VOLUME         59
#define LVM_ENGINE_PARSING_ERROR                      60
#define LVM_ENGINE_INTERNAL_FEATURE_ERROR             61
#define LVM_ENGINE_VOLUME_NOT_CONVERTED               62
:exmp.


.* ----------------------------------------------------------------------------
:h2 x=left y=bottom width=100% height=100%.Data structures
:p.The follow sections define data structures defined in
:hp2.lvm_intr.h:ehp2..

.* ............................................................................
.* Drive_Control_Record
.*
:h3 x=left y=bottom width=100% height=100%.Drive_Control_Record
:p.The following are invariant for a disk drive.
.br
:xmp.
typedef struct _Drive_Control_Record {
    CARDINAL32   :link reftype=fn refid=DCR_drive_number.Drive_Number:elink.;
    CARDINAL32   :link reftype=fn refid=DCR_drive_size.Drive_Size:elink.;
    DoubleWord   :link reftype=fn refid=DCR_drive_serial_number.Drive_Serial_Number:elink.;
    ADDRESS      :link reftype=fn refid=DCR_drive_handle.Drive_Handle:elink.;
    CARDINAL32   :link reftype=fn refid=DCR_drive_cylinders.Cylinder_Count:elink.;
    CARDINAL32   :link reftype=fn refid=DCR_drive_heads.Heads_Per_Cylinder:elink.;
    CARDINAL32   :link reftype=fn refid=DCR_drive_sectors.Sectors_Per_Track:elink.;
    BOOLEAN      :link reftype=fn refid=DCR_drive_isprm.Drive_Is_PRM:elink.;
    BYTE         :link reftype=fn refid=DCR_reserved.Reserved[ 3 ]:elink.;
} Drive_Control_Record;
:exmp.
:p.

:fn id=DCR_drive_number.
:p.OS/2 Drive Number for this drive.
:efn.
:fn id=DCR_drive_size.
:p.The total number of sectors on the drive.
:efn.
:fn id=DCR_drive_serial_number.
:p.The serial number assigned to this drive.  For info. purposes only.
:efn.
:fn id=DCR_drive_handle.
:p.Handle used for operations on the disk that this record corresponds to.
:efn.
:fn id=DCR_drive_cylinders.
:p.The number of cylinders on the drive.
:efn.
:fn id=DCR_drive_heads.
:p.The number of heads per cylinder for this drive.
:efn.
:fn id=DCR_drive_sectors.
:p.The number of sectors per track for this drive.
:efn.
:fn id=DCR_drive_isprm.
:p.Set to TRUE if this drive is a PRM.
:efn.
:fn id=DCR_reserved.
:p.Alignment.
:efn.

.* ............................................................................
.* Drive_Control_Array
.*
:h3 x=left y=bottom width=100% height=100%.Drive_Control_Array
:p.The following structure is returned by the Get_Drive_Control_Data function.
.br
:xmp.
typedef struct _Drive_Control_Array {
    Drive_Control_Record *   :link reftype=fn refid=DCA_data.Drive_Control_Data:elink.;
    CARDINAL32               :link reftype=fn refid=DCA_count.Count:elink.;
} Drive_Control_Array;
:exmp.
:p.

:fn id=DCA_data.
:p.An array of drive control records.
:efn.

:fn id=DCA_count.
:p.The number of entries in the array of drive control records.
:efn.

.* ............................................................................
.* Drive_Information_Record
.*
:h3 x=left y=bottom width=100% height=100%.Drive_Information_Record
:p.The following structure defines the information that can be changed for a specific disk drive.
.br
:xmp.
typedef struct _Drive_Information_Record {
    CARDINAL32   :link reftype=fn refid=DIR_available.Total_Available_Sectors:elink.;
    CARDINAL32   :link reftype=fn refid=DIR_largest.Largest_Free_Block_Of_Sectors:elink.;
    BOOLEAN      :link reftype=fn refid=DIR_corrupt.Corrupt_Partition_Table:elink.;
    BOOLEAN      :link reftype=fn refid=DIR_unusable.Unusable:elink.;
    BOOLEAN      :link reftype=fn refid=DIR_ioerror.IO_Error:elink.;
    BOOLEAN      :link reftype=fn refid=DIR_bigfloppy.Is_Big_Floppy:elink.;
    char         :link reftype=fn refid=DIR_drive_name.Drive_Name[ DISK_NAME_SIZE ]:elink.;
} Drive_Information_Record;
:exmp.
:p.

:fn id=DIR_available.
:p.The number of sectors on the disk which are not currently assigned to a partition.
:efn.
:fn id=DIR_largest.
:p.The number of sectors in the largest contiguous block of available sectors.
:efn.
:fn id=DIR_corrupt.
:p.If TRUE, then the partitioning information found on the drive is incorrect!
:efn.
:fn id=DIR_unusable.
:p.If TRUE, the drive's MBR is not accessible and the drive can not be partitioned.
:efn.
:fn id=DIR_ioerror.
:p.If TRUE, then the last I/O operation on this drive failed!
:efn.
:fn id=DIR_bigfloppy.
:p.If TRUE, then the drive is a PRM formatted as a big floppy (i.e. the old style removable media support).
:efn.
:fn id=DIR_drive_name.
:p.User assigned name for this disk drive.
:efn.

.* ............................................................................
.* Partition_Information_Record
.*
:h3 x=left y=bottom width=100% height=100%.Partition_Information_Record
.br
:xmp.
typedef struct _Partition_Information_Record {
    ADDRESS      :link reftype=fn refid=PIR_partition_handle.Partition_Handle:elink.;
    ADDRESS      :link reftype=fn refid=PIR_volume_handle.Volume_Handle:elink.;
    ADDRESS      :link reftype=fn refid=PIR_drive_handle.Drive_Handle:elink.;
    DoubleWord   :link reftype=fn refid=PIR_partition_serial.Partition_Serial_Number:elink.;
    CARDINAL32   :link reftype=fn refid=PIR_partition_start.Partition_Start:elink.;
    CARDINAL32   :link reftype=fn refid=PIR_true_size.True_Partition_Size:elink.;
    CARDINAL32   :link reftype=fn refid=PIR_usable_size.Usable_Partition_Size:elink.;
    CARDINAL32   :link reftype=fn refid=PIR_boot_limit.Boot_Limit:elink.;
    BOOLEAN      :link reftype=fn refid=PIR_spanned_volume.Spanned_Volume:elink.;
    BOOLEAN      :link reftype=fn refid=PIR_primary.Primary_Partition:elink.;
    BYTE         :link reftype=fn refid=PIR_active.Active_Flag:elink.;
    BYTE         :link reftype=fn refid=PIR_osflag.OS_Flag:elink.;
    BYTE         :link reftype=fn refid=PIR_partition_type.Partition_Type:elink.;
    BYTE         :link reftype=fn refid=PIR_status.Partition_Status:elink.;
    BOOLEAN      :link reftype=fn refid=PIR_onbm.On_Boot_Manager_Menu:elink.;
    BYTE         :link reftype=fn refid=PIR_reserved.Reserved:elink.;
    char         :link reftype=fn refid=PIR_volume_letter.Volume_Drive_Letter:elink.;
    char         :link reftype=fn refid=PIR_drive_name.Drive_Name[ DISK_NAME_SIZE ]:elink.;
    char         :link reftype=fn refid=PIR_fs_name.File_System_Name[ FILESYSTEM_NAME_SIZE ]:elink.;
    char         :link reftype=fn refid=PIR_partition_name.Partition_Name[ PARTITION_NAME_SIZE ]:elink.;
    char         :link reftype=fn refid=PIR_volume_name.Volume_Name[ VOLUME_NAME_SIZE ]:elink.;
} Partition_Information_Record;
:exmp.
:p.

:fn id=PIR_partition_handle.
:p.The handle used to perform operations on this partition.
:efn.
:fn id=PIR_volume_handle.
:p.If this partition is part of a volume, this will be the handle of
the volume.  If this partition is NOT part of a volume, then this
handle will be 0.
:p.
:efn.
:fn id=PIR_drive_handle.
:p.The handle for the drive this partition resides on.
:efn.
:fn id=PIR_partition_serial.
:p.The serial number assigned to this partition.
:efn.
:fn id=PIR_partition_start.
:p.The LBA of the first sector of the partition.
:efn.
:fn id=PIR_true_size.
:p.The total number of sectors comprising the partition.
:efn.
:fn id=PIR_usable_size.
:p.The size of the partition as reported to the IFSM.  This is the
size of the partition less any LVM overhead.
:p.
:efn.
:fn id=PIR_boot_limit.
:p.The maximum number of sectors from this block of free space that can be used to
create a bootable partition if you allocate from the beginning of the block of
free space.
:p.
:efn.
:fn id=PIR_spanned_volume.
:p.TRUE if this partition is part of a multi-partition volume.
:efn.
:fn id=PIR_primary.
:p.True or False.  Any non-zero value here indicates that
this partition is a primary partition.  Zero here indicates
that this partition is a "logical drive" - i.e. it resides
inside of an extended partition.
:p.
:efn.
:fn id=PIR_active.
:p.80 = Partition is marked as being active.
.br
0 = Partition is not active.
:p.
:efn.
:fn id=PIR_osflag.
:p.This field is from the partition table.  It is known as the
OS flag, the Partition Type Field, Filesystem Type, and
various other names.
:p.Values of interest
:p.If this field is: (values are in hex)
:dl compact tsize=6.
:dt.07 =
:dd.The partition is a compatibility partition formatted for use
with an installable filesystem, such as HPFS or JFS.
:dt.00 =
:dd.Unformatted partition
:dt.01 =
:dd.FAT12 filesystem is in use on this partition.
:dt.04 =
:dd.FAT16 filesystem is in use on this partition.
:dt.0A =
:dd.OS/2 Boot Manager Partition
:dt.35 =
:dd.LVM partition
:dt.84 =
:dd.OS/2 FAT16 partition which has been relabeled by Boot Manager to "Hide" it.
:edl.
:p.
:efn.
:fn id=PIR_partition_type.
:dl compact tsize=5.
:dt.0 =
:dd.Free Space
:dt.1 =
:dd.LVM Partition (Part of an LVM Volume.)
:dt.2 =
:dd.Compatibility Partition
:edl.
:p.All other values are reserved for future use.
:p.
:efn.
:fn id=PIR_status.
:dl compact tsize=5.
:dt.0 =
:dd.Free Space
:dt.1 =
:dd.In Use - i.e. already assigned to a volume.
:dt.2 =
:dd.Available - i.e. not currently assigned to a volume.
:edl.
:p.
:efn.
:fn id=PIR_onbm.
:p.Set to TRUE if this partition is not part of a Volume yet is on the Boot Manager Menu.
:efn.
:fn id=PIR_reserved.
:p.Alignment.
:efn.
:fn id=PIR_volume_letter.
:p.The drive letter assigned to the volume that this partition is a part of.
:p.This field appears to reflect the
:link reftype=fn refid=VIR_letter_preference.Drive_Letter_Preference:elink. field
rather than the :link reftype=fn refid=VIR_current_letter.Current_Drive_Letter:elink.
field.

:efn.
:fn id=PIR_drive_name.
:p.User assigned name for this disk drive.
:efn.
:fn id=PIR_fs_name.
:p.The name of the filesystem in use on this partition, if it is known.
:p.Known values include 'HPFS', 'JFS', 'FAT16', 'FAT32', 'NTFS', 'UDF', 'CDFS',
'Linux' and '????'.
:p.Note that there is an apparent error in the current OS/2 implementation of
LVM.DLL which causes partition type 0x83 (Linux native) to be reported as '????'
while type 0x82 (Linux swap) is reported as 'Linux'.
:p.
:efn.
:fn id=PIR_partition_name.
:p.The user assigned name for this partition.
:efn.
:fn id=PIR_volume_name.
:p.If this partition is part of a volume, then this will be the
name of the volume that this partition is a part of.  If this
record represents free space, then the Volume_Name will be
"FREE SPACE xx", where xx is a unique numeric ID generated by
LVM.DLL.  Otherwise it will be an empty string.
:p.
:efn.

.* ............................................................................
.* Partition_Information_Array
.*
:h3 x=left y=bottom width=100% height=100%.Partition_Information_Array
:p.The following structure is returned by various functions in the LVM Engine.
.br
:xmp.
typedef struct _Partition_Information_Array {
    Partition_Information_Record * :link reftype=fn refid=PIA_array.Partition_Array:elink.;
    CARDINAL32                     :link reftype=fn refid=PIA_count.Count:elink.;
} Partition_Information_Array;
:exmp.
:p.

:fn id=PIA_array.
:p.An array of Partition_Information_Records.
:efn.
:fn id=PIA_count.
:p.The number of entries in the Partition_Array.
:efn.


.* ............................................................................
.* Volume_Control_Record
.*
:h3 x=left y=bottom width=100% height=100%.Volume_Control_Record
:p.The following items are invariant for a volume.
.br
:xmp.
typedef struct _Volume_Control_Record {
    DoubleWord :link reftype=fn refid=VCR_serial.Volume_Serial_Number:elink.;
    ADDRESS    :link reftype=fn refid=VCR_handle.Volume_Handle:elink.;
    BOOLEAN    :link reftype=fn refid=VCR_compatibility.Compatibility_Volume:elink.;
    BYTE       :link reftype=fn refid=VCR_devtype.Device_Type:elink.;
    BYTE       :link reftype=fn refid=VCR_reserved.Reserved[ 2 ]:elink.;
} Volume_Control_Record;
:exmp.
:p.

:fn id=VCR_serial.
:p.The serial number assigned to this volume.
:efn.
:fn id=VCR_handle.
:p.The handle used to perform operations on this volume.
:efn.
:fn id=VCR_compatibility.
:p.TRUE indicates that this volume is compatible with older versions of OS/2.
:p.FALSE indicates that this is an LVM specific volume and can not be used without OS2LVM.DMD.
:p.
:efn.
:fn id=VCR_devtype.
:p.Indicates what type of device the Volume resides on&colon.
:dl compact tsize=5.
:dt.0 =
:dd.Hard Drive under LVM Control
:dt.1 =
:dd.PRM under LVM Control
:dt.2 =
:dd.CD-ROM
:dt.3 =
:dd.Network drive
:dt.4 =
:dd.Unknown device NOT under LVM Control
:edl.
:p.
:efn.
:fn id=VCR_reserved.
:p.Alignment.
:efn.

.* ............................................................................
.* Volume_Control_Array
.*
:h3 x=left y=bottom width=100% height=100%.Volume_Control_Array
:p.The following structure is returned by the Get_Volume_Control_Data function.
.br
:xmp.
typedef struct _Volume_Control_Array {
    Volume_Control_Record *  :link reftype=fn refid=VCA_data.Volume_Control_Data:elink.;
    CARDINAL32               :link reftype=fn refid=VCA_count.Count:elink.;
} Volume_Control_Array;
:exmp.
:p.

:fn id=VCA_data.
:p.An array of volume control records.
:efn.
:fn id=VCA_count.
:p.The number of entries in the array of volume control records.
:efn.

.* ............................................................................
.* Volume_Information_Record
.*
:h3 x=left y=bottom width=100% height=100%.Volume_Information_Record
:p.The following information about a volume can (and often does) vary.
.br
:xmp.
typedef struct _Volume_Information_Record {
    CARDINAL32 :link reftype=fn refid=VIR_size.Volume_Size:elink.;
    CARDINAL32 :link reftype=fn refid=VIR_pcount.Partition_Count:elink.;
    CARDINAL32 :link reftype=fn refid=VIR_letter_conflict.Drive_Letter_Conflict:elink.;
    BOOLEAN    :link reftype=fn refid=VIR_compatibility.Compatibility_Volume:elink.;
    BOOLEAN    :link reftype=fn refid=VIR_bootable.Bootable:elink.;
    char       :link reftype=fn refid=VIR_letter_preference.Drive_Letter_Preference:elink.;
    char       :link reftype=fn refid=VIR_current_letter.Current_Drive_Letter:elink.;
    char       :link reftype=fn refid=VIR_initial_letter.Initial_Drive_Letter:elink.;
    BOOLEAN    :link reftype=fn refid=VIR_new_volume.New_Volume:elink.;
    BYTE       :link reftype=fn refid=VIR_status.Status:elink.;
    BYTE       Reserved_1;
    char       :link reftype=fn refid=VIR_volume_name.Volume_Name[ VOLUME_NAME_SIZE ]:elink.;
    char       :link reftype=fn refid=VIR_fs_name.File_System_Name[ FILESYSTEM_NAME_SIZE ]:elink.;
} Volume_Information_Record;
:exmp.
:p.

:fn id=VIR_size.
:p.The number of sectors comprising the volume.
:efn.
:fn id=VIR_pcount.
:p.The number of partitions which comprise this volume.
:efn.
:fn id=VIR_letter_conflict.
:dl compact tsize=3.
:dt.0
:dd.indicates that the drive letter preference for this volume is unique.
:dt.1
:dd.indicates that the drive letter preference for this volume
is not unique, but this volume got its preferred drive letter anyway.
:dt.2
:dd.indicates that the drive letter preference for this volume
is not unique, and this volume did NOT get its preferred drive letter.
:dt.4
:dd.indicates that this volume is currently "hidden" - i.e. it has
no drive letter preference at the current time.
:edl.
:efn.
:fn id=VIR_compatibility.
:p.TRUE if this is for a compatibility volume, FALSE otherwise.
:efn.
:fn id=VIR_bootable.
:p.Set to TRUE if this volume appears on the Boot Manager menu, or if it is
a compatibility volume and its corresponding partition is the first active
primary partition on the first drive.
:p.
:efn.
:fn id=VIR_letter_preference.
:p.The drive letter that this volume desires to be.  This typically corresponds
to a letter selected by the user or system administrator within the LVM
application.
:efn.
:fn id=VIR_current_letter.
:p.The drive letter currently used to access this volume.  May be different from
:link reftype=fn refid=VIR_letter_preference.Drive_Letter_Preference:elink. if
there was a conflict (i.e. Drive_Letter_Preference is already in use by another
volume).
:nt.When the volume drive letter is changed, the
:link reftype=fn refid=VIR_letter_preference.Drive_Letter_Preference:elink. field
reflects the requested change immediately; however, the Current_Drive_Letter
field will contain a null character (0x0) until the LVM engine is closed and
re-opened, even if the change was successful.
:p.This is presumably because a drive letter conflict could occur up to the point the
changes are committed.  The null character serves as a flag for the application to
indicate that the drive letter assignment is not yet fixed.:ent.
:p.
:efn.
:fn id=VIR_initial_letter.
:p.The drive letter assigned to this volume by the operating system when LVM was started.
This may be different from the
:link reftype=fn refid=VIR_letter_preference.Drive_Letter_Preference:elink. if there were
conflicts, and may be different from the
:link reftype=fn refid=VIR_current_letter.Current_Drive_Letter.  This will be 0x0 if the
volume did not exist when the LVM Engine was opened (i.e. it was created during this LVM
session).
:p.
:efn.
:fn id=VIR_new_volume.
:p.Set to FALSE if this volume existed before the LVM Engine was opened.  Set to
TRUE if this volume was created after the LVM Engine was opened.
:p.
:efn.
:fn id=VIR_status.
:dl compact tsize=5.
:dt.0 =
:dd.None.
:dt.1 =
:dd.Bootable
:dt.2 =
:dd.Startable
:dt.3 =
:dd.Installable.
:edl.
:efn.
:fn id=VIR_volume_name.
:p.The user assigned name for this volume.
:efn.
:fn id=VIR_fs_name.
:p.The name of the filesystem in use on this partition, if it is known.
:p.Known values include 'HPFS', 'JFS', 'FAT16', 'FAT32', 'NTFS', 'UDF', 'CDFS',
'Linux' and '????'.
:p.Note that there is an apparent error in the current OS/2 implementation of
LVM.DLL which causes partition type 0x83 (Linux native) to be reported as '????'
while type 0x82 (Linux swap) is reported as 'Linux'.
:p.
:efn.


.* ............................................................................
.* Feature_Information_Array
.*
:h3 x=left y=bottom width=100% height=100%.Feature_Information_Array
:p.The following structure is used to return the feature information for the installed features, or the features on a volume.
.br
:xmp.
typedef struct _Feature_Information_Array {
    CARDINAL32        Count;
    Feature_ID_Data * Feature_Data;
} Feature_Information_Array;
:exmp.
:p.

.* ............................................................................
.* Boot_Manager_Menu_Item
.*
:h3 x=left y=bottom width=100% height=100%.Boot_Manager_Menu_Item
:p.The following structure defines an item on the Boot Manager Menu.
.br
:xmp.
typedef struct _Boot_Manager_Menu_Item {
    ADDRESS     :link reftype=fn refid=BMMI_handle.Handle:elink.;
    BOOLEAN     :link reftype=fn refid=BMMI_volume.Volume:elink.;
} Boot_Manager_Menu_Item;
:exmp.
:p.

:fn id=BMMI_handle.
:p.A Volume or Partition handle.
:efn.
:fn id=BMMI_volume.
:p.If TRUE, then Handle is the handle of a Volume.  Otherwise, Handle is the handle of a partition.
:p.
:efn.


.* ............................................................................
.* Boot_Manager_Menu
.*
:h3 x=left y=bottom width=100% height=100%.Boot_Manager_Menu
:p.The following structure is used to get a list of the items on the partition manager menu.
.br
:xmp.
typedef struct _Boot_Manager_Menu {
    Boot_Manager_Menu_Item *  Menu_Items;
    CARDINAL32                Count;
} Boot_Manager_Menu;
:exmp.
:p.

.* ............................................................................
.* LVM_Feature_Specification_Record
.*
:h3 x=left y=bottom width=100% height=100%.LVM_Feature_Specification_Record
:p.The following structure is used to specify an LVM Feature when creating a volume.
Since LVM Features may be part of more than one LVM Class, the specific class to be
used with the feature must also be specified.
.br
:xmp.
typedef struct _LVM_Feature_Specification_Record {
    CARDINAL32       :link reftype=fn refid=LFSR_fid.Feature_ID:elink.;
    LVM_Classes      :link reftype=fn refid=LFSR_class.Actual_Class:elink.;
    ADDRESS          :link reftype=fn refid=LFSR_init.Init_Data:elink.;
} LVM_Feature_Specification_Record;
:exmp.
:p.

:fn id=LFSR_fid.
:p.The feature ID of the feature to use.
:efn.
:fn id=LFSR_class.
:p.The LVM Class (supported by the specified feature) to use.
:efn.
:fn id=LFSR_init.
:p.The address of a buffer containing initialization data for this feature.
NULL if there is no initialization data being provided for this feature.
:p.
:efn.

.* ............................................................................
.* LVM_Handle_Array_Record
.*
:h3 x=left y=bottom width=100% height=100%.LVM_Handle_Array_Record
:p.The following structure is used with the Get_Child_Handles function.
.br
:xmp.
typedef struct {
    CARDINAL32   Count;
    ADDRESS *    Handles;
} LVM_Handle_Array_Record;
:exmp.
:p.

.* ............................................................................
.*
.*
:h3 x=left y=bottom width=100% height=100%.Allocation_Algorithm
:p.The following enumeration defines the allocation strategies used by the Create_Partition function.
.br
:xmp.
typedef enum _Allocation_Algorithm {
    :link reftype=fn refid=AA_automatic.Automatic:elink.,
    :link reftype=fn refid=AA_best_fit.Best_Fit:elink.,
    :link reftype=fn refid=AA_first_fit.First_Fit:elink.,
    :link reftype=fn refid=AA_last_fit.Last_Fit:elink.,
    :link reftype=fn refid=AA_from_largest.From_Largest:elink.,
    :link reftype=fn refid=AA_from_smallest.From_Smallest:elink.,
    :link reftype=fn refid=AA_all.All:elink.
} Allocation_Algorithm;
:exmp.
:p.

:fn id=AA_automatic.
:p.Let LVM decide which block of free space to use to create the partition.
:efn.
:fn id=AA_best_fit.
:p.Use the block of free space which is closest in size to the partition being created.
:efn.
:fn id=AA_first_fit.
:p.Use the first block of free space on the disk which is large enough to hold a partition of the specified size.
:efn.
:fn id=AA_last_fit.
:p.Use the last block of free space on the disk which is large enough to hold a partition of the specified size.
:efn.
:fn id=AA_from_largest.
:p.Find the largest block of free space and allocate the partition from that block of free space.
:efn.
:fn id=AA_from_smallest.
:p.Find the smallest block of free space that can accommodate a partition of the size specified.
:efn.
:fn id=AA_all.
:p.Turn the specified drive or block of free space into a single partition.
:efn.


.* ----------------------------------------------------------------------------
.* Function Prototypes
.* ----------------------------------------------------------------------------

:h2 x=left y=bottom width=100% height=100%.Functions
:p.Function prototypes exported by LVM.DLL.

:p.The function prototype shown at the top of each page is the standard, 32-bit
version of the function.  All of these prototypes are included under the
preprocessor directive
.br
:xmp.
#ifndef USE_16_BIT_FUNCTIONS
:exmp.

:p.If &osq.USE_16_BIT_FUNCTIONS&csq. is defined, then 16-bit function
prototypes will be enabled instead.
:p.

:p.:hp5.16 Bit Functions:ehp5.

:p.Many LVM functions have equivalent 16-bit versions.  The function prototypes
for these are listed at the bottom of the page.

:p.There are two 16-bit function prototypes given.  The first is for use with
IBM VisualAge C/C++, and is included under the preprocessor directive
.br
:xmp.
#ifdef BUILD_LVM_ENGINE
:exmp.

:p.The second 16-bit function prototype is for use with other 16-bit compilers.
:p.


.* ----------------------------------------------------------------------------
.* Functions relating to the LVM engine itself.

:h3 x=left y=bottom width=100% height=100%.Functions relating to the LVM Engine itself
:p.Functions relating to the LVM Engine itself.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Open_LVM_Engine

:xmp.
void _System Open_LVM_Engine(

        BOOLEAN      Ignore_CHS,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.&colon.
:p.Opens the LVM Engine and readies it for use.
:p.

:p.:hp7.Input:ehp7.&colon.

:parml.
:pt.:hp5.BOOLEAN Ignore_CHS:ehp5.
:pd.If TRUE, then the LVM engine will not check the CHS values in the MBR/EBR
partition tables for validity.  This is useful if there are drive geometry
problems, such as the drive was partitioned and formatted with one geometry
and then moved to a different machine which uses a different geometry for the
drive.  This would cause the starting and ending CHS values in the partition
tables to be inconsistent with the size and partition offset entries in the
partition tables.  Setting Ignore_CHS to TRUE will disable the LVM Engine's
CHS consistency checks, thereby allowing the drive to be partitioned.

:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an error
occur.
:eparml.
:p.

:p.:hp7.Output:ehp7.&colon.
:p.*Error_Code will be 0 if this function completes successfully.  If an error
occurs, *Error_Code will contain a non-zero error code.
:p.

:p.:hp7.Error Handling:ehp7.&colon.
:p.If this function aborts with an error, all memory allocated during the course
of this function will be released.  Disk read errors will be reported to the
user via pop-up error messages.  Disk read errors will only cause this
function to abort if none of the disk drives in the system could be
successfully read.
:p.

:p.:hp7.Side Effects:ehp7.&colon.
:p.The LVM Engine will be initialized.  The partition tables for all OS2DASD
controlled disk drives will be read into memory.  Memory will be allocated for
the data structures used by the LVM Engine.
:p.

:p.:hp7.Notes:ehp7.&colon.
:p.This is provided for programs that used LVM Version 1.  This function assumes
an LVM_Interface_Type of VIO_Interface.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds OPEN_LVM_ENGINE16(
        BOOLEAN             Ignore_CHS,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds OPEN_LVM_ENGINE16(
        BOOLEAN          Ignore_CHS,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Open_LVM_Engine2
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
void _System Open_LVM_Engine2(

        BOOLEAN             Ignore_CHS,
        LVM_Interface_Types Interface_Type,
        CARDINAL32 *        Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.&colon.
:p.Opens the LVM Engine and readies it for use.
:p.

:p.:hp7.Input:ehp7.&colon.
:parml.
:pt.:hp5.BOOLEAN Ignore_CHS:ehp5.
:pd.If TRUE, then the LVM engine will not check the CHS values in the MBR/EBR
partition tables for validity.  This is useful if there are drive geometry
problems, such as the drive was partitioned and formatted with one geometry
and then moved to a different machine which uses a different geometry for the
drive.  This would cause the starting and ending CHS values in the partition
tables to be inconsistent with the size and partition offset entries in the
partition tables.  Setting Ignore_CHS to TRUE will disable the LVM Engine's
CHS consistency checks, thereby allowing the drive to be partitioned.

:pt.:hp5.LVM_Interface_Types Interface_Type :ehp5.
:pd.Indicate the type of user interface being used&colon.  PM_Interface,
VIO_Interface, or Java_Interface.  This lets the LVM Engine know which
interface support routines to call in any plugin modules which may be loaded.

:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.
:p.

:p.:hp7.Output:ehp7.&colon.
:p.*Error_Code will be 0 if this function completes successfully.  If an error
occurs, *Error_Code will contain a non-zero error code.
:p.

:p.:hp7.Error Handling:ehp7.&colon.
:p.If this function aborts with an error, all memory allocated during the
course of this function will be released.  Disk read errors will be reported
to the user via pop-up error messages.  Disk read errors will only cause this
function to abort if none of the disk drives in the system could be
successfully read.
:p.

:p.:hp7.Side Effects:ehp7.&colon.
:p.The LVM Engine will be initialized.  The partition tables for all OS2DASD
controlled disk drives will be read into memory.  Memory will be allocated for
the data structures used by the LVM Engine.
:p.

:p.:hp7.Notes:ehp7.&colon.
:p.None.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds OPEN_LVM_ENGINE216(
        BOOLEAN             Ignore_CHS,
        LVM_Interface_Types Interface_Type,
        CARDINAL32 *        _Seg16 Error_Code
);

void far pascal _loadds OPEN_LVM_ENGINE216(
        BOOLEAN          Ignore_CHS,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Commit_Changes

:xmp.
BOOLEAN _System Commit_Changes( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Saves any changes made to the partitioning information of the OS2DASD
controlled disk drives in the system.
:p.

:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in in which to store an error code should an
error occur.
:eparml.
:p.

:p.:hp7.Output:ehp7.
:p.The function return value will be TRUE if all of the partitioning/volume
changes made were successfully written to disk.  Also, *Error_Code will be 0
if no errors occur.

:p.If an error occurs, then the furnction return value will be FALSE and
*Error_Code will contain a non-zero error code.
:p.

:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, the function return value will be false and *Error_Code
will be > 0.

:p.Disk read and write errors will be indicated by setting the IO_Error field
of the Drive_Information_Record to TRUE.  Thus, if the function return value
is FALSE, and *Error_Code indicates an I/O error, the caller of this function
should call the Get_Drive_Status function on each drive to determine which
drives had I/O errors.

:p.If a read or write error occurs, then the engine may not have been able to
create a partition or volume.  Thus, the caller may want to refresh all
partition and volume data to see what the engine was and was not able to
create.
:p.

:p.:hp7.Side Effects:ehp7.
:p.The partitioning information of the disk drives in the system may be
altered.
:p.

:p.:hp7.Notes:ehp7.
:p.None.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
BOOLEAN _Far16 _Pascal _loadds COMMIT_CHANGES16( CARDINAL32 * _Seg16 Error_Code );

BOOLEAN far pascal _loadds COMMIT_CHANGES16( CARDINAL32 far * Error_Code );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Java_Call_Back
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
void _System Set_Java_Call_Back(

        void (* _System Execute_Java_Class) ( char * Class_Name,
                                              ADDRESS      InputBuffer,
                                              CARDINAL32   InputBufferSize,
                                              ADDRESS    * OutputBuffer,
                                              CARDINAL32 * OutputBufferSize,
                                              CARDINAL32 * Error_Code),
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.&colon.
:p.This function allows the calling Java program to set the call back address.
The call back address is used when the LVM Engine or one of its plug-ins,
needs to run a Java class to gather information from the user.
:p.

:p.:hp7.Input:ehp7.&colon.
:parml.
:pt.:hp5.void (* Execute_Java_Class) ...:ehp5.
:pd.The address of a function that the LVM engine may call when it needs a
Java class to be executed.  This is only required if the user interface being
used is written in Java

:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.&colon.
:p.If the function completes successfully, then *Error_Code will be set to
LVM_ENGINE_NO_ERROR.  Otherwise, *Error_Code will be set to a non-zero error
code.
:p.

:p.:hp7.Error Handling:ehp7.&colon.
:p.If an error occurs, the function will abort and *Error_Code will be set to
a non-zero error code.
:p.

:p.:hp7.Side Effects:ehp7.&colon.
:p.The Java call back address is set to point to the specified function.  Once
the Java call back address is set, LVM plug-ins which require the Java call
back will be enabled and can be used during the creation of LVM Volumes.
:p.

:p.:hp7.Notes:ehp7.&colon.
:p.If a Java interface is in use (as specified on the Open_LVM_Engine call),
then this function must be called in order to enable those LVM plug-ins which
require initialization information during the creation of an LVM Volume.  If
these plug-ins are not enabled, then they will not be reported by the
Get_Available_Features API, nor can they be used or accessed by any other LVM
Engine APIs.  Thus, this function should be called immediately after the
Open_LVM_Engine API is called.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Close_LVM_Engine

:xmp.
void _System Close_LVM_Engine ( void );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Closes the LVM Engine and frees any memory held by the LVM Engine.

:p.
:p.:hp7.Input:ehp7.
:p.None.

:p.
:p.:hp7.Output:ehp7.
:p.None.

:p.
:p.:hp7.Error Handling:ehp7.
:p.N/A

:p.
:p.:hp7.Side Effects:ehp7.
:p.Any memory held by the LVM Engine is released.

:p.
:p.:hp7.Notes:ehp7.
:p.None.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds CLOSE_LVM_ENGINE16( void );

void far pascal _loadds CLOSE_LVM_ENGINE16( void );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Available_Features

:xmp.
Feature_Information_Array _System Get_Available_Features( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns the feature ID information for each of the features that the LVM
Engine knows about.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If successful, a Feature_Information_Array structure is returned with a
non-zero Count.  Also, *Error_Code will be set to LVM_ENGINE_NO_ERROR.  If an
error occurs, then the Count field in the structure will be 0 and
(*Error_Code) will contain a non-zero error code.

:p.
:p.:hp7.Error Handling:ehp7.
:p.The only expected error is if this function is called while the LVM Engine
is not open.  This should be the only error condition.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Memory is allocated using the LVM Engine's memory manager for the array of
Feature_ID_Data items being returned.

:p.
:p.:hp7.Notes:ehp7.
:p.None.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Issue_Feature_Command
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
void _System Issue_Feature_Command(

        CARDINAL32   Feature_ID,
        ADDRESS      Handle,
        BOOLEAN      Ring0,
        ADDRESS      InputBuffer,
        CARDINAL32   InputSize,
        ADDRESS *    OutputBuffer,
        CARDINAL32 * OutputSize,
        CARDINAL32 * Error_Code
);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Issues a feature specific command to either the Ring 0 or Ring 3 portion of
the feature.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Feature_ID:ehp5.
:pd.The numeric ID assigned to the feature which is to receive the command
being issued.

:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of the volume, partition, or aggregate to which the feature
command is to be directed.

:pt.:hp5.BOOLEAN Ring0:ehp5.
:pd.If TRUE, then the command will be sent to the Ring 0 portion of the feature.
.br
If FALSE, then the command will be sent to the Ring 3 portion of the feature.

:pt.:hp5.ADDRESS InputBuffer:ehp5.
:pd.A buffer containing the command and any necessary information for the
feature to process the command.

:pt.:hp5.CARDINAL32 InputSize:ehp5.
:pd.The number of bytes in the InputBuffer.

:pt.:hp5.ADDRESS * OutputBuffer:ehp5.
:pd.The address of a variable used to hold the location of the output buffer
created by the feature in response to the command in InputBuffer.

:pt.:hp5.CARDINAL32 * OutputSize:ehp5.
:pd.The address of a variable used to hold the number of bytes in
*OutputBuffer.

:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If successful, then *Error_Code will be set to LVM_ENGINE_NO_ERROR.  If
unsuccessful, then *Error_Code will be set to a non-zero error code.
*OutputBuffer and *OutputSize are set by the feature.  If the feature
specified does not exist, then *OutputBuffer will be NULL and *Outputsize will
be 0.  If the feature does exist, then the value of *OutputBuffer and
*OutputSize depend upon the feature.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the specified feature does not exist, then
*Error_Code will contain a non-zero error code,
*OutputBuffer will be NULL, and *OutputSize will
be set to 0.  All other error conditions are
feature dependent.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Side effects are feature dependent.

:p.
:p.:hp7.Notes:ehp7.
:p.None.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Parse_Feature_Parameters
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
void _System Parse_Feature_Parameters(

        DLIST                              Tokens,
        LVM_Feature_Specification_Record * Feature_Data,
        char **                            Error_Message,
        CARDINAL32 *                       Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function allows access to the parsing function of an LVM Plug-in
Feature.  The specified feature will be passed a list of tokens to parse, and,
if it parses the tokens successfully, will produce a buffer containing
initialization data that can be used with the Create_Volume API.  If it
encounters an error, the current item in the Tokens list will be the offending
item, and a pointer to an error message will be returned.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.DLIST Tokens:ehp5.
:pd.A DLIST of tokens to parse.  Parsing will begin with the current entry in
the list and proceed until there is an error or until the specified feature
has found a complete command.  Each feature defines what commands it will
accept.

:pt.:hp5.LVM_Feature_Specification_Record * Feature_Data:ehp5.
:pd.A pointer to a record which contains the ID of the feature which is to
parse the DLIST of Tokens.  The other fields in this record will be filled in
by the feature if it successfully parses the tokens.

:pt.:hp5.char ** Error_Message:ehp5.
:pd.The address of a pointer to char. This will be set to NULL if the feature
successfully parses the list of tokens, or it will be set to point to an error
message if an error occurs.

:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 variable into which an error code may be
placed.  The error code will be LVM_ENGINE_NO_ERROR if this function completes
successfully, or a non-zero error code if an error occurs.
:eparml.

:p.:hp7.Output:ehp7.
:p.If there are no errors, the Actual_Class and Init_Data fields of
*Feature_Data will be set, *Error_Message will be set to NULL, and Error_Code
will be set to LVM_ENGINE_NO_ERROR.  The current item in the Tokens list will
be the first token that was not parsed by the feature (i.e. the first token
after the command accepted by the plug-in).

:p.If an error occurs, the values of Actual_Class and Init_Data in
*Feature_Data are undefined.  *Error_Code will be set to
LVM_ENGINE_PARSING_ERROR if the error is parsing related, or some other
non-zero value if the error is not parsing related.  If the error is parsing
related, then *Error_Message will point to an error message which can be
displayed for the user.  The current item in the Tokens list will be the token
which failed.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an parsing related error occurs, i.e. the tokens in the Tokens list do
not form a valid command accepted by the specified feature, then the current
item in the Tokens list will be the offending token, *Error_Message will be
set to point to an error message, and *Error_Code will be set to
LVM_ENGINE_PARSING_ERROR.

:p.If any other error occurs, the current item in the Tokens list will be the
token that was being processed when the error occurs, and *Error_Code will be
set to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The current item in the Tokens list may change.

:p.
:p.:hp7.Notes:ehp7.
:p.Each feature defines which commands it will accept, and therefore which
commands it will successfully parse.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Refresh_LVM_Engine

:xmp.
void _System  Refresh_LVM_Engine( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function causes the LVM Engine to look for changes in the current
system configuration and update its internal tables accordingly.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.None.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be set to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Volumes which represent non-LVM devices may have their handles changed!

:p.
:p.:hp7.Notes:ehp7.
:p.After calling this function, Get_Volume_Control_Data should be called to
get the updated list of volumes.  This is necessary as the handles of some
volumes may have changed.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds REFRESH_LVM_ENGINE16( CARDINAL32 * _Seg16 Error_Code );

void far pascal _loadds REFRESH_LVM_ENGINE16( CARDINAL32 far * Error_Code );
:exmp.
:p.


.* ----------------------------------------------------------------------------
.* Functions relating to Drives
:h3 x=left y=bottom width=100% height=100%.Functions relating to Drives
:p.Functions relating to drives.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Drive_Control_Data

:xmp.
Drive_Control_Array _System Get_Drive_Control_Data( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns an array of Drive_Control_Records.  These records
provide important information about the drives in the system and provide the
handles required to access them.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.A Drive_Control_Array structure is returned.  If no errors occur,
Drive_Control_Data will be non-NULL, Count will be greater than zero, and
*Error_Code will  be 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, the Drive_Control_Array returned by
this function will have NULL for Drive_Control_Data, and 0 for Count.
*Error_Code will be greater than 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.The caller becomes responsible for the memory allocated for the
array of Drive_Control_Records pointed to by Drive_Control_Data pointer in
the Drive_Control_Array structure returned by this function.  The caller
should free this memory when they are done using it.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_DRIVE_CONTROL_DATA16(
        Drive_Control_Record * _Seg16 * _Seg16 Drive_Control_Data,
        CARDINAL32 *                    _Seg16 Count,
        CARDINAL32 *                    _Seg16 Error_Code
);

void far pascal _loadds GET_DRIVE_CONTROL_DATA16(
        Drive_Control_Record far ** Drive_Control_Data,
        CARDINAL32 far *            Count,
        CARDINAL32 far *            Error_Code
);
:exmp.
:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Drive_Status

:xmp.
Drive_Information_Record _System Get_Drive_Status(

        ADDRESS      Drive_Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns the Drive_Information_Record for the drive
specified by Drive_Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Drive_Handle:ehp5.
:pd.The handle of the drive to use.  Drive handles
are obtained through the Get_Drive_Control_Data function.

:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an error
occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.This function returns the Drive_Information_Record for the drive
associated with the specified Drive_Handle.  If no errors occur, *Error_Code
will be set to 0.  If an error does occur, then *Error_Code will be non-zero.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, then *Error_Code will be non-zero.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_DRIVE_STATUS16(
        CARDINAL32                          Drive_Handle,
        Drive_Information_Record *   _Seg16 Drive_Status,
        CARDINAL32 *                 _Seg16 Error_Code
);

void far pascal _loadds GET_DRIVE_STATUS16(
        CARDINAL32                      Drive_Handle,
        Drive_Information_Record far *  Drive_Status,
        CARDINAL32 *                    Error_Code
);
:exmp.
:p.


.* ----------------------------------------------------------------------------
.* Functions relating to Partitions
:h3 x=left y=bottom width=100% height=100%.Functions relating to Partitions
:p.Functions relating to partitions.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Partitions

:xmp.
Partition_Information_Array _System Get_Partitions(

        ADDRESS      Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns an array of partitions associated with the object specified by
Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.This is the handle of a drive or volume.  Drive handles are obtained
through the Get_Drive_Control_Data function.  Volume handles are obtained
through the Get_Volume_Control_Data function.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.This function returns a structure.  The structure has two components: an
array of partition information records and the number of entries in the array.
If Handle is the handle of a disk drive, then the returned array will contain
a partition information record for each partition and block of free space on
that drive.  If Handle is the handle of a volume, then the returned array will
contain a partition information record for each partition which is part of the
specified volume.  If no errors occur, then *Error_Code will be 0.  If an
error does occur, then *Error_Code will be non-zero.

:p.
:p.:hp7.Error Handling:ehp7.
:p.Any memory allocated for the return value will be freed.  The
Partition_Information_Array returned by this function will contain a NULL
pointer for Partition_Array, and have a Count of 0.  *Error_Code will be
non-zero.

:p.If Handle is non-NULL and is invalid, a trap is likely.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Memory will be allocated to hold the array returned by this function.

:p.
:p.:hp7.Notes:ehp7.
:p.The caller becomes responsible for the memory allocated for the array of
Partition_Information_Records pointed to by Partition_Array pointer in the
Partition_Information_Array structure returned by this function.  The caller
should free this memory when they are done using it.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_PARTITIONS16(
        CARDINAL32                                     Handle,
        Partition_Information_Record * _Seg16 * _Seg16 Partition_Array,
        CARDINAL32 *                            _Seg16 Count,
        CARDINAL32 *                            _Seg16 Error_Code
);

void far pascal _loadds GET_PARTITIONS16(
        CARDINAL32                           Handle,
        Partition_Information_Record far * * Partition_Array,
        CARDINAL32 far *                     Count,
        CARDINAL32 far *                     Error_Code
);
:exmp.
:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Partition_Handle

:xmp.
ADDRESS _System Get_Partition_Handle(

        CARDINAL32   Serial_Number,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns the handle of the partition whose serial number matches the one
provided.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Serial_Number:ehp5.
:pd.This is the serial number to look for.  If a partition with a matching
serial number is found, its handle will be returned.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If a partition with a matching serial number is found, then the function
return value will be the handle of the partition found.  If no matching
partition is found, then the function return value will be NULL.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If no errors occur, *Error_Code will be LVM_ENGINE_NO_ERROR.  If an error
occurs, then *Error_Code will be a non-zero error code.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_PARTITION_HANDLE16(
        CARDINAL32          Serial_Number,
        CARDINAL32 * _Seg16 Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds GET_PARTITION_HANDLE16(
        CARDINAL32       Serial_Number,
        CARDINAL32 far * Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Partition_Information

:xmp.
Partition_Information_Record  _System Get_Partition_Information(

        ADDRESS      Partition_Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns the Partition_Information_Record for the partition specified by
Partition_Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Partition_Handle:ehp5.
:pd.The handle associated with the partition for which the
Partition_Information_Record is desired.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.A Partition_Information_Record is returned.  If there is no error, then
*Error_Code will be 0.  If an error occurs, *Error_Code will be non-zero.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the Partition_Handle is not a valid handle, a trap could result.  If it
is a handle for something other than a partition, an error code will be
returned in *Error_Code.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds  GET_PARTITION_INFORMATION16(
        CARDINAL32                            Partition_Handle,
        Partition_Information_Record * _Seg16 Partition_Information,
        CARDINAL32 *                   _Seg16 Error_Code
);

void far pascal _loadds  GET_PARTITION_INFORMATION16(
        CARDINAL32                         Partition_Handle,
        Partition_Information_Record far * Partition_Information,
        CARDINAL32 far *                   Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Create_Partition

:xmp.
ADDRESS _System Create_Partition(

        ADDRESS               Handle,
        CARDINAL32            Size,
        char                  Name[ PARTITION_NAME_SIZE ],
        Allocation_Algorithm  algorithm,
        BOOLEAN               Bootable,
        BOOLEAN               Primary_Partition,
        BOOLEAN               Allocate_From_Start,
        CARDINAL32 *          Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Creates a partition on a disk drive.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of a disk drive or a block of free space.
:pt.:hp5.CARDINAL32 Size:ehp5.
:pd.The size, in sectors, of the partition to create.
:pt.:hp5.char Name[]:ehp5.
:pd.The name to give to the newly created partition.
:pt.:hp5.Allocation_Algorithm algorithm:ehp5.
:pd.If Handle is a drive, then the engine will find a block of free space to
use to create the partition.  This tells the engine which memory management
algorithm to use.
:pt.:hp5.BOOLEAN Bootable:ehp5.
:pd.If TRUE, then the engine will only create the partition if it can be
booted from.  If Primary_Partition is FALSE, then it is assumed that OS/2 is
the operating system that will be booted.
:pt.:hp5.BOOLEAN Primary_Partition:ehp5.
:pd.If TRUE, then the engine will create a primary partition.
.br
If FALSE, then the engine will create a logical drive.
:pt.:hp5.BOOLEAN Allocate_From_Start:ehp5.
:pd.If TRUE, then the engine will allocate the new partition from the
beginning of the selected block of free space.  If FALSE, then the
partition will be allocated from the end of the selected block of free space.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.The function return value will be the handle of the partition created.  If
the partition could not be created, then NULL will be returned.

:p.*Error_Code will be 0 if the partition was created.
.br
*Error_Code will be > 0 if the partition could not be created.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the partition can not be created, then any memory allocated by this
function will be freed and the partitioning of the disk in question will be
unchanged.
:p.If Handle is not a valid handle, then a trap may result.
:p.If Handle represents a partition or volume, then the function will abort
and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A partition may be created on a disk drive.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
CARDINAL32 _Far16 _Pascal _loadds CREATE_PARTITION16(
        CARDINAL32           Handle,
        CARDINAL32           Size,
        char  *     _Seg16   Name,
        Allocation_Algorithm algorithm,
        BOOLEAN              Bootable,
        BOOLEAN              Primary_Partition,
        BOOLEAN              Allocate_From_Start,
        CARDINAL32 * _Seg16  Error_Code
);

CARDINAL32 far pascal _loadds CREATE_PARTITION16(
        CARDINAL32           Handle,
        CARDINAL32           Size,
        char far             Name[ PARTITION_NAME_SIZE ],
        Allocation_Algorithm algorithm,
        BOOLEAN              Bootable,
        BOOLEAN              Primary_Partition,
        BOOLEAN              Allocate_From_Start,
        CARDINAL32 far *     Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Delete_Partition

:xmp.
void _System Delete_Partition(

        ADDRESS      Partition_Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Deletes the partition specified by Partition_Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Partition_Handle:ehp5.
:pd.The handle associated with the partition to be deleted.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the partition was deleted successfully.
*Error_Code will be > 0 if the partition could not be deleted.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the partition can not be deleted, then *Error_Code will be > 0.
:p.If Partition_Handle is not a valid handle, a trap may result.
:p.If Partition_Handle is a volume or drive handle, then this function will
abort and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A partition on a disk drive may be deleted.

:p.
:p.:hp7.Notes:ehp7.
:p.A partition can not be deleted if it is part of a volume!

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds DELETE_PARTITION16(
        CARDINAL32          Partition_Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds DELETE_PARTITION16(
        CARDINAL32       Partition_Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Active_Flag

:xmp.
void _System Set_Active_Flag (

        ADDRESS      Partition_Handle,
        BYTE         Active_Flag,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Sets the Active Flag field for a partition.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Partition_Handle:ehp5.
:pd.The handle of the partition whose Active Flag is to be set
:pt.:hp5.BYTE Active_Flag:ehp5.
:pd.The new value for the Active Flag.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the Active Flag was successfully set, otherwise
*Error_Code will contain a non-zero error code indicating what went wrong.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the Active Flag can not be set, this function will abort without
changing any disk structures.

:p.If Partition_Handle is not a valid handle, a trap may result.

:p.If Partition_Handle is a volume or drive handle, then this function will
abort and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The Active Flag for a partition may be modified.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_ACTIVE_FLAG16(
        CARDINAL32          Partition_Handle,
        BYTE                Active_Flag,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_ACTIVE_FLAG16(
        CARDINAL32       Partition_Handle,
        BYTE             Active_Flag,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_OS_Flag

:xmp.
void _System Set_OS_Flag (

        ADDRESS      Partition_Handle,
        BYTE         OS_Flag,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Sets the OS Flag field for a partition.  This field is typically used to
indicate the filesystem used on the partition, which generally gives an
indication of which OS is using that partition.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Partition_Handle:ehp5.
:pd.The handle of the partition whose Active Flag is to be set
:pt.:hp5.BYTE OS_Flag:ehp5.
:pd.The new value for the OS Flag.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the OS Flag was successfully set, otherwise
*Error_Code will contain a non-zero error code indicating what went wrong.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the OS Flag can not be set, this function will abort without changing
any disk structures.

:p.If Partition_Handle is not a valid handle, a trap may result.

:p.If Partition_Handle is a volume or drive handle, then this function will
abort and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The OS Flag for a partition may be modified.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_OS_FLAG16(
        CARDINAL32          Partition_Handle,
        BYTE                OS_Flag,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_OS_FLAG16(
        CARDINAL32       Partition_Handle,
        BYTE             OS_Flag,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ----------------------------------------------------------------------------
.* Functions relating to volumes
:h3 x=left y=bottom width=100% height=100%.Functions relating to Volumes
:p.Functions relating to volumes.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Volume_Control_Data

:xmp.
Volume_Control_Array _System Get_Volume_Control_Data( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns a structure containing an array of
Volume_Control_Records.  These records contain information about volumes which
is invariant - i.e. will not change for as long as the volume exists.  One of
the items in the Volume_Control_Record is the handle for the volume.  This
handle must be used on all accesses to the volume.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.A Volume_Control_Array structure is returned.

:p.If there are no errors, then the Volume_Control_Data pointer in the
Volume_Control_Array will be non-NULL, the Count field of the
Volume_Control_Array will be
>= 0, and *Error_Code will be 0.

:p.If an error does occur, then the Volume_Control_Data pointer in the the
Volume_Control_Array will be NULL, the Count field of the Volume_Control_Array
will be 0, and *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, then any memory allocated by this function will be
freed.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Memory for the returned array is allocated.

:p.
:p.:hp7.Notes:ehp7.
:p.The caller becomes responsible for the memory allocated for the array of
Volume_Control_Records pointed to by Volume_Control_Data pointer in the
Volume_Control_Array structure returned by this function.  The caller should
free this memory when they are done using it.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_VOLUME_CONTROL_DATA16(
        Volume_Control_Record * _Seg16 * _Seg16 Volume_Control_Data,
        CARDINAL32 *                     _Seg16 Count,
        CARDINAL32 *                     _Seg16 Error_Code
);

void far pascal _loadds GET_VOLUME_CONTROL_DATA16(
        Volume_Control_Record far ** Volume_Control_Data,
        CARDINAL32 far *             Count,
        CARDINAL32 far *             Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Volume_Information

:xmp.
Volume_Information_Record _System Get_Volume_Information(

        ADDRESS      Volume_Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns the Volume_Information_Record for the volume
associated with Volume_Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Volume_Handle:ehp5.
:pd.The handle of the volume about which information is desired.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.This function returns a Volume_Information_Record.
:p.If this function is successful, then *Error_Code will be 0.
:p.If this function fails, then *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If Volume_Handle is not a valid handle, a trap will be likely.  If
Volume_Handle is a drive or partition handle, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_VOLUME_INFORMATION16(
        CARDINAL32                         Volume_Handle,
        Volume_Information_Record * _Seg16 Volume_Information,
        CARDINAL32 *                _Seg16 Error_Code

);

void far pascal _loadds GET_VOLUME_INFORMATION16(
        CARDINAL32                      Volume_Handle,
        Volume_Information_Record far * Volume_Information,
        CARDINAL32 far *                Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Create_Volume

:xmp.
void _System Create_Volume(

        char         Name[ VOLUME_NAME_SIZE ],
        BOOLEAN      Create_LVM_Volume,
        BOOLEAN      Bootable,
        char         Drive_Letter_Preference,
        CARDINAL32   FeaturesToUse,
        CARDINAL32   Partition_Count,
        ADDRESS      Partition_Handles[ ],
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function creates a volume from a list of partitions.  The partitions
are specified by their corresponding handles.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.char Name[]:ehp5.
:pd.The name to assign to the newly created volume.
:pt.:hp5.BOOLEAN Create_LVM_Volume:ehp5.
:pd.If TRUE, then an LVM volume is created, otherwise a compatibility volume
is created.
:pt.:hp5.BOOLEAN Bootable:ehp5.
:pd.If TRUE, the volume will not be created unless OS/2 can be booted from it.
:pt.:hp5.char Drive_Letter_Preference:ehp5.
:pd.This is the drive letter to use for accessing the newly created volume.
Specifying a non-alphabetic character will cause the volume to be created
without a drive letter.
:pt.:hp5.CARDINAL32 FeaturesToUse:ehp5.
:pd.This is currently reserved for future use and should always be set to 0.
:pt.:hp5.CARDINAL32 Partition_Count:ehp5.
:pd.The number of partitions to link together to form the volume being
created.
:pt.:hp5.ADDRESS Partition_Handles[]:ehp5.
:pd.An array of partition handles with one entry for each partition that is to
become part of the volume being created.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the volume was created.
.br
*Error_Code will be > 0 if the volume could not be created.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If any of the handles in the partition handles array is not valid, then a
trap is likely.  If Partition_Count is greater than the number of entries in
the partition handles array, then a trap is likely.  If any of the handles in
the partition array are not partition handles, then *Error_Code will be > 0.
If the volume can NOT be created, then *Error_Code will be > 0 and any memory
allocated by this function will be freed.  If the volume can NOT be created,
then the existing partition/volume structure of the disk will be unchanged.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A volume may be created.

:p.
:p.:hp7.Notes:ehp7.
:p.:hp9.(This note applies when the LVM Engine is LVM Version 2.):ehp9.
:p.This function provides limited compatibility for programs written to use
the LVM Version 1 interface.  Specifically, this function will only allow the
creation of compatibility volumes.  Any attempt to create an LVM volume will
result in an error code being returned.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds CREATE_VOLUME16(
        char   *     _Seg16 Name,
        BOOLEAN             Create_LVM_Volume,
        BOOLEAN             Bootable,
        char                Drive_Letter_Preference,
        CARDINAL32          FeaturesToUse,
        CARDINAL32          Partition_Count,
        CARDINAL32 * _Seg16 Partition_Handles,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds CREATE_VOLUME16(
        char far         Name[VOLUME_NAME_SIZE],
        BOOLEAN          Create_LVM_Volume,
        BOOLEAN          Bootable,
        char             Drive_Letter_Preference,
        CARDINAL32       FeaturesToUse,
        CARDINAL32       Partition_Count,
        CARDINAL32       Partition_Handles[],
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Create_Volume2
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
void _System Create_Volume2(

        char                               Name[ VOLUME_NAME_SIZE ],
        BOOLEAN                            Create_LVM_Volume,
        BOOLEAN                            Bootable,
        char                               Drive_Letter_Preference,
        CARDINAL32                         Feature_Count,
        LVM_Feature_Specification_Record   FeaturesToUse[ ],
        CARDINAL32                         Partition_Count,
        ADDRESS                            Partition_Handles[ ],
        CARDINAL32 *                       Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function creates a volume from a list of partitions.  The partitions
are specified by their corresponding handles.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.char Name[]:ehp5.
:pd.The name to assign to the newly created volume.
:pt.:hp5.BOOLEAN Create_LVM_Volume:ehp5.
:pd.If TRUE, then an LVM volume is created, otherwise a compatibility volume
is created.
:pt.:hp5.BOOLEAN Bootable:ehp5.
:pd.If TRUE, the volume will not be created unless OS/2 can be booted from it.
:pt.:hp5.char Drive_Letter_Preference:ehp5.
:pd.This is the drive letter to use for accessing the newly created volume.
Specifying a non-alphabetic character will cause the volume to be created
without a drive letter.
:pt.:hp5.CARDINAL32 Feature_Count:ehp5.
:pd.The number of features to install on the volume being created.  This field
is ignored if Create_LVM_Volume is FALSE.
:pt.:hp5.LVM_Feature_Specification_Record FeaturesToUse[]:ehp5.
:pd.An array of feature IDs and their associated LVM classes used to designate
which features to install on the volume being created and the order in which
to install them.  This field is ignored if Create_LVM_Volume is FALSE.
:pt.:hp5.CARDINAL32 Partition_Count:ehp5.
:pd.The number of partitions to link together to form the volume being created.
:pt.:hp5.ADDRESS Partition_Handles[]:ehp5.
:pd.An array of partition handles with one entry for each partition that is to
become part of the volume being created.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the volume was created.
.br
*Error_Code will be > 0 if the volume could not be created.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If any of the handles in the partition handles array is not valid, then a
trap is likely.  If Partition_Count is greater than the number of entries in
the partition handles array, then a trap is likely.  If any of the handles in
the partition array are not partition handles, then *Error_Code will be > 0.
If the volume can NOT be created, then *Error_Code will be > 0 and any memory
allocated by this function will be freed.  If the volume can NOT be created,
then the existing partition/volume structure of the disk will be unchanged.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A volume may be created.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds  CREATE_VOLUME216(
        char   * _Seg16                           Name,
        BOOLEAN                                   Create_LVM_Volume,
        BOOLEAN                                   Bootable,
        char                                      Drive_Letter_Preference,
        CARDINAL32                                Feature_Count,
        LVM_Feature_Specification_Record * _Seg16 FeaturesToUse,
        CARDINAL32                                Partition_Count,
        CARDINAL32 * _Seg16                       Partition_Handles,
        CARDINAL32 * _Seg16                       Error_Code
);

void far pascal _loadds CREATE_VOLUME216(
        char far  *                            Name,
        BOOLEAN                                Create_LVM_Volume,
        BOOLEAN                                Bootable,
        char                                   Drive_Letter_Preference,
        CARDINAL32                             Feature_Count,
        LVM_Feature_Specification_Record far * FeaturesToUse,
        CARDINAL32                             Partition_Count,
        CARDINAL32 far *                       Partition_Handles,
        CARDINAL32 far *                       Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Delete_Volume

:xmp.
void _System Delete_Volume(

        ADDRESS      Volume_Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Deletes the volume specified by Volume_Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Volume_Handle:ehp5.
:pd.The handle of the volume to delete.  All partitions which are part of the
specified volume will be deleted also.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the volume and its partitions are successfully
deleted.  Otherwise, *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.*Error_Code will be > 0 if an error occurs.  If the volume or any of its
partitions can not be deleted, then any changes made by this function will be
undone.

:p.If Volume_Handle is not a valid handle, a trap may result.

:p.If Volume_Handle is a partition or drive handle, then this function will
abort and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A volume and its partitions may be deleted.  System memory may be freed as
the internal structures used to track the deleted volume are no longer
required.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds DELETE_VOLUME16(
        CARDINAL32          Volume_Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds DELETE_VOLUME16(
        CARDINAL32       Volume_Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Hide_Volume

:xmp.
void _System Hide_Volume(

        ADDRESS      Volume_Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Hide volume "hides" a volume from OS/2 by removing its drive letter
assignment.  Without a drive letter assignment, OS/2 can not access (or "see")
the volume.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Volume_Handle:ehp5.
:pd.The handle of the volume to hide.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the volume was successfully hidden.  If the volume
could not be hidden, then *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.*Error_Code will be > 0 if the volume can not be hidden.  If the volume can
not be hidden, then nothing will be altered.
:p.If Volume_Handle is not a valid handle, a trap may result.
:p.If Volume_Handle is a partition or drive handle, then this function will
abort and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds HIDE_VOLUME16(
        CARDINAL32          Volume_Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds HIDE_VOLUME16(
        CARDINAL32       Volume_Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Expand_Volume

:xmp.
void _System Expand_Volume(

        ADDRESS         Volume_Handle,
        CARDINAL32      Partition_Count,
        ADDRESS         Partition_Handles[ ],
        CARDINAL32 *    Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function expands an existing volume by linking additional partitions
to it.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Volume_Handle:ehp5.
:pd.The handle of the volume to be expanded.
:pt.:hp5.CARDINAL32 Partition_Count:ehp5.
:pd.The number of partitions or volumes to be added to the volume being
expanded.
:pt.:hp5.ADDRESS Partition_Handles[]:ehp5.
:pd.An array of handles.  Each handle in the array is the handle of a
partition which is to be added to the volume being expanded.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the volume is successfully expanded.  If the
volume can not be expanded, *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the volume can not be expanded, the state of the volume is unchanged and
any memory allocated by this function is freed.
:p.If Volume_Handle is not a valid handle, a trap may result.
:p.If Volume_Handle is a partition or drive handle, then this function will
abort and set *Error_Code to a non-zero value.
:p.If any of the partition handles in the Partition_handles array are not
valid handles, then a trap may result.
:p.If any of the partition handles in the Partition_Handles array are actually
drive handles, then this function will abort and set *Error_Code to a non-zero
value.
:p.If Partition_Count is greater than the number of entries in the
Partition_Handles array, a trap may result.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A volume may be expanded.  If the volume is expanded using another volume,
the partitions on the second volume will be linked to those of the first
volume and all data on the second volume will be lost.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds EXPAND_VOLUME16(
        CARDINAL32          Volume_Handle,
        CARDINAL32          Partition_Count,
        CARDINAL32 * _Seg16 Partition_Handles,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds EXPAND_VOLUME16(
        CARDINAL32       Volume_Handle,
        CARDINAL32       Partition_Count,
        CARDINAL32 far   Partition_Handles[],
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Assign_Drive_Letter

:xmp.
void _System Assign_Drive_Letter(

        ADDRESS      Volume_Handle,
        char         New_Drive_Preference,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Assigns a drive letter to a volume.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Volume_Handle:ehp5.
:pd.The handle of the volume which is to have its assigned drive letter
changed.
:pt.:hp5.char New_Drive_Preference:ehp5.
:pd.The new drive letter to assign to the volume.  Specifying a non-alphabetic
character will cause the volume to be assigned no drive letter (i.e. it will
be hidden).
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the drive letter was assigned successfully;
otherwise *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the drive letter assignment can not be made, the volume will not be
altered.
:p.If Volume_Handle is not a valid handle, a trap may result.
:p.If Volume_Handle is a partition or drive handle, then this function will
abort and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A volume may have its drive letter assignment changed.

:p.
:p.:hp7.Notes:ehp7.
:p.If the drive letter being assigned is already in use by a volume which does
not lie on removable media, then the drive assignment will NOT be made.
:p.In the current OS/2 implementation, if the volume drive letter is changed,
the Current_Drive_Letter field within the volume's :hp2.Volume_Information_Record:ehp2.
(as returned by any subsequent call to :hp2.Get_Volume_Information():ehp2.) will
contain a null character, until changes are committed.  Refer to the
:link reftype=fn refid=VIR_current_letter.description of this field:elink. for details.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds ASSIGN_DRIVE_LETTER16(
        CARDINAL32          Volume_Handle,
        char                New_Drive_Preference,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds ASSIGN_DRIVE_LETTER16(
        CARDINAL32       Volume_Handle,
        char             New_Drive_Preference,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Installable

:xmp.
void _System Set_Installable (

        ADDRESS      Volume_Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Marks a volume as being the volume to install OS/2 on.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Volume_Handle:ehp5.
:pd.The handle of the volume to which OS/2 should be installed.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If the volume is successfully marked as installable, *Error_Code will be 0;
otherwise *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If Volume_Handle is not a valid handle, a trap may result.
:p.If Volume_Handle is a partition or drive handle, then this function will
abort and set *Error_Code to a non-zero value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The specified volume may be marked as installable.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_INSTALLABLE16(
        CARDINAL32          Volume_Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_INSTALLABLE16(
        CARDINAL32       Volume_Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Installable_Volume

:xmp.
Volume_Information_Record _System Get_Installable_Volume ( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Marks a volume as being the volume to install OS/2 on.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If a volume is mared installable, its information will
be returned and *Error_Code will be LVM_ENGINE_NO_ERROR.
If there is no volume marked installable, then *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.An error code is returned if there is an error.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp5.Notes:ehp5.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_INSTALLABLE_VOLUME16(
        Volume_Information_Record * _Seg16  Volume_Information,
        CARDINAL32 *                _Seg16  Error_Code
);

void far pascal _loadds GET_INSTALLABLE_VOLUME16(
        Volume_Information_Record * Volume_Information,
        CARDINAL32 far *            Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Convert_Volumes_To_V1
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
CARDINAL32 _System Convert_Volumes_To_V1 (

    BOOLEAN *    Hidden_Volume_Conversion_Failure,
    CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function attempts to convert all LVM volumes in the system into a
format that can be used by LVM Version 1, which was shipped with Warp Server
for e-business.  This function returns a bitmap of the drive letters
corresponding to Volumes that can not be converted.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.BOOLEAN * Hidden_Volume_Conversion_Failure:ehp5.
:pd.The address of a BOOLEAN variable in which to store a flag indicating if
there were hidden volumes that could not be converted.  If
*Hidden_Volume_Conversion_Failure is TRUE, then there were hidden volumes that
could not be converted.  If FALSE, then there were no hidden volumes, or the
hidden volumes that existed were converted successfully.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.This function returns a bitmap of the drive letters corresponding to
volumes that could not be converted to LVM Version 1 format.  If this function
is successful and all volumes were converted, then *Error_Code will be set to
LVM_ENGINE_NO_ERROR and the bitmap returned will have no bits set.  If this
function failes, *Error_Code will contain a non-zero error code and the bitmap
returned by this function may be non-zero.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.All LVM volumes that can be converted to LVM Version 1 format will be.

:p.
:p.:hp7.Notes:ehp7.
:p.Bit 0 in the bitmap returned by this function represents drive letter 'A'.
:p.


.* ----------------------------------------------------------------------------
.* Functions relating to Partitions, Drives, and Volumes.
:h3 x=left y=bottom width=100% height=100%.Functions relating to Partitions, Drives, and Volumes.
:p.Functions relating to partitions, drives, and volumes.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Name

:xmp.
void _System Set_Name (

        ADDRESS      Handle,
        char         New_Name[],
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Sets the name of a volume, drive, or partition

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of the drive, partition, or
volume which is to have its name set.
:pt.:hp5.char New_Name[]:ehp5.
:pd.The new name for the drive/partition/volume.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the name is set as specified.
If the name can not be set, *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the name can not be set, then drive/volume/partition is not modified.

:p.If Handle is not a valid handle, a trap may result.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A drive/volume/partition may have its name set.

:p.
:p.:hp7.Notes:ehp7.
:p.None.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_NAME16(
        CARDINAL32          Handle,
        char       * _Seg16 New_Name,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_NAME16(
        CARDINAL32       Handle,
        char  far        New_Name[ ],
        CARDINAL32 far * Error_Code
);
:exmp.
:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Startable

:xmp.
void _System Set_Startable(

        ADDRESS      Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Sets the specified volume or partition
startable.  If a volume is specified, it must
be a compatibility volume whose partition is
a primary partition on the first drive.  If a
partition is specified, it must be a primary
partition on the first drive in the system.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of the partition or volume which is to be set startable.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the specified volume or
partition was set startable.
If the name can not be set, *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the volume or partition could not be set
startable, then nothing in the system is changed.

:p.If Handle is not a valid handle, a trap may result.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Any other partition or volume which is marked
startable will have its startable flag cleared.

:p.
:p.:hp7.Notes:ehp7.
:p.None.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void  _Far16 _Pascal _loadds SET_STARTABLE16(
        CARDINAL32          Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_STARTABLE16(
        CARDINAL32       Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Valid_Options

:xmp.
CARDINAL32 _System Get_Valid_Options(

        ADDRESS      Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns a bitmap where each bit in the bitmap
corresponds to a possible operation that the
LVM Engine can perform.  Those bits which are
1 represent operations which can be performed
on the item specified by Handle.  Those bits
which are 0 are not allowed on the item
specified by Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.This is any valid drive, volume, or partition handle.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.A bitmap indicating which operations are valid on the
item specified by Handle.

:p.If no errors occur, *Error_Code will be 0, otherwise
*Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If Handle is not valid, a trap will be likely.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.The values of the various bits in the bitmap returned
by this function are defined near the beginning of this
file, immediately after all of the structure
definitions.
:p.

:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
CARDINAL32 _Far16 _Pascal _loadds GET_VALID_OPTIONS16(
        CARDINAL32          Handle,
        CARDINAL32 * _Seg16 Error_Code
);

CARDINAL32 far pascal _loadds GET_VALID_OPTIONS16(
        CARDINAL32       Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Child_Handles
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
LVM_Handle_Array_Record  _System Get_Child_Handles(

        ADDRESS      Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Given the handle of a volume or aggregate,
this function will return the handles of the
children of the volume or aggregate.  This
allows the entire tree representation of a
volume to be traversed, a level at a time.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of the volume or aggregate whose children are required.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If successful, an LVM_Handle_Array_Record is returned
with a non-zero Count.  Also, *Error_Code will be set
to LVM_ENGINE_NO_ERROR.  If an error occurs, then
the Count field will be 0 and *Error_Code will contain
a non-zero error code.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If Handle is not a valid handle, then a trap is
likely.  If Handle is the handle of partition,
then *Error_Code will be set to
LVM_ENGINE_NO_CHILDREN.  If Handle is not a
volume or aggregate handle, then *Error_Code
will be set to LVM_ENGINE_BAD_HANDLE.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Parent_Handle
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
ADDRESS _System Get_Parent_Handle(

        ADDRESS      Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Given the handle of a partition or aggregate,
this function will return the handle of the
parent of the partition or aggregate.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of the partition or aggregate whose parent is required.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If successful, the handle of the parent is returned
as the function result and *Error_Code will be set to
LVM_ENGINE_NO_ERROR.
If an error occurs, then NULL will be the function
result and *Error_Code will contain a non-zero error
code.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If Handle is not a valid handle, then a trap is
likely.  If Handle is the handle of volume,
then *Error_Code will be set to
LVM_ENGINE_NO_PARENT.  If Handle is not the
handle of a volume, partition, or aggregate
then *Error_Code will be set to
LVM_ENGINE_BAD_HANDLE.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp5.Notes:ehp5.
:p.None.

:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Features
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
Feature_Information_Array _System Get_Features(

        ADDRESS      Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns the feature ID information for each of
the features that are installed on the item specified by Handle.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of the object to use.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If successful, a Feature_Information_Array structure is
returned with a non-zero Count.  Also, *Error_Code will
be set to LVM_ENGINE_NO_ERROR.  If an error occurs,
then the Count field in the structure will be 0 and
(*Error_Code) will contain a non-zero error code.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If Handle is not a valid handle, a trap
will be likely.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Memory is allocated using the LVM Engine's memory
manager for the array of Feature_ID_Data items
being returned.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.


.* ----------------------------------------------------------------------------
.* Functions relating to Boot Manager
:h3 x=left y=bottom width=100% height=100%.Functions relating to Boot Manager
:p.Functions relating to Boot Manager.
:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Boot_Manager_Is_Installed

:xmp.
BOOLEAN _System Boot_Manager_Is_Installed(

        BOOLEAN *    Active,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Indicates whether or not Boot Manager is
installed on the first or second hard drives
in the system.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.BOOLEAN * Active:ehp5.
:pd.*Active is set to TRUE if LVM found an
active copy of Boot Manager on the
system.  If LVM could not find an
active copy of Boot Manager on the
system, but did find an inactive copy
of Boot Manager, then *Active will be
set to FALSE.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.TRUE is returned if Boot Manager is found.  If this
copy of Boot Manager is Active, then *Active will be set
to TRUE.  If the copy of Boot Manager is not currently
active, then *Active will be set to FALSE.

:p.FALSE is returned if Boot Manager is not found or if an
error occurs.  In this case, *Active is undefined.

:p.*Error_Code will be 0 if no errors occur; otherwise it
will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.Current OS/2 implementations of this function appear to be unreliable,
and calling it may cause a segmentation fault in some circumstances.  You
are recommended to use the :hp2.Get_Boot_Manager_Handle():ehp2. function
for this purpose instead.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
BOOLEAN _Far16 _Pascal _loadds BOOT_MANAGER_IS_INSTALLED16(
        BOOLEAN * _Seg16    Active,
        CARDINAL32 * _Seg16 Error_Code
);

BOOLEAN far pascal _loadds BOOT_MANAGER_IS_INSTALLED16(
        BOOLEAN far *    Active,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Boot_Manager_Handle

:xmp.
ADDRESS _System Get_Boot_Manager_Handle( CARDINAL32 * Error_Code);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns the handle of the partition containing Boot Manager.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If Boot Manager is NOT installed, NULL is returned.
If Boot Manager is installed, whether it is active or
not, the handle of the partition it resides in is
returned.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
ADDRESS _Far16 _Pascal _loadds GET_BOOT_MANAGER_HANDLE16( CARDINAL32 * _Seg16 Error_Code);

ADDRESS far _pascal _loadds GET_BOOT_MANAGER_HANDLE16( CARDINAL32 far * Error_Code);
:exmp.
:p.



.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Add_To_Boot_Manager

:xmp.
void _System Add_To_Boot_Manager(

        ADDRESS Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Adds the volume/partition to the Boot Manager menu.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of a partition or volume that
is to be added to the Boot Manager menu.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the partition or volume was
successfully added to the Boot Manager menu; otherwise
*Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the partition/volume can not be added to the
Boot Manager menu, no action is taken and
*Error_Code will contain a non-zero error code.

:p.If Handle is not a valid handle, a trap may
result.

:p.If Handle represents a drive, then this function
will abort and set *Error_Code to a non-zero
value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The Boot Manager menu may be altered.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds ADD_TO_BOOT_MANAGER16(
        CARDINAL32          Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds ADD_TO_BOOT_MANAGER16(
        CARDINAL32       Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Remove_From_Boot_Manager

:xmp.
void _System Remove_From_Boot_Manager(

        ADDRESS Handle,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Removes the specified partition or volume from the Boot Manager menu.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the partition or volume was
successfully removed to the Boot Manager menu;
otherwise *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If Handle is not a valid handle, a trap may result.

:p.If Handle represents a drive, or if Handle
represents a volume or partition which is NOT on
the boot manager menu, then this function
will abort and set *Error_Code to a non-zero
value.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The Boot Manager menu may be altered.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds REMOVE_FROM_BOOT_MANAGER16(
        CARDINAL32          Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds REMOVE_FROM_BOOT_MANAGER16(
        CARDINAL32       Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Boot_Manager_Menu

:xmp.
Boot_Manager_Menu  _System Get_Boot_Manager_Menu( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Returns an array containing the handles of the
partitions and volumes appearing on the
Boot Manager menu.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.The function returns a Boot_Manager_Menu structure.
This structure contains two items: a pointer to an array
of Boot_Manager_Menu_Items and a count of how many items
are in the array.  Each Boot_Manager_Menu_Item contains
a handle and a BOOLEAN variable to indicate whether the
handle is for a partition or a volume.

:p.If this function is successful, then *Error_Code will
be 0.

:p.If an error occurs, the Count field in the
Boot_Manager_Menu will be 0 and the corresponding
pointer will be NULL.  *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.
any memory allocated by this function will be
freed.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_BOOT_MANAGER_MENU16(
        Boot_Manager_Menu_Item * _Seg16 * _Seg16 Menu_Items,
        CARDINAL32 *                      _Seg16 Count,
        CARDINAL32 *                      _Seg16 Error_Code
);

void far pascal _loadds GET_BOOT_MANAGER_MENU16(
        Boot_Manager_Menu_Item ** Menu_Items,
        CARDINAL32 *              Count,
        CARDINAL32 *              Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Install_Boot_Manager

:xmp.
void _System Install_Boot_Manager (

        CARDINAL32   Drive_Number,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function installs Boot Manager.  It can
be used to replace an existing Boot Manager
as well.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32  Drive_Number:ehp5.
:pd.The number of the drive (starting from 1) to install Boot Manager on.
Must be 1 or 2.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If this function is successful, then *Error_Code will be
0; otherwise it will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be set to a
non-zero value.  Depending upon the error, it
is possible that the Boot Manager partition can
be left in an unusuable state (such as for a
write error).

:p.
:p.:hp7.Side Effects:ehp7.
:p.Boot Manager may be installed on drive 1 or 2.
The MBR for drive 1 may be altered.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds INSTALL_BOOT_MANAGER16(
        CARDINAL32          Drive_Number,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds INSTALL_BOOT_MANAGER16(
        CARDINAL32       Drive_Number,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Remove_Boot_Manager

:xmp.
void _System Remove_Boot_Manager( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Removes Boot Manager from the system.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if Boot Manager was successfully
removed from the system; otherwise *Error_Code will
be 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Boot Manager will be removed from the system.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds REMOVE_BOOT_MANAGER16( CARDINAL32 * _Seg16 Error_Code );

void far pascal _loadds REMOVE_BOOT_MANAGER16( CARDINAL32 far * Error_Code );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Boot_Manager_Options

:xmp.
void _System Set_Boot_Manager_Options(

        ADDRESS      Handle,
        BOOLEAN      Timer_Active,
        CARDINAL32   Time_Out_Value,
        BOOLEAN      Advanced_Mode,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Sets the Boot Managers Options.  The options
that can be set are: whether or not the time-
out timer is active, how long the timer-out
is, the partition to boot by default, and
whether or not Boot Manager should display its
menu using default mode or advanced mode.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Handle:ehp5.
:pd.The handle of the partition or volume to boot if the time-out timer is active
and the time-out value is reached.
:p.Specifying a NULL handle will cause Boot Manager to default to the last-booted volume.
:pt.:hp5.BOOLEAN Timer_Active:ehp5.
:pd.If TRUE, then the time-out timer is active.
:pt.:hp5.CARDINAL32 Time_Out_Value:ehp5.
:pd.If the time-out timer is active, this is the time-out
value, in seconds.
:pt.:hp5.BOOLEAN Advanced_Mode:ehp5.
:pd.If TRUE, then Boot Manager will operate in advanced mode.  If
FALSE, then normal mode will be in effect.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if no errors occur.  If an error
does occur, then *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, no changes will be made to
Boot Manager and *Error_Code will be set a
non-zero error code.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Boot Manager may be modified.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_BOOT_MANAGER_OPTIONS16(
        CARDINAL32          Handle,
        BOOLEAN             Timer_Active,
        CARDINAL32          Time_Out_Value,
        BOOLEAN             Advanced_Mode,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_BOOT_MANAGER_OPTIONS16(
        CARDINAL32       Handle,
        BOOLEAN          Timer_Active,
        CARDINAL32       Time_Out_Value,
        BOOLEAN          Advanced_Mode,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Boot_Manager_Options

:xmp.
void _System Get_Boot_Manager_Options(

        ADDRESS    * Handle,
        BOOLEAN    * Handle_Is_Volume,
        BOOLEAN    * Timer_Active,
        CARDINAL32 * Time_Out_Value,
        BOOLEAN    * Advanced_Mode,
        CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns the current Boot Manager
settings for the various Boot Manager options.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS * Handle:ehp5.
:pd.The handle for the default boot volume or partition.
:pt.:hp5.BOOLEAN * Handle_Is_Volume:ehp5.
:pd.If TRUE, then Handle represents a volume.  If
FALSE, then Handle represents a partition.
:pt.:hp5.BOOLEAN * Timer_Active:ehp5.
:pd.If TRUE, then the time-out timer is active.  If FALSE, then the
time-out timer is not active.
:pt.:hp5.CARDINAL32 * Time_Out_Value:ehp5.
:pd.If the time-out timer is active, then this is the
number of seconds that Boot Manager will wait for user
input before booting the default volume/partition.
:pt.:hp5.BOOLEAN * Advanced_Mode:ehp5.
:pd.If TRUE, the Boot Manager is operating in advanced mode.  If
FALSE, then Boot Manager is operating in normal mode.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Handle, *Handle_Is_Volume, *Timer_Active,
*Time_out_value, *Advanced_Mode, and *Error_Code are all
set by this function.  If there are no errors, then
*Error_Code will be set to 0.  If any errors occur, then
*Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If any of the parameters are invalid, then a
trap is likely.  If Boot Manager is not
installed, then *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds GET_BOOT_MANAGER_OPTIONS16(
        CARDINAL32 * _Seg16 Handle,
        BOOLEAN    * _Seg16 Handle_Is_Volume,
        BOOLEAN    * _Seg16 Timer_Active,
        CARDINAL32 * _Seg16 Time_Out_Value,
        BOOLEAN    * _Seg16 Advanced_Mode,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds GET_BOOT_MANAGER_OPTIONS16(
        CARDINAL32 far * Handle,
        BOOLEAN    far * Handle_Is_Volume,
        BOOLEAN    far * Timer_Active,
        CARDINAL32 far * Time_Out_Value,
        BOOLEAN    far * Advanced_Mode,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ----------------------------------------------------------------------------
.* Other Functions
:h3 x=left y=bottom width=100% height=100%.Other Functions
:p.Other functions.
:p.

.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Allocate_Engine_Memory
:p.:hp9.LVM Version 2 only:ehp9.
:p.

:xmp.
ADDRESS _System Allocate_Engine_Memory( CARDINAL32 Size );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Allocates a block of memory using LVM.DLL's
memory management functions.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Size:ehp5.
:pd.The number of bytes of memory to allocate.
:eparml.

:p.:hp7.Output:ehp7.
:p.The address of the block of memory which was allocated,
or NULL if the requested amount of memory could not be
allocated.

:p.
:p.:hp7.Error Handling:ehp7.
:p.None.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The specified number of bytes is allocated from
the memory manager imbedded in LVM.DLL.  Memory
allocated by this function must be freed using
Free_Engine_Memory function.  The use of any
memory manager to free the memory could result in
Bad Things Happening!

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Free_Engine_Memory

:xmp.
void _System Free_Engine_Memory( ADDRESS Object );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Frees a memory object created by LVM.DLL and
returned to a user of LVM.DLL.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Object:ehp5.
:pd.The address of the memory object to
free.  This could be the Drive_Control_Data field of a
Drive_Control_Record, the Partition_Array field of a
Partition_Information_Array structure, or any other dynamically allocated
memory object created by LVM.DLL and returned by a function in LVM.DLL.
:eparml.

:p.:hp7.Output:ehp7.
:p.None.

:p.
:p.:hp7.Error Handling:ehp7.
:p.None.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.A trap or exception could occur if a bad address is
passed into this function.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds FREE_ENGINE_MEMORY16( ADDRESS _Seg16 Object );

void far pascal _loadds FREE_ENGINE_MEMORY16( CARDINAL32 Object );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.New_MBR

:xmp.
void _System New_MBR(

    ADDRESS      Drive_Handle,
    CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function lays down a new MBR on the specified drive.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.ADDRESS Drive_Handle:ehp5.
:pd.The handle of the drive on which the new MBR is to be placed.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an
error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if the new MBR was successfully
placed on the specified drive.  If the operation failed
for any reason, then *Error_Code will contain a non-zero
error code.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, then the existing MBR is not
altered and *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A new MBR may be placed on the specified drive.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds NEW_MBR16(
        CARDINAL32          Drive_Handle,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds NEW_MBR16(
        CARDINAL32       Drive_Handle,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Available_Drive_Letters

:xmp.
CARDINAL32 _System Get_Available_Drive_Letters ( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns a bitmap indicating which drive letters are available
for use.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an error
occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.This function returns a bitmap of the available drive letters.  If this
function is successful, then *Error_Code will be set to 0.  Otherwise,
*Error_Code will be > 0 and the bitmap returned will have all bits set to 0.
:p.Drive letters &osq.A&csq. through &osq.Z&csq. are represented in the bitmap
from right to left.  In other words, &osq.A&csq. is 0x00000001 and &osq.Z&csq.
is 0x02000000.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.A drive letter is available if it is not associated with a volume located on
a disk drive controlled by OS2DASD.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
CARDINAL32 _Far16 _Pascal _loadds GET_AVAILABLE_DRIVE_LETTERS16( CARDINAL32 * _Seg16 Error_Code );

CARDINAL32 far pascal _loadds GET_AVAILABLE_DRIVE_LETTERS16( CARDINAL32 far * Error_Code ) ;
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Reserved_Drive_Letters

:xmp.
CARDINAL32 _System Get_Reserved_Drive_Letters ( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns a bitmap indicating which drive letters are reserved
for use by devices NOT under the control of LVM.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code should an error
occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.This function returns a bitmap of the drive letters which are being used by
devices which are NOT controlled by LVM.  While a Volume CAN be assigned a drive
letter from this list, a reboot will almost always be required in order for the
assignment to take place.
:p.If this function is successful, then *Error_Code will be set to 0.
Otherwise, *Error_Code will be > 0 and the bitmap returned will have all bits
set to 0.
:p.Drive letters &osq.A&csq. through &osq.Z&csq. are represented in the bitmap
from right to left.  In other words, &osq.A&csq. is 0x00000001 and &osq.Z&csq.
is 0x02000000.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.Devices which are assigned drive letters but which are NOT under LVM control
include&colon. CD-ROM, Network drives, parallel port attached devices, and any DASD
devices not controlled by OS2DASD.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
CARDINAL32 _Far16 _Pascal _loadds GET_RESERVED_DRIVE_LETTERS16( CARDINAL32 * _Seg16 Error_Code );

CARDINAL32 far pascal _loadds GET_RESERVED_DRIVE_LETTERS16( CARDINAL32 far * Error_Code ) ;
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Reboot_Required

:xmp.
BOOLEAN _System Reboot_Required ( void );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function indicates whether or not any changes were made to the
partitioning of the disks in the system which would require a reboot to make
functional.

:p.
:p.:hp7.Input:ehp7.
:p.None.

:p.
:p.:hp7.Output:ehp7.
:p.The function return value will be TRUE if the system must be rebooted as a
result of disk partitioning changes.

:p.
:p.:hp7.Error Handling:ehp7.
:p.None required.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
BOOLEAN _Far16 _Pascal _loadds REBOOT_REQUIRED16( void );

BOOLEAN far pascal _loadds REBOOT_REQUIRED16( void );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Changes_Pending

:xmp.
BOOLEAN _System Changes_Pending ( void );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function indicates whether or not any changes were made to the
partitioning of the disks in the system which have not yet been comitted to
disk.

:p.
:p.:hp7.Input:ehp7.
:p.None.

:p.
:p.:hp7.Output:ehp7.
:p.The function return value will be TRUE if there are uncomitted changes to the
partitioning of one or more of the drives in the system.

:p.
:p.:hp7.Error Handling:ehp7.
:p.None required.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
BOOLEAN _Far16 _Pascal _loadds CHANGES_PENDING16( void );

BOOLEAN far pascal _loadds CHANGES_PENDING16( void );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Reboot_Flag

:xmp.
void _System Set_Reboot_Flag(

    BOOLEAN      Reboot,
    CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function sets the Reboot Flag.  The Reboot Flag is a special flag on
the boot disk used by the install program to keep track of whether or not the
system was just rebooted.  It is used by the various phases of install.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.BOOLEAN Reboot:ehp5.
:pd.The new value for the Reboot Flag.  If TRUE, then the reboot flag will be
set.  If FALSE, then the reboot flag will be cleared.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be set to 0 if there are no errors.
*Error_Code will be > 0 if an error occurs.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, then the value of the Reboot Flag will be unchanged.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The value of the Reboot Flag may be changed.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_REBOOT_FLAG16(
        BOOLEAN             Reboot,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_REBOOT_FLAG16(
        BOOLEAN          Reboot,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Reboot_Flag

:xmp.
BOOLEAN _System Get_Reboot_Flag( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns the value of the Reboot
Flag.  The Reboot Flag is a special flag on
the boot disk used by the install program to
keep track of whether or not the system was
just rebooted.  It is used by the various
phases of install.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.The function return value will be TRUE if no errors
occur and the Reboot Flag is set.  *Error_Code will be
0 under these conditions.  If an error occurs, the
function return value will be FALSE and *Error_Code
will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.
The value of the reboot flag will be unchanged.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
BOOLEAN _Far16 _Pascal _loadds GET_REBOOT_FLAG16( CARDINAL32 * _Seg16 Error_Code );

BOOLEAN far pascal _loadds GET_REBOOT_FLAG16( CARDINAL32 far * Error_Code );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Install_Flags

:xmp.
void _System Set_Install_Flags(

    CARDINAL32   Install_Flags,
    CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function sets the value of the Install
Flags.  The Install Flags reside in a 32 bit
field in the LVM dataspace.  These flags are
not used by LVM, thereby leaving Install free
to use them for whatever it wants.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Install_Flags:ehp5.
:pd.The new value for the Install Flags.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be set to 0 if there are no errors.
*Error_Code will be > 0 if an error occurs.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, then the value of the
Install Flags will be unchanged.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The value of the Install Flags may be changed.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds Set_Install_Flags16(
        CARDINAL32          Install_Flags,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds SET_INSTALL_FLAGS16(
        CARDINAL32       Install_Flags,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_Install_Flags

:xmp.
CARDINAL32 _System Get_Install_Flags( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function returns the value of the Install
Flags.  The Install Flags reside in a 32 bit
field in the LVM dataspace.  These flags are
not used by LVM, thereby leaving Install free
to use them for whatever it wants.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.The function returns the current value of the Install
Flags stored in the LVM Dataspace.
*Error_Code will be LVM_ENGINE_NO_ERROR if the function
is successful.  If an error occurs, the function will
return 0 and *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If an error occurs, *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds Get_Install_Flags16(
        CARDINAL32 * _Seg16 Install_Flags,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds GET_INSTALL_FLAGS16(
        CARDINAL32 far * Install_Flags,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Min_Install_Size

:xmp.
void _System Set_Min_Install_Size ( CARDINAL32  Min_Sectors );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function tells the LVM Engine how big a
partition/volume must be in order for it to
marked installable.  If this function is not
used to set the minimum size for an
installable partition/volume, the LVM Engine
will use a default value of 300 MB.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Min_Sectors:ehp5.
:pd.The minimum size, in sectors, that a partition must be in
order for it to be marked as installable.
:eparml.

:p.:hp7.Output:ehp7.
:p.None.

:p.
:p.:hp7.Error Handling:ehp7.
:p.None required.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_MIN_INSTALL_SIZE16( CARDINAL32 Min_Sectors );

void far pascal _loadds SET_MIN_INSTALL_SIZE16( CARDINAL32 Min_Sectors );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Set_Free_Space_Threshold

:xmp.
void _System Set_Free_Space_Threshold( CARDINAL32  Min_Sectors );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function tells the LVM Engine not to
report blocks of free space which are less
than the size specified.  The engine defaults
to not reporting blocks of free space which
are smaller than 2048 sectors (1 MB).

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Min_Sectors:ehp5.
:pd.The minimum size, in sectors, that a block of free space must
be in order for the LVM engine to report it.
:eparml.

:p.:hp7.Output:ehp7.
:p.None.

:p.
:p.:hp7.Error Handling:ehp7.
:p.None required.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds SET_FREE_SPACE_THRESHOLD16( CARDINAL32 Min_Sectors );

void far pascal _loadds SET_FREE_SPACE_THRESHOLD16( CARDINAL32 Min_Sectors );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Read_Sectors

:xmp.
void _System Read_Sectors (

    CARDINAL32   Drive_Number,
    LBA          Starting_Sector,
    CARDINAL32   Sectors_To_Read,
    ADDRESS      Buffer,
    CARDINAL32 * Error

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function reads one or more sectors from
the specified drive and places the data read in Buffer.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Drive_Number:ehp5.
:pd.The number of the hard drive to read from.  The drives in the
system are numbered from 1 to n, where n is the total number
of hard drives in the system.
:pt.:hp5.LBA Starting_Sector:ehp5.
:pd.The first sector to read from.
:pt.:hp5.CARDINAL32 Sectors_To_Read:ehp5.
:pd.The number of sectors to read into memory.
:pt.:hp5.ADDRESS Buffer:ehp5.
:pd.The location to put the data read into.
:pt.:hp5.CARDINAL32 * Error:ehp5.
:pd.The address of a variable to hold the error return code.
:eparml.

:p.:hp7.Output:ehp7.
:p.If Successful, then the data read will be placed in
memory starting at Buffer, and *Error will be LVM_ENGINE_NO_ERROR.
:p.If Unsuccessful, then *Error will be > 0 and the
contents of memory starting at Buffer is undefined.

:p.
:p.:hp7.Error Handling:ehp7.
:p.*Error will be > 0 if an error occurs.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Data may be read into memory starting at Buffer.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds READ_SECTORS16(
        CARDINAL32          Drive_Number,
        LBA                 Starting_Sector,
        CARDINAL32          Sectors_To_Read,
        ADDRESS      _Seg16 Buffer,
        CARDINAL32 * _Seg16 Error
);

void far pascal _loadds READ_SECTORS16(
        CARDINAL32       Drive_Number,
        LBA              Starting_Sector,
        CARDINAL32       Sectors_To_Read,
        void far *       Buffer,
        CARDINAL32 far * Error
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Write_Sectors

:xmp.
void _System Write_Sectors (

    CARDINAL32   Drive_Number,
    LBA          Starting_Sector,
    CARDINAL32   Sectors_To_Write,
    ADDRESS      Buffer,
    CARDINAL32 * Error

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function writes data from memory to one
or more sectors on the specified drive.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 Drive_Number:ehp5.
:pd.The number of the hard drive to write to.  The drives in the
system are numbered from 1 to n, where n is the total number
of hard drives in the system.
:pt.:hp5.LBA Starting_Sector:ehp5.
:pd.The first sector to write to.
:pt.:hp5.CARDINAL32 Sectors_To_Read:ehp5.
:pd.The number of sectors to be written.
:pt.:hp5.ADDRESS Buffer:ehp5.
:pd.The location of the data to be written to disk.
:pt.:hp5.CARDINAL32 * Error:ehp5.
:pd.The address of a variable to hold the error return code.
:eparml.

:p.:hp7.Output:ehp7.
:p.If Successful, then the data at Buffer will be placed
on the disk starting at the sector specified, and
*Error will be LVM_ENGINE_NO_ERROR.
:p.If Unsuccessful, then *Error will be > 0 and the
contents of the disk starting at sector
Starting_Sector is undefined.

:p.
:p.:hp7.Error Handling:ehp7.
:p.*Error will be > 0 if an error occurs.

:p.
:p.:hp7.Side Effects:ehp7.
:p.Data may be written to disk.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds WRITE_SECTORS16(
        CARDINAL32          Drive_Number,
        LBA                 Starting_Sector,
        CARDINAL32          Sectors_To_Write,
        ADDRESS      _Seg16 Buffer,
        CARDINAL32 * _Seg16 Error
);

void far pascal _loadds WRITE_SECTORS16(
        CARDINAL32       Drive_Number,
        LBA              Starting_Sector,
        CARDINAL32       Sectors_To_Write,
        void far *       Buffer,
        CARDINAL32 far * Error
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Rediscover_PRMs

:xmp.
void _System Rediscover_PRMs( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Causes OS2LVM and OS2DASD to check PRMs for new or changed media.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If the Rediscover PRM operation was successful, then
*Error_Code will be LVM_ENGINE_NO_ERROR.  If there
was an error, then *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.None.

:p.
:p.:hp7.Side Effects:ehp7.
:p.New volumes may be discovered and assigned drive
letters by OS2LVM and OS2DASD.

:p.
:p.:hp7.Notes:ehp7.
:p.The LVM Engine must be CLOSED when this function is
called as this function is disabled while it is open!

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds REDISCOVER_PRMS16( CARDINAL32 * _Seg16 Error_Code );

void far pascal _loadds REDISCOVER_PRMS16( CARDINAL32 far * Error_Code );
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Get_LVM_View

:xmp.
BOOLEAN _System Get_LVM_View(

    char         IFSM_Drive_Letter,
    CARDINAL32 * Drive_Number,
    CARDINAL32 * Partition_LBA,
    char *       LVM_Drive_Letter,
    BYTE *       UnitID

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function gets the OS2LVM data for the
specified drive letter.  The intent is to
allow the determination of what drive letter
a volume really has given the possibilities
of conflict or a drive preference of '*'.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.char IFSM_Drive_Letter:ehp5.
:pd.The drive letter for which the OS2LVM data is requested.
:pt.:hp5.CARDINAL32 * Drive_Number:ehp5.
:pd.The address of a variable to hold the OS/2 drive
number of the drive  containing the first partition of the volume
currently assigned to the requested drive letter.
:pt.:hp5.CARDINAL32 * Partition_LBA:ehp5.
:pd.The address of a variable to hold the LBA of the
first partition of the volume currently assigned
to the requested drive letter.
:pt.:hp5.char * LVM_Drive_Letter:ehp5.
:pd.The address of a variable to hold the drive letter that
OS2LVM thinks the volume assigned to the requested
drive letter should have.
:pt.:hp5.BYTE * UnitID:ehp5.
:pd.The address of a variable to hold the OS2LVM unit ID for the
volume associated with the requested drive letter.
:eparml.

:p.:hp7.Output:ehp7.
:p.The function return value will be TRUE if the function
completed successfully.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If this function fails, the specified drive
letter is either not in use, or is in use by a
device not controlled by OS2LVM.

:p.
:p.:hp7.Side Effects:ehp7.
:p.None.

:p.
:p.:hp7.Notes:ehp7.
:p.This function can be used with the LVM Engine open or
closed.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
BOOLEAN _Far16 _Pascal _loadds GET_LVM_VIEW16(
        char                IFSM_Drive_Letter,
        CARDINAL32 * _Seg16 Drive_Number,
        CARDINAL32 * _Seg16 Partition_LBA,
        char *       _Seg16 LVM_Drive_Letter,
        BYTE *       _Seg16 UnitID
);

BOOLEAN far pascal _loadds GET_LVM_VIEW16(
        char             IFSM_Drive_Letter,
        CARDINAL32 far * Drive_Number,
        CARDINAL32 far * Partition_LBA,
        char far *       LVM_Drive_Letter,
        BYTE far *       UnitID
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Start_Logging

:xmp.
void _System Start_Logging(

    char *       Filename,
    CARDINAL32 * Error_Code

);
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.Enables the LVM Engine logging.  Once enabled,
the LVM Engine logging function will log all
LVM Engine activity to the specified log file.
The data is logged in a binary format for
compactness and speed.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.char * Filename:ehp5.
:pd.The filename of the file to use as the log file.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.If the logging file was successfully created, then
*Error_Code will be 0.  If the log file could not be
created, then *Error_Code will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the log file can not be created, then *Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.A file may be created/opened for logging of LVM Engine actions.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds START_LOGGING16(
        char *       _Seg16 Filename,
        CARDINAL32 * _Seg16 Error_Code
);

void far pascal _loadds START_LOGGING16(
        char far *       Filename,
        CARDINAL32 far * Error_Code
);
:exmp.
:p.


.* ............................................................................
:h4 x=left y=bottom width=100% height=100%.Stop_Logging

:xmp.
void _System Stop_Logging ( CARDINAL32 * Error_Code );
:exmp.

:p.
:p.:hp7.Description:ehp7.
:p.This function ends LVM Engine logging and closes the log file.

:p.
:p.:hp7.Input:ehp7.
:parml.
:pt.:hp5.CARDINAL32 * Error_Code:ehp5.
:pd.The address of a CARDINAL32 in which to store an error code
should an error occur.
:eparml.

:p.:hp7.Output:ehp7.
:p.*Error_Code will be 0 if this function completes
successfully; otherwise it will be > 0.

:p.
:p.:hp7.Error Handling:ehp7.
:p.If the log file is not currently opened, or if
the close operation fails on the log file, then
*Error_Code will be > 0.

:p.
:p.:hp7.Side Effects:ehp7.
:p.The log file may be closed.

:p.
:p.:hp7.Notes:ehp7.
:p.None.

:p.
:p.:hp7.16 Bit Versions:ehp7.&colon.
.br
:xmp.
void _Far16 _Pascal _loadds STOP_LOGGING16( CARDINAL32 * _Seg16 Error_Code );

void far pascal _loadds STOP_LOGGING16( CARDINAL32 far * Error_Code );
:exmp.
:p.
:euserdoc.

