/* TESTALL */
signal on error name fineko
signal on failure name fineko
signal on halt name fineko
signal on syntax name fineko

say 'RxWav: test function!'

rcy = RxFuncAdd('WavLoadFuncs', 'RxWav', 'WavLoadFuncs')
call WavLoadFuncs
/* Load all the function of package                                   */


/* "fwav" is the name of temporary file in witch TESTALL write sample
   "fc" is sampling rate
   "camp" is the length of work memory (trac) in number of sample     */
fwav='temp.wav'
fc = 44100
camp = fc * 10


/* allocate the memory needed for required number of sample; this
   function return pointer to the memory area allocated               */
TRK = WavAllocTrac(camp)


/* generate sinusoid;
 - first parameter is offset (1 sec. after the begin of trac)
 - second parameter is length of sound; 8. sec. in this case, but the
   real length is adjuste to the first sample accross 0
 - third parameter is frequency
 - fourth parameter is amplitude from 0 to 1 (value of sample from
   -32768 to +32768 in 16 bit wave file)                              */
offset = TRK + fc
len = fc * 8
rcy = WavSinOsc(offset, len, 440, 0.5)
say '440 Hz sinusoid ...'
call PlayFile


/* copy the previous generated sound over itself but with varying
   envelop; the first half is fade in and the second is fade out      */
offset2 = offset + len / 2
rcy = WavCopyTrac(offset, offset, len / 2, 0, 1, 'LOG', 'NOMIX')
rcy = WavCopyTrac(offset2, offset2, len / 2, 1, 0, 'LOG', 'NOMIX')
say 'Fade in, fade out ...'
call PlayFile


/* blank all trac and put 9 single sample ("click")                   */
rcy = WavMute(TRK, camp)
do i=1 to 9
   rcy = WavPoke(TRK + (i * fc), 1)
   end
say 'Single impulse every second ...'
call PlayFile


/* generate some test signal                                          */
rcy = WavTestOsc(TRK, camp, 0.5)
say 'Test sound, from 20 Hz to 20 kHz ...'
call PlayFile

rcy = WavWhiteNoiseOsc(TRK, camp, 0.5)
say 'White noise ...'
call PlayFile

rcy = WavPinkNoiseOsc(TRK, camp, 0.5)
say 'Pink noise ...'
call PlayFile


/* test filter function                                               */
len = camp / 2
offset = TRK + len
rcy = WavWhiteNoiseOsc(TRK, camp, 0.5)
rcy = WavFilterHigh(TRK, len, 1000, 1)
rcy = WavFilterLow(offset, len, 1000, 1)
say 'High pass 1000 Hz filter and next low pass ...'
call PlayFile

rcy = WavWhiteNoiseOsc(TRK, camp, 0.5)
rcy = WavFilterBand(TRK, camp, 1000, 200, 1)
say 'Band pass 1000 Hz filter, 200 Hz width ...'
call PlayFile


/* test equalizer:
   WavGraphEQ make FIR filter with 32 * (band + 1) coefficient; for
   31 band (1/3 octave) equalize there are 1024 coeff!!!
   each band is filter with gain: 0 for bandstop, 1 for flat response
   or greater than 1 for amplify band frequency;                      */
do i=1 to 31
   filt.i = 0
   end
filt.0 = 31
rcy = WavWhiteNoiseOsc(TRK, camp, 0.5)
do i=0 to 9
   y = i + 10
   filt.y = 6
   rcy = WavGraphEQ(TRK + (fc * i), fc, filt.)
   filt.y = 0
   end
say '1/3 octave band pass filter ...'
call PlayFile


/* get various info on trac:
 - WavPeak find amplitude of max sample in trac
 - WavAvg return two value: average value of sample with sign and
   average value os sample without sign (absolute value); the first
   is near 0 if there is not DC component in audio signal; absolute
   value is the power of signal;
 - WavAnalyze get FFT spectrum                                        */
parse value WavAvg(TRK, camp) with avg avg_abs
peak = WavPeak(TRK, camp)
say 'Max amp='peak
say 'Average amp='avg '  absolute value='avg_abs

rcy = WavAnalyze(TRK + fc, 'OTT', fft.)
say 'FFT analyse ...'
f_da = 0
f_a = 20
do i=1 to fft.0
   say '   band from' f_da 'Hz to' f_a 'Hz amp='trunc(fft.i)
   f_da = f_a
   f_a = f_a * 2
   end

'@DEL' fwav

fine:
say 'finish !!!'
call WavDropFuncs
return 0


fineko:
say 'error !!! press <RETURN> for exit'
pull k
return 12
/**********************************************************************/



PlayFile:

rcy = WavWriteMono(fwav, TRK, camp)
call play 'FILE='fwav

return

