/* Sample of using Yet Another GetKey */
parse version verrexx
say verrexx

if RxFuncQuery('yaGetKeyLoad') then do
   _rc = RxFuncAdd('yaGetKeyLoad', 'yaGetKey', 'yaGetKeyLoad');
   _rc = yaGetKeyLoad();
end
signal on halt

say ''
say '1. display version: yaGetKeyVer()'
say ''
say 'Version '||yaGetKeyVer()

say ''
say '2. display version and about info: yaGetKeyVer(v)'
say ''
say 'Version '||yaGetKeyVer('v.')
say v.0about
say 'Implemented Function List:'
do i=1 to v.0
   say '   '||v.i
end;

say ''
say '3. unlimited key waitig: yaGetKey() or yaGetKey(0)'
say 'Press Esc to next test'
say ''
key = '';
do while (key \== '1B'x)
   key = yaGetKey();
   if (key == '') then
      say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'
   else
      say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'
end

say ''
say '4. restricted key waitig - 5 sec: yaGetKey(5)'
say 'Press Esc to next test'
say ''
key = '';
do while (key \== '1B'x)
   key = yaGetKey(5);
   if (key == '') then
      say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'
   else
      say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'
end

say ''
say '5. unlimited key waitig and state displaying: yaGetKey(0, x)'
say 'Press Esc to quit'
key = '';
do while (key \== '1B'x)
   key = yaGetKey(0, 'x.');
   say ''
   if (key == '') then
      say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'
   else
      say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'
   say 'x.0scancode="'||c2x(x.0scancode)||'"x'
   say 'x.0sysreq_down='||x.0sysreq_down
   say 'x.0caps_lock_down='||x.0caps_lock_down
   say 'x.0num_lock_down='||x.0num_lock_down
   say 'x.0scroll_lock_down='||x.0scroll_lock_down
   say 'x.0right_alt_down='||x.0right_alt_down
   say 'x.0right_ctrl_down='||x.0right_ctrl_down
   say 'x.0left_alt_down='||x.0left_alt_down
   say 'x.0left_ctrl_down='||x.0left_ctrl_down
   say 'x.0insert_on='||x.0insert_on
   say 'x.0caps_lock_on='||x.0caps_lock_on
   say 'x.0num_lock_on='||x.0num_lock_on
   say 'x.0scroll_lock_on='||x.0scroll_lock_on
   say 'x.0either_alt_down='||x.0either_alt_down
   say 'x.0either_ctrl_down='||x.0either_ctrl_down
   say 'x.0left_shift_down='||x.0left_shift_down
   say 'x.0right_shift_down='||x.0right_shift_down
end;

say ''
say '6. restricted key waitig and state displaying: yaGetKey(5, x)'
say 'Press Esc to quit'
key = '';
do while (key \== '1B'x)
   key = yaGetKey(5, 'x.');
   say ''
   if (key == '') then
      say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'
   else
      say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'
   if (x.0scancode == '') then
      say 'x.0scancode="'||x.0scancode||'"'
   else
      say 'x.0scancode="'||c2x(x.0scancode)||'"x'
   say 'x.0sysreq_down='||x.0sysreq_down
   say 'x.0caps_lock_down='||x.0caps_lock_down
   say 'x.0num_lock_down='||x.0num_lock_down
   say 'x.0scroll_lock_down='||x.0scroll_lock_down
   say 'x.0right_alt_down='||x.0right_alt_down
   say 'x.0right_ctrl_down='||x.0right_ctrl_down
   say 'x.0left_alt_down='||x.0left_alt_down
   say 'x.0left_ctrl_down='||x.0left_ctrl_down
   say 'x.0insert_on='||x.0insert_on
   say 'x.0caps_lock_on='||x.0caps_lock_on
   say 'x.0num_lock_on='||x.0num_lock_on
   say 'x.0scroll_lock_on='||x.0scroll_lock_on
   say 'x.0either_alt_down='||x.0either_alt_down
   say 'x.0either_ctrl_down='||x.0either_ctrl_down
   say 'x.0left_shift_down='||x.0left_shift_down
   say 'x.0right_shift_down='||x.0right_shift_down
end;

halt:
say 'Halted...'
_rc = yaGetKeyDrop();
exit;
