#!/bin/sh

CPPFLAGS="-std=gnu99 -Zmt $EXTRA_INCLUDES"
# gcc 3.4 and 4.x
CXXFLAGS="-Wall -O9 -mtune=pentium4 -march=pentium -fomit-frame-pointer"
# 3.3.5
# CXXFLAGS="-Wall -O9 -mcpu=pentium4 -march=pentium -fomit-frame-pointer"
CFLAGS="$CXXFLAGS -pedantic"

#
LDFLAGS="-s -Zmt -Zbin-files -Zstack 32768 -Zomf -Zno-high-mem"
LIBS=""

# Multi-threading
# OS/2 native thread...
pthread_enable="disable"
CPPFLAGS="$CPPFLAGS -DCHM_MT"

# pthreads...
#pthread_enable="enable"
#pthread_base="/usr/local"
#CPPFLAGS="$CPPFLAGS -Zmt -I$pthread_base/include"
#LDFLAGS="$LDFLAGS -Zmt -L$pthread_base/lib"

export CPPFLAGS
export CFLAGS
export CXXFLAGS
export LDFLAGS
export LIBS
export EXAMPLES

export LN="cp -p"
export AWK="awk"
export SED="sed"
export ac_cv_path_SED="$SED"
export lt_cv_path_NM="nm -B"
export lt_cv_sys_max_cmd_len="8192"
export lt_cv_path_SED="$SED"

./configure --prefix=/usr/local \
  --enable-static \
  --disable-shared \
  --enable-devel \
  --enable-examples \
  --${pthread_enable}-pthread
