/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999-2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.apache.org.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

/*
 * Object Rexx script to generate a makefile for each sample and
 * a command file, to build all samples.
 * 
 * CD into the directory this file is placed and call it from the
 * command line, without any parameters. A Makefile for each 
 * sample is created with all paths properly set.
 *
 * After that, call the bldsamples.cmd to build all samples.
 *
 * Needless to say, that it's imperative that you must have
 * successfully installed VisualAge C++ V 3.0 before. 
 *
 * @author Joachim Deelen, Cologne/Germany, 16. August 2003
 * @since xerces 2.3.0 
 */

IF LoadRexxUtil() THEN EXIT

here = Directory()~translate('* ', ' \')
base = here~subword(1, here~words - 4)~strip~translate(' \', '* ')

basedir = .subdirlist~new(base'\samples')
basedir~removeAnyContaining("\CVS")
basedir~removeAnyContaining("\Projects")
basedir~removeAnyContaining("\data")

includedirs=base||'\include;'||base||'\include\xercesc;'||base||'\include\xercesc\dom;'||base||'\include\xercesc\util'

compiler='icc.exe'
cpp_obj = '.cpp.obj:'
compiler_options = '/I$(INCL_DIRS) /Q /Fi /Si /Gm /Oi /G5 /Fo$@ /C'
compiler_msg = '	@echo " Compile::C++ Compiler "'
compiler_call = '	' || compiler ||' $(COMPILER_OPTIONS) %s'

linker='ilink.exe'
obj_exe='.obj.exe:'
linker_options = '/FR /EXEPACK:2 /PMTYPE:VIO'
linker_msg = '	@echo " Link::ILink "'
linker_call = '	' || linker || ' $(LINKER_OPTIONS)'

baseoptions = .list~new
baseoptions~insert('BASE_DIR=' || base)
baseoptions~insert('SAMPLES_DIR=$(BASE_DIR)\samples')
baseoptions~insert('INCL_DIRS=' || includedirs)
baseoptions~insert('LIB_DIR=$(BASE_DIR)\lib')
baseoptions~insert('')
baseoptions~insert('COMPILER_OPTIONS='compiler_options)
baseoptions~insert('LINKER_OPTIONS='linker_options)
baseoptions~insert('')
baseoptions~insert('.SUFFIXES:')
baseoptions~insert('')
baseoptions~insert('.SUFFIXES: .cpp .obj .exe')
baseoptions~insert('')
baseoptions~insert(cpp_obj)
baseoptions~insert(compiler_msg)
baseoptions~insert(compiler_call)
baseoptions~insert('')
baseoptions~insert(obj_exe)
baseoptions~insert(linker_msg)
baseoptions~insert(linker_call)
baseoptions~insert('')

f_buildsamples = .stream~new('bldsamples.cmd')
f_buildsamples~open('Write Replace')
f_buildsamples~lineout("@echo off")

DO dir OVER basedir
	thisdir = FileSpec('N', dir)
	grpname = thisdir
	files = .filelist~new(dir || '\*.cpp')
	files~removeAnyContaining("\CVS")
	
	makefile = .list~new
	
	makefilename = grpname || '.mak'
	f_buildsamples~lineout('echo making' grpname)
	f_buildsamples~lineout('nmake /f' makefilename)
	DO option OVER baseoptions
 		makefile~insert(option)
 	END
	makefile~insert('PROJECT_DIR=$(SAMPLES_DIR)\' || grpname)
	makefile~insert('')
	makefile~insert('{$(PROJECT_DIR)}.cpp.obj:')
	makefile~insert(compiler_call)
	makefile~insert('')
	
	makefile~insert('$(PROJECT_DIR)\' || grpname || '.exe: \')


	filenames_woe = .list~new
	
	DO file OVER files
		filename = FileSpec('name', file)
		filedir = FileSpec('path', file)
		filedrive = FileSpec('drive', file)
		filepath = (filedrive || filedir)~changestr(base, '$(BASE_DIR)')
		filepath = filepath~substr(1, filepath~lastpos('\')-1)
		filename_woe = filepath || '\' || filename~substr(1, filename~pos('.')-1)
		filenames_woe~insert(filename_woe)
	END
	
	count = filenames_woe~items
	delim = ' \'
	DO file over filenames_woe
		count = count-1
		if count = 0 then
			delim = ''
		makefile~insert('	$(PROJECT_DIR)\' || FileSpec('name', file) || '.obj' || delim)
	END
	
	makefile~insert(linker_msg)
	makefile~insert('	' || linker || ' @<<')
	makefile~insert('	$(LINKER_OPTIONS)')
	makefile~insert('	/O:$(PROJECT_DIR)\' || grpname || '.exe')
	makefile~insert('	$(LIB_DIR)\xerces-c.lib')
	
	DO file over filenames_woe
		makefile~insert('	$(PROJECT_DIR)\' || FileSpec('name', file) || '.obj')
	END
	
	makefile~insert('<<')
	makefile~insert('')
	
	DO file over filenames_woe
		makefile~insert('$(PROJECT_DIR)\' || FileSpec('name', file) || '.obj: \')
		makefile~insert('	$(PROJECT_DIR)\' || FileSpec('name', file) || '.cpp')
		makefile~insert(compiler_msg)
		makefile~insert(compiler_call)
		makefile~insert('')
	END
	
	f_makefile = .stream~new(makefilename)
	f_makefile~open('Write Replace')

	DO line OVER makefile
 		f_makefile~lineout(line)
 	END
	f_makefile~close
END
f_buildsamples~close

EXIT

/*------------------------------ LoadRexxUtil -------------------------------
 * Load the RexxUtil library
 */
::routine LoadRexxUtil
  IF RxFuncQuery('SysLoadFuncs') THEN
   DO
    IF RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') THEN
     DO
      .output~lineout("Error: Couldn't load RexxUtil library.")
      RETURN 1
     END
    CALL SysLoadFuncs
   END

  RETURN 0

/******************************** SubdirList ********************************
 */
::class SubdirList PUBLIC

::method init
  EXPOSE !root !dirs
  USE ARG !root

  !dirs = .list~new

  CALL SysFileTree !root'\*', 'dirs.', 'DO'
  DO i = 1 TO dirs.0
    !dirs~insert(dirs.i)
  END

::method basedir
  EXPOSE !root
  RETURN !root

::method makearray
  EXPOSE !dirs
  RETURN !dirs~makearray

::method removeAnyContaining
  EXPOSE !dirs
  USE ARG sub

  i = !dirs~first
  DO WHILE i <> .nil
    n = i
    i = !dirs~next(i)
    IF !dirs[n]~pos(sub) <> 0 THEN
     DO
      !dirs~remove(n)
     END
  END

::method removeAllBut
  EXPOSE !dirs
  USE ARG sub

  DO i = !dirs~first TO !dirs~last
    n = i
    i = !dirs~next(i)
    IF !dirs[n]~pos(sub) = 0 THEN
     DO
      !dirs~remove(n)
     END
  END

/********************************* FileList *********************************
 */
::class FileList PUBLIC

::method init
  EXPOSE !pattern !files
  USE ARG !pattern

  !files = .list~new

  CALL SysFileTree !pattern, 'files.', 'FOS'
  DO i = 1 TO files.0
    !files~insert(files.i)
  END

::method basedir
  EXPOSE !pattern
  RETURN (FileSpec('D', !pattern) || FileSpec('P', !pattern))~strip('T', '\')

::method makearray
  EXPOSE !files
  RETURN !files~makearray

::method items
  EXPOSE !files
  RETURN !files~items

::method removeAnyContaining
  EXPOSE !files
  USE ARG sub

  i = !files~first
  DO WHILE i <> .nil
    n = i
    i = !files~next(i)
    IF !files[n]~pos(sub) <> 0 THEN
     DO
      !files~remove(n)
     END
  END

::method removeAllBut
  EXPOSE !files
  USE ARG sub

  i = !files~first
  DO WHILE i <> .nil
    n = i
    i = !files~next(i)
    IF !files[n]~pos(sub) = 0 THEN
     DO
      !files~remove(n)
     END
  END

::method merge
  EXPOSE !files
  USE ARG fl
  DO f OVER fl
    !files~insert(f)
  END

