program TimServ;

uses OS2Def,OS2Base,DOS,VPUtils,
     Socket,U_DateTime;

{$L IBMTCPIP.LIB}

const
  Version     = '0.90';
  StackSize   = 64*1024;
  TimServPort: ULong  = 10037;
  UseString:   string = '@(#)time server for OS/2'+#0;
  CopyRight1:  string = '@(#)timeserver2 Version '+Version+' - 10.10.96'+#0;
  CopyRight2:  string = '@(#)(C) Chr.Hohmann BfS ST2.2 1996'+#0;
var
  mrc:      ApiRet;
  TCPTh:    TID;
  ValError: longint;
  TempStr:  string;
  (***************************************************************************)
{$S-}
  function TCP_Timeserver(P: pointer): ULong;
  var
    Ended:    boolean;
    rc:       ApiRet;
    BufFlag:  ULong;
    SDescr,
    CDescr:   longint;
    TempDT:   OS2Base.DateTime;
    SAddr,
    CAddr:    SockAddr_In_Ptr;
    Client:   string;
    ValStr:   string[ 3];
  begin
    new(SAddr);
    new(CAddr);
    fillchar(SAddr^,sizeof(SAddr^),#0);
    fillchar(CAddr^,sizeof(CAddr^),#0);
    rc := socksocket(AF_INET,SOCK_STREAM,IPPROTO_NULL);
    if (rc <> -1) then begin
      SDescr                 := rc;
      SAddr^.Sin_Addr.IPAddr := InAddr_Any;
      SAddr^.Sin_Port        := htons(TimServPort);
      SAddr^.Sin_Family      := AF_INET;
      rc := SockBind(SDescr,
                     SAddr,
                     SockAddr_Len);
      if (rc <> -1) then begin
        rc := SockListen(SDescr,5);
        CDescr := SDescr;
        if (rc <> -1) then begin
          Ended := false;
          writeln('Startup TCP using Port ',TimServPort,' complete  -  waiting for clients.');
          write  ('--------------------------------------------------------------------------------');
          repeat
            CDescr := SockAccept(SDescr,
                                 CAddr,
                                 SockAddr_Len);
            Client := SockGetHostNameByAddr(@CAddr^.Sin_Addr);
            if (rc = -1) then Client := 'unknown host';
            str(CAddr^.Sin_Addr.ClassA,ValStr);
            while (length(ValStr) <  3) do ValStr := '0'+ValStr;
            Client := Client+' ('+ValStr+'.';
            str(CAddr^.Sin_Addr.ClassB,ValStr);
            while (length(ValStr) <  3) do ValStr := '0'+ValStr;
            Client := Client+ValStr+'.';
            str(CAddr^.Sin_Addr.ClassC,ValStr);
            while (length(ValStr) <  3) do ValStr := '0'+ValStr;
            Client := Client+ValStr+'.';
            str(CAddr^.Sin_Addr.ClassD,ValStr);
            while (length(ValStr) <  3) do ValStr := '0'+ValStr;
            Client := Client+ValStr+')';
            write('TCP: request from ',Client);
            rc := DosGetDateTime(TempDT);
            if (rc = 0) then begin
              BufFlag  := 0;
              rc := SockSend(CDescr,
                             @TempDT,
                             sizeof(TempDT),
                             BufFlag);
              if (rc = sizeof(TempDT)) then
                writeln(' - ',Long_DateString(Default,TempDT),' - OK.')
              else
                writeln(' - socket send rc: ',rc);
              rc := SockShutdown(CDescr,BufFlag);
              if (rc <> 0) then begin
                writeln('Socket shutdown failed - rc: ',rc);
              end;
            end else begin
              writeln(' DosGetDateTime failed');
            end;
          until (rc = -1);
          (*  hope we never come here, but ... *)
          rc := SockClose(SDescr);
          writeln('TCP  close rc: ',rc:12,'  errno: ',sockerrno);
          dispose(CAddr);
          dispose(SAddr);
        end else begin
          writeln('TCP socket rc: ',SDescr:12);
          writeln('    listen rc: ',rc:12,'  errno: ',sockerrno);
          writeln;
          writeln('program aborted');
          halt(99);
        end;
      end else  begin
        writeln('TCP socket rc: ',SDescr:12);
        writeln('    bind   rc: ',rc:12,'  errno: ',sockerrno);
        writeln;
        writeln('program aborted');
        halt(99);
      end;
    end else begin
      writeln('TCP socket rc: ',rc:12,'  errno: ',SockErrNo);
      writeln;
      writeln('program aborted');
      halt(99);
    end;
  end;
{$S+}
  (***************************************************************************)
begin
  TempStr := getenv('TimeService2');
  if (TempStr > '') then begin
    val(TempStr,TimServPort,ValError);
    if (ValError <> 0) and (TimServPort > 0) then begin
      writeln('timserv2 error - not a value ',TempStr);
      halt(99);
    end;
  end;
  write  ('--------------------------------------------------------------------------------');
  writeln('Timeservice for OS/2  Version ',Version,'  -  by Christian Hohmann  -  bugs@bga.de');
  write  ('--------------------------------------------------------------------------------');

  mrc := BeginThread(nil,16*1024,TCP_Timeserver,pointer(0),0,TCPTh);
  if (mrc <> -1) then begin
    mrc := DosSleep(-1);
  end else begin
    writeln;
    writeln('can'+#39+'t start TCP-thread - program aborted');
    halt(99);
  end;
  UseString  := UseString;
  CopyRight1 := CopyRight1;
  CopyRight2 := CopyRight2;
end.
