{  Library of functions that can be called only from within an
   an OS/2 Virtual DOS Machine (VDM).

   These Pascal declarations were tested using IBM Pascal/2 in
   DOS mode. Any problems when using a more mainstream compiler
   should be reported, preferably with resolutions.

   Some Pascal/2 idiosyncrasies are:
      Pointer variables:
      ADS OF xxxx     means a far pointer to type xxxx
      ADR OF xxxx     means a near pointer to type xxxx
      ADSMEM          means a far pointer to general bytes
      ADRMEM          means a near pointer to general bytes

      Formal parameters of PROCEDURE and FUNCTION declarations:
      VARS            means a variable passed by far pointer
      CONSTS          means a constant passed by far pointer
      CONST           means a constant passed by near pointer

   Since this is the only Pascal compiler I have, I must put up
   with this crap. Alas, it means you will have to fix these
   declarations to suit your compiler yourself.

   Copyright (C) 1996, 1997, David W. Noon }

CONST
      NULLSHANDLE               =       0;
      NULLHANDLE                =       0;

      DC_SEM_SHARED             =       1;
      DCMW_WAIT_ANY             =       2;
      DCMW_WAIT_ALL             =       4;
      SEM_INDEFINITE_WAIT       =      -1;
      SEM_IMMEDIATE_RETURN      =       0;

      FIL_STANDARD              =       1;
      FIL_QUERYEASIZE           =       2;
      FIL_QUERYEASFROMLIST      =       3;
      FIL_QUERYALLEAS           =       4;
      FIL_QUERYFULLNAME         =       5;

      { Since these are bit mask options we'll do them in hex. }
      FEA_NEEDEA                =   16#80;

      EAT_BINARY                = 16#FFFE;
      EAT_ASCII                 = 16#FFFD;
      EAT_BITMAP                = 16#FFFB;
      EAT_METAFILE              = 16#FFFA;
      EAT_ICON                  = 16#FFF9;
      EAT_EA                    = 16#FFEE;
      EAT_MVMT                  = 16#FFDF;
      EAT_MVST                  = 16#FFDE;
      EAT_ASN1                  = 16#FFDD;

      SSF_RELATED_INDEPENDENT   = 16#0000;
      SSF_RELATED_CHILD         = 16#0001;

      SSF_FGBG_FORE             = 16#0000;
      SSF_FGBG_BACK             = 16#0001;

      SSF_TRACEOPT_NONE         = 16#0000;
      SSF_TRACEOPT_TRACE        = 16#0001;
      SSF_TRACEOPT_TRACEALL     = 16#0002;

      SSF_INHERTOPT_SHELL       = 16#0000;
      SSF_INHERTOPT_PARENT      = 16#0001;

      SSF_TYPE_DEFAULT          = 16#0000;
      SSF_TYPE_FULLSCREEN       = 16#0001;
      SSF_TYPE_WINDOWABLEVIO    = 16#0002;
      SSF_TYPE_PM               = 16#0003;
      SSF_TYPE_VDM              = 16#0004;
      SSF_TYPE_WINDOWEDVDM      = 16#0007;

      SSF_CONTROL_SETPOS        = 16#8000;
      SSF_CONTROL_NOAUTOCLOSE   = 16#0008;
      SSF_CONTROL_MINIMIZE      = 16#0004;
      SSF_CONTROL_MAXIMIZE      = 16#0002;
      SSF_CONTROL_INVISIBLE     = 16#0001;
      SSF_CONTROL_VISIBLE       = 16#0000;

TYPE SHANDLE = WORD;
     LHANDLE = INTEGER4;
     HFILE = SHANDLE;
     HEV = LHANDLE;
     HMTX = LHANDLE;
     HMUX = LHANDLE;
     PID = LHANDLE;
     TID = LHANDLE;
     PCSZ = ADS OF STRING;

     {  The following types have been translated from the
        OS/2 Developer's Toolkit 1.3 documentation. }

     FDATE = WORD;
     {
        unsigned day   : 5;     /* binary day for directory entry */
        unsigned month : 4;     /* binary month for directory entry */
        unsigned year  : 7;     /* binary year for directory entry, offset from 1980 */
     }

     FTIME = WORD;
     {
        unsigned twosecs : 5;       /* binary number of two-second increments */
        unsigned minutes : 6;       /* binary number of minutes */
        unsigned hours   : 5;       /* binary number of hours */
     }

     { Note that this structure needs to be byte packed!! }
     FILESTATUS = PACKED RECORD
        fdateCreation   : FDATE;     { date of file creation }
        ftimeCreation   : FTIME;     { time of file creation }
        fdateLastAccess : FDATE;     { date of last access }
        ftimeLastAccess : FTIME;     { time of last access }
        fdateLastWrite  : FDATE;     { date of last write }
        ftimeLastWrite  : FTIME;     { time of last write }
        cbFile          : INTEGER4;  { file size (end of data) }
        cbFileAlloc     : INTEGER4;  { file allocated size }
        attrFile        : WORD;      { attributes of the file }
        cbList          : INTEGER4;  { file EA structure size }
     END;

     {  Since the next four structures are self-defining, they cannot be readily
        declared in Pascal. [Or C/C++ for that matter!]
     GEA = RECORD
        cbName          : BYTE;                     /* name length not including NULL */
        szName          : STRING(cbName);           /* attribute name */
        filler          : CHAR;                     /* must be CHR(0) */
     END;

     FEA = RECORD
        fEAflag         : BYTE;                     /* flags */
        cbName          : BYTE;                     /* name length not including NULL */
        cbValue         : WORD;                     /* value length */
        szName          : STRING(cbName);           /* attribute name */
        filler          : CHAR;                     /* must be CHR(0) */
        aValue          : STRING(cbValue);          /* attribute value -- offset varies with cbName */
     END;

     GEALIST = RECORD
        cbList          : INTEGER4;                 /* total bytes of structure including full list */
        list            : STRING(cbList);           /* variable length GEA structures */
     END;

     FEALIST = RECORD
        cbList          : INTEGER4;                 /* total bytes of structure including full list */
        list            : STRING(cbList);           /* variable length FEA structures */
     END;
     { End of self-defining structures }

     EAOP = RECORD
        fpGEAList       : ADSMEM;                   { general EA list }
        fpFEAList       : ADSMEM;                   { full EA list }
        oError          : INTEGER4;
     END;

     { The following type has been translated from the OS/2 Warp Developer's Toolkit 4.0 }
     STARTDATA = RECORD
        Length           : WORD;     { The length of the data structure, in bytes, including Length itself. }
        Related          : WORD;     { An indicator which specifies whether the session created is related to the calling session. }
        FgBg             : WORD;     { An indicator which specifies whether the new session should be started in the foreground or background. }
        TraceOpt         : WORD;     { An indicator which specifies whether the program started in the new session should be executed under conditions for tracing. }
        PgmTitle         : PCSZ;     { Address of an ASCIIZ string that contains the program title. }
        PgmName          : PCSZ;     { The address of an ASCIIZ string that contains the file specification of the program to be loaded. }
        PgmInputs        : PCSZ;     { Either 0 or the address of an ASCIIZ string that contains the input arguments to be passed to the program. }
        TermQ            : PCSZ;     { Either 0 or the address of an ASCIIZ string that contains the file specification of a system queue. }
        Environment      : PCSZ;     { The address of an environment string to be passed to the program started in the new session. }
        InheritOpt       : WORD;     { Specifies whether the program started in the new session should inherit the calling program's environment and open file handles. }
        SessionType      : WORD;     { The type of session that should be created for this program. }
        IconFile         : PCSZ;     { Either 0 or the address of an ASCIIZ string that contains the file specification of an icon definition. }
        PgmHandle        : INTEGER4; { Either 0 or the program handle. }
        PgmControl       : WORD;     { An indicator which specifies the initial state for a windowed application. }
        InitXPos         : WORD;     { The initial x-coordinate, in pels, for the initial session window. }
        InitYPos         : WORD;     { The initial y-coordinate, in pels, for the initial session window. }
        InitXSize        : WORD;     { The initial x extent, in pels, for the initial session window. }
        InitYSize        : WORD;     { The initial y extent, in pels, for the initial session window. }
        Reserved         : WORD;     { Reserved; must be zero. }
        ObjectBuffer     : ADSMEM;   { Buffer in which the name of the object that contributed to the failure of DosExecPgm is returned. }
        ObjectBuffLen    : INTEGER4; { The length, in bytes, of the buffer pointed to by ObjectBuffer. }
     END;

FUNCTION DwnExitVDM : WORD; EXTERN;

PROCEDURE DwnReleaseTimeSlice; EXTERN;

PROCEDURE DwnSetSessionTitle(CONSTS Session_title : STRING); EXTERN;
PROCEDURE DwnQuerySessionTitle(VARS Session_title : STRING); EXTERN;

FUNCTION DwnQFileInfo(FileHandle : HFILE; FileInfoLevel : WORD; FileInfoBuf : ADSMEM; FileInfoBufSize : WORD) : WORD; EXTERN;
FUNCTION DwnQPathInfo(CONSTS PathName : STRING; PathInfoLevel : WORD; PathInfoBuf : ADSMEM; PathInfoBufSize : WORD) : WORD; EXTERN;
FUNCTION DwnSetFileInfo(FileHandle : HFILE; FileInfoLevel : WORD; FileInfoBuf : ADSMEM; FileInfoBufSize : WORD) : WORD; EXTERN;
FUNCTION DwnSetPathInfo(CONSTS PathName : STRING; PathInfoLevel : WORD; PathInfoBuf : ADSMEM; PathInfoBufSize : WORD) : WORD; EXTERN;

FUNCTION DwnCreateEventSem(CONSTS SemName : STRING; VARS SemHandle : HEV; Attr : WORD; State : WORD) : WORD; EXTERN;
FUNCTION DwnOpenEventSem(CONSTS SemName : STRING; VARS SemHandle : HEV) : WORD; EXTERN;
FUNCTION DwnCloseEventSem(SemHandle : HEV) : WORD; EXTERN;
FUNCTION DwnResetEventSem(SemHandle : HEV; VARS PostCount : INTEGER4) : WORD; EXTERN;
FUNCTION DwnPostEventSem(SemHandle : HEV) : WORD; EXTERN;
FUNCTION DwnWaitEventSem(SemHandle : HEV; Timeout : INTEGER4) : WORD; EXTERN;
FUNCTION DwnQueryEventSem(SemHandle : HEV; VARS PostCount : INTEGER4) : WORD; EXTERN;

FUNCTION DwnCreateMutexSem(CONSTS SemName : STRING; VARS SemHandle : HMTX; Attr : WORD; State : WORD) : WORD; EXTERN;
FUNCTION DwnOpenMutexSem(CONSTS SemName : STRING; VARS SemHandle : HMTX) : WORD; EXTERN;
FUNCTION DwnCloseMutexSem(SemHandle : HMTX) : WORD; EXTERN;
FUNCTION DwnRequestMutexSem(SemHandle : HMTX; TimeOut : INTEGER4) : WORD; EXTERN;
FUNCTION DwnReleaseMutexSem(SemHandle : HMTX) : WORD; EXTERN;
{ Dos32QueryMutexSem() isn't supported at the moment, courtesy of IBM.
FUNCTION DwnQueryMutexSem(SemHandle : HMTX; VARS OwnerProcess : PID; VARS OwnerThread : TID; VARS RequestCount : INTEGER4) : WORD; EXTERN;
}

FUNCTION DwnStartSession(VARS StrtData : STARTDATA) : WORD; EXTERN;
