/* rexx */
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

'cls'
say
say 'G2Hlb --- Testing REXXGDB2.DLL HTML listbox (select) tag creator function'
say '          (G2HSelect2Listbox)'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., Dec 1996 - Aug 1997'
say

sq1 = 'Select name||'', ''||job from staff'

htmlfn = 'G22HTML.HTM'
requestedrows = 10
nullchar      = ''
varcharlen    = ''

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'

'@del' htmlfn '1>NUL 2>NUL'

say

call time 'R'
call          g2h htmlfn, 1, '<form method="post">'
call          g2h htmlfn, 1, '<HR>Default settings<BR>'
call          g2hselect2listbox htmlfn, 1, 'sq1', requestedrows

call          g2h htmlfn, 1, '<HR>Showing 5 items in 10-item box<BR>'
call          g2hselect2listbox htmlfn, 1, 'sq1', 5,,, 10,, 'LB2'

call          g2h htmlfn, 1, '<HR>Showing 3 multiple selectable in 5-item box<BR>'
call          g2hselect2listbox htmlfn, 1, 'sq1', 3,,, 5, 1, 'LB3'
call          g2h htmlfn, 1, '</form>'
elapse = time('E')

'@netscape file:///'htmlfn
/* '@explore -q' htmlfn */

say 'Execution time' elapse

say
say 'Commiting...'
call g2commit
return 0



error:
say 'Error detected at line' SIGL
return 10

syntax:
say 'Syntax error detected at line' SIGL
return 20
