/* rexx */
signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

'cls'
say
say 'G2Form --- Testing REXXGDB2.DLL function: G2SelectForm'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., December 1995, November 1996'
say

sql = 'Select * from org'
stem = 'form.'
requestedrows = 999999999
nullchar      = '%'
padchar       = '_'
varcharlen    = 10

say 'SQL:         'sql
say 'Stem:        'stem
say 'Req. rows:   'requestedrows
say 'Null Char.:  'nullchar
say 'Pad Char.:   'padchar
say 'VARCHAR len.:'varcharlen

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
call time 'R'
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'
say 'Execution time    ' time('E')

say
call time 'R'
retcode = g2selectform(sql, stem, requestedrows, nullchar, padchar, varcharlen)
elapse = time('E')
say 'Return Code       ' retcode
say 'Execution time    ' time('E')
say
say 'Stem tot# elements' form.0
if retcode = 0 | retcode = 100 then do
   say 'Element FORM.0.0=' form.0.0
   do i = 1 to form.0
      say 'Element FORM.'i ' =' form.i
      end

say
call time 'R'
say 'Commiting...'
call g2commit
say 'Execution time    ' time('E')
return 0



error:
say 'Error detected at line' SIGL
return 10

syntax:
say 'Syntax error detected at line' SIGL
return 20
