/* Tower of hanoi */
/* Originally sourced from Anders Christensen's Regina Rexx Interpreter */

Trace o
Say starting
Parse Version ver
Say ver
Parse Source src .

Call Charout ,"Number of discs (3-12) ? "
Parse Pull disks .

Signal On Syntax Name ignorerxfuncquery
If Word(ver,1) = 'REXXSAA' & src = 'AIX/6000' Then rc = SysAddFuncPkg('librxcurses.so')
Else Do
   If Rxfuncquery('CurLoadFuncs') = 1 Then Do
      If Rxfuncadd('CurLoadFuncs','rxcurses','CurLoadFuncs')  Then Do
         Say 'An error occured when trying to load the Rexx/Curses library.'
         If Substr(ver, 1, 11) = 'REXX-Regina' Then Say 'Error was' Rxfuncerrmsg()
         Say 'Exiting...'
         Exit
      End
      Call CurLoadFuncs
   End
End

ignorerxfuncquery:

Signal on Syntax

Call CurInitscr
If lines < 24 | cols < 80 Then Do
   Say 'This program cannot run in a screen with fewer than 24 lines'
   Say 'and 80 columns. The size of this screen is' lines 'lines by' cols 'columns.'
   Say 'Exiting...'
   Signal syntax
   End
If CurHasColors() Then Do
   Call CurStartColor
   Call CurInitPair 1, 'COLOR_RED', 'COLOR_BLACK'
   Call CurInitPair 2, 'COLOR_BLUE', 'COLOR_BLACK'
   Call CurInitPair 3, 'COLOR_WHITE', 'COLOR_BLACK'
   Call CurInitPair 4, 'COLOR_GREEN', 'COLOR_BLACK'
   Call CurInitPair 5, 'COLOR_YELLOW', 'COLOR_BLACK'
   Call CurInitPair 6, 'COLOR_CYAN', 'COLOR_BLACK'
   Call CurInitPair 7, 'COLOR_MAGENTA', 'COLOR_BLACK'
   Call CurInitPair 8, 'COLOR_RED', 'COLOR_BLACK'
   Call CurInitPair 9, 'COLOR_BLUE', 'COLOR_BLACK'
   Call CurInitPair 10, 'COLOR_WHITE', 'COLOR_BLACK'
   Call CurInitPair 11, 'COLOR_GREEN', 'COLOR_BLACK'
   Call CurInitPair 12, 'COLOR_YELLOW', 'COLOR_BLACK'
   End

If CurHasAcs() Then platechar = 'ACS_CKBOARD'
Else platechar = '#'

Call CurCursSet 0  /* turn off cursor */
Call CurClear
Call CurErase
Call CurRefresh

w1 = CurNewwin(3,55,1,10)
Call CurBox w1
Call CurWmove w1, 1, 2
Call CurWaddstr w1, 'Towers of Hanoi:' disks 'disks: '
Call CurWrefresh w1

rc = Time('E')

pole.1 = "" 
pole.2 = ""
pole.3 = ""
pole.height = disks 

Do i=1 To disks
   pole.1 = Space( i pole.1 )
   End

Parse Value  13 40 66  With pole.pos.1 pole.pos.2 pole.pos.3

Call setup_screen
Call move_stack disks 1 3 2
Call CurCursSet 1  /* turn on cursor */
Call CurWaddstr w1, 'Elapsed time:' Time('E')
Call CurWrefresh w1
Call CurMove 5, 20
Call CurAddstr 'Press any key to continue...'
Call CurRefresh
Call CurCbreak
Call CurNoecho
rc = CurGetch()
Call CurDelwin w1
Call CurEndwin
Return 0

move_stack: Procedure Expose pole. screen. platechar
   Parse Arg num from target scratch
   If num <= 0 Then
      Return

   Call move_stack num-1 from scratch target
   Call move_plate from target
   Call move_stack num-1 scratch target from
   Return



move_plate: Procedure Expose pole. screen. platechar
   Parse Arg from target
   
   plate = Word( pole.from, Words( pole.from ))
/* pole.from = Subword( pole.from, 1, Words( pole.from ) - 1 )  */
   pole.from = Reverse( pole.from )
   Parse Var pole.from . pole.from
   pole.from = Reverse( pole.from )
   
   If 0 Then
      Say 'Moving plate' plate 'from pole' from 'to pole' target
   Else
      Call draw_a_move plate from target

   pole.target = pole.target plate
   Return


draw_a_move: Procedure Expose pole. screen. platechar
   Parse Arg plate from target

   top = screen.height - pole.height - 2
   fulllen = plate*2+1
   empty = Center('|', plate*2+1)
   real_empty = Copies( ' ', plate*2+1)

   Do i=Words(pole.from) To pole.height+1
      Call CurMove screen.height-i-2, pole.pos.from-plate
      If CurHasColors() Then Call CurAttrset 'COLOR_PAIR('plate')', 'A_BOLD'
      Do fulllen
         Call CurAddch platechar
         End
      If CurHasColors() Then Call CurAttrset 'A_NORMAL'
      call CurMove screen.height-i-1, pole.pos.from-plate
      If (i>pole.height) Then
         Call CurAddstr real_empty
      Else
         Call CurAddstr empty
      Call CurRefresh
      End

   top = screen.height - pole.height - 3
   step = Sign( pole.pos.target - pole.pos.from )
   Do i=pole.pos.from To pole.pos.target-step By step
      If i-step*plate < 0 Then Trace ?r
      Call CurMove top, i-step*plate
      Call CurAddch ' '
      Call CurMove top, i+step*plate+step
      If CurHasColors() Then Call CurAddch platechar, 'COLOR_PAIR('plate')', 'A_BOLD'
      Else Call CurAddch platechar
      Call CurRefresh
      End


   j = screen.height - pole.height - 1
   Do i=0 To pole.height + 1 - Words(pole.target)
      Call CurMove j+i-1, pole.pos.target-plate
      If CurHasColors() Then Call CurAttrset 'COLOR_PAIR('plate')', 'A_BOLD'
      Do fulllen
         Call CurAddch platechar
         End
      If CurHasColors() Then Call CurAttrset 'A_NORMAL'
      Call CurMove j+i-2, pole.pos.target-plate
      If (i<=1) Then
         Call CurAddstr real_empty
      Else
         Call CurAddstr empty
      Call CurRefresh
      End

   Return


setup_screen: 
   screen.height = lines-1 /*24*/
   screen.width = cols /*80*/
   

   Do i=1 To disks
      Call CurMove screen.height-i, pole.pos.1-(disks+1-i)
      fulllen = 2*(disks-i)+3
      If CurHasColors() Then Call CurAttrset 'COLOR_PAIR(' || (fulllen-1)/2 || ')', 'A_BOLD'
      Do fulllen
         Call CurAddch platechar
         End
      End

   If CurHasColors() Then Call CurAttrset 'A_NORMAL'
   Call CurMove (screen.height-(disks+1)), pole.pos.1
   Call CurAddch '|'

   Do i=1 To disks+1
      Call CurMove screen.height-i, pole.pos.2
      Call CurAddch '|'
      Call CurMove screen.height-i, pole.pos.3
      Call CurAddch '|'
      End

   Call CurRefresh

   Return

syntax:
   Call CurEndwin
   Exit 0
