{
HALVIO provides REXX with access to OS/2's Vio... functions.
}

Library halvio;

{$CDecl+,OrgName+,I-,S-,Delphi+,Use32+}

Uses
  Dos, Os2Def, Rexx, Strings, Os2Base;

{$LINKER
  DESCRIPTION      "HALVIO - Access to OS/2's Kbd... functions for REXX"
  DATA MULTIPLE NONSHARED

  EXPORTS
    HALVIOGETANSI       = HALVioGetAnsi
    HALVIOSETANSI       = HALVioSetAnsi
    HALVIOLOADFUNCS     = HALVioLoadFuncs
}

Const FunctionTable : Array[ 0..1 ] of pChar =
(
  'HALVioGetAnsi',
  'HALVioSetAnsi'
);

Function HALVioLoadFuncs( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
Var
  j       : Integer;
begin
  Ret.strLength := 0;
  If ArgC > 0 then                        { Do not allow parameters }
    HALVioLoadFuncs := 40
  else
    begin
      For j := Low( FunctionTable ) to High( FunctionTable ) do
        RexxRegisterFunctionDLL( FunctionTable[j],
                                 'HALVIO',
                                 FunctionTable[j] );
      HALVioLoadFuncs := 0;
    end;

end;

Function Str2Int( s : String) : Integer;
var
  int,i : Integer;
begin
  int:=0;
  for i := 1 to length(s) do
    int:=int*10+ord(s[i])-ord('0');
  Str2Int:=int;
end;

Function HALVioGetAnsi( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  isansi : smallword;
  s : String;
begin
  VioGetAnsi(isansi,0);
  str( isansi, s );
  strpcopy( Ret.strptr, s );
  Ret.strLength := strlen(Ret.strptr);
  HALVioGetAnsi:=0;
end;

Function HALVioSetAnsi( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  isansi : Integer;
begin
  If ArgC < 1 then
    begin
      HALVioSetAnsi := 40;
      Exit;
    end;
  isansi := Str2Int(StrPas( Args^.strptr ));
  VioSetAnsi(isansi,0);
  Ret.strLength := 0;
  HALVioSetAnsi := 0;
end;

initialization
end.


