/****************************************************************************}
{*                                                                          *}
{*  The FreeType project - a Free and Portable Quality TrueType Renderer.   *}
{*                                                                          *}
{*  Copyright 1996  D. Turner, R.Wilhelm, W. Lemberg                        *}
{*                                                                          *}
{*  fdebug : A very simple TrueType bytecode debugger.                      *}
{*                                                                          *}
{*  NOTE : You must compile the interpreter with the DEBUG macro            *}
{*         defined in order to link this program !!                         *}
{*                                                                          *}
{*  Keys :                                                                  *}
{*                                                                          *}
{*  x :   fine counter_clockwise rotation                                   *}
{*  c :   fine clockwise rotation                                           *}
{*                                                                          *}
{*  v :   fast counter_clockwise rotation                                   *}
{*  b :   fast clockwise rotation                                           *}
{*                                                                          *}
{*  + :   fast scale up                                                     *}
{*  - :   fast scale down                                                   *}
{*  u :   fine scale down                                                   *}
{*  j :   fine scale up                                                     *}
{*                                                                          *}
{*  l :   go to next glyph                                                  *}
{*  k :   go to previous glyph                                              *}
{*                                                                          *}
{*  o :   go to tenth next glyph                                            *}
{*  i :   go to tenth previous glyph                                        *}
{*                                                                          *}
{*  0 :   go to hundredth next glyph                                        *}
{*  9 :   go to hundredth previous glyph                                    *}
{*                                                                          *}
{*  ESC :   exit                                                            *}
{*                                                                          *}
{*                                                                          *}
{*  NOTE : This is just a test program that is used to show off and         *}
{*         debug the current engine; which is still in alpha. In no         *}
{*         way does it shows the final high-level interface that            *}
{*         client applications will use. Wait for at least a beta for       *}
{*         this.                                                            *}
{*                                                                          *}
{****************************************************************************/

#ifdef HAVE_CONIO_H
#include <conio.h>
#endif

#ifdef ARM
#include "std.h"
#include "graflink.h"
#endif

#include "tttypes.h"
#include "tterror.h"
#include "ttcalc.h"
#include "tttables.h"
#include "ttmemory.h"
#include "ttraster.h"
#include "ttindex.h"
#include "ttins.h"
#include "ttfile.h"
#include "ttexec.h"
#include "tttables.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>    /* libc ANSI */


#ifdef ARM
#include "armsup.c" /* pull in our routines */
#endif

#define  Pi          3.1415926535

#define  MAXPTSIZE   500           /* dtp */
#define  Center_X   (Bit.width/2)  /* dtp */
#define  Center_Y   (Bit.rows/2)   /* dtp */

#define  Profile_Buff_Size  64000      /* Size of the render pool   */
                                       /* Minimum is around 4 Kb    */
                                       /* experiment to see how its */
                                       /* size impacts on raster    */

                                       /* performance..             */
#define  Font_Buff_Size  256000        /* this buffer holds all     */
                                       /* font specific data.       */

#define  Border 10

  TT_Stream         stream;
  PResident_Record  resident;
  PInstance_Record  instance;

  PExecution_Context  exec;

  PStorage        Font_Buffer;

  int   num_glyphs;
  int   num_pts;
  int   num_ctr;

  int   glyfArray;

  PShort  epts_ctr;

  /* DTP important font metrics */
  Long   cur_LeftSB,
         cur_Ascent,
         cur_Descent,
         cur_AdvanceWidth; 
           
  Int    ptsize;

  float  ymin,
         ymax,
         xmax,
         xmin,
         xsize;    /* DTP testing precision */

  float  resR;

  TGlyphRecord  gRec;

  TRasterBlock  Bit;

  Int           Rotation;
  Int           Fail;
  Int           Num;
  unsigned char autorun;

  char          GrayLines[1024];
  int           gray_render;

  TT_PCMapTable OurcmapIndex;

  FILE* FOut;

  TT_PCoordinates   Save_orgx, Save_orgy, Save_curx, Save_cury, Save_touch;


  void Dump_CVT( PShort cvt, Int num )
  {
    Int  i;

    for ( i = 0; i < num; i++ )
    {
      fprintf( FOut, "%04hx:", cvt[i] );
    }
    fprintf( FOut, "\n" );
  }


  Bool  LoadTrueTypeChar( Int idx )
  {
    TGlyph      *pG;
    Short       numP, numC;

    Int i;

    /* Reset_Context( instance->exec );  */
    
    if ( !Load_TrueType_Glyph( instance, idx, TRUE ) )
      return FAILURE;
  
    pG   = instance->glyph;
    numP = instance->pts.n;
    numC = instance->glyph->numberOfContours;
  
    if (numP <= 0 || numC <= 0)
      return FAILURE;
  
    DebugTrace(( "num contours = %d\n", numC ));

    for ( i = 0; i < numC; i++ )
    DebugTrace(( "%d ", instance->endContours[i] ));

    DebugTrace(( "\n" ));

    DebugTrace(( "Original values\n" ));
    for ( i = 0; i < instance->pts.n; i++ )
    {
      DebugTrace(( "%02hx  ", i ));
      DebugTrace(( "%08lx,%08lx\n", 
                   instance->pts.cur_x[i],
                   instance->pts.cur_y[i] ));
    }
    DebugTrace(( "\n" ));

    TT_Transform_Glyph( instance );
     /* This call scales the glyph */

    DebugTrace(( "Scaled values\n" ));
    for ( i = 0; i < instance->pts.n; i++ )
    {
      DebugTrace(( "%02hx  ", i ));
      DebugTrace(( "%08lx,%08lx\n", 
                   instance->pts.cur_x[i],
                   instance->pts.cur_y[i] ));
    }
    DebugTrace(( "\n" ));

    DebugTrace(( "Scale1 = %04lx\n", exec->scale1 ));
    DebugTrace(( "Scale2 = %04lx\n\n", exec->scale2 ));

    /* The following operations should be later included into the */
    /* Run_Context function. However, we're still under debuggig  */
    /* and it is important to do these things ourselves           */

     if ( !Load_Glyph_Instructions( instance, 0 ) )
       Panic( "ERROR: could not load instructions\n" );

     if ( !DebugIns( exec ) )
	 {
	   DebugTrace(( "error = %d\n", exec->error ));
       return FAILURE;
	 }

    return SUCCESS;
  }


  void main( int argc, char** argv ) 
  {
  
   int     i;
   char    filename[128+4];
   char*   execname;
  
   Font_Buffer = (PStorage)malloc( Font_Buff_Size );
    if ( !Font_Buffer )
    {
      Message( "Error: Could not even allocate font pool!\n" );
      exit( 1 );
    }

    Init_FontPool( Font_Buffer, Font_Buff_Size );

    num_pts = 0;
    num_ctr = 0;

    execname = argv[0];

    if ( argc != 4 )
    {
      Message( "Test: simple TrueType interpreter tester - part of the FreeType project\n" );
      Message( "-----------------------------------------------------------------------\n\n");
      Message( "Usage: %s glyphnum ppem fontname[.ttf]\n\n", execname );
      exit( 1 );
    }

    if ( sscanf( argv[1], "%d", &Num ) == EOF )
      Num = 0;

    if ( sscanf( argv[2], "%d", &ptsize ) == EOF )
      ptsize = 64;

    i = strlen( argv[3] );
    while ( i > 0 && argv[3][i] != '\\' )
    {
      if ( argv[3][i] == '.' )
        i = 0;
      i--;
    }

    filename[128] = 0;

    strncpy( filename, argv[3], 128 );
    if ( i >= 0 )
      strncpy( filename + strlen(filename), ".ttf", 4 );

    if ( !TT_Open_File( filename , &stream) )
    {
      Message( "Error, could not find/open %s\n\n", filename );
      exit( 1 );
    }

    if ( !TT_Load_Resident_Table( stream, &resident ) ) 
    {
      Message( "ERROR: Could not load data from %s\n", filename );
      exit( 1 );
    }
/*
    FOut = fopen( "h:\\work\\freetype\\p2.txt", "wt" );

    fprintf( FOut, "Original CVT\n" );
    Dump_CVT( resident->cvt, resident->cvtSize );
*/
    num_glyphs = resident->numGlyphs;
        
    if ( !TT_Load_Instance_Data( resident, &instance ) ) 
    {
      Message( "ERROR: Could not open instance from %s\n", filename );
      exit( 1 );
    }

    if ( !Create_Context( instance ) )
      Panic( "ERROR: could not create execution context\n" );

    exec = (PExecution_Context)instance->exec;

    if ( !Reset_Context( instance, ptsize, 96 ) )
      Panic( "ERROR: could not reset execution context\n" );
/*
    fprintf( FOut, "Scaled CVT\n" );
    Dump_CVT( instance->cvt, instance->cvtSize );
*/
    LoadTrueTypeChar(Num);

/*
    fprintf( FOut, "Hinted CVT\n" );
    Dump_CVT( instance->cvt, instance->cvtSize );

    fclose( FOut );
*/
    TT_Close_File(stream);
  }


/* End */
