{***************************************************************************}
{*                                                                         *}
{*  FreeType Glyph Viewer.                                                 *}
{*                                                                         *}
{*                                                                         *}
{*    This small program will load a TrueType font file and allow          *}
{*    you to view/scale/rotate its glyphs. Glyphs are in the order         *}
{*    found within the 'glyf' table.                                       *}
{*                                                                         *}
{*  This source code has been compiled and run under both Virtual Pascal   *}
{*  on OS/2 and Borland's BP7.                                             *}
{*                                                                         *}
{***************************************************************************}

program Zoom;

uses Crt,
     FullScr,
     FreeType,
     TTTypes,
     TTMemory,
     TTFile,
     TTTables,
     TTRaster;

{&PMTYPE NOVIO}

{ $DEFINE DEBUG}

const
  Precis  = 64;
  Precis2 = Precis div 2;

  PrecisAux = 1024;

  Centre_X : int = 320;
  Centre_Y : int = 225;

  Profile_Buff_Size = 64000;

var

  Font_Buffer : PStorage;

  num_pts : word;
  num_ctr : word;

  glyfArray : word;

  epts_ctr : PShort;

  xCoord : TT_PCoordinates;
  yCoord : TT_PCoordinates;
  Flag   : TT_PTouchTable;

  ymin, ymax, xmax, xmin, xsize : longint;
  res,  resB                    : int;

  resR : real;

  resX, resY : real;

  LastX, LastY : FixedPoint;

  numPoints, numContours : int;

  Bit : TRasterBlock;

  yCur : integer;

  ScXMax, ScYMax,
  CntX, CntY : Integer;

  Rotation : int;  (* Angle modulo 1024 *)

  num_glyphs : int;

  gray_level : Boolean;

  stream    : TT_Stream;
  resident  : PResidentLeading;
  instance  : PInstanceRecord;

  old_glyph : int;
  glyph     : int;

  grayLines : array[0..2048] of Byte;

Procedure InitRows;
var
  i: integer;
  P: Pointer;
begin

  if gray_level then
  begin
    Bit.rows  := 200;
    Bit.cols  := 320;
    Bit.width := 320*2;
    Bit.flow  := TTFlowDown;
    Bit.size  := 320*200;
  end
  else
  begin
    Bit.rows  := 450;
    Bit.cols  := 80;
    Bit.width := 640;
    Bit.flow  := TTFlowDown;
    Bit.size  := 80*450;
  end;

  GetMem( Bit.buffer, Bit.size );
  if Bit.buffer = NIL then
   begin
    Writeln('ERREUR:InitRows:Not enough memory to allocate BitMap');
    halt(1);
   end;

  { Note that the render pool should be allocated from the font pool }
  { for vairous debugging reasons, and because we're still in alpha, }
  { we don't do it yet..                                             }

  GetMem( P, Profile_Buff_Size );
  if P=nil then
   begin
    writeln('ERREUR:InitRows:Not enough memory to allocate render pool');
    Halt(2);
   end;

  if gray_level then

    Init_Rasterizer( P,
                     Profile_Buff_Size,
                     @grayLines,
                     2048 )
  else
    Init_Rasterizer( P,
                     Profile_Buff_Size,
                     nil,
                     0 );

  FillChar( Bit.Buffer^, Bit.Size, 0 );
end;


Procedure ClearData;
var i: integer;
begin
  FillChar( Bit.Buffer^, Bit.Size, 0 );

  FreeMem( XCoord, SizeOf(FixedPoint)*numPoints );
  FreeMem( YCoord, SizeOf(FixedPoint)*numPoints );

  FreeMem( Flag, numPoints );
end;


Function LoadTrueTypeChar( idx : integer ) : boolean;
var
  off    : longint;
  x, y   : Real;
  i, szp : integer;
  j      : word;
  c, ct  : byte;
  EM     : Word;
  CR, SR : Real;

begin
  LoadtrueTypeChar := FALSE;

  if glyph = old_glyph then
    begin
      LoadTrueTypeChar := True;
      exit;
    end;

  if not TT_Load_Glyph( instance, idx ) then exit;

  numPoints        := instance^.pts.n - 2;  (* remove phantom points *)
  numContours      := instance^.numContours;

  if (numPoints <= 0) or (numContours <= 0) then exit;

  GetMem( XCoord, SizeOf(Fixed) * numPoints );
  GetMem( YCoord, SizeOf(Fixed) * numPoints );
  GetMem( Flag, numPoints );

  xMin := instance^.xMin;
  xMax := instance^.xMax;
  yMin := instance^.yMin;
  yMax := instance^.yMax;

  EM := instance^.fontres^.fontHeader.Units_Per_EM;

  dec( xMax, xMin );
  dec( yMax, yMin );

  dec ( res );
  resR := res/EM/2;

  xmax := trunc( xmax * resR + 0.5 );
  ymax := trunc( ymax * resR + 0.5 );

  CR := Cos( Rotation*Pi/512 );
  SR := Sin( Rotation*Pi/512 );

  for j:=0 to numPoints-1 do
   begin

    x := instance^.pts.cur_x^[j] * ( res / EM );
    y := instance^.pts.cur_y^[j] * ( res / EM );

    off := Trunc( Precis*( CR*(x-xmax) + SR*(y-ymax) ) );

    XCoord^[j] := Precis*Centre_X + off;
    (*
    XCoord^[j] := Precis*( Centre_X + off div Precis ) + Precis2;
    *)

    off := Trunc( Precis*( - SR*(x-xmax) + CR*(y-ymax) ) );

    YCoord^[j] := Precis*Centre_Y + off;
    (*
    YCoord^[j] := Precis*( Centre_Y + off div Precis ) + Precis2;
    *)

    Flag^[j] := instance^.pts.touch^[j] and 1;
   end;

  inc ( res );
  resR := 1/res;

  xsize := ( xmax + 7 ) div 8;

  LoadTrueTypeChar := TRUE;
end;


function ConvertRaster : boolean;
var
  B : Array[0..128] of Integer;
  i : integer;
  G : TGlyphRecord;
begin

  G.numConts  := instance^.numContours;
  G.endPoints := instance^.endContours;
  G.Points    := numPoints;
  G.XCoord    := XCoord;
  G.YCoord    := YCoord;
  G.Flag      := Flag;

  if gray_level then
    ConvertRaster := Render_Gray_Glyph( G, @Bit, 2, nil )
  else
    ConvertRaster := Render_Glyph ( G, @Bit, 2 );
end;

procedure Usage;
begin
    Writeln('Simple TrueType Glyphs viewer - part of the FreeType project' );
    Writeln;
    Writeln('Usage : ',paramStr(0),' FontName[.TTF]');
    Halt(1);
end;



var i: integer;
    heure,
    min1,
    min2,
    sec1,
    sec2,
    cent1,
    cent2  :
{$IFDEF OS2}
    longint;
{$ELSE}
    word;
{$ENDIF}

    C : Char;

    Filename : String;

label Fin;

var
  Fail     : Int;
  glyphStr : String[4];

begin
  TextMode( co80+Font8x8 );

  GetMem       ( Font_Buffer, 64000 );
  Init_FontPool( Font_Buffer^, 64000 );

  num_pts   := 0;
  num_ctr   := 0;

  xCoord  := NIL;
  yCoord  := NIL;
  Flag    := NIL;

  if ParamCount = 0 then Usage;

  gray_level := ParamStr(1)='-g';

  if gray_level then
    if ParamCount <> 2 then Usage else
  else
    if ParamCount <> 1 then Usage;

  if gray_level then Filename := ParamStr(2)
                else Filename := ParamStr(1);

  if Pos('.',FileName) = 0 then FileName:=FileName+'.TTF';

  if not TT_Open_File( FileName, stream ) then
    begin
      Writeln('ERROR: Could not open ', FileName );
      halt(1);
    end;

  if not TT_Load_Resident_Table( stream, resident ) then
   begin
    Writeln('ERROR: Could not load data from ', FileName );
    Halt(1);
   end;

  if not TT_Load_Instance_Data( resident, instance ) then
   begin
    Writeln('ERROR: Could not open instance from ', FileName );
    Halt(1);
   end;

  res  := 800;
  resB := (res+7) div 8;

  TT_Reset_Instance( instance, res, 96 );

  Rotation := 0;

  Fail := 0;

  InitRows;

  if gray_level then
    SetGraphScreen( FS_Graphics_Gray )
  else
    SetGraphScreen( FS_Graphics_Mono );

  res := 800;

  num_glyphs := instance^.fontres^.numGlyphs;

  old_glyph := -1;
  glyph     := 0;

  Repeat

    if LoadtrueTypeChar(glyph) then

      if ConvertRaster then
      begin
        if gray_level then
          Display( Bit.Buffer^, 200, 320 )
        else
          Display( Bit.Buffer^, 450, 80  );

        ClearData;
      end
      else
        begin
          inc( Fail );
          goto_xy( 11, 0 );
          Write_Str( 'Failure  ' );
        end

    else
      begin
        goto_xy( 10, 0 );
        Write_Str('Composite');
      end;

    goto_xy( 0, 0 );
    Write_Str('Glyph ');
    Str( glyph:3, glyphStr );
    Write_Str( glyphStr );

    C := Readkey;
    Case C of

     #27 : goto Fin;
     { ESC Key }

     'x' : Rotation := ( Rotation-1 ) and 1023;
     'c' : Rotation := ( Rotation+1 ) and 1023;
     'v' : Rotation := ( Rotation-16) and 1023;
     'b' : Rotation := ( Rotation+16) and 1023;

     '+' : if res < 10040 then inc( res, 10 ) else res := 1050;
     '-' : if res > 11 then dec( res, 10 ) else res := 1;

     'i' : if glyph > 10 then dec( glyph, 10 ) else i := 0;

     'o' : if glyph < num_glyphs-11 then inc( glyph, 10 )
                                    else glyph := num_glyphs-1;

     'k' : if glyph > 0 then dec(glyph);
     'l' : if glyph < num_glyphs-1 then inc(glyph);

     'u' : if res > 0 then dec(res);
     'j' : if res < 450 then inc(res);

    end;

  Until false;

 Fin:
  RestoreScreen;
  TT_Close_File(stream);

  Writeln('Echecs : ', Fail );
end.

