/* The Turbo Vision Stack Component. Part of the FreeType Debugger */

#ifndef stacktv_h
#define stacktv_h

#include "tttypes.h"
#include "tttables.h"
#include "ttdebug.h"

/*
 * TStackView
 *
 * A Simple stack display
 */

class TStackView :
    public TListViewer
{
public:

  TStackView( const TRect &bounds, PExecution_Context ainstance,
	      TScrollBar *avScrollBar );
  virtual void handleEvent( TEvent &event );
  virtual void draw();
  void update();

private:

  PExecution_Context instance;
};

/*
 * TStackWindow
 */

class TStackWindow :
    public TWindow
{
public:  


  TStackWindow( const TRect &bounds, PExecution_Context instance );

  TScrollBar *V;
  TStackView *S;
};


#endif

