/**
 * DEVHELP32.H - DevHelp header file for 32 bit Watcom-based device drivers
 *
 * Author: David Azarewicz <david@88watts.net>
 *
 * Copyright (c) 2013-2018 David Azarewicz david@88watts.net
 *
 * LICENSE
 *
 * The following source code is provided to you solely for the purpose of
 * assisting you in developing your own OS/2 device drivers. You may use
 * this source code as a reference and to build your own OS/2 drivers. You
 * may not modify, fork, or otherwise copy this source code other than what
 * is necessary for building your own OS/2 drivers. Any request for changes
 * or fixes must be referred to the author shown above.
 *
 * This copyright and license statement may not be removed.
 */
#ifndef DEVHELP_INCLUDED
#define DEVHELP_INCLUDED

#ifdef __WATCOMC__

#ifndef OS2_INCLUDED
#define INCL_NOPMAPI
#include <os2.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define DHGETDOSV_SYSINFOSEG       1
#define DHGETDOSV_LOCINFOSEG       2
#define DHGETDOSV_VECTORSDF        4
#define DHGETDOSV_VECTORREBOOT     5
#define DHGETDOSV_YIELDFLAG        7
#define DHGETDOSV_TCYIELDFLAG      8
#define DHGETDOSV_DOSCODEPAGE      11
#define DHGETDOSV_INTERRUPTLEV     13
#define DHGETDOSV_DEVICECLASSTABLE 14
#define DHGETDOSV_DMQSSELECTOR     15
#define DHGETDOSV_APMINFO          16

extern ULONG __syscall Dev32Help_GetDOSVar(USHORT VarNumber, USHORT VarMember, VOID **KernalVar);

extern void Dev32Help_EOI(ULONG Irq);
#pragma aux Dev32Help_EOI parm [ecx] modify nomemory [eax ecx edx];

extern ULONG __syscall Dev32Help_SetIRQ(void *HandlerOffset, USHORT IRQ, UCHAR SharableFlag, ULONG ulIntData);
/* Handler at HandlerOffset can be declared with
 * #pragma aux Handler parm [eax]
 * int Handler(ULONG ulIntData)
 * to receive the ulIntData that was passed to Dev32Help_SetIRQ()
 * Handler is called with a 32 bit stack.
 */

extern ULONG __syscall Dev32Help_TickCount(void *HandlerOffset, ULONG Count);
/* Handler at HandlerOffset is called with a 32 bit stack */

extern ULONG __syscall Dev32Help_ResetTimer(void *HandlerOffset);

extern ULONG Dev32Help_AllocGDTSelector(USHORT *pSelectors, ULONG Count);
#pragma aux Dev32Help_AllocGDTSelector parm [eax] [ecx] value [eax] modify nomemory [eax ecx edx];

extern ULONG Dev32Help_LinToGDTSelector(USHORT Selector, ULONG LinearAddr, ULONG Size);
#pragma aux Dev32Help_LinToGDTSelector parm [eax] [ebx] [ecx] value [eax] modify nomemory [eax ecx edx];

#define GDTSEL_R3CODE           0x0000
#define GDTSEL_R3DATA           0x0001
#define GDTSEL_R2CODE           0x0003
#define GDTSEL_R2DATA           0x0004
#define GDTSEL_R0CODE           0x0005
#define GDTSEL_R0DATA           0x0006
/* GDTSEL_ADDR32 may be OR'd with above defines */
#define GDTSEL_ADDR32           0x0080

extern ULONG Dev32Help_PhysToGDTSel(ULONG PhysAddr, ULONG Count, USHORT Selector, UCHAR Access);
#pragma aux Dev32Help_PhysToGDTSel parm [eax] [ecx] [esi] [edx] value [eax] modify nomemory [eax ecx edx];

/* This function provides a temporary mapping and can be called at interrupt time */
extern ULONG __syscall Dev32Help_PhysToLin(ULONG PhysAddr, ULONG ulSize, VOID **pLinAdr);

extern ULONG __syscall Dev32Help_VirtToPhys(void __far16 *f16Ptr,  ULONG *pPhysAddr);

/* This function can be called at interrupt time */
extern ULONG __syscall Dev32Help_LinToPhys(void *pLinAdr, ULONG ulSize, ULONG *ulPhysAdr);

/* Finds the specified Device Driver and returns the data necessary to access it.
 * You must provide an 8 character DevName.
 */
extern ULONG __syscall Dev32Help_FindDD(char *DevName, DDINFO *DDinfo);

/* Calls the specified Device Driver's strategy routine with the given request packet
 * The callee receives the call in the normal way. A far16 call is done to the driver's
 * strategy handler with a pointer to the request packet in es:bx.
 */
extern ULONG __syscall Dev32Help_CallStrategy(DDINFO *DDinfo, void *pkt);

/* Calls the specified Device Driver's IDC routine with the given request packet
 * The callee receives the call in the normal way. A far16 call is done to the driver's
 * IDC handler with a pointer to the request packet in es:bx.
 */
extern ULONG __syscall Dev32Help_CallIdc(DDINFO *DdInfo, void *Packet);
extern ULONG (__far16 *Far16AdrOfIdcEntry16)(void FAR16DATA *);

/* Sends an IOCtl request to the specified device driver */
extern ULONG __syscall Dev32Help_IOCtl(DDINFO *pDdInfo, UCHAR Category, UCHAR Function, void *pvParam, ULONG ulParamLen, void *pvData, ULONG ulDataLen);

#define DEVICECLASS_ADDDM 1
#define DEVICECLASS_MOUSE 2

extern ULONG __syscall Dev32Help_RegisterDeviceClass(char *DeviceString, void *DriverEP, ULONG DeviceFlags, ULONG DeviceClass, USHORT *DeviceHandle);
/* Handler at DriverEP is called with a 32 bit stack */

extern ULONG __syscall Dev32Help_RegisterKrnlExit(void *HandlerOffset, USHORT ExitFlags, USHORT ExitType);
/* Handler at HandlerOffset is called with a 32 bit stack */

void Dev32Help_InternalError(char *Msg, USHORT usLen);
#pragma aux Dev32Help_InternalError parm [eax] [edi] modify nomemory [];

void Dev32Help_Beep(ULONG Freq, ULONG Duration);
#pragma aux Dev32Help_Beep parm [ebx ecx] modify nomemory [eax ecx edx];

typedef void (__far16  *PFNFAR16)(VOID);
extern ULONG __syscall Dev32Help_CallFar16(PFNFAR16 pFunction, ...);
#pragma aux Dev32Help_CallFar16 modify [ebx];

extern void __syscall Dev32Help_Yield(void);

extern ULONG __syscall Dev32Help_OpenEventSem(ULONG hEvent);
extern ULONG __syscall Dev32Help_PostEventSem(ULONG hEvent);
extern ULONG __syscall Dev32Help_CloseEventSem(ULONG hEvent);

/* The following File I/O functions are experimental and may not work, may be changed,
 * or may be removed.
 */
extern ULONG Dev32Help_FileIO(ULONG Function, void *FileInfo);
#pragma aux Dev32Help_FileIO parm [edx] [eax] value [eax] modify nomemory [eax ecx edx];
extern ULONG __syscall Dev32Help_FileOpen(char *pFileName, ULONG *pFileLen);

#ifdef __cplusplus
}
#endif

#endif
#endif
