/*
 * This is the equivalent demo program that comes with gd-1.8.3
 */
Call RxFuncAdd 'GdLoadFuncs', 'rexxgd', 'GdLoadFuncs'
Call GdLoadFuncs
/*
Call gdvariable 'DEBUG', 3
*/
/* Create output image, 128 by 128 pixels. */
im_out = gdImageCreate(128, 128)

/* First color allocated is background. */
white = gdImageColorAllocate(im_out, 255, 255, 255)

/* Set transparent color. */
Call gdImageColorTransparent im_out, white

/* Try to load demoin.png and paste part of it into the output image. */

im_in = gdImageCreateFromPng("demoin.png")
If im_in = '' Then
   Do
      Say "Can't load source image; this demo"
      Say "is much more impressive if demoin.png"
      Say "is available."
      im_in = 0
   End
Else
   Do
      /* Now copy, and magnify as we do so */
      Call gdImageCopyResized im_out, im_in, 16, 16, 0, 0, 96, 96, 127, 127
   End
red = gdImageColorAllocate(im_out, 255, 0, 0)
green = gdImageColorAllocate(im_out, 0, 255, 0)
blue = gdImageColorAllocate(im_out, 0, 0, 255)
/* Rectangle */
Call gdImageLine im_out, 8, 8, 120, 8, green
Call gdImageLine im_out, 120, 8, 120, 120, green
Call gdImageLine im_out, 120, 120, 8, 120, green
Call gdImageLine im_out, 8, 120, 8, 8, green
/* Circle */
Call gdImageArc im_out, 64, 64, 30, 10, 0, 360, blue
/* Arc */
Call gdImageArc im_out, 64, 64, 20, 20, 45, 135, blue
/* Flood fill */
Call gdImageFill im_out, 4, 4, blue
/* Polygon */
xpoints.1 = 32
ypoints.1 = 0
xpoints.2 = 0
ypoints.2 = 64
xpoints.3 = 64
ypoints.3 = 64
xpoints.0 = 3
ypoints.0 = 3
Call gdImageFilledPolygon im_out, 'xpoints.', 'ypoints.', green
/* Brush. A fairly wild example also involving a line style! */
If im_in \= 0 Then
   Do
      brush = gdImageCreate(8, 8)
      Call gdImageCopyResized brush, im_in, 0, 0, 0, 0, gdImageGetWidth(brush), gdImageGetHeight(brush), gdImageGetWidth(im_in), gdImageGetHeight(im_in)
      Call gdImageSetBrush im_out, brush
      /* With a style, so they won't overprint each other.
         Normally, they would, yielding a fat-brush effect. */
      style.1 = 0
      style.2 = 0
      style.3 = 0
      style.4 = 0
      style.5 = 0
      style.6 = 0
      style.7 = 0
      style.8 = 1
      style.0 = 8
      Call gdImageSetStyle im_out, 'style.'
      /* Draw the styled, brushed line */
      Call gdImageLine im_out, 0, 127, 127, 0, "GDSTYLEDBRUSHED"
   End
/* Text */
Call gdImageString im_out, gdFontGiant, 16, 16, "hi", red
Call gdImageStringUp im_out, gdFontSmall, 32, 32, "hi", red
/* Make output image interlaced (allows "fade in" in some viewers,
   and in the latest web browsers) */
Call gdImageInterlace im_out, 1
/* Write PNG */
Call gdImagePng im_out, "demoout.png"
Call gdImageDestroy im_out
If im_in \= 0 Then Call gdImageDestroy im_in
return 0

